/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.webgiscli.servlet;

import de.riwagis.webgiscli.WebGisConfiguration;
import de.riwagis.webgiscli.WebGisContext;
import de.riwagis.webgiscli.servlet.RiwaProxyServlet;
import de.riwagis.webgiscli.servlet.Token;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URI;
import lombok.Generated;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.client.utils.URIUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrafanaProxyServlet
extends RiwaProxyServlet {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GrafanaProxyServlet.class);
    private static final String SDS_GRAFANA_DASHBOARD_URL = "sds_grafana_dashboard_url";
    private HttpHost grafanaServer = null;
    private boolean useJWT;
    private final Token token = new Token("grafana");

    public GrafanaProxyServlet() {
        WebGisConfiguration.getWebGisContext().getServiceProvider().addLoginListener(e -> {
            this.token.invalidate();
            this.setupGrafana();
        });
    }

    @Override
    public void init() throws ServletException {
        super.init();
        this.setupGrafana();
    }

    private void setupGrafana() {
        WebGisContext wgContext = WebGisConfiguration.getWebGisContext();
        try {
            this.grafanaServer = URIUtils.extractHost((URI)((URI)wgContext.getUserInfo().get(SDS_GRAFANA_DASHBOARD_URL)));
        }
        catch (Exception ex) {
            log.error("Could not retrieve sds grafana url", (Throwable)ex);
        }
        this.useJWT = true;
    }

    protected void service(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws ServletException, IOException {
        if (this.grafanaServer == null) {
            throw new ServletException("Could not open SDS grafana dashboard. Grafana Server is undefined.");
        }
        servletRequest.setAttribute(ATTR_TARGET_HOST, (Object)this.grafanaServer);
        servletRequest.setAttribute(ATTR_TARGET_URI, (Object)"");
        super.service(servletRequest, servletResponse);
    }

    protected void copyRequestHeaders(HttpServletRequest servletRequest, HttpRequest proxyRequest) {
        String jwt;
        super.copyRequestHeaders(servletRequest, proxyRequest);
        if (!this.useJWT) {
            return;
        }
        if (!this.token.isValid()) {
            this.token.refresh(this.httpProv);
        }
        if (!(jwt = this.token.get()).isBlank()) {
            proxyRequest.addHeader("X-JWT-Assertion", jwt);
        }
    }
}

