/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.webgiscli.servlet;

import de.riwagis.webgiscli.WebGisConfiguration;
import de.riwagis.webgiscli.WebGisContext;
import de.riwagis.webgiscli.servlet.RiwaProxyServlet;
import de.riwagis.webgiscli.servlet.Token;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URI;
import java.util.Objects;
import lombok.Generated;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.client.utils.URIUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Gis3DProxyServlet
extends RiwaProxyServlet {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Gis3DProxyServlet.class);
    private static final String USR_PROJECT3D_SRV = "usr_project3d_srv";
    private static final String USR_PROJECT3D_URL = "usr_project3d_url";
    private static final String USR_PROJECT3D_NO_SECURITY = "usr_project3d_no_security";
    private final Token token = new Token("gis3d");
    private HttpHost server3d = null;
    private String projectURL = "";
    private String projectDataSourceURL = "";
    private boolean useJWT;

    public Gis3DProxyServlet() {
        WebGisConfiguration.getWebGisContext().getServiceProvider().addLoginListener(e -> {
            this.token.invalidate();
            this.setupProject();
        });
    }

    @Override
    public void init() throws ServletException {
        super.init();
        this.setupProject();
    }

    private void setupProject() {
        WebGisContext wgContext = WebGisConfiguration.getWebGisContext();
        try {
            URI uri3d = new URI(Objects.toString(wgContext.getUserInfo().get(USR_PROJECT3D_SRV), ""));
            this.server3d = URIUtils.extractHost((URI)uri3d);
            this.projectURL = Objects.toString(wgContext.getUserInfo().get(USR_PROJECT3D_URL), "");
            if (this.projectURL.endsWith("/")) {
                this.projectURL = this.projectURL.substring(0, this.projectURL.length() - 1);
            }
            if (this.projectURL.endsWith("/vcm")) {
                this.projectURL = this.projectURL.substring(0, this.projectURL.length() - 4);
            }
            this.projectDataSourceURL = this.projectURL + "/..";
        }
        catch (Exception ex) {
            log.error("Could not retrieve 3d project url", (Throwable)ex);
        }
        String noSecurityFlag = Objects.toString(wgContext.getUserInfo().get(USR_PROJECT3D_NO_SECURITY), "false");
        this.useJWT = !"true".equalsIgnoreCase(noSecurityFlag);
    }

    protected void service(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws ServletException, IOException {
        if (this.server3d == null) {
            throw new ServletException("Error trying to process 3D-URL in HttpBridgeGis3DServlet: 3D server is not defined.");
        }
        if (this.projectURL.isBlank()) {
            throw new ServletException("Error trying to process 3D-URL in HttpBridgeGis3DServlet: 3D project is not defined.");
        }
        servletRequest.setAttribute(ATTR_TARGET_HOST, (Object)this.server3d);
        if (servletRequest.getPathInfo().startsWith("/datasource-data/")) {
            servletRequest.setAttribute(ATTR_TARGET_URI, (Object)this.projectDataSourceURL);
        } else if (servletRequest.getPathInfo().startsWith("/vcm/")) {
            servletRequest.setAttribute(ATTR_TARGET_URI, (Object)this.projectURL);
        } else {
            servletRequest.setAttribute(ATTR_TARGET_URI, (Object)"");
        }
        super.service(servletRequest, servletResponse);
    }

    protected void copyRequestHeaders(HttpServletRequest servletRequest, HttpRequest proxyRequest) {
        String jwt;
        super.copyRequestHeaders(servletRequest, proxyRequest);
        if (!this.useJWT) {
            return;
        }
        if (!this.token.isValid()) {
            this.token.refresh(this.httpProv);
        }
        if (!(jwt = this.token.get()).isBlank()) {
            proxyRequest.addHeader("Authorization", "Bearer " + jwt);
        }
    }
}

