/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.webgiscli.service.http.streams;

import de.riwagis.service.ServiceException;
import de.riwagis.util.Config;
import de.riwagis.util.exception.SystemException;
import de.riwagis.util.gui.components.StatusDisplayer;
import de.riwagis.util.i18n.I18N;
import de.riwagis.util.thread.ThreadUtils;
import de.riwagis.webgiscli.WebGisContext;
import de.riwagis.webgiscli.module.dialog.WebGisDialog;
import java.io.File;
import org.apache.commons.lang.StringUtils;

public final class ServerFileStream {
    private static I18N i18n = new I18N(Config.LOCALE, "de.riwagis.webgiscli.i18n.i18n");
    public static final int STREAM_TIMEOUT = 480000;

    public static void buildServerFileAsynchronous(WebGisContext wgContext, String streamID, StatusDisplayer statusDisplay, File expFile) throws SystemException, ServiceException {
        if (StringUtils.isNotBlank((String)streamID)) {
            int done = 0;
            long startTime = System.currentTimeMillis();
            while (done < 100 && startTime - System.currentTimeMillis() < 480000L) {
                done = WebGisDialog.statusServerStream(wgContext, streamID);
                if (done <= 100 && statusDisplay != null) {
                    statusDisplay.setMessage(i18n.fmt("service.http.ServerFileStream.waitpercent", new Object[]{done}));
                }
                ThreadUtils.sleepQuietly((long)500L);
            }
            if (done >= 100) {
                WebGisDialog.retrieveServerStream(wgContext, streamID, expFile);
            } else {
                throw new SystemException("error streaming file: timeout");
            }
        }
    }

    private ServerFileStream() {
    }
}

