/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.webgiscli.service.http;

import de.riwagis.service.ServiceException;
import de.riwagis.service.ServiceMData;
import de.riwagis.service.ServiceRequest;
import de.riwagis.service.registry.ServiceRegistry;
import de.riwagis.util.thread.ThreadUtils;
import de.riwagis.webgiscli.service.http.HttpServiceProvider;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeepSessionAliveDeamon
implements Runnable {
    private static final int DEFAULT_KEEPALIVE_TIME_IN_SECONDS = 600;
    private static final Logger LOG = LoggerFactory.getLogger(KeepSessionAliveDeamon.class);
    private final HttpServiceProvider svp;
    private final AtomicBoolean keepItAlive = new AtomicBoolean(false);
    private Thread daemonThread;
    private final Lock lck = new ReentrantLock();
    private long lastRoundtrip;

    public KeepSessionAliveDeamon(HttpServiceProvider svp) {
        this.svp = svp;
    }

    private int keepSessionAlive() {
        try {
            ServiceMData svc = ServiceRegistry.getService((String)"http-login", (int)0);
            HashMap<String, Long> mapParam = new HashMap<String, Long>();
            mapParam.put("roundtriptime", this.lastRoundtrip);
            ServiceRequest keepAliveRequest = svc.createRequest("session_keepalive", mapParam);
            StopWatch swRoundTrip = new StopWatch();
            swRoundTrip.start();
            this.svp.execRequest(keepAliveRequest, false);
            swRoundTrip.stop();
            this.lastRoundtrip = swRoundTrip.getTime();
            int sessionTimeout = (Integer)keepAliveRequest.getResult();
            LOG.info(String.format("session timeout for '%s': %d (roundtrip: %d)", this.svp.getURL(), sessionTimeout, this.lastRoundtrip));
            return sessionTimeout / 3;
        }
        catch (ServiceException se) {
            LOG.error(String.format("Error at keeping user session alive: %s", se.getMessage()), (Throwable)se);
            return 600;
        }
    }

    public void stop() {
        try {
            this.lck.lock();
            this.keepItAlive.set(false);
            if (this.daemonThread != null) {
                this.daemonThread.interrupt();
                try {
                    this.daemonThread.join();
                }
                catch (InterruptedException ex) {
                    LOG.warn("interrupted: " + ex.getMessage());
                }
            }
            this.daemonThread = null;
        }
        finally {
            this.lck.unlock();
        }
    }

    public void start() {
        try {
            this.lck.lock();
            if (this.keepItAlive.get()) {
                this.stop();
            }
            this.keepItAlive.set(true);
            this.daemonThread = new Thread(this);
            this.daemonThread.setDaemon(true);
            this.daemonThread.start();
        }
        finally {
            this.lck.unlock();
        }
    }

    @Override
    public void run() {
        while (this.keepItAlive.get()) {
            int sessionTimeout = this.keepSessionAlive();
            ThreadUtils.sleepQuietly((long)(sessionTimeout * 1000));
        }
    }
}

