/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.webgiscli.service.http;

import de.riwagis.browser.WindowManager;
import de.riwagis.service.AbstractServiceProvider;
import de.riwagis.service.ServiceException;
import de.riwagis.service.ServiceMData;
import de.riwagis.service.ServiceRequest;
import de.riwagis.service.ServiceSupport;
import de.riwagis.service.registry.ServiceRegistry;
import de.riwagis.util.Config;
import de.riwagis.util.Support;
import de.riwagis.util.exception.SystemException;
import de.riwagis.util.gui.ErrorBox;
import de.riwagis.util.gui.ExceptionDialog;
import de.riwagis.util.gui.GUIException;
import de.riwagis.util.gui.GUISupport;
import de.riwagis.util.gui.components.SelfClosingMessageBox;
import de.riwagis.util.gui.components.WaitDialog;
import de.riwagis.util.http.HTTPClientSupport;
import de.riwagis.util.http.HttpClientConfig;
import de.riwagis.util.http.HttpClientProxyManager;
import de.riwagis.util.i18n.I18N;
import de.riwagis.webgiscli.WebGisClient;
import de.riwagis.webgiscli.WebGisConfiguration;
import de.riwagis.webgiscli.WebGisContext;
import de.riwagis.webgiscli.login.LoginCredentials;
import de.riwagis.webgiscli.login.LoginCredentialsUtils;
import de.riwagis.webgiscli.login.LoginInfo;
import de.riwagis.webgiscli.login.LoginUtils;
import de.riwagis.webgiscli.login.ServerInfo;
import de.riwagis.webgiscli.login.gui.AdminPwdLoginDialog;
import de.riwagis.webgiscli.login.gui.ChangePasswordDialog;
import de.riwagis.webgiscli.login.gui.HttpLoginDialog;
import de.riwagis.webgiscli.login.gui.InvalidLoginDialog;
import de.riwagis.webgiscli.login.handlers.LoginHandler;
import de.riwagis.webgiscli.service.http.KeepSessionAliveDeamon;
import de.riwagis.webgiscli.service.http.LoginResult;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.SwingUtilities;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpServiceProvider
extends AbstractServiceProvider {
    private static final Logger LOG = LoggerFactory.getLogger(HttpServiceProvider.class);
    public static final Integer LOGIN_USERPWD_ERR = -1;
    public static final Integer LOGIN_ADMINPWD_ERR = 1;
    public static final Integer LOGIN_NOPWD_ERR = 2;
    public static final Integer LOGIN_WRONGIP_ERR = 3;
    public static final Integer LOGIN_PASSWORD_CHANGE = 4;
    private final CloseableHttpClient client;
    private HttpClientProxyManager clientProxyManager;
    private LoginHandler loginHandler = null;
    private final WebGisContext wgContext;
    private HttpLoginDialog dlgLogin = null;
    private static final I18N i18n = new I18N(Config.LOCALE, "de.riwagis.webgiscli.i18n.i18n");
    private final Map<String, Object> mapUserInfo = new HashMap<String, Object>();
    private static volatile boolean bolLoginSucceeded = false;
    private static final Lock LOCKLOGIN = new ReentrantLock();
    private final KeepSessionAliveDeamon keepSessionAliveDeamon = new KeepSessionAliveDeamon(this);
    private final List<String> visibleToasts = Collections.synchronizedList(new ArrayList());
    private final ActionListener actionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            HttpServiceProvider.this.tryLogin(((HttpLoginDialog)e.getSource()).getLoginInfo());
        }
    };

    public HttpServiceProvider(WebGisContext _wgContext) throws SystemException {
        this.wgContext = _wgContext;
        this.client = HTTPClientSupport.generateHttpClient((HttpClientConfig)HttpClientConfig.builder().charset(StandardCharsets.UTF_8).socketTimeoutInMillis(600000).connTimeoutInMillis(5000).parallelConnections(10).validateRootCAs(this.parseValidateRootCaFromConfig(_wgContext)).build());
        this.clientProxyManager = new HttpClientProxyManager();
    }

    public CloseableHttpClient getHttpClientInternal() {
        return this.client;
    }

    public void doLogout() throws ServiceException {
        this.keepSessionAliveDeamon.stop();
        if (this.loginHandler != null) {
            this.loginHandler.doLogout();
        }
        this.fireLogoutListeners();
    }

    public boolean doLogin() throws ServiceException {
        return this.doLogin(!bolLoginSucceeded);
    }

    public boolean doLogin(boolean allowGraphicalLogin) throws ServiceException {
        LoginResult res = LoginResult.RETRY_LOGIN;
        this.keepSessionAliveDeamon.stop();
        int counter = 0;
        do {
            if (++counter > 100) {
                GUISupport.msgbox((Component)this.wgContext.getWebGisClient().getFrame(), (String)"Login failed - more than 100 attempts are not allowed.", (String)"error");
                LOG.error("Login failed - more than 100 attempts are not allowed.");
                break;
            }
            try {
                if (LOCKLOGIN.tryLock()) {
                    try {
                        LoginHandler lhOneServer = null;
                        if (this.loginHandler == null) {
                            lhOneServer = HttpServiceProvider.retrieveLoginHandlerIfOneServerInList(this);
                        }
                        if (lhOneServer != null && !lhOneServer.needsCredentials()) {
                            this.loginHandler = lhOneServer;
                            this.loginHandler.getLoginInfo().setPerformLogin(true);
                        } else if (this.loginHandler != null && allowGraphicalLogin && res == LoginResult.CHANGE_PWD) {
                            if (this.loginHandler.canChangePassword()) {
                                this.showPasswordChangeDialog();
                            } else {
                                GUISupport.msgbox((Component)this.wgContext.getWebGisClient().getFrame(), (String)i18n.get("service.http.HttpServiceProvider.change-password-error-ldap"), (String)i18n.get("service.http.HttpServiceProvider.change-password"));
                                this.loginHandler.getLoginInfo().setPerformLogin(false);
                            }
                        } else if (allowGraphicalLogin && res != LoginResult.RETRY_IMMEDIATE) {
                            this.loginHandler = this.showGraphicalLogin();
                        }
                        if (this.loginHandler.getLoginInfo().isPerformLogin()) {
                            this.loginHandler.getLoginInfo().setSubUser(this.getSubUser());
                            Map<String, Object> mapUser = this.loginHandler.doLogin();
                            ServerInfo serverInfo = this.loginHandler.getLoginInfo().getServerInfo();
                            WindowManager.getInstance().setForwardProxy(URI.create(WebGisConfiguration.getHttpBridgeURL()));
                            WindowManager.getInstance().setWebgisPath(serverInfo.getURI());
                            Integer intErr = (Integer)mapUser.get("error_number");
                            if (allowGraphicalLogin && LOGIN_PASSWORD_CHANGE.equals(intErr)) {
                                res = LoginResult.CHANGE_PWD;
                            } else if (mapUser.containsKey("error")) {
                                if (allowGraphicalLogin) {
                                    res = this.handleLoginError(mapUser, intErr);
                                } else {
                                    GUISupport.msgbox((Component)this.wgContext.getWebGisClient().getFrame(), (String)i18n.fmt("service.http.HttpServiceProvider.relogon-error", new Object[]{StringUtils.defaultIfBlank((String)this.getSubUser(), (String)this.loginHandler.getLoginInfo().getLoginCredentials().getUsername()), mapUser.get("error")}).replace("\\n", "<br>"), (String)i18n.get("service.http.HttpServiceProvider.errortitle"));
                                    res = LoginResult.LOGIN_CANCEL;
                                }
                            } else {
                                this.mapUserInfo.clear();
                                this.mapUserInfo.putAll(mapUser);
                                this.keepSessionAliveDeamon.start();
                                res = LoginResult.LOGIN_SUCCESS;
                            }
                        } else {
                            res = LoginResult.EXIT_PROGRAM;
                        }
                        continue;
                    }
                    catch (GUIException ex) {
                        throw new SystemException((Throwable)ex);
                    }
                    finally {
                        LOCKLOGIN.unlock();
                    }
                }
                return this.waitLock();
            }
            catch (SystemException e) {
                bolLoginSucceeded = false;
                String strEcho = HttpServiceProvider.queryEcho(this);
                if (WebGisClient.getSplash().isVisible()) {
                    WebGisClient.getSplash().setVisible(false);
                }
                strEcho = strEcho.startsWith("Server tests are OK") ? "" : String.format("%nR\u00fcckgabemeldung Echo-Dienst: '%s'", strEcho);
                LOG.error(String.format("Error on login to '%s': %s", this.getURL(), e.getMessage()), (Throwable)e);
                throw new ServiceException(String.format("Login auf '%s' fehlgeschlagen.%nMeldung: '%s'%s", this.getURL(), e.getMessage(), strEcho), (Throwable)e);
            }
        } while (res == LoginResult.RETRY_LOGIN || res == LoginResult.CHANGE_PWD || res == LoginResult.RETRY_IMMEDIATE);
        this.fireLoginListeners();
        bolLoginSucceeded = res == LoginResult.LOGIN_SUCCESS;
        return bolLoginSucceeded;
    }

    public void showPasswordChangeDialog() throws SystemException, ServiceException {
        LoginCredentials creds = this.loginHandler.getLoginInfo().getLoginCredentials();
        String newEncryptedPassword = this.resetServiceProviderPassword(true, creds);
        if (StringUtils.isNotBlank((String)newEncryptedPassword)) {
            this.loginHandler.getLoginInfo().setLoginCredentials(creds);
        }
        if (newEncryptedPassword == null) {
            this.loginHandler.getLoginInfo().setPerformLogin(false);
        }
    }

    private boolean waitLock() {
        boolean bolLockAquired = false;
        try {
            boolean bl;
            bolLockAquired = LOCKLOGIN.tryLock(20L, TimeUnit.SECONDS);
            boolean bl2 = bl = bolLockAquired && bolLoginSucceeded;
            if (bolLockAquired) {
                LOCKLOGIN.unlock();
            }
            return bl;
        }
        catch (Throwable throwable) {
            try {
                if (bolLockAquired) {
                    LOCKLOGIN.unlock();
                }
                throw throwable;
            }
            catch (InterruptedException e) {
                return false;
            }
        }
    }

    public static LoginHandler retrieveLoginHandlerIfOneServerInList(HttpServiceProvider sp) {
        if (LoginUtils.readServerInfos().size() == 1) {
            ServerInfo srvInfoTmp = LoginUtils.readServerInfos().iterator().next();
            LoginInfo loginInfoTmp = new LoginInfo();
            loginInfoTmp.setServerInfo(srvInfoTmp);
            return LoginUtils.retrieveLoginHandler(loginInfoTmp, sp);
        }
        return null;
    }

    public static String queryEcho(HttpServiceProvider requestExecutor) {
        try {
            ServiceMData svc = ServiceRegistry.getService((String)"http-login", (int)0);
            ServiceRequest echoRequest = svc.createRequest("echo");
            return requestExecutor.execRequest(echoRequest, false, false).getResult().toString();
        }
        catch (Exception e1) {
            return StringUtils.replace((String)e1.getMessage(), (String)"\n", (String)" ");
        }
    }

    public void requestNewPassword(LoginCredentials locLoginCredentials) throws ServiceException {
        String strUsername = locLoginCredentials.getUsername();
        if (StringUtils.isBlank((String)strUsername) && (strUsername = GUISupport.inputbox((Component)this.dlgLogin, (String)i18n.get("service.http.HttpServiceProvider.new-pwd-insert-username"))) == null) {
            return;
        }
        if (StringUtils.isBlank((String)strUsername)) {
            ErrorBox.showError((Window)this.dlgLogin, (String)i18n.get("common.error"), (String)i18n.fmt("service.http.HttpServiceProvider.invalid-username", new Object[]{strUsername}), null, null);
            return;
        }
        try {
            String strMessage = String.format("<html>%s<br><br>%s : <b>%s</b></html>", i18n.get("service.http.HttpServiceProvider.new-pwd-question"), i18n.get("service.http.HttpServiceProvider.username"), strUsername);
            boolean bolYes = GUISupport.yesnobox((Component)this.dlgLogin, (String)strMessage, (String)i18n.get("common.message"));
            if (bolYes) {
                ServiceMData svcMData = ServiceRegistry.getService((String)"http-login", (int)0);
                HashMap<String, String> mapParam = new HashMap<String, String>();
                mapParam.put("name", strUsername);
                ServiceRequest reqNewPwd = svcMData.createRequest("send_user_pwd", mapParam);
                this.execRequest(this.getServerInfo(), reqNewPwd, false, true);
                GUISupport.msgbox((Component)this.dlgLogin, (String)i18n.get("service.http.HttpServiceProvider.new-pwd-requested"), (String)i18n.get("common.message"));
            }
        }
        catch (ServiceException ex) {
            ErrorBox.showException((Window)this.dlgLogin, (String)i18n.get("common.error"), (String)i18n.get("service.http.HttpServiceProvider.new-pwd-requested-failed"), (Throwable)ex);
        }
    }

    public static String getServer(ServerInfo serverInfo) {
        return serverInfo == null ? "" : serverInfo.getServer();
    }

    public String getServer() {
        return HttpServiceProvider.getServer(this.getServerInfo());
    }

    public static String getURI(ServerInfo serverInfo) {
        String tmpUri = serverInfo == null ? "" : serverInfo.getURI();
        return tmpUri.endsWith("/") ? tmpUri : tmpUri + "/";
    }

    public String getURI() {
        return HttpServiceProvider.getURI(this.getServerInfo());
    }

    public static String getURL(ServerInfo serverInfo) {
        return HttpServiceProvider.getServer(serverInfo) + HttpServiceProvider.getURI(serverInfo);
    }

    public String getURL() {
        return HttpServiceProvider.getURL(this.getServerInfo());
    }

    public ServerInfo getServerInfo() {
        if (this.loginHandler == null) {
            return null;
        }
        if (this.loginHandler.getLoginInfo() == null) {
            return null;
        }
        return this.loginHandler.getLoginInfo().getServerInfo();
    }

    public void resetProxyConfiguration() {
        this.clientProxyManager = new HttpClientProxyManager();
    }

    public Map<String, Object> getUserInfo() {
        return this.mapUserInfo;
    }

    public void relogonOnUnauthorizedStatusCode() {
        this.displaySessionInvalidatedToast();
        Thread thRelogon = new Thread(() -> {
            try {
                boolean bolSuccess = this.doLogin(false);
                if (bolSuccess) {
                    WindowManager.getInstance().closeAll();
                    this.displayNewLoginToast();
                } else {
                    this.displayLoginDidNotSucceedToast();
                }
            }
            catch (Exception e) {
                LOG.error("Error at automatic relogon after receiving unauthorized status.", (Throwable)e);
            }
        }, "automatic-relogon");
        thRelogon.start();
    }

    public CloseableHttpResponse execMethod(HttpUriRequest meth) throws SystemException {
        try {
            HttpClientContext httpClientContext = this.clientProxyManager.getHttpClientContext(new URI(meth.getURI().getScheme(), meth.getURI().getHost(), "", ""));
            return this.client.execute(meth, (HttpContext)httpClientContext);
        }
        catch (IOException | URISyntaxException e) {
            throw new SystemException(((Object)((Object)this)).getClass(), (Throwable)e);
        }
    }

    public CloseableHttpResponse execMethod(HttpHost targetHost, HttpRequest meth) throws IOException, URISyntaxException {
        HttpClientContext httpClientContext = this.clientProxyManager.getHttpClientContext(new URI(targetHost.toURI()));
        return this.client.execute(targetHost, meth, (HttpContext)httpClientContext);
    }

    public <T> ServiceRequest<T> execRequest(ServiceRequest<T> srvReq) throws ServiceException {
        return this.execRequest(srvReq, true);
    }

    public <T> ServiceRequest<T> execRequest(ServiceRequest<T> srvReq, boolean bolLogin) throws ServiceException {
        return this.execRequest(srvReq, bolLogin, true);
    }

    public <T> ServiceRequest<T> execRequest(ServiceRequest<T> srvReq, boolean bolLogin, boolean bolShowWaitDialog) throws ServiceException {
        return this.execRequest(this.getServerInfo(), srvReq, bolLogin, bolShowWaitDialog);
    }

    public <T> ServiceRequest<T> execRequest(final ServerInfo serverInfo, final ServiceRequest<T> srvReq, final boolean bolLogin, boolean bolShowWaitDialog) throws ServiceException {
        final ServiceRequest[] arrReturn = new ServiceRequest[1];
        final ServiceException[] arrEx = new ServiceException[1];
        final String fullURL = HttpServiceProvider.getURL(serverInfo) + String.format("service/%s/%s", srvReq.getSericeName(), srvReq.getMethodName());
        Runnable runner = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    HttpClientContext httpClientContext = HttpServiceProvider.this.clientProxyManager.getHttpClientContext(new URI(HttpServiceProvider.getServer(serverInfo)));
                    CloseableHttpResponse httpResponse = ServiceSupport.executeWebgisServiceRequest((CloseableHttpClient)HttpServiceProvider.this.client, (HttpContext)httpClientContext, (ServiceRequest)srvReq, (String)fullURL);
                    try {
                        int status = httpResponse.getStatusLine().getStatusCode();
                        if (status != 200) {
                            if (status == 401 && bolLogin) {
                                HttpServiceProvider.this.relogonOnUnauthorizedStatusCode();
                            }
                            String strError = HttpServiceProvider.retrieveErrorMessage(httpResponse);
                            srvReq.setError(strError);
                            throw new ServiceException(String.format("%s%nStatus: %d%nURL: '%s'", strError, status, fullURL));
                        }
                        arrReturn[0] = srvReq;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (httpResponse != null) {
                                EntityUtils.consumeQuietly((HttpEntity)httpResponse.getEntity());
                                httpResponse.close();
                            }
                        }
                        catch (Exception e) {
                            LOG.warn(String.format("couldn't release connection: %s", e.getMessage()), (Throwable)e);
                        }
                        throw throwable;
                    }
                    try {
                        if (httpResponse != null) {
                            EntityUtils.consumeQuietly((HttpEntity)httpResponse.getEntity());
                            httpResponse.close();
                        }
                    }
                    catch (Exception e) {
                        LOG.warn(String.format("couldn't release connection: %s", e.getMessage()), (Throwable)e);
                    }
                }
                catch (ServiceException se) {
                    arrEx[0] = se;
                }
                catch (Exception e) {
                    arrEx[0] = new ServiceException(String.format("Error on request '%s.%s' to '%s': %s", srvReq.getSericeName(), srvReq.getMethodName(), fullURL, e.getMessage()), (Throwable)e);
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread() && bolShowWaitDialog) {
            WaitDialog dlgWait = new WaitDialog((Window)WebGisContext.getInstance().getWebGisClient().getFrame(), i18n.get("service.http.HttpServiceProvider.please-wait"), runner);
            dlgWait.setCancelable(true);
            dlgWait.setVisible(250L);
            if (dlgWait.isCanceled()) {
                ServiceException e = new ServiceException("request cancelled");
                LOG.warn("request cancelled", (Throwable)e);
                throw e;
            }
        } else {
            runner.run();
        }
        if (arrEx[0] != null) {
            throw arrEx[0];
        }
        ServiceRequest res = arrReturn[0];
        return res;
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public void tryLogin(LoginInfo loginInfo) {
        loginInfo.setPerformLogin(false);
        this.loginHandler = LoginUtils.retrieveLoginHandler(loginInfo, this);
        this.resetProxyConfiguration();
    }

    public LoginHandler showGraphicalLogin() throws SystemException, ServiceException, GUIException {
        if (this.dlgLogin == null) {
            this.dlgLogin = new HttpLoginDialog(this.wgContext, this, this.actionListener);
        }
        GUISupport.executeSyncOnEventThread((Runnable)new Runnable(){

            @Override
            public void run() {
                HttpServiceProvider.this.dlgLogin.setSize(560, 500);
                GUISupport.centreOnScreen((Component)HttpServiceProvider.this.dlgLogin);
                boolean bolSplashVisible = false;
                if (WebGisClient.getSplash().isVisible()) {
                    bolSplashVisible = true;
                    WebGisClient.getSplash().setVisible(false);
                }
                HttpServiceProvider.this.dlgLogin.setVisible(true);
                HttpServiceProvider.this.loginHandler = null;
                HttpServiceProvider.this.dlgLogin.requestFocus();
                if (bolSplashVisible) {
                    WebGisClient.getSplash().setVisible(true);
                    WebGisClient.getSplash().requestFocus();
                }
            }
        });
        LoginInfo loginInfo = this.dlgLogin.getLoginInfo();
        return LoginUtils.retrieveLoginHandler(loginInfo, this);
    }

    public static String retrieveErrorMessage(CloseableHttpResponse httpResponse) throws UnsupportedEncodingException, DecoderException {
        String strError = "";
        if (httpResponse.getFirstHeader("errorbase64") != null) {
            strError = new String(new Base64().decode(httpResponse.getFirstHeader("errorbase64").getValue()), "utf-8");
        }
        if (StringUtils.isBlank((String)strError) && httpResponse.getFirstHeader("error") != null) {
            strError = httpResponse.getFirstHeader("error").getValue();
        }
        if (StringUtils.isBlank((String)strError)) {
            strError = ObjectUtils.toString((Object)httpResponse.getStatusLine());
        }
        return strError;
    }

    private LoginResult handleLoginError(Map<String, Object> mapUser, Integer intErr) throws SystemException, ServiceException, GUIException {
        String errorText = ObjectUtils.toString((Object)mapUser.get("error"));
        LOG.info(String.format("Error on login: %s", errorText));
        LoginResult tmpAction = intErr.equals(LOGIN_ADMINPWD_ERR) ? LoginResult.QUERY_ADMIN_PWD : (intErr.equals(LOGIN_NOPWD_ERR) ? LoginResult.SEND_NEW_PWD : InvalidLoginDialog.queryInvalidLoginAction(this.dlgLogin, errorText));
        switch (tmpAction) {
            case RETRY_LOGIN: {
                break;
            }
            case SEND_NEW_PWD: {
                this.requestNewPassword(this.loginHandler.getLoginInfo().getLoginCredentials());
                break;
            }
            case QUERY_ADMIN_PWD: {
                char[] adminPWDChars = AdminPwdLoginDialog.queryAdminPwd(this.dlgLogin);
                if (adminPWDChars == null || adminPWDChars.length <= 0) break;
                try {
                    String strAdminPwd = Support.encryptOneWay((char[])adminPWDChars, (String)"SHA-1");
                    LoginCredentialsUtils.storeAdminPassword(this.wgContext.getPermWhiteboard(), LoginCredentialsUtils.determineDefaultSuffix(), strAdminPwd);
                    this.wgContext.writePermWhiteboard();
                    return LoginResult.RETRY_IMMEDIATE;
                }
                catch (Exception e) {
                    ExceptionDialog.handleGuiException((Component)this.dlgLogin, (Throwable)e, (String)"webgiscli");
                    break;
                }
            }
            default: {
                return LoginResult.EXIT_PROGRAM;
            }
        }
        return LoginResult.RETRY_LOGIN;
    }

    public String changePassword(String username, String oldPassword, String newPassword) throws ServiceException {
        HashMap<String, String> mapParam = new HashMap<String, String>();
        mapParam.put("name", username);
        mapParam.put("pwd", oldPassword);
        mapParam.put("pwd_new", newPassword);
        ServiceMData svc = ServiceRegistry.getService((String)"http-login", (int)0);
        ServiceRequest changePwdRequest = svc.createRequest("change_user_password", mapParam);
        return (Boolean)this.execRequest(changePwdRequest, false).getResult() != false ? newPassword : oldPassword;
    }

    public void changeServiceProviderPassword() {
        try {
            LoginCredentials creds = this.loginHandler.getLoginInfo().getLoginCredentials();
            String encPwd = this.resetServiceProviderPassword(false, creds);
            this.loginHandler.getLoginInfo().setLoginCredentials(creds);
            if (StringUtils.isNotBlank((String)encPwd)) {
                this.loginHandler.getLoginInfo().setLoginCredentials(creds);
                if (this.loginHandler.getLoginInfo().isStoreLogin()) {
                    LoginCredentialsUtils.storeLoginCredentials(this.wgContext.getPermWhiteboard(), LoginCredentialsUtils.determineDefaultSuffix(), creds);
                    this.wgContext.writePermWhiteboard();
                }
                GUISupport.msgbox((Component)this.wgContext.getWebGisClient().getFrame(), (String)i18n.get("service.http.HttpServiceProvider.change-password-successful"), (String)i18n.get("service.http.HttpServiceProvider.change-password"));
            }
        }
        catch (ServiceException | SystemException | GeneralSecurityException e) {
            ExceptionDialog.handleGuiException((Component)this.wgContext.getWebGisClient().getFrame(), (Throwable)e, (String)"webgiscli");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String resetServiceProviderPassword(boolean loginAlreadDone, final LoginCredentials lc) throws SystemException, ServiceException {
        String newEncryptedPassword;
        List<ChangePasswordDialog.PasswordCheckGuideline> passwordGuidelines = List.of(new ChangePasswordDialog.PasswordCheckGuideline(){

            @Override
            public String checkPassword(String pwd) {
                try {
                    return HttpServiceProvider.this.loginHandler.isValidPassword(lc.getUsername(), pwd);
                }
                catch (SystemException ex) {
                    return String.format("error query server: %s", ex.getMessage());
                }
            }
        });
        ChangePasswordDialog cpd = new ChangePasswordDialog((Window)this.dlgLogin, passwordGuidelines);
        try {
            cpd.setUsername(lc.getUsername());
            cpd.setShowExpiredNotification(loginAlreadDone);
            boolean showOldPwd = LoginCredentialsUtils.wasPasswordSaved();
            cpd.setKnownEncryptedOldPassword(loginAlreadDone || showOldPwd ? lc.getEncryptedPassword() : "");
            cpd.setAllowEditUsername(StringUtils.isBlank((String)lc.getUsername()));
            cpd.setAllowEditPassword(!loginAlreadDone);
            GUISupport.centreOnScreen((Component)cpd);
            cpd.setVisible(true);
        }
        finally {
            GUISupport.disposeQuietly((Window)cpd);
        }
        if (cpd.getModalResult() == 0 && StringUtils.isNotBlank((String)(newEncryptedPassword = this.changePassword(cpd.getUsername(), cpd.getOldPassword(), cpd.getNewPassword())))) {
            lc.setUsername(cpd.getUsername());
            lc.setEncryptedPassword(newEncryptedPassword);
            return newEncryptedPassword;
        }
        return null;
    }

    public void close() throws IOException {
        try {
            if (this.client != null) {
                this.client.close();
            }
        }
        catch (Exception e) {
            LOG.warn(String.format("Error closing down HttpClient: %s", e.getMessage()), (Throwable)e);
        }
    }

    private void displaySessionInvalidatedToast() {
        StringBuilder sbMessage = new StringBuilder();
        sbMessage.append("<html>");
        sbMessage.append(i18n.get("service.http.HttpServiceProvider.session-invalidated"));
        sbMessage.append("<br/>");
        sbMessage.append(i18n.get("service.http.HttpServiceProvider.automatic-relogin"));
        sbMessage.append("</html>");
        this.displayToast("session-invalid", sbMessage.toString(), 2500);
    }

    private void displayNewLoginToast() {
        String username = this.loginHandler.getLoginInfo().getLoginCredentials().getUsername();
        this.displayToast("login", i18n.fmt("service.http.HttpServiceProvider.new-login-message", new Object[]{username}), 2500);
    }

    private void displayLoginDidNotSucceedToast() {
        String username = this.loginHandler.getLoginInfo().getLoginCredentials().getUsername();
        this.displayToast("login-error", i18n.fmt("service.http.HttpServiceProvider.relogon-unsuccessful", new Object[]{username}), 5000);
    }

    private void displayToast(final String id, String msg, int displayTime) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(() -> this.displayToast(id, msg, displayTime));
            return;
        }
        if (this.visibleToasts.contains(id)) {
            return;
        }
        this.visibleToasts.add(id);
        SelfClosingMessageBox msgbox = new SelfClosingMessageBox((Window)WebGisContext.getInstance().getWebGisClient().getFrame(), msg, displayTime);
        msgbox.addWindowListener((WindowListener)new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                HttpServiceProvider.this.visibleToasts.remove(id);
            }
        });
        msgbox.setVisible(true);
    }

    private boolean parseValidateRootCaFromConfig(WebGisContext wgContext) {
        try {
            Element elemRoot = wgContext.getConfiguration().getRootElement();
            Namespace ns = elemRoot.getNamespace();
            String rawValue = elemRoot.getChild("services", ns).getChild("http", ns).getChildTextTrim("https-validate-root-ca", ns);
            return !"false".equals(rawValue);
        }
        catch (Exception e) {
            LOG.error("Could parse root-ca validation setting from configuration. Defaulting to true.", (Throwable)e);
            return true;
        }
    }
}

