/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.webgiscli.service.http;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.riwagis.browser.WindowManager;
import de.riwagis.service.ServiceException;
import de.riwagis.util.exception.SystemException;
import de.riwagis.webgiscli.WebGisContext;
import de.riwagis.webgiscli.service.http.HttpServiceProvider;
import java.net.URI;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import lombok.Generated;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EndpointService<P, R> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EndpointService.class);
    private static final Lock requestEndpoint = new ReentrantLock();
    private static final ObjectMapper MAPPER = new ObjectMapper().configure(JsonParser.Feature.ALLOW_COMMENTS, true).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    private final Class<R> responseClass;
    private final Supplier<WindowManager> windowManagerSupplier;

    public EndpointService(Class<R> responseClass) {
        this(responseClass, WindowManager::getInstance);
    }

    EndpointService(Class<R> responseClass, Supplier<WindowManager> windowManagerSupplier) {
        this.responseClass = responseClass;
        this.windowManagerSupplier = windowManagerSupplier;
    }

    public Optional<R> callMethod(WebGisContext wgContext, int moduleKey, String endpoint, P parameters) throws SystemException {
        return this.callMethod(wgContext, moduleKey, endpoint, parameters, this.responseClass);
    }

    public <CR> Optional<CR> callMethod(WebGisContext wgContext, int moduleKey, String endpoint, P parameters, Class<CR> customResponseClass) throws SystemException {
        try {
            Optional<Object> optional;
            block17: {
                Object epResponse;
                CloseableHttpResponse response;
                block15: {
                    Optional optional2;
                    block16: {
                        requestEndpoint.lock();
                        String path = String.format("rest/dbparser/moduledata/custommethod/%d/%s", moduleKey, endpoint);
                        Map<String, P> methodParameters = Map.of("methodParameters", parameters);
                        String jsonMethodParameters = MAPPER.writeValueAsString(methodParameters);
                        StringEntity jsonEntity = new StringEntity(jsonMethodParameters, ContentType.APPLICATION_JSON);
                        URI url = this.windowManagerSupplier.get().getWebgisForwardProxy().resolve(path);
                        HttpUriRequest httpRequest = RequestBuilder.post((URI)url).setEntity((HttpEntity)jsonEntity).build();
                        HttpServiceProvider provider = (HttpServiceProvider)wgContext.getServiceProvider();
                        response = provider.execMethod(httpRequest);
                        try {
                            if (response.getStatusLine().getStatusCode() != 200) {
                                throw new ServiceException(String.format("Could not communicate with endpoint '%s' ('%s') for module %d. Response: %s", endpoint, path, moduleKey, response.getStatusLine().getStatusCode()));
                            }
                            String rawResult = EntityUtils.toString((HttpEntity)response.getEntity());
                            epResponse = MAPPER.readValue(rawResult, customResponseClass);
                            if (epResponse != null) break block15;
                            log.error("Endpoint response is empty.");
                            optional2 = Optional.empty();
                            if (response == null) break block16;
                        }
                        catch (Throwable throwable) {
                            try {
                                if (response != null) {
                                    try {
                                        response.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            catch (SystemException ex) {
                                throw ex;
                            }
                            catch (Exception ex) {
                                throw new SystemException(this.getClass(), "Error while calling server endpoint", (Throwable)ex);
                            }
                        }
                        response.close();
                    }
                    return optional2;
                }
                optional = Optional.of(epResponse);
                if (response == null) break block17;
                response.close();
            }
            return optional;
        }
        finally {
            requestEndpoint.unlock();
        }
    }
}

