/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.webgiscli.quickinfo;

import de.riwagis.gis.context.module.quickinfo.QuickInfoRequest;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.locationtech.jts.io.WKBWriter;
import org.locationtech.jts.io.WKTWriter;

class SubstitutionBuilder {
    private static final String PARAM_GEOMETRY = "geometry";
    private static final String PARAM_FEATURE_ID = "featureID";
    private static final String PARAM_REQUEST_ID = "requestID";
    private static final String PARAM_LAYER_NAME = "layerName";
    private static final String PARAM_LAYER_ID = "layerID";
    private static final String PARAM_SOURCE_MAPPING = "sourceMapping";
    private final QuickInfoRequest request;
    private final Map<String, String> substitutions;
    private final String sourceMapping;
    private final WKTWriter wktWriter = new WKTWriter();
    private final WKBWriter wkbWriter = new WKBWriter();

    public SubstitutionBuilder(QuickInfoRequest request, Map<String, String> substitutions, String sourceMapping) {
        this.request = request;
        this.substitutions = substitutions;
        this.sourceMapping = sourceMapping;
    }

    public String getSourceMapping() {
        return this.sourceMapping;
    }

    public Map<String, String> buildWithWKTGeometry(UUID id) {
        HashMap<String, String> result = new HashMap<String, String>(this.substitutions);
        result.put(PARAM_LAYER_ID, this.request.getLayerID());
        result.put(PARAM_LAYER_NAME, this.request.getLayerName());
        result.put(PARAM_FEATURE_ID, String.valueOf(this.request.getKey()));
        result.put(PARAM_SOURCE_MAPPING, this.sourceMapping);
        result.put(PARAM_GEOMETRY, this.wktWriter.write(this.request.getGeometry()));
        result.put(PARAM_REQUEST_ID, id.toString());
        return result;
    }

    public Map<String, Object> buildWithWKBGeometry() {
        HashMap<String, Object> result = new HashMap<String, Object>(this.substitutions);
        result.put(PARAM_LAYER_ID, this.request.getLayerID());
        result.put(PARAM_LAYER_NAME, this.request.getLayerName());
        result.put(PARAM_FEATURE_ID, String.valueOf(this.request.getKey()));
        result.put(PARAM_SOURCE_MAPPING, this.sourceMapping);
        result.put(PARAM_GEOMETRY, (String)this.wkbWriter.write(this.request.getGeometry()));
        return result;
    }
}

