/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.webgiscli.quickinfo;

import de.riwagis.gis.context.map.LayerContext;
import de.riwagis.gis.context.map.MapContext;
import de.riwagis.gis.context.map.VectorLayerContext;
import de.riwagis.gis.context.module.DialogContext;
import de.riwagis.gis.context.module.ModuleContext;
import de.riwagis.gis.context.module.interfaces.QuickInfoSupplierExternalCall;
import de.riwagis.gis.context.module.quickinfo.QuickInfo;
import de.riwagis.gis.context.module.quickinfo.QuickInfoAction;
import de.riwagis.gis.context.module.quickinfo.QuickInfoList;
import de.riwagis.gis.context.module.quickinfo.QuickInfoRequest;
import de.riwagis.gis.context.module.quickinfo.QuickInfoTarget;
import de.riwagis.gis.context.module.quickinfo.impl.QuickInfoActionImpl;
import de.riwagis.gis.context.module.quickinfo.impl.QuickInfoCategoryImpl;
import de.riwagis.gis.context.module.quickinfo.impl.QuickInfoImpl;
import de.riwagis.gis.context.module.quickinfo.impl.QuickInfoListImpl;
import de.riwagis.service.ServiceException;
import de.riwagis.service.ServiceMData;
import de.riwagis.service.ServiceRequest;
import de.riwagis.service.registry.ServiceRegistry;
import de.riwagis.util.lang.VersionComparator;
import de.riwagis.webgiscli.WebGisClient;
import de.riwagis.webgiscli.WebGisContext;
import de.riwagis.webgiscli.interfaces.FeatureAttributeSubstitutor;
import de.riwagis.webgiscli.module.bsh.BshMenuRuntime;
import de.riwagis.webgiscli.quickinfo.SourceMapping;
import de.riwagis.webgiscli.quickinfo.SubstitutionBuilder;
import java.awt.Desktop;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterators;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import lombok.Generated;
import org.opengis.feature.simple.SimpleFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuickInfoService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(QuickInfoService.class);
    private static final String VERSION_MIN_FOR_MODULE_INFOS = "1.0.23.12";
    private static final String MODULE_PARAM_LABEL = "label";
    private static final String MODULE_PARAM_ACTIONS = "actions";
    private static final String MODULE_PARAM_ACTION_DATA = "actionData";
    private static final String MODULE_PARAM_ACTION_TEXT = "actionText";
    private static final String MODULE_PARAM_TARGET = "target";
    private static final String MODULE_PARAM_ELEMENTS = "elements";
    private final WebGisContext context;
    private final Map<UUID, CompletableFuture<QuickInfoList>> runningInterfaceRequests = new ConcurrentSkipListMap<UUID, CompletableFuture<QuickInfoList>>();
    private CompletableFuture<QuickInfoList> activeRequest;

    public QuickInfoService(WebGisContext context) {
        this.context = context;
    }

    public Set<LayerContext> getQuickInfoLayers() throws Exception {
        MapContext activeMap = this.getActiveMap();
        return this.getRawQuickInfoMappingsFromModules().flatMap(moduleInfo -> moduleInfo.values().stream().flatMap(x -> x.keySet().stream()).map(l -> {
            try {
                return activeMap.getMapLayer(l);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }).filter(Objects::nonNull)).collect(Collectors.toSet());
    }

    public CompletableFuture<QuickInfoList> sendQuickInfoRequest(QuickInfoRequest request) {
        this.runningInterfaceRequests.clear();
        if (this.activeRequest != null && !this.activeRequest.isDone()) {
            boolean result = this.activeRequest.cancel(true);
            log.debug("Canceled running quick info request. Result: {}", (Object)result);
        }
        log.debug("Starting new quick info request.");
        this.activeRequest = this.getQuickInfoSubstitutions(request).thenCompose(substitutionBuilder -> {
            log.debug("Sending all quick info requests");
            List requests = this.getAllQuickInfoInterfaceSuppliers(substitutionBuilder.getSourceMapping()).stream().map(supplierCall -> {
                CompletableFuture interfaceFuture = new CompletableFuture();
                UUID requestID = UUID.randomUUID();
                log.debug("Requesting quick infos with id {}", (Object)requestID);
                this.runningInterfaceRequests.put(requestID, interfaceFuture);
                supplierCall.open(substitutionBuilder.buildWithWKTGeometry(requestID));
                return interfaceFuture;
            }).collect(Collectors.toList());
            if (this.serverDeliversQuickInfos()) {
                CompletableFuture<QuickInfoList> serverSupplier = CompletableFuture.supplyAsync(() -> {
                    log.debug("Requesting quickinfos from server");
                    try {
                        return this.requestQuickInfosFromServer(substitutionBuilder.buildWithWKBGeometry());
                    }
                    catch (Exception e) {
                        log.error("Could not get quickinfos from server", (Throwable)e);
                        throw new IllegalStateException(e);
                    }
                });
                requests.add(serverSupplier);
            }
            return ((CompletableFuture)CompletableFuture.allOf((CompletableFuture[])requests.toArray(CompletableFuture[]::new)).thenApplyAsync(void_ -> requests.stream().flatMap(s -> ((QuickInfoList)s.join()).getQuickInfos().stream()).collect(Collectors.toList()))).thenApplyAsync(allInfos -> new QuickInfoListImpl(UUID.randomUUID(), allInfos));
        });
        return this.activeRequest;
    }

    private List<QuickInfoSupplierExternalCall> getAllQuickInfoInterfaceSuppliers(String sourceMapping) {
        return this.context.getExternalService().getExternalCalls().stream().filter(ec -> ec instanceof QuickInfoSupplierExternalCall).map(QuickInfoSupplierExternalCall.class::cast).filter(ec -> ec.getSources().contains(sourceMapping)).collect(Collectors.toList());
    }

    public void consumeQuickInfos(QuickInfoList quickInfos) {
        log.debug("Consuming quick infos for request {}", (Object)quickInfos.getID());
        CompletableFuture<QuickInfoList> interfaceRequest = this.runningInterfaceRequests.get(quickInfos.getID());
        if (interfaceRequest != null) {
            interfaceRequest.complete(quickInfos);
            this.runningInterfaceRequests.remove(quickInfos.getID());
        } else {
            log.debug("Received QuickInfos with an unknown ID. Probably from an timeouted or canceled previous request.");
        }
    }

    public void invokeQuickInfoAction(QuickInfoAction action) {
        try {
            Map actionData = action.getActionData();
            switch (action.getTarget()) {
                case MODULE: {
                    String moduleKey = (String)actionData.get("moduleID");
                    String dialogKey = (String)actionData.get("dialogID");
                    String[] filter = this.getFilterList(actionData);
                    String bsh = (String)actionData.get("bsh");
                    if (moduleKey != null && dialogKey != null && filter != null) {
                        ModuleContext module = this.context.getModule(moduleKey);
                        if (module == null) {
                            throw new IllegalStateException("Module " + moduleKey + " is not assigned to user");
                        }
                        DialogContext dialog = module.getDialog(dialogKey);
                        dialog.setFilter(filter);
                        dialog.show();
                        break;
                    }
                    if (moduleKey != null && bsh != null) {
                        BshMenuRuntime rt = BshMenuRuntime.getInstance(bsh, this.context, Integer.parseInt(moduleKey));
                        rt.onClick();
                        break;
                    }
                    throw new IllegalStateException("Unknown module action from quickinfo");
                }
                case WEB: {
                    URI uri = URI.create((String)actionData.get("uri"));
                    Desktop.getDesktop().browse(uri);
                    break;
                }
                case LOCAL: {
                    String actionName = (String)actionData.get("action");
                    Map parameters = (Map)actionData.get("parameters");
                    this.context.invokeExternalCall(actionName, parameters);
                    break;
                }
                default: {
                    log.error("Unknown quick info action type '{}'", (Object)action.getTarget());
                    break;
                }
            }
        }
        catch (Exception e) {
            log.error("QuickInfo Action could not be executed", (Throwable)e);
        }
    }

    public Set<String> getLayersWithoutTooltips() throws ServiceException {
        try {
            HashSet<String> allLayersWithoutTooltip = new HashSet<String>();
            Iterator<ModuleContext> modules = this.context.getModules();
            while (modules.hasNext()) {
                ModuleContext module = modules.next();
                Map quickInfoMapping = (Map)module.getModuleInfo("mod_quickinfo_mapping");
                if (quickInfoMapping == null || quickInfoMapping.isEmpty()) continue;
                Set<String> moduleQuickInfoMappingsWithoutTooltips = this.collectTooltips(module);
                quickInfoMapping.entrySet().stream().filter(kv -> moduleQuickInfoMappingsWithoutTooltips.contains(kv.getKey())).flatMap(kv -> ((Map)kv.getValue()).keySet().stream()).forEach(allLayersWithoutTooltip::add);
            }
            return allLayersWithoutTooltip;
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    private Set<String> collectTooltips(ModuleContext module) throws Exception {
        if (module == null) {
            return Collections.emptySet();
        }
        Map layersWithTooltips = (Map)module.getModuleInfo("mod_quickinfo_mapping_tooltips");
        if (layersWithTooltips == null) {
            return Collections.emptySet();
        }
        return layersWithTooltips.entrySet().stream().filter(kv -> (Integer)kv.getValue() == 0).map(kv -> (String)kv.getKey()).collect(Collectors.toSet());
    }

    private String[] getFilterList(Map<String, Object> actionData) {
        Object filter = actionData.get("filter");
        if (filter == null) {
            return null;
        }
        if (filter instanceof List) {
            return (String[])((List)filter).toArray(String[]::new);
        }
        return (String[])filter;
    }

    private Stream<Map<String, Map<String, Map<String, String>>>> getRawQuickInfoMappingsFromModules() {
        try {
            return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.context.getModules(), 16), false).map(mod -> {
                try {
                    return (Map)mod.getModuleInfo("mod_quickinfo_mapping");
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }).filter(Objects::nonNull);
        }
        catch (ServiceException e) {
            throw new IllegalStateException(e);
        }
    }

    private CompletableFuture<SubstitutionBuilder> getQuickInfoSubstitutions(QuickInfoRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            log.debug("Determining substitutions for quick info request");
            String layerID = request.getLayerID();
            SourceMapping sourceMapping = this.findMatchingSourceMapping(layerID);
            Map<String, String> substitutions = this.substituteValuesFromFeature(request, layerID, sourceMapping);
            return new SubstitutionBuilder(request, substitutions, sourceMapping.getName());
        });
    }

    private Map<String, String> substituteValuesFromFeature(QuickInfoRequest request, String layerID, SourceMapping sourceMapping) {
        FeatureAttributeSubstitutor substitutor = new FeatureAttributeSubstitutor("null");
        SimpleFeature feature = this.retrieveFeatureWithRequiredFields(layerID, request.getKey(), sourceMapping.getTemplates());
        return sourceMapping.getTemplates().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, kv -> substitutor.replace(feature, (String)kv.getValue())));
    }

    private SourceMapping findMatchingSourceMapping(String layerID) {
        return this.getRawQuickInfoMappingsFromModules().flatMap(x -> x.entrySet().stream()).filter(x -> ((Map)x.getValue()).containsKey(layerID)).map(x -> new SourceMapping((String)x.getKey(), (Map)((Map)x.getValue()).get(layerID))).findAny().orElseThrow();
    }

    private SimpleFeature retrieveFeatureWithRequiredFields(String layerID, Object key, Map<String, String> fieldTemplates) {
        try {
            Set attributes = fieldTemplates.values().stream().flatMap(v -> FeatureAttributeSubstitutor.getPlaceholders(v).stream()).collect(Collectors.toSet());
            LayerContext mapLayer = this.getActiveMap().getMapLayer(layerID);
            return (SimpleFeature)((VectorLayerContext)mapLayer).featuresForFIDs(Collections.singletonList(key.toString()), 1, attributes).findAny().orElseThrow();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private MapContext getActiveMap() throws Exception {
        return WebGisClient.GIS_CONTEXT.getMapApp().getActiveMap();
    }

    private QuickInfoList requestQuickInfosFromServer(Map<String, Object> substitutions) throws ServiceException {
        long timestart = System.currentTimeMillis();
        ServiceMData moduleService = ServiceRegistry.getService((String)"module", (int)0);
        HashMap<String, Map<String, Object>> params = new HashMap<String, Map<String, Object>>();
        params.put("quickinfo_substitutions", substitutions);
        ServiceRequest req = moduleService.createRequest("get_quickinfos", params);
        List quickInfoCategories = (List)this.context.getServiceProvider().execRequest(req).getResult();
        long timeend = System.currentTimeMillis();
        log.trace("QuickInfo Request to Server: " + (timeend - timestart));
        return new QuickInfoListImpl(UUID.randomUUID(), quickInfoCategories.stream().map(info -> {
            String category = (String)info.get("category");
            int priority = this.getQuickInfoPriority((Map<String, Object>)info);
            List<QuickInfo> elements = this.deserializeSubElements((List)info.get(MODULE_PARAM_ELEMENTS));
            return new QuickInfoCategoryImpl(category, priority, elements);
        }).collect(Collectors.toList()));
    }

    private List<QuickInfo> deserializeSubElements(List<Map<String, Object>> rawElements) {
        return rawElements.stream().map(info -> {
            String label = (String)info.get(MODULE_PARAM_LABEL);
            List rawActions = (List)info.get(MODULE_PARAM_ACTIONS);
            List actions = rawActions.stream().map(rawAction -> {
                String actionText = (String)rawAction.get(MODULE_PARAM_ACTION_TEXT);
                Map actionData = (Map)rawAction.get(MODULE_PARAM_ACTION_DATA);
                String rawTarget = (String)rawAction.get(MODULE_PARAM_TARGET);
                QuickInfoTarget target = rawTarget != null ? QuickInfoTarget.valueOf((String)rawTarget) : null;
                return new QuickInfoActionImpl(actionText, actionData, target);
            }).collect(Collectors.toList());
            List<QuickInfo> elements = this.deserializeSubElements((List)info.get(MODULE_PARAM_ELEMENTS));
            return new QuickInfoImpl(label, actions, elements);
        }).collect(Collectors.toList());
    }

    private boolean serverDeliversQuickInfos() {
        return this.context.getVersionWithHotfix().filter(v -> VersionComparator.DEFAULT_VERSIONCOMPARATOR.compare(v, VERSION_MIN_FOR_MODULE_INFOS) >= 0).isPresent();
    }

    private int getQuickInfoPriority(Map<String, Object> mapInfo) {
        Object object = mapInfo.get("priority");
        if (object instanceof Integer) {
            Integer priority = (Integer)object;
            return priority;
        }
        return 0;
    }
}

