/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.webgiscli.quickinfo;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.riwagis.gis.context.module.quickinfo.QuickInfo;
import de.riwagis.gis.context.module.quickinfo.QuickInfoAction;
import de.riwagis.gis.context.module.quickinfo.QuickInfoList;
import de.riwagis.gis.context.module.quickinfo.QuickInfoTarget;
import de.riwagis.gis.context.module.quickinfo.impl.QuickInfoActionImpl;
import de.riwagis.gis.context.module.quickinfo.impl.QuickInfoCategory;
import de.riwagis.gis.context.module.quickinfo.impl.QuickInfoCategoryImpl;
import de.riwagis.gis.context.module.quickinfo.impl.QuickInfoImpl;
import de.riwagis.gis.context.module.quickinfo.impl.QuickInfoListImpl;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JacksonQuickInfoResponseMapper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JacksonQuickInfoResponseMapper.class);
    private static final int CURRENT_QUICK_INFO_VERSION = 3;
    private static final String FIELD_VERSION = "version";
    private static final String FIELD_REQUEST_ID = "requestID";
    private static final String FIELD_CATEGORY = "category";
    private static final String FIELD_ELEMENTS = "elements";
    private static final String FIELD_QUICK_INFOS = "quickInfos";
    private static final String FIELD_LABEL = "label";
    private static final String FIELD_ACTION_TEXT = "actionText";
    private static final String FIELD_ACTION_DATA = "actionData";
    private static final String FIELD_TARGET = "target";
    private static final String FIELD_ACTIONS = "actions";
    private static final String FIELD_PRIORITY = "priority";
    private final ObjectMapper quickInfoListMapper;
    private final Map<Integer, Function<JsonNode, JsonNode>> responseUpgrade = Map.of(1, this::convertV1toV2, 2, this::convertV2toV3);

    public JacksonQuickInfoResponseMapper() {
        InjectableValues.Std injectableValues = new InjectableValues.Std().addValue("defaultEmptyList", Collections.emptyList()).addValue(QuickInfoTarget.class, (Object)QuickInfoTarget.LOCAL);
        this.quickInfoListMapper = new ObjectMapper().configure(JsonParser.Feature.ALLOW_COMMENTS, true).setInjectableValues((InjectableValues)injectableValues).addMixIn(QuickInfoList.class, QuickInfoListMixin.class).addMixIn(QuickInfoListImpl.class, QuickInfoListMixin.class).addMixIn(QuickInfoCategory.class, QuickInfoCategoryMixin.class).addMixIn(QuickInfoCategoryImpl.class, QuickInfoCategoryMixin.class).addMixIn(QuickInfo.class, QuickInfoMixin.class).addMixIn(QuickInfoImpl.class, QuickInfoMixin.class).addMixIn(QuickInfoAction.class, QuickInfoActionMixin.class).addMixIn(QuickInfoActionImpl.class, QuickInfoActionMixin.class);
    }

    private JsonNode convertV1toV2(JsonNode node) {
        ObjectNode oNode = (ObjectNode)node;
        ArrayNode quickInfos = (ArrayNode)oNode.remove(FIELD_QUICK_INFOS);
        ArrayNode newInfos = oNode.putArray(FIELD_QUICK_INFOS);
        HashMap<String, ArrayNode> categoryToElements = new HashMap<String, ArrayNode>();
        for (JsonNode oldInfo : quickInfos) {
            String category = oldInfo.get(FIELD_CATEGORY).asText();
            JsonNode label = oldInfo.path(FIELD_LABEL);
            JsonNode actionText = oldInfo.path(FIELD_ACTION_TEXT);
            JsonNode actionData = oldInfo.path(FIELD_ACTION_DATA);
            JsonNode target = oldInfo.path(FIELD_TARGET);
            ObjectNode element = (ObjectNode)categoryToElements.computeIfAbsent(category, c -> newInfos.addObject().put(FIELD_CATEGORY, category).putArray(FIELD_ELEMENTS)).addObject().set(FIELD_LABEL, label);
            ObjectNode action = element.putArray(FIELD_ACTIONS).addObject();
            action.set(FIELD_ACTION_TEXT, actionText);
            action.set(FIELD_ACTION_DATA, actionData);
            action.set(FIELD_TARGET, target);
        }
        return node;
    }

    private JsonNode convertV2toV3(JsonNode node) {
        ObjectNode oNode = (ObjectNode)node;
        ArrayNode quickInfos = (ArrayNode)oNode.get(FIELD_QUICK_INFOS);
        for (JsonNode oldInfo : quickInfos) {
            ((ObjectNode)oldInfo).put(FIELD_PRIORITY, Integer.MAX_VALUE);
        }
        return node;
    }

    public QuickInfoList mapJSONToList(String rawJsonData) throws JsonProcessingException {
        String rawJsonInCurrentVersion = this.ensureQuickInfoResponseFormat(rawJsonData);
        return (QuickInfoList)this.quickInfoListMapper.readValue(rawJsonInCurrentVersion, QuickInfoListImpl.class);
    }

    private String ensureQuickInfoResponseFormat(String rawQuickInfoList) throws JsonProcessingException {
        JsonNode jsonNode = this.quickInfoListMapper.readTree(rawQuickInfoList);
        int inputVersion = jsonNode.path(FIELD_VERSION).asInt(1);
        if (inputVersion == 3) {
            return rawQuickInfoList;
        }
        if (inputVersion > 3) {
            throw new IllegalArgumentException(String.format("Supplied Quick Info Response format version %s ist too new. Maximum version supported is %s", inputVersion, 3));
        }
        JsonNode currentNode = jsonNode;
        for (int currentVersion = inputVersion; currentVersion < 3; ++currentVersion) {
            log.debug("Converting Quick Info Response from v{} to v{}", (Object)currentVersion, (Object)(currentVersion + 1));
            currentNode = this.responseUpgrade.get(currentVersion).apply(currentNode);
        }
        return currentNode.toString();
    }

    @JsonDeserialize(as=QuickInfoListImpl.class)
    @JsonIgnoreProperties(value={"version"})
    public static class QuickInfoListMixin {
        @JsonCreator
        public QuickInfoListMixin(@JsonProperty(value="requestID") UUID id, @JsonProperty(value="quickInfos") List<QuickInfo> quickInfos) {
        }
    }

    @JsonDeserialize(as=QuickInfoCategoryImpl.class)
    public static class QuickInfoCategoryMixin {
        @JsonCreator
        public QuickInfoCategoryMixin(@JsonProperty(value="category") String name, @JsonProperty(value="priority") int priority, @JsonProperty(value="elements") List<QuickInfo> elements) {
        }
    }

    @JsonDeserialize(as=QuickInfoImpl.class)
    public static class QuickInfoMixin {
        @JsonCreator
        public QuickInfoMixin(@JsonProperty(value="label") String label, @JacksonInject(value="defaultEmptyList") @JsonProperty(value="actions") List<QuickInfoAction> actions, @JacksonInject(value="defaultEmptyList") @JsonProperty(value="elements") List<QuickInfo> elements) {
        }
    }

    @JsonDeserialize(as=QuickInfoActionImpl.class)
    public static class QuickInfoActionMixin {
        @JsonCreator
        public QuickInfoActionMixin(@JsonProperty(value="actionText") String actionText, @JsonProperty(value="actionData") Map<String, Object> actionData, @JacksonInject @JsonProperty(value="target") QuickInfoTarget target) {
        }
    }
}

