/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.webgiscli.module.special.system;

import de.riwagis.service.ServiceException;
import de.riwagis.service.ServiceMData;
import de.riwagis.service.ServiceRequest;
import de.riwagis.service.registry.ServiceRegistry;
import de.riwagis.service.stream.FileStreamProcessor;
import de.riwagis.util.Config;
import de.riwagis.util.file.FileSupport;
import de.riwagis.util.gui.ExceptionDialog;
import de.riwagis.util.gui.GUISupport;
import de.riwagis.util.gui.filedrop.FileDrop;
import de.riwagis.util.gui.models.ListListModel;
import de.riwagis.util.i18n.I18N;
import de.riwagis.webgiscli.WebGisContext;
import de.riwagis.webgiscli.module.special.system.Data4XDialog;
import de.riwagis.webgiscli.module.special.system.Data4XDialogHelper;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;

public class Symbol4ModuleDialog
extends Data4XDialog {
    private static final I18N i18n = new I18N(Config.LOCALE, "de.riwagis.webgiscli.i18n.i18n");
    private static final WebGisContext wgContext = WebGisContext.getInstance();
    private static final ServiceMData systemService = ServiceRegistry.getService((String)"system", (int)0);
    private static final String KEY_DIR = Symbol4ModuleDialog.class.getName() + "_Dir";
    private Integer contentID;
    public static final String SRVACTION_DOWNLOAD = "download_sym4module";
    public static final String KEY_CONTENTID = "module_key";
    public static final String[] KNOWN_EXTENSIONS = new String[]{"png", "svg"};
    public static final FileFilter mapFileFilter = GUISupport.createFileFilter((String)i18n.get("module.special.system.Symbol4ModuleDialog.symbols"), (String[])KNOWN_EXTENSIONS);
    private JButton butClose;
    private JButton butDelete;
    private JButton butDownload;
    private JButton butNew;
    private JButton butRename;
    private JCheckBox chkUseSubDirs;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JLabel lblDnD;
    private JLabel lblTitle;
    private JLabel lblTitleText;
    private JList<String> lstData;
    private JPanel pnlBottom;
    private JPanel pnlButtons;
    private JPanel pnlData;
    private JPanel pnlDataType;
    private JPanel pnlDrop;
    private JPanel pnlDropGlobal;
    private JPanel pnlTitle;

    public static String buildPathKey(String KEY_DIR, Integer intModKey1) {
        return String.format("%s_Mod%s", KEY_DIR, intModKey1);
    }

    public Symbol4ModuleDialog(Window parent) {
        super(parent, Dialog.ModalityType.DOCUMENT_MODAL);
        this.initComponents();
        this.i18n();
        this.setResizable(true);
        FileDrop fd = new FileDrop((Component)this.pnlDropGlobal, dropEvent -> {
            String destinationDir = this.queryDestinationDir();
            LinkedHashSet<File> allowedFiles = new LinkedHashSet<File>();
            for (File file2test : dropEvent.getFiles()) {
                if (!mapFileFilter.accept(file2test)) continue;
                allowedFiles.add(file2test);
            }
            if (!allowedFiles.isEmpty()) {
                try {
                    this.uploadSymbols(destinationDir, allowedFiles.toArray(new File[allowedFiles.size()]));
                }
                catch (ServiceException ex) {
                    ExceptionDialog.handleGuiException((Component)this, (Exception)((Object)ex), Symbol4ModuleDialog.class);
                }
            }
        });
    }

    @Override
    public final void initContent(Integer contentKey) throws ServiceException {
        this.contentID = contentKey;
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("key", contentKey);
        param.put("action", "module");
        ServiceRequest req = systemService.createRequest("get_system_info", param);
        Map mapInfo = (Map)wgContext.getServiceProvider().execRequest(req).getResult();
        String contentName = ObjectUtils.toString(mapInfo.get("mod_name"));
        this.lblTitleText.setText(i18n.fmt("module.special.system.Data4XDialog.title_text", new Object[]{contentName, contentKey}));
        GUISupport.setDefaultButton((JButton)this.butClose, (int)27);
        GUISupport.setDefaultButton((JButton)this.butDelete, (int)127);
        this.pack();
        this.refreshData();
    }

    @Override
    public void refreshData() throws ServiceException {
        HashMap<String, Integer> param = new HashMap<String, Integer>();
        param.put(KEY_CONTENTID, this.contentID);
        ServiceRequest req = systemService.createRequest("get_syms4module", param);
        List llstData = (List)wgContext.getServiceProvider().execRequest(req).getResult();
        Collections.sort(llstData, String.CASE_INSENSITIVE_ORDER);
        this.lstData.setModel((ListModel<String>)new ListListModel(llstData));
    }

    private void i18n() {
        this.lblDnD.setText(i18n.get("common.drop-file"));
        this.setTitle(i18n.get("module.special.system.Symbol4ModuleDialog.title"));
        this.lblTitle.setText(i18n.get("module.special.system.Symbol4ModuleDialog.module"));
        ((TitledBorder)this.pnlData.getBorder()).setTitle(i18n.get("module.special.system.Symbol4ModuleDialog.symbols"));
        this.butNew.setText(i18n.get("common.upload"));
        this.butRename.setText(i18n.get("common.rename"));
        this.butDelete.setText(i18n.get("common.delete"));
        this.butClose.setText(i18n.get("common.close"));
        this.butDownload.setText(i18n.get("common.download"));
    }

    private void initComponents() {
        this.pnlDropGlobal = new JPanel();
        this.pnlDrop = new JPanel();
        this.lblDnD = new JLabel();
        this.pnlTitle = new JPanel();
        this.lblTitle = new JLabel();
        this.lblTitleText = new JLabel();
        this.pnlDataType = new JPanel();
        this.pnlData = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.lstData = new JList();
        this.jPanel1 = new JPanel();
        this.butNew = new JButton();
        this.butRename = new JButton();
        this.butDelete = new JButton();
        this.butDownload = new JButton();
        this.pnlBottom = new JPanel();
        this.chkUseSubDirs = new JCheckBox();
        this.pnlButtons = new JPanel();
        this.butClose = new JButton();
        this.setMinimumSize(new Dimension(350, 420));
        this.setPreferredSize(new Dimension(380, 470));
        this.getContentPane().setLayout(new GridBagLayout());
        this.pnlDropGlobal.setLayout(new GridBagLayout());
        this.pnlDrop.setLayout(new GridBagLayout());
        this.lblDnD.setBackground(new Color(255, 255, 204));
        this.lblDnD.setFont(this.lblDnD.getFont().deriveFont(this.lblDnD.getFont().getStyle() | 1, this.lblDnD.getFont().getSize() + 2));
        this.lblDnD.setForeground(new Color(102, 102, 102));
        this.lblDnD.setHorizontalAlignment(0);
        ResourceBundle bundle = ResourceBundle.getBundle("de/riwagis/webgiscli/i18n/i18n");
        this.lblDnD.setText(bundle.getString("common.drop-file"));
        this.lblDnD.setBorder(BorderFactory.createLineBorder(new Color(102, 102, 102), 2));
        this.lblDnD.setMaximumSize(new Dimension(104, 60));
        this.lblDnD.setMinimumSize(new Dimension(104, 60));
        this.lblDnD.setOpaque(true);
        this.lblDnD.setPreferredSize(new Dimension(34, 60));
        this.lblDnD.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                Symbol4ModuleDialog.this.lblDnDMouseClicked(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlDrop.add((Component)this.lblDnD, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.pnlDropGlobal.add((Component)this.pnlDrop, gridBagConstraints);
        this.pnlTitle.setBackground(UIManager.getDefaults().getColor("TabbedPane.light"));
        this.pnlTitle.setLayout(new GridBagLayout());
        this.lblTitle.setText(bundle.getString("module.special.system.Symbol4ModuleDialog.title"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(9, 9, 3, 3);
        this.pnlTitle.add((Component)this.lblTitle, gridBagConstraints);
        this.lblTitleText.setFont(this.lblTitleText.getFont().deriveFont(this.lblTitleText.getFont().getStyle() | 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(9, 9, 3, 3);
        this.pnlTitle.add((Component)this.lblTitleText, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.pnlDropGlobal.add((Component)this.pnlTitle, gridBagConstraints);
        this.pnlDataType.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.pnlDropGlobal.add((Component)this.pnlDataType, gridBagConstraints);
        this.pnlData.setBorder(BorderFactory.createTitledBorder("Symbole"));
        this.pnlData.setLayout(new GridBagLayout());
        this.jScrollPane1.setMinimumSize(new Dimension(150, 100));
        this.jScrollPane1.setPreferredSize(new Dimension(300, 200));
        this.lstData.setMinimumSize(null);
        this.lstData.setPreferredSize(null);
        this.lstData.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                Symbol4ModuleDialog.this.lstData_onMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.lstData);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlData.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.butNew.setText(bundle.getString("common.upload"));
        this.butNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Symbol4ModuleDialog.this.butNew_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 9);
        this.jPanel1.add((Component)this.butNew, gridBagConstraints);
        this.butRename.setText(bundle.getString("common.rename"));
        this.butRename.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Symbol4ModuleDialog.this.butRename_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 9);
        this.jPanel1.add((Component)this.butRename, gridBagConstraints);
        this.butDelete.setText(bundle.getString("common.delete"));
        this.butDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Symbol4ModuleDialog.this.butDelete_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 3, 3, 9);
        this.jPanel1.add((Component)this.butDelete, gridBagConstraints);
        this.butDownload.setText(bundle.getString("common.download"));
        this.butDownload.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Symbol4ModuleDialog.this.butDownload_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 9, 9);
        this.jPanel1.add((Component)this.butDownload, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 1.0;
        this.pnlData.add((Component)this.jPanel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.pnlDropGlobal.add((Component)this.pnlData, gridBagConstraints);
        this.pnlBottom.setLayout(new GridBagLayout());
        this.chkUseSubDirs.setText(bundle.getString("module.special.system.Symbol4ModuleDialog.chkUseSubdir"));
        this.chkUseSubDirs.setToolTipText(bundle.getString("module.special.system.Symbol4ModuleDialog.chkUseSubdirTooltip"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlBottom.add((Component)this.chkUseSubDirs, gridBagConstraints);
        this.pnlButtons.setLayout(new GridBagLayout());
        this.butClose.setText(bundle.getString("common.close"));
        this.butClose.setPreferredSize(new Dimension(100, 23));
        this.butClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Symbol4ModuleDialog.this.butClose_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(9, 3, 9, 9);
        this.pnlButtons.add((Component)this.butClose, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        this.pnlBottom.add((Component)this.pnlButtons, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.pnlDropGlobal.add((Component)this.pnlBottom, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        this.getContentPane().add((Component)this.pnlDropGlobal, gridBagConstraints);
        this.pack();
    }

    private void butDownload_onActionPerformed(ActionEvent evt) {
        try {
            if (Data4XDialogHelper.checkIsAnEntrySelected(this.lstData)) {
                String pathKey = Symbol4ModuleDialog.buildPathKey(KEY_DIR, this.contentID);
                File destination = GUISupport.chooseDirectory((Component)this, (String)i18n.get("module.special.system.Symbol4ModuleDialog.storeSymbols"), (File)Data4XDialogHelper.retrievePathFromWB(pathKey));
                if (destination != null) {
                    Data4XDialogHelper.rememberPathInWB(pathKey, destination);
                    List<String> selectedEntries = this.lstData.getSelectedValuesList();
                    for (String arrSymName : selectedEntries) {
                        HashMap<String, Object> param = new HashMap<String, Object>();
                        param.put(KEY_CONTENTID, this.contentID);
                        param.put("sym_name", arrSymName.toString());
                        File dataFileFinal = new File(destination, arrSymName.toString());
                        if (!dataFileFinal.getParentFile().exists()) {
                            dataFileFinal.getParentFile().mkdirs();
                        }
                        Data4XDialogHelper.startServerCommunication(this, i18n.get("common.wait"), param, SRVACTION_DOWNLOAD, new FileStreamProcessor(dataFileFinal));
                    }
                    GUISupport.msgbox((Component)this, (String)i18n.get("module.special.system.Symbol4ModuleDialog.success"), (String)i18n.get("common.message"));
                    this.refreshData();
                }
            }
        }
        catch (Exception e) {
            ExceptionDialog.handleGuiException((Component)this, (Throwable)e, (String)"webgiscli");
        }
    }

    private void lstData_onMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.butRename_onActionPerformed(null);
        }
    }

    private void butRename_onActionPerformed(ActionEvent evt) {
        try {
            if (Data4XDialogHelper.checkOneEntrySelected(this.lstData)) {
                Object strName;
                String selectedEntry;
                String strDataName = selectedEntry = this.lstData.getSelectedValue();
                String strExt = FilenameUtils.getExtension((String)strDataName);
                Object strOldFileName = FilenameUtils.getBaseName((String)strDataName);
                String strPath = FileSupport.getPathOfFile((String)strDataName);
                if (strPath.length() > 0) {
                    strOldFileName = strPath + "/" + (String)strOldFileName;
                }
                if ((strName = Data4XDialogHelper.askNewMapName(this, (String)strOldFileName, "module.special.system.Symbol4ModuleDialog.input-sym-name")) != null) {
                    if (StringUtils.isBlank((String)strName)) {
                        throw new Exception(i18n.get("module.special.system.Symbol4ModuleDialog.invalidSymbolName"));
                    }
                    if (!FilenameUtils.isExtension((String)StringUtils.lowerCase((String)strName), (String[])KNOWN_EXTENSIONS)) {
                        strName = (String)strName + "." + strExt;
                    }
                    HashMap<String, Object> param = new HashMap<String, Object>();
                    param.put(KEY_CONTENTID, this.contentID);
                    param.put("sym_name", strDataName + "|" + (String)strName);
                    param.put("action", "rename");
                    Data4XDialogHelper.startServerCommunication(this, i18n.get("common.wait"), param, "edit_sym4module", null);
                    GUISupport.msgbox((Component)this, (String)i18n.get("module.special.system.Symbol4ModuleDialog.success"), (String)i18n.get("common.message"));
                    this.refreshData();
                }
            }
        }
        catch (Exception e) {
            ExceptionDialog.handleGuiException((Component)this, (Throwable)e, (String)"webgiscli");
        }
    }

    private void butDelete_onActionPerformed(ActionEvent evt) {
        try {
            if (Data4XDialogHelper.checkIsAnEntrySelected(this.lstData)) {
                boolean bolDelete = GUISupport.yesnobox((Component)this, (String)i18n.get("module.special.system.Data4XDialog.delete-question"), (String)i18n.get("common.message"));
                if (!bolDelete) {
                    return;
                }
                for (String entry : this.lstData.getSelectedValuesList()) {
                    HashMap<String, Object> param = new HashMap<String, Object>();
                    param.put(KEY_CONTENTID, this.contentID);
                    param.put("sym_name", entry);
                    param.put("action", "delete");
                    Data4XDialogHelper.startServerCommunication(this, i18n.get("common.wait"), param, "edit_sym4module", null);
                }
                GUISupport.msgbox((Component)this, (String)i18n.get("module.special.system.Symbol4ModuleDialog.success"), (String)i18n.get("common.message"));
                this.refreshData();
            }
        }
        catch (Exception e) {
            ExceptionDialog.handleGuiException((Component)this, (Throwable)e, (String)"webgiscli");
        }
    }

    private void butNew_onActionPerformed(ActionEvent evt) {
        try {
            File[] arrFiles;
            String destinationDir = this.queryDestinationDir();
            if (destinationDir != null) {
                String pathKey = Symbol4ModuleDialog.buildPathKey(KEY_DIR, this.contentID);
                arrFiles = GUISupport.chooseFile((Component)this, (String)i18n.get("module.special.system.Symbol4ModuleDialog.symbols"), (FileFilter[])new FileFilter[]{mapFileFilter}, (File)Data4XDialogHelper.retrievePathFromWB(pathKey), (boolean)true, (boolean)true);
                if (arrFiles != null && arrFiles.length > 0) {
                    Data4XDialogHelper.rememberPathInWB(pathKey, arrFiles[0]);
                }
            } else {
                arrFiles = null;
            }
            this.uploadSymbols(destinationDir, arrFiles);
        }
        catch (Exception e) {
            ExceptionDialog.handleGuiException((Component)this, (Throwable)e, (String)"webgiscli");
        }
    }

    private void uploadSymbols(String destinationDir, File[] arrFiles) throws ServiceException {
        if (destinationDir != null && arrFiles != null && arrFiles.length > 0) {
            for (File destination : arrFiles) {
                HashMap<String, Object> param = new HashMap<String, Object>();
                param.put(KEY_CONTENTID, this.contentID);
                param.put("file", destination);
                param.put("sym_name", StringUtils.isBlank((String)destinationDir) ? destination.getName() : destinationDir + "/" + destination.getName());
                Data4XDialogHelper.startServerCommunication(this, i18n.get("common.wait"), param, "upload_sym4module", null);
            }
            GUISupport.msgbox((Component)this, (String)i18n.get("module.special.system.Symbol4ModuleDialog.success"), (String)i18n.get("common.message"));
            this.refreshData();
        }
    }

    public String queryDestinationDir() {
        String destinationDir = this.chkUseSubDirs.isSelected() ? Data4XDialogHelper.askUploadPath(this, this.lstData.getModel()) : "";
        return destinationDir;
    }

    private void butClose_onActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void lblDnDMouseClicked(MouseEvent evt) {
        this.butNew.doClick();
    }
}

