/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.webgiscli.module.special.system;

import de.riwagis.browser.BrowserFrame;
import de.riwagis.browser.WindowManager;
import de.riwagis.util.exception.SystemException;
import de.riwagis.util.gui.ExceptionDialog;
import de.riwagis.webgiscli.WebGisContext;
import de.riwagis.webgiscli.module.special.system.Data4AdminDialog;
import de.riwagis.webgiscli.module.special.system.Data4ModuleDialog;
import de.riwagis.webgiscli.module.special.system.Symbol4ModuleDialog;
import de.riwagis.webgiscli.servlet.actions.AbstractAsyncAction;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Arrays;
import java.util.Map;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;

public class ShowSystemDialogAction
extends AbstractAsyncAction {
    private static final String ACT_MAP4ADMIN = "map4admin";
    private static final String ACT_SYM4MODULE = "sym4module";
    private static final String ACT_MAP4MODULE = "map4module";
    private static Data4ModuleDialog m4mDialog = null;
    private static Data4AdminDialog m4aDialog = null;
    private static Symbol4ModuleDialog s4mDialog = null;

    @Override
    public String getName() {
        return "system_ShowDialog";
    }

    @Override
    public synchronized void executeInternal(Map<String, Object[]> mapParam) throws SystemException {
        block13: {
            try {
                Object[] objModKey;
                Object[] objAction = mapParam.get("action");
                if (objAction == null) {
                    throw new Exception("Invalid Parameters");
                }
                String strAction = ((String[])objAction)[0];
                Window parentFrame = null;
                Frame centerWindow = WebGisContext.getWebGisClientFrame();
                if (Arrays.asList(ACT_MAP4MODULE, ACT_SYM4MODULE).contains(strAction)) {
                    if (m4mDialog == null || s4mDialog == null) {
                        s4mDialog = new Symbol4ModuleDialog(parentFrame);
                        m4mDialog = new Data4ModuleDialog(parentFrame);
                        windowAdapter = new ComponentAdapter(this){

                            @Override
                            public void componentHidden(ComponentEvent e) {
                                ShowSystemDialogAction.requestBrowserFrameFocus("mod_struct");
                                for (JDialog currDialog : new JDialog[]{m4mDialog, s4mDialog}) {
                                    if (currDialog == null || !currDialog.isVisible()) continue;
                                    currDialog.requestFocus();
                                }
                            }
                        };
                        m4mDialog.addComponentListener((ComponentListener)windowAdapter);
                        s4mDialog.addComponentListener((ComponentListener)windowAdapter);
                        m4mDialog.setLocationRelativeTo(centerWindow);
                        s4mDialog.setLocationRelativeTo(centerWindow);
                    }
                } else if (Arrays.asList(ACT_MAP4ADMIN).contains(strAction) && m4aDialog == null) {
                    m4aDialog = new Data4AdminDialog(parentFrame);
                    windowAdapter = new WindowAdapter(this){

                        @Override
                        public void windowClosing(WindowEvent e) {
                            ShowSystemDialogAction.requestBrowserFrameFocus("rsv_dd");
                            for (JDialog currDialog : new JDialog[]{m4aDialog}) {
                                if (currDialog == null || !currDialog.isVisible()) continue;
                                currDialog.requestFocus();
                            }
                        }
                    };
                    m4aDialog.addWindowListener((WindowListener)windowAdapter);
                    m4aDialog.setLocationRelativeTo(centerWindow);
                }
                if (strAction.equals(ACT_MAP4MODULE)) {
                    objModKey = mapParam.get("module_key");
                    if (objModKey == null) {
                        throw new Exception("Invalid Parameters");
                    }
                    m4mDialog.initContent(Integer.parseInt(((String[])objModKey)[0]));
                    m4mDialog.setVisible(true);
                    break block13;
                }
                if (strAction.equals(ACT_MAP4ADMIN)) {
                    Object[] objAdminKey = mapParam.get("admin_key");
                    if (objAdminKey == null) {
                        throw new Exception("Invalid Parameters");
                    }
                    m4aDialog.initContent(Integer.parseInt(((String[])objAdminKey)[0]));
                    m4aDialog.setVisible(true);
                    break block13;
                }
                if (strAction.equals(ACT_SYM4MODULE)) {
                    objModKey = mapParam.get("module_key");
                    if (objModKey == null) {
                        throw new Exception("Invalid Parameters");
                    }
                    s4mDialog.initContent(Integer.parseInt(((String[])objModKey)[0]));
                    s4mDialog.setVisible(true);
                    break block13;
                }
                throw new Exception(String.format("invalid action parameter '%s'", strAction));
            }
            catch (Exception e) {
                ExceptionDialog.handleGuiException((Component)WebGisContext.getWebGisClientFrame(), (Throwable)e, (String)"webgiscli");
                throw new SystemException(this.getClass(), (Throwable)e);
            }
        }
    }

    public static void requestBrowserFrameFocus(String windowName) {
        SwingUtilities.invokeLater(() -> {
            BrowserFrame win = WindowManager.getInstance().getWindow(windowName);
            if (win != null) {
                win.requestFocus();
            }
        });
    }
}

