/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.webgiscli.module.special.system;

import de.riwagis.service.ServiceException;
import de.riwagis.service.ServiceMData;
import de.riwagis.service.ServiceRequest;
import de.riwagis.service.StreamProcessor;
import de.riwagis.service.registry.ServiceRegistry;
import de.riwagis.util.Config;
import de.riwagis.util.Whiteboard;
import de.riwagis.util.file.FileSupport;
import de.riwagis.util.gui.GUISupport;
import de.riwagis.util.gui.components.WaitDialog;
import de.riwagis.util.i18n.I18N;
import de.riwagis.webgiscli.WebGisContext;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.HeadlessException;
import java.awt.Window;
import java.io.File;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.ListModel;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Data4XDialogHelper {
    private static final Logger LOG = LoggerFactory.getLogger(Data4XDialogHelper.class);
    private static final WebGisContext wgContext = WebGisContext.getInstance();
    private static final ServiceMData systemService = ServiceRegistry.getService((String)"system", (int)0);
    private static final I18N i18n = new I18N(Config.LOCALE, "de.riwagis.webgiscli.i18n.i18n");
    public static final Comparator<String[]> COMPARATOR_STRINGARRAY = new Comparator<String[]>(){

        @Override
        public int compare(String[] o1, String[] o2) {
            return o1[1].compareTo(o2[1]);
        }
    };

    public static File getMapFile(Component parent, String title, boolean showSaveDialog, File lastDirOrFile, String filterDescription, String extension) throws HeadlessException {
        String buttonText;
        JFileChooser dataFileChooser = GUISupport.createJFileChooser();
        dataFileChooser.setFileFilter(Data4XDialogHelper.createFileFilter(filterDescription, extension));
        dataFileChooser.setAcceptAllFileFilterUsed(false);
        dataFileChooser.setMultiSelectionEnabled(false);
        if (lastDirOrFile.isDirectory()) {
            dataFileChooser.setCurrentDirectory(lastDirOrFile);
        } else {
            dataFileChooser.setSelectedFile(lastDirOrFile);
        }
        String string = buttonText = showSaveDialog ? i18n.get("common.download") : i18n.get("common.upload");
        if (StringUtils.isNotBlank((String)title)) {
            dataFileChooser.setDialogTitle(title);
        } else {
            dataFileChooser.setDialogTitle(buttonText);
        }
        int intOption = dataFileChooser.showDialog(parent, buttonText);
        File dataFile = intOption == 1 ? null : dataFileChooser.getSelectedFile();
        return dataFile;
    }

    public static FileFilter createFileFilter(final String filterDescription, final String extension) {
        return new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || FilenameUtils.wildcardMatch((String)f.getName(), (String)("*." + extension), (IOCase)IOCase.INSENSITIVE);
            }

            @Override
            public String getDescription() {
                return String.format("%s (*.%s)", filterDescription, extension);
            }
        };
    }

    public static void storeToWB(String whiteboardKey, Object storedValue) {
        Whiteboard wb = wgContext.getPermWhiteboard();
        wb.setAttribute(whiteboardKey, storedValue);
        wgContext.writePermWhiteboard();
    }

    public static Object readFromWB(String whiteboardKey, Object defaultObjectValue) {
        Whiteboard wb = wgContext.getPermWhiteboard();
        return wb.getAttribute(whiteboardKey, defaultObjectValue);
    }

    public static final String readStringFromWB(String whiteboardKey, String defaultValue) {
        return ObjectUtils.toString((Object)Data4XDialogHelper.readFromWB(whiteboardKey, defaultValue));
    }

    public static <T> void startServerCommunication(Dialog parent, String message, final Map<String, Object> param, final String requestCommand, final StreamProcessor<T> streamProcessor) throws ServiceException {
        WaitDialog dlgWait = WaitDialog.createWaitDialog((Window)parent, (String)message, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                ServiceRequest req = systemService.createRequest(requestCommand, param);
                if (streamProcessor != null) {
                    req.setStreamProcessor(streamProcessor);
                }
                return wgContext.getServiceProvider().execRequest(req).getResult();
            }
        });
        dlgWait.setCancelable(false);
        dlgWait.setVisible(true);
        Exception executionFailure = dlgWait.getError();
        if (executionFailure != null) {
            throw new ServiceException(String.format("error communicating with server: %s", executionFailure.getMessage()), (Throwable)executionFailure);
        }
    }

    public static final String askNewMapName(Dialog parent, String defaultName, String messageKey) {
        String strName;
        while ((strName = GUISupport.inputbox((Component)parent, (String)i18n.fmt(messageKey, new Object[]{defaultName}), (String)i18n.get("common.message"), (String)defaultName)) != null && StringUtils.isBlank((String)strName)) {
            GUISupport.msgbox((Component)parent, (String)i18n.fmt("module.special.system.Data4AdminDialog.input-data-name-empty", new Object[0]), (String)i18n.get("common.message"));
        }
        return strName;
    }

    public static boolean checkIsAnEntrySelected(JList<?> component) {
        if (component.getSelectedValue() == null) {
            GUISupport.msgbox((Component)GUISupport.findParentWindow(component), (String)i18n.get("module.special.system.Data4AdminDialog.no-selection"), (String)i18n.get("common.message"));
            return false;
        }
        return true;
    }

    public static boolean checkMultipleEntriesSelected(JList<?> component) {
        if (component.getSelectedValuesList().size() > 1) {
            GUISupport.msgbox((Component)GUISupport.findParentWindow(component), (String)i18n.get("module.special.system.Data4AdminDialog.no-multiple-selection"), (String)i18n.get("common.message"));
            return true;
        }
        return false;
    }

    public static boolean checkOneEntrySelected(JList<?> component) {
        return Data4XDialogHelper.checkIsAnEntrySelected(component) && !Data4XDialogHelper.checkMultipleEntriesSelected(component);
    }

    public static File retrievePathFromWB(String pathKey) {
        return new File(Data4XDialogHelper.readStringFromWB(pathKey, ""));
    }

    public static void rememberPathInWB(String pathKey, File filePath) {
        if (filePath != null) {
            Data4XDialogHelper.storeToWB(pathKey, filePath.isDirectory() ? filePath : filePath.getParent());
        }
    }

    public static String askUploadPath(Component parent, ListModel<String> lModel) throws HeadlessException {
        JComboBox<String> cmb = new JComboBox<String>();
        cmb.setEditable(true);
        LinkedHashSet<String> lstDirs = new LinkedHashSet<String>();
        for (int i = 0; i < lModel.getSize(); ++i) {
            String strPath = FileSupport.getPathOfFile((String)lModel.getElementAt(i));
            if (lstDirs.contains(strPath)) continue;
            lstDirs.add(strPath);
            cmb.addItem(strPath);
        }
        BorderLayout bly = new BorderLayout(5, 5);
        JPanel pnlList = new JPanel(bly);
        pnlList.add((Component)new JLabel(i18n.get("module.special.system.Symbol4ModuleDialog.choose-directory")), "North");
        pnlList.add(cmb, "Center");
        if (JOptionPane.showOptionDialog(parent, pnlList, i18n.get("module.special.system.Symbol4ModuleDialog.choose-directory.title"), 2, 3, null, null, null) == 0) {
            String strPath = ObjectUtils.toString((Object)cmb.getSelectedItem());
            return strPath;
        }
        return null;
    }

    public static int yesnobox(final Component _parent, final String strMessage, final String strTitle) {
        final int[] arrReturn = new int[1];
        try {
            GUISupport.executeSyncOnEventThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    int intReturn;
                    GUISupport.toFront((Component)_parent);
                    arrReturn[0] = intReturn = JOptionPane.showConfirmDialog(_parent, strMessage, strTitle, 1);
                }
            });
            return arrReturn[0];
        }
        catch (Exception e) {
            LOG.error(String.format("Error on showing inputbox: %s", e.getMessage()), (Throwable)e);
            return 2;
        }
    }

    private Data4XDialogHelper() {
    }
}

