/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.webgiscli.module.special.system;

import de.riwagis.service.ServiceException;
import de.riwagis.service.ServiceMData;
import de.riwagis.service.ServiceRequest;
import de.riwagis.service.registry.ServiceRegistry;
import de.riwagis.service.stream.FileStreamProcessor;
import de.riwagis.util.Config;
import de.riwagis.util.file.FileSupport;
import de.riwagis.util.gui.ExceptionDialog;
import de.riwagis.util.gui.GUISupport;
import de.riwagis.util.gui.filedrop.FileDrop;
import de.riwagis.util.i18n.I18N;
import de.riwagis.webgiscli.WebGisContext;
import de.riwagis.webgiscli.module.special.system.Data4XDialog;
import de.riwagis.webgiscli.module.special.system.Data4XDialogHelper;
import de.riwagis.webgiscli.module.special.system.FileMDFileType;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Data4XBaseDialog
extends Data4XDialog {
    private static final Logger LOG = LoggerFactory.getLogger((String)"webgiscli");
    protected static final I18N i18n = new I18N(Config.LOCALE, "de.riwagis.webgiscli.i18n.i18n");
    protected static final WebGisContext wgContext = WebGisContext.getInstance();
    protected static final ServiceMData systemService = ServiceRegistry.getService((String)"system", (int)0);
    protected Integer contentID;
    private final Map<Object, Integer> mapTypes = new HashMap<Object, Integer>();
    protected int intDataType = 1;
    private final String keyContentID;
    private final String srvactionDownload;
    private final String srvactionEdit;
    private final String srvactionAdd;
    private final String srvactionGettypes;
    private final String mapinfoContentName;
    private final String actionInit;
    private final DefaultListCellRenderer CELLRENDERER_STANDARD = new DefaultListCellRenderer(){

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String myVal = MessageFormat.format("{1}, {2}", (Object[])value);
            return super.getListCellRendererComponent(Data4XBaseDialog.this.lstData, myVal, index, isSelected, cellHasFocus);
        }
    };
    private final DefaultListCellRenderer CELLRENDERER_PRIO = new DefaultListCellRenderer(){

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String myVal = MessageFormat.format("{1}, priority: {4}, {2}", (Object[])value);
            return super.getListCellRendererComponent(Data4XBaseDialog.this.lstData, myVal, index, isSelected, cellHasFocus);
        }
    };
    protected JButton butClose;
    protected JButton butDelete;
    protected JButton butDownload;
    protected JButton butNew;
    protected JButton butPrio;
    protected JButton butRename;
    protected JButton butReplace;
    protected JComboBox<Object> cmbDataType;
    protected JScrollPane jScrollPane1;
    private JLabel lblDnD;
    protected JLabel lblTitle;
    protected JLabel lblTitleText;
    protected JList<String[]> lstData;
    protected JPanel pnlButtonEditData;
    protected JPanel pnlButtons;
    protected JPanel pnlData;
    protected JPanel pnlDataType;
    protected JPanel pnlDrop;
    protected JPanel pnlDropGlobal;
    protected JPanel pnlTitle;

    public abstract String buildPathKey(Integer var1, Integer var2);

    public String getKeyContentID() {
        return this.keyContentID;
    }

    public Data4XBaseDialog(Window parent, String actionInit, String mapinfoContentName) throws ServiceException {
        super(parent, Dialog.ModalityType.DOCUMENT_MODAL);
        this.actionInit = actionInit;
        this.srvactionDownload = "download_data4" + actionInit;
        this.srvactionEdit = "edit_data4" + actionInit;
        this.srvactionAdd = "add_data4" + actionInit;
        this.srvactionGettypes = "get_types4" + actionInit;
        this.mapinfoContentName = mapinfoContentName;
        this.keyContentID = actionInit + "_key";
        this.initComponents();
        this.i18n();
        this.setResizable(true);
        HashMap param = new HashMap();
        ServiceRequest req = systemService.createRequest(this.srvactionGettypes, param);
        Map mapTempTypes = (Map)wgContext.getServiceProvider().execRequest(req).getResult();
        for (Map.Entry objKey : mapTempTypes.entrySet()) {
            this.mapTypes.put(objKey.getValue(), (Integer)objKey.getKey());
            this.cmbDataType.addItem(objKey.getValue());
        }
        FileDrop fd = new FileDrop((Component)this.pnlDropGlobal, dropEvent -> {
            Data4XBaseDialog outerDialog = this;
            JList<String[]> lstData1 = this.lstData;
            if (dropEvent.getFiles().size() != 1) {
                GUISupport.msgbox((Component)GUISupport.findParentWindow((Component)outerDialog), (String)i18n.get("module.special.system.Data4ModuleDialog.singlefiledrop"), (String)i18n.get("common.message"));
            } else {
                try {
                    File destination = (File)dropEvent.getFiles().iterator().next();
                    if (destination != null) {
                        Integer duplicateKey;
                        String fileExtension = FileMDFileType.getExtensionByID(this.intDataType);
                        if (!Data4XDialogHelper.createFileFilter("tmp", fileExtension).accept(destination)) {
                            throw new ServiceException(i18n.fmt("module.special.system.Data4ModuleDialog.fileNotAllowed", new Object[]{destination.getName()}));
                        }
                        boolean doReplace = false;
                        boolean cancelled = false;
                        String baseName = FilenameUtils.getBaseName((String)destination.getName());
                        Integer dataKey = null;
                        String strNewName = null;
                        String tmpName = baseName;
                        do {
                            duplicateKey = null;
                            strNewName = Data4XDialogHelper.askNewMapName(outerDialog, tmpName, "module.special.system.Data4XDialog.input-data-name");
                            for (int i = 0; i < lstData1.getModel().getSize(); ++i) {
                                String prevName = lstData1.getModel().getElementAt(i)[1];
                                if (!StringUtils.equals((String)prevName, (String)strNewName)) continue;
                                duplicateKey = Integer.valueOf(lstData1.getModel().getElementAt(i)[0]);
                            }
                            if (duplicateKey != null && !ObjectUtils.equals(dataKey, duplicateKey) && !doReplace) {
                                int replaceAnswer = Data4XDialogHelper.yesnobox(outerDialog, i18n.fmt("module.special.system.Data4ModuleDialog.replaceEntry", new Object[]{strNewName}), i18n.get("common.message"));
                                cancelled = replaceAnswer == 2;
                                doReplace = replaceAnswer == 0;
                                dataKey = doReplace ? duplicateKey : dataKey;
                            }
                            tmpName = strNewName;
                        } while (!cancelled && duplicateKey != null && !ObjectUtils.equals(dataKey, duplicateKey));
                        if (!cancelled) {
                            if (doReplace) {
                                if (strNewName != null) {
                                    this.replaceDataFile(dataKey, strNewName, destination);
                                }
                            } else if (strNewName != null) {
                                this.addDataFile(strNewName, destination);
                            }
                        }
                    }
                }
                catch (ServiceException | NumberFormatException e) {
                    ExceptionDialog.handleGuiException((Component)outerDialog, (Throwable)e, (String)"webgiscli");
                }
            }
        });
    }

    private void displayOkAndRefresh(Collection<String> errorFiles, int completeCount) throws ServiceException {
        if (errorFiles.isEmpty()) {
            GUISupport.msgbox((Component)this, (String)i18n.get("module.special.system.Data4XDialog.success"), (String)i18n.get("common.message"));
        } else if (errorFiles.size() < completeCount) {
            GUISupport.msgbox((Component)this, (String)i18n.fmt("module.special.system.Data4ModuleDialog.partialfail", new Object[]{errorFiles.size(), completeCount, StringUtils.join(errorFiles, (String)"\n")}), (String)i18n.get("common.error"));
        } else {
            GUISupport.msgbox((Component)this, (String)i18n.fmt("module.special.system.Data4ModuleDialog.fullfail", new Object[]{errorFiles.size(), completeCount, StringUtils.join(errorFiles, (String)"\n")}), (String)i18n.get("common.error"));
        }
        this.refreshData();
    }

    @Override
    public final void initContent(Integer contentKey) throws ServiceException {
        this.contentID = contentKey;
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("key", contentKey);
        param.put("action", this.actionInit);
        ServiceRequest req = systemService.createRequest("get_system_info", param);
        Map mapInfo = (Map)wgContext.getServiceProvider().execRequest(req).getResult();
        String contentName = ObjectUtils.toString(mapInfo.get(this.mapinfoContentName));
        this.lblTitleText.setText(i18n.fmt("module.special.system.Data4XDialog.title_text", new Object[]{contentName, contentKey}));
        GUISupport.setDefaultButton((JButton)this.butClose, (int)27);
        GUISupport.setDefaultButton((JButton)this.butDelete, (int)127);
        this.pack();
        this.refreshData();
    }

    protected abstract void i18nTitle();

    private void i18n() {
        this.lblDnD.setText(i18n.get("common.drop-file"));
        ((TitledBorder)this.pnlData.getBorder()).setTitle(i18n.get("module.special.system.Data4XDialog.data"));
        ((TitledBorder)this.pnlDataType.getBorder()).setTitle(i18n.get("module.special.system.Data4XDialog.data-type"));
        this.butNew.setText(i18n.get("common.new"));
        this.butRename.setText(i18n.get("common.rename"));
        this.butDelete.setText(i18n.get("common.delete"));
        this.butClose.setText(i18n.get("common.close"));
        this.butReplace.setText(i18n.get("common.replace"));
        this.butDownload.setText(i18n.get("common.download"));
        this.butPrio.setText(i18n.get("module.special.system.Data4ModuleDialog.prio"));
        this.butPrio.setToolTipText(i18n.get("module.special.system.Data4ModuleDialog.prio-tooltip"));
        this.i18nTitle();
    }

    private void initComponents() {
        this.pnlDropGlobal = new JPanel();
        this.pnlDrop = new JPanel();
        this.lblDnD = new JLabel();
        this.pnlTitle = new JPanel();
        this.lblTitle = new JLabel();
        this.lblTitleText = new JLabel();
        this.pnlDataType = new JPanel();
        this.cmbDataType = new JComboBox();
        this.pnlData = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.lstData = new JList();
        this.pnlButtonEditData = new JPanel();
        this.butNew = new JButton();
        this.butRename = new JButton();
        this.butDelete = new JButton();
        this.butReplace = new JButton();
        this.butPrio = new JButton();
        this.butDownload = new JButton();
        this.pnlButtons = new JPanel();
        this.butClose = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(350, 440));
        this.setPreferredSize(new Dimension(380, 470));
        this.getContentPane().setLayout(new GridBagLayout());
        this.pnlDropGlobal.setLayout(new GridBagLayout());
        this.pnlDrop.setLayout(new GridBagLayout());
        this.lblDnD.setBackground(new Color(255, 255, 204));
        this.lblDnD.setFont(this.lblDnD.getFont().deriveFont(this.lblDnD.getFont().getStyle() | 1, this.lblDnD.getFont().getSize() + 2));
        this.lblDnD.setForeground(new Color(102, 102, 102));
        this.lblDnD.setHorizontalAlignment(0);
        ResourceBundle bundle = ResourceBundle.getBundle("de/riwagis/webgiscli/i18n/i18n");
        this.lblDnD.setText(bundle.getString("common.drop-file"));
        this.lblDnD.setBorder(BorderFactory.createLineBorder(new Color(102, 102, 102), 2));
        this.lblDnD.setMaximumSize(new Dimension(104, 60));
        this.lblDnD.setMinimumSize(new Dimension(104, 60));
        this.lblDnD.setOpaque(true);
        this.lblDnD.setPreferredSize(new Dimension(34, 60));
        this.lblDnD.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                Data4XBaseDialog.this.lblDnDMouseClicked(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlDrop.add((Component)this.lblDnD, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.pnlDropGlobal.add((Component)this.pnlDrop, gridBagConstraints);
        this.pnlTitle.setBackground(UIManager.getDefaults().getColor("TabbedPane.light"));
        this.pnlTitle.setLayout(new GridBagLayout());
        this.lblTitle.setText("Title:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(9, 9, 3, 9);
        this.pnlTitle.add((Component)this.lblTitle, gridBagConstraints);
        this.lblTitleText.setFont(this.lblTitleText.getFont().deriveFont(this.lblTitleText.getFont().getStyle() | 1));
        this.lblTitleText.setText("null");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(9, 9, 3, 9);
        this.pnlTitle.add((Component)this.lblTitleText, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.pnlDropGlobal.add((Component)this.pnlTitle, gridBagConstraints);
        this.pnlDataType.setBorder(BorderFactory.createTitledBorder("Datentyp:"));
        this.pnlDataType.setLayout(new GridBagLayout());
        this.cmbDataType.setMinimumSize(new Dimension(170, 20));
        this.cmbDataType.setPreferredSize(new Dimension(170, 22));
        this.cmbDataType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Data4XBaseDialog.this.cmbDataType_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 9, 3, 9);
        this.pnlDataType.add(this.cmbDataType, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.pnlDropGlobal.add((Component)this.pnlDataType, gridBagConstraints);
        this.pnlData.setBorder(BorderFactory.createTitledBorder("Karten:"));
        this.pnlData.setLayout(new GridBagLayout());
        this.jScrollPane1.setMinimumSize(new Dimension(200, 200));
        this.jScrollPane1.setPreferredSize(new Dimension(260, 200));
        this.lstData.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                Data4XBaseDialog.this.lstData_onMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.lstData);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 9, 3, 3);
        this.pnlData.add((Component)this.jScrollPane1, gridBagConstraints);
        this.pnlButtonEditData.setLayout(new GridBagLayout());
        this.butNew.setText(bundle.getString("common.new"));
        this.butNew.setMinimumSize(new Dimension(100, 23));
        this.butNew.setPreferredSize(new Dimension(100, 23));
        this.butNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Data4XBaseDialog.this.butNew_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(3, 3, 3, 9);
        this.pnlButtonEditData.add((Component)this.butNew, gridBagConstraints);
        this.butRename.setText(bundle.getString("common.rename"));
        this.butRename.setMinimumSize(new Dimension(100, 23));
        this.butRename.setPreferredSize(new Dimension(100, 23));
        this.butRename.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Data4XBaseDialog.this.butRename_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(3, 3, 3, 9);
        this.pnlButtonEditData.add((Component)this.butRename, gridBagConstraints);
        this.butDelete.setText(bundle.getString("common.delete"));
        this.butDelete.setMinimumSize(new Dimension(100, 23));
        this.butDelete.setPreferredSize(new Dimension(100, 23));
        this.butDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Data4XBaseDialog.this.butDelete_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(12, 3, 3, 9);
        this.pnlButtonEditData.add((Component)this.butDelete, gridBagConstraints);
        this.butReplace.setText(bundle.getString("common.replace"));
        this.butReplace.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Data4XBaseDialog.this.butReplace_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(3, 3, 3, 9);
        this.pnlButtonEditData.add((Component)this.butReplace, gridBagConstraints);
        this.butPrio.setText(bundle.getString("module.special.system.Data4ModuleDialog.prio"));
        this.butPrio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Data4XBaseDialog.this.butPrioActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 3, 3, 9);
        this.pnlButtonEditData.add((Component)this.butPrio, gridBagConstraints);
        this.butDownload.setText(bundle.getString("common.download"));
        this.butDownload.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Data4XBaseDialog.this.butDownload_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new Insets(3, 3, 3, 9);
        this.pnlButtonEditData.add((Component)this.butDownload, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 1.0;
        this.pnlData.add((Component)this.pnlButtonEditData, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.pnlDropGlobal.add((Component)this.pnlData, gridBagConstraints);
        this.pnlButtons.setLayout(new GridBagLayout());
        this.butClose.setText(bundle.getString("common.close"));
        this.butClose.setPreferredSize(new Dimension(100, 23));
        this.butClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Data4XBaseDialog.this.butClose_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(9, 3, 9, 9);
        this.pnlButtons.add((Component)this.butClose, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        this.pnlDropGlobal.add((Component)this.pnlButtons, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        this.getContentPane().add((Component)this.pnlDropGlobal, gridBagConstraints);
        this.pack();
    }

    private void cmbDataType_onActionPerformed(ActionEvent evt) {
        try {
            this.intDataType = this.getTypeId();
            this.refreshData();
        }
        catch (ServiceException e) {
            ExceptionDialog.handleGuiException((Component)this, (Throwable)e, (String)"webgiscli");
        }
    }

    private void butDownload_onActionPerformed(ActionEvent evt) {
        block5: {
            try {
                if (!Data4XDialogHelper.checkOneEntrySelected(this.lstData)) break block5;
                String pathKey = this.buildPathKey(this.contentID, this.intDataType);
                String fileExtension = FileMDFileType.getExtensionByID(this.intDataType);
                List<String[]> selectedEntries = this.lstData.getSelectedValuesList();
                String fileNameDestination = String.format("%s.%s", FilenameUtils.getName((String)selectedEntries.get(0)[1]), fileExtension);
                File destination = Data4XDialogHelper.getMapFile(this, "", true, new File(Data4XDialogHelper.retrievePathFromWB(pathKey), fileNameDestination), i18n.get("module.special.system.Data4XDialog.data"), fileExtension);
                if (destination == null) break block5;
                Data4XDialogHelper.rememberPathInWB(pathKey, destination);
                HashMap<String, Object> param = new HashMap<String, Object>();
                param.put(this.keyContentID, this.contentID);
                param.put("data_key", Integer.valueOf(selectedEntries.get(0)[0]));
                File dataFileFinal = FileSupport.addExtension((File)destination, (String)fileExtension);
                if (dataFileFinal.exists() && !GUISupport.yesnobox((Component)this, (String)i18n.get("module.special.system.Data4XDialog.replaceFile"), (String)i18n.get("common.alert"))) {
                    return;
                }
                LinkedHashSet<String> errorFiles = new LinkedHashSet<String>();
                try {
                    Data4XDialogHelper.startServerCommunication(this, i18n.get("common.wait"), param, this.srvactionDownload, new FileStreamProcessor(dataFileFinal));
                }
                catch (ServiceException sex) {
                    errorFiles.add(destination.getName());
                    LOG.error(String.format("error downloading file '%s' from server: %s", destination.getName(), sex.getMessage()));
                }
                this.displayOkAndRefresh(errorFiles, 1);
            }
            catch (ServiceException | HeadlessException | NumberFormatException e) {
                ExceptionDialog.handleGuiException((Component)this, (Throwable)e, (String)"webgiscli");
            }
        }
    }

    private void lstData_onMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.butReplace_onActionPerformed(null);
        }
    }

    private void butRename_onActionPerformed(ActionEvent evt) {
        JList<String[]> lstData1 = this.lstData;
        if (Data4XDialogHelper.checkOneEntrySelected(lstData1)) {
            try {
                String[] selectedEntry = lstData1.getSelectedValue();
                this.renameDataFile(Integer.valueOf(selectedEntry[0]), selectedEntry[1]);
            }
            catch (ServiceException | NumberFormatException e) {
                ExceptionDialog.handleGuiException((Component)this, (Throwable)e, (String)"webgiscli");
            }
        }
    }

    private void butReplace_onActionPerformed(ActionEvent evt) {
        JList<String[]> lstData1 = this.lstData;
        if (Data4XDialogHelper.checkOneEntrySelected(lstData1)) {
            try {
                String pathKey = this.buildPathKey(this.contentID, this.intDataType);
                String fileExtension = FileMDFileType.getExtensionByID(this.intDataType);
                File destination = Data4XDialogHelper.getMapFile(this, i18n.get("module.special.system.Data4ModuleDialog.upload-file"), false, Data4XDialogHelper.retrievePathFromWB(pathKey), i18n.get("module.special.system.Data4XDialog.data"), fileExtension);
                if (destination != null) {
                    Data4XDialogHelper.rememberPathInWB(pathKey, destination);
                    String[] entry = lstData1.getSelectedValue();
                    String strSelectedName = entry[1];
                    String strNewName = Data4XDialogHelper.askNewMapName(this, strSelectedName, "module.special.system.Data4XDialog.input-data-name");
                    if (strNewName != null) {
                        Integer dataKey = Integer.valueOf(entry[0]);
                        this.replaceDataFile(dataKey, strNewName, destination);
                    }
                }
            }
            catch (ServiceException | HeadlessException | NumberFormatException e) {
                ExceptionDialog.handleGuiException((Component)this, (Throwable)e, (String)"webgiscli");
            }
        }
    }

    private void butDelete_onActionPerformed(ActionEvent evt) {
        JList<String[]> lstData1 = this.lstData;
        try {
            boolean bolDelete;
            if (Data4XDialogHelper.checkIsAnEntrySelected(lstData1) && (bolDelete = GUISupport.yesnobox((Component)this, (String)i18n.get("module.special.system.Data4XDialog.delete-question"), (String)i18n.get("common.message")))) {
                LinkedHashSet<String> errorFiles = new LinkedHashSet<String>();
                for (String[] entry : lstData1.getSelectedValuesList()) {
                    Integer dataKey = Integer.valueOf(entry[0]);
                    HashMap<String, Object> param = new HashMap<String, Object>();
                    param.put(this.keyContentID, this.contentID);
                    param.put("data_type", this.intDataType);
                    param.put("data_key", dataKey);
                    param.put("action", "delete");
                    try {
                        Data4XDialogHelper.startServerCommunication(this, i18n.get("common.wait"), param, this.srvactionEdit, null);
                    }
                    catch (ServiceException sex) {
                        errorFiles.add(entry[1]);
                        LOG.error(String.format("error deleting file '%s' on server: %s", entry[1], sex.getMessage()));
                    }
                }
                this.displayOkAndRefresh(errorFiles, lstData1.getSelectedValuesList().size());
            }
        }
        catch (ServiceException | NumberFormatException e) {
            ExceptionDialog.handleGuiException((Component)this, (Throwable)e, (String)"webgiscli");
        }
    }

    private void butNew_onActionPerformed(ActionEvent evt) {
        try {
            String pathKey = this.buildPathKey(this.contentID, this.intDataType);
            String fileExtension = FileMDFileType.getExtensionByID(this.intDataType);
            File destination = Data4XDialogHelper.getMapFile(this, i18n.get("module.special.system.Data4ModuleDialog.upload-file"), false, Data4XDialogHelper.retrievePathFromWB(pathKey), i18n.get("module.special.system.Data4XDialog.data"), fileExtension);
            if (destination != null) {
                Data4XDialogHelper.rememberPathInWB(pathKey, destination);
                String strNewName = Data4XDialogHelper.askNewMapName(this, FilenameUtils.getBaseName((String)destination.getName()), "module.special.system.Data4XDialog.input-data-name");
                if (strNewName != null) {
                    this.addDataFile(strNewName, destination);
                }
            }
        }
        catch (ServiceException | HeadlessException e) {
            ExceptionDialog.handleGuiException((Component)this, (Throwable)e, (String)"webgiscli");
        }
    }

    private void renameDataFile(Integer dataKey, String dataName) throws ServiceException {
        String strNewName = Data4XDialogHelper.askNewMapName(this, dataName, "module.special.system.Data4XDialog.input-data-name");
        if (strNewName != null && !strNewName.equals(dataName)) {
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put(this.keyContentID, this.contentID);
            param.put("data_type", this.intDataType);
            param.put("data_key", dataKey);
            param.put("action", "rename");
            param.put("data_name", strNewName);
            LinkedHashSet<String> errorFiles = new LinkedHashSet<String>();
            try {
                Data4XDialogHelper.startServerCommunication(this, i18n.get("common.wait"), param, this.srvactionEdit, null);
            }
            catch (ServiceException sex) {
                errorFiles.add(dataName);
                LOG.error(String.format("error renaming file '%s' on server: %s", strNewName, sex.getMessage()));
            }
            this.displayOkAndRefresh(errorFiles, 1);
        }
    }

    private void replaceDataFile(Integer dataKey, String dataName, File destination) throws ServiceException {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put(this.keyContentID, this.contentID);
        param.put("data_type", this.intDataType);
        param.put("data_key", dataKey);
        param.put("data_name", dataName);
        param.put("action", "update");
        param.put("originalfilename", destination.getName());
        param.put("file", destination);
        LinkedHashSet<String> errorFiles = new LinkedHashSet<String>();
        try {
            Data4XDialogHelper.startServerCommunication(this, i18n.get("common.wait"), param, this.srvactionEdit, null);
        }
        catch (ServiceException sex) {
            errorFiles.add(String.format("%s - %s", dataName, sex.getMessage()));
            LOG.error(String.format("error replacing '%s': %s", destination.getName(), sex.getMessage()));
        }
        this.displayOkAndRefresh(errorFiles, 1);
    }

    private void addDataFile(String dataName, File destination) throws ServiceException {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put(this.keyContentID, this.contentID);
        param.put("data_type", this.intDataType);
        param.put("file", destination);
        param.put("originalfilename", destination.getName());
        param.put("data_name", dataName);
        LinkedHashSet<String> errorFiles = new LinkedHashSet<String>();
        try {
            Data4XDialogHelper.startServerCommunication(this, i18n.get("common.wait"), param, this.srvactionAdd, null);
        }
        catch (ServiceException sex) {
            errorFiles.add(dataName);
            LOG.error(String.format("error adding file '%s' on server: %s", dataName, sex.getMessage()));
        }
        this.displayOkAndRefresh(errorFiles, 1);
    }

    private void butClose_onActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void butPrioActionPerformed(ActionEvent evt) {
        block6: {
            JList<String[]> lstData1 = this.lstData;
            try {
                if (!Data4XDialogHelper.checkOneEntrySelected(lstData1)) break block6;
                String[] entry = lstData1.getSelectedValue();
                String strPrio = GUISupport.inputbox((Component)this, (String)i18n.get("module.special.system.Data4ModuleDialog.input-prio"), (String)i18n.get("common.message"), (String)entry[4]);
                if (strPrio == null) break block6;
                int intPrio = 1;
                try {
                    intPrio = Integer.parseInt(strPrio);
                }
                catch (NumberFormatException nf) {
                    GUISupport.msgbox((Component)this, (String)i18n.get("common.invalid-number"), (String)i18n.get("common.error"));
                }
                Integer dataKey = Integer.valueOf(entry[0]);
                HashMap<String, Object> param = new HashMap<String, Object>();
                param.put(this.keyContentID, this.contentID);
                param.put("data_type", this.intDataType);
                param.put("data_key", dataKey);
                param.put("action", "priority");
                param.put("data_name", strPrio);
                param.put("priority", intPrio);
                LinkedHashSet<String> errorFiles = new LinkedHashSet<String>();
                try {
                    Data4XDialogHelper.startServerCommunication(this, i18n.get("common.wait"), param, this.srvactionEdit, null);
                }
                catch (ServiceException sex) {
                    errorFiles.add(entry[1]);
                    LOG.error(String.format("error changing prio on file '%s' on server: %s", entry[1], sex.getMessage()));
                }
                this.displayOkAndRefresh(errorFiles, 1);
            }
            catch (ServiceException | NumberFormatException e) {
                ExceptionDialog.handleGuiException((Component)this, (Throwable)e, (String)"webgiscli");
            }
        }
    }

    private void lblDnDMouseClicked(MouseEvent evt) {
        this.butNew.doClick();
    }

    private Integer getTypeId() {
        return this.mapTypes.get(this.cmbDataType.getSelectedItem());
    }
}

