/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.webgiscli.module.special.system;

import de.riwagis.service.ServiceException;
import de.riwagis.service.ServiceRequest;
import de.riwagis.util.gui.models.ListListModel;
import de.riwagis.webgiscli.WebGisContext;
import de.riwagis.webgiscli.module.special.system.Data4XBaseDialog;
import de.riwagis.webgiscli.module.special.system.Data4XDialogHelper;
import java.awt.Component;
import java.awt.Window;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;

public class Data4ModuleDialog
extends Data4XBaseDialog {
    private static final String KEY_DIR = Data4ModuleDialog.class.getName() + "_Dir";
    private final DefaultListCellRenderer CELLRENDERER_STANDARD = new DefaultListCellRenderer(){

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String myVal = MessageFormat.format("{1}, {2}", (Object[])value);
            return super.getListCellRendererComponent((JList<?>)Data4ModuleDialog.this.lstData, myVal, index, isSelected, cellHasFocus);
        }
    };
    private final DefaultListCellRenderer CELLRENDERER_PRIO = new DefaultListCellRenderer(){

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String myVal = MessageFormat.format("{1}, priority: {4}, {2}", (Object[])value);
            return super.getListCellRendererComponent((JList<?>)Data4ModuleDialog.this.lstData, myVal, index, isSelected, cellHasFocus);
        }
    };

    @Override
    public String buildPathKey(Integer subKey, Integer dataType) {
        return String.format("%s_Mod%s_%d", KEY_DIR, subKey, dataType);
    }

    public Data4ModuleDialog(Window parent) throws ServiceException {
        super(parent, "module", "mod_name");
    }

    @Override
    public void refreshData() throws ServiceException {
        HashMap<String, Integer> param = new HashMap<String, Integer>();
        param.put(this.getKeyContentID(), this.contentID);
        param.put("data_type", this.intDataType);
        ServiceRequest req = systemService.createRequest("get_data4module", param);
        List llstData = (List)wgContext.getServiceProvider().execRequest(req).getResult();
        Collections.sort(llstData, Data4XDialogHelper.COMPARATOR_STRINGARRAY);
        this.lstData.setModel(new ListListModel(llstData));
        boolean showPrio = llstData.size() > 1 && ((String[])llstData.get(0)).length >= 5;
        boolean isMobileMapPrioritySupported = this.isMobileMapPrioritySupported();
        if ((this.intDataType == 1 || isMobileMapPrioritySupported) && showPrio) {
            this.lstData.setCellRenderer(this.CELLRENDERER_PRIO);
        } else {
            this.lstData.setCellRenderer(this.CELLRENDERER_STANDARD);
        }
        this.butPrio.setEnabled(this.intDataType == 1 || isMobileMapPrioritySupported);
        this.butPrio.setVisible(true);
    }

    @Override
    protected void i18nTitle() {
        this.setTitle(i18n.get("module.special.system.Data4ModuleDialog.title"));
        this.lblTitle.setText(i18n.get("module.special.system.Data4ModuleDialog.module"));
    }

    private boolean isMobileMapPrioritySupported() {
        return this.intDataType == 6 && WebGisContext.getInstance().getVersion() >= 2000;
    }
}

