/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.webgiscli.module.special.system;

import de.riwagis.service.ServiceException;
import de.riwagis.service.ServiceRequest;
import de.riwagis.util.gui.models.ListListModel;
import de.riwagis.webgiscli.module.special.system.Data4XBaseDialog;
import de.riwagis.webgiscli.module.special.system.Data4XDialogHelper;
import java.awt.Component;
import java.awt.Window;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;

public class Data4AdminDialog
extends Data4XBaseDialog {
    private static final String KEY_DIR = Data4AdminDialog.class.getName() + "_Dir";
    private final DefaultListCellRenderer CELLRENDERER_STANDARD;
    private final DefaultListCellRenderer CELLRENDERER_PRIO;

    @Override
    public String buildPathKey(Integer subKey, Integer dataType) {
        return String.format("%s_%d_%d", KEY_DIR, subKey, dataType);
    }

    public Data4AdminDialog(Window parent) throws ServiceException {
        super(parent, "admin", "admin_name");
        this.CELLRENDERER_PRIO = this.CELLRENDERER_STANDARD = new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                String myVal = MessageFormat.format("{1} ({2}, ''{3}'')", (Object[])value);
                return super.getListCellRendererComponent((JList<?>)Data4AdminDialog.this.lstData, myVal, index, isSelected, cellHasFocus);
            }
        };
    }

    @Override
    public void refreshData() throws ServiceException {
        HashMap<String, Integer> param = new HashMap<String, Integer>();
        param.put(this.getKeyContentID(), this.contentID);
        param.put("data_type", this.intDataType);
        ServiceRequest req = systemService.createRequest("get_data4admin", param);
        List llstData = (List)wgContext.getServiceProvider().execRequest(req).getResult();
        Collections.sort(llstData, Data4XDialogHelper.COMPARATOR_STRINGARRAY);
        this.lstData.setModel(new ListListModel(llstData));
        this.lstData.setCellRenderer(this.CELLRENDERER_STANDARD);
        this.butPrio.setEnabled(false);
        this.butPrio.setVisible(false);
    }

    @Override
    protected void i18nTitle() {
        this.setTitle(i18n.get("module.special.system.Data4AdminDialog.title"));
        this.lblTitle.setText(i18n.get("module.special.system.Data4AdminDialog.admin"));
    }
}

