/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.webgiscli.module.gui;

import de.riwagis.util.Config;
import de.riwagis.util.Whiteboard;
import de.riwagis.util.gui.ExceptionDialog;
import de.riwagis.util.gui.FileFilterWrapper;
import de.riwagis.util.gui.GUISupport;
import de.riwagis.util.gui.filedrop.FileDrop;
import de.riwagis.util.i18n.I18N;
import de.riwagis.webgiscli.WebGisContext;
import de.riwagis.webgiscli.module.dialog.gui.DBParserBaseDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;

public class FileLinkDialog
extends JDialog {
    private static final String KEY_DIR = FileLinkDialog.class.getName() + "_Dir";
    private static final I18N i18n = new I18N(Config.LOCALE, "de.riwagis.webgiscli.i18n.i18n");
    private final WebGisContext wgContext;
    private FileFilter fileFilter = null;
    private String strLastDir = "";
    private boolean bolOK = false;
    private FileDrop fdLocal;
    private JButton butCancel;
    private JButton butDelete;
    private JButton butFile;
    private JButton butSave;
    private JLabel lblDnD;
    private JLabel lblFile;
    private JPanel pnlButtons;
    private JPanel pnlDrop;
    private JPanel pnlFileSelect;
    private JTextField txtFile;

    public FileLinkDialog(Window parent, WebGisContext _wgContext) {
        super(parent, Dialog.ModalityType.APPLICATION_MODAL);
        super.setPreferredSize(new Dimension(460, 180));
        this.initComponents();
        this.wgContext = _wgContext;
        this.i18n();
        this.init();
    }

    private void init() {
        Whiteboard wb = this.wgContext.getPermWhiteboard();
        this.strLastDir = (String)wb.getAttribute(KEY_DIR, (Object)"");
        this.fdLocal = new FileDrop((Component)this.lblDnD, dropEvent -> {
            File file2link = null;
            for (File file2test : dropEvent.getFiles()) {
                if (this.fileFilter != null) {
                    if (!this.fileFilter.accept(file2test)) continue;
                    file2link = file2test;
                    break;
                }
                file2link = file2test;
                break;
            }
            if (file2link != null) {
                this.txtFile.setText(file2link.toString());
            }
        });
    }

    private void i18n() {
        this.lblDnD.setText(i18n.get("common.drop-file"));
        this.setTitle(i18n.get("module.gui.FileLinkDialog.title"));
        this.lblFile.setText(i18n.get("module.gui.FileLinkDialog.select-file"));
        this.butFile.setText(i18n.get("common.choose"));
        this.butCancel.setText(i18n.get("common.cancel"));
        this.butDelete.setText(i18n.get("common.delete"));
        this.butSave.setText(i18n.get("module.gui.FileLinkDialog.link"));
    }

    public final void setLink(String strLink, String[] arrFilter) {
        this.fileFilter = DBParserBaseDialog.createFileFilter(arrFilter);
        this.fdLocal.setFileFilter(FileFilterWrapper.wrapFileFilter((FileFilter)this.fileFilter));
        if (strLink.length() > 0) {
            this.butDelete.setVisible(true);
            this.txtFile.setText(strLink);
        } else {
            this.butDelete.setVisible(false);
            this.txtFile.setText("");
        }
    }

    public final void setSaveText(String text) {
        this.butSave.setText(text);
    }

    public final void toggleDeleteButton(boolean visible) {
        this.butDelete.setVisible(visible);
    }

    public final void setDialogTitle(String title) {
        this.setTitle(title);
    }

    public String getLink() {
        return this.txtFile.getText();
    }

    public boolean wasOKPressed() {
        return this.bolOK;
    }

    private void initComponents() {
        this.pnlDrop = new JPanel();
        this.lblDnD = new JLabel();
        this.pnlFileSelect = new JPanel();
        this.lblFile = new JLabel();
        this.txtFile = new JTextField();
        this.butFile = new JButton();
        this.pnlButtons = new JPanel();
        this.butCancel = new JButton();
        this.butDelete = new JButton();
        this.butSave = new JButton();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.getContentPane().setLayout(new GridBagLayout());
        this.pnlDrop.setLayout(new GridBagLayout());
        this.lblDnD.setBackground(new Color(255, 255, 204));
        this.lblDnD.setFont(this.lblDnD.getFont().deriveFont(this.lblDnD.getFont().getStyle() | 1, this.lblDnD.getFont().getSize() + 2));
        this.lblDnD.setForeground(new Color(102, 102, 102));
        this.lblDnD.setHorizontalAlignment(0);
        this.lblDnD.setText("Drop file here...");
        this.lblDnD.setBorder(BorderFactory.createLineBorder(new Color(102, 102, 102), 2));
        this.lblDnD.setOpaque(true);
        this.lblDnD.setPreferredSize(new Dimension(34, 30));
        this.lblDnD.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                FileLinkDialog.this.lblDnDMouseClicked(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlDrop.add((Component)this.lblDnD, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.pnlDrop, gridBagConstraints);
        this.pnlFileSelect.setLayout(new GridBagLayout());
        this.lblFile.setText("Dateiauswahl:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 9, 3, 3);
        this.pnlFileSelect.add((Component)this.lblFile, gridBagConstraints);
        this.txtFile.setPreferredSize(new Dimension(250, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 8, 3, 3);
        this.pnlFileSelect.add((Component)this.txtFile, gridBagConstraints);
        this.butFile.setText("w\u00e4hlen");
        this.butFile.setPreferredSize(new Dimension(80, 23));
        this.butFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileLinkDialog.this.butFile_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 9);
        this.pnlFileSelect.add((Component)this.butFile, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 9, 4, 9);
        this.getContentPane().add((Component)this.pnlFileSelect, gridBagConstraints);
        this.butCancel.setText("abbrechen");
        this.butCancel.setPreferredSize(new Dimension(100, 23));
        this.butCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileLinkDialog.this.butCancel_onActionPerformed(evt);
            }
        });
        this.pnlButtons.add(this.butCancel);
        this.butDelete.setText("l\u00f6schen");
        this.butDelete.setPreferredSize(new Dimension(100, 23));
        this.butDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileLinkDialog.this.butDelete_onActionPerformed(evt);
            }
        });
        this.pnlButtons.add(this.butDelete);
        this.butSave.setText("anbinden");
        this.butSave.setPreferredSize(new Dimension(100, 23));
        this.butSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileLinkDialog.this.butSave_onActionPerformed(evt);
            }
        });
        this.pnlButtons.add(this.butSave);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 9, 9, 9);
        this.getContentPane().add((Component)this.pnlButtons, gridBagConstraints);
        this.getAccessibleContext().setAccessibleName("File Upload");
        this.pack();
    }

    private void butDelete_onActionPerformed(ActionEvent evt) {
        boolean bolYes = GUISupport.yesnobox((Component)this, (String)i18n.get("module.gui.FileLinkDialog.delete-check"), (String)i18n.get("common.message"));
        if (!bolYes) {
            return;
        }
        this.txtFile.setText("");
        this.bolOK = true;
        this.setVisible(false);
        this.dispose();
    }

    private void butFile_onActionPerformed(ActionEvent evt) {
        JFileChooser fileChoose = GUISupport.createJFileChooser();
        if (this.fileFilter == null) {
            for (FileFilter arrFilt1 : fileChoose.getChoosableFileFilters()) {
                fileChoose.removeChoosableFileFilter(arrFilt1);
            }
            fileChoose.setAcceptAllFileFilterUsed(true);
        } else {
            fileChoose.setAcceptAllFileFilterUsed(false);
            fileChoose.setFileFilter(this.fileFilter);
        }
        fileChoose.setMultiSelectionEnabled(false);
        File lastFolder = new File(this.strLastDir);
        File linkFile = new File(this.txtFile.getText());
        if (linkFile.exists() && this.txtFile.getText().trim().length() > 0) {
            fileChoose.setCurrentDirectory(linkFile);
        } else {
            fileChoose.setCurrentDirectory(lastFolder);
        }
        int intOption = fileChoose.showSaveDialog(this);
        if (intOption == 1) {
            return;
        }
        lastFolder = fileChoose.getSelectedFile();
        this.strLastDir = lastFolder.getParent();
        Whiteboard wb = this.wgContext.getPermWhiteboard();
        wb.setAttribute(KEY_DIR, (Object)this.strLastDir);
        this.txtFile.setText(lastFolder.toString());
        this.wgContext.writePermWhiteboard();
    }

    private void butSave_onActionPerformed(ActionEvent evt) {
        try {
            this.bolOK = true;
            this.setVisible(false);
            this.dispose();
        }
        catch (Exception e) {
            ExceptionDialog.handleGuiException((Component)this, (Throwable)e, (String)"webgiscli");
        }
    }

    private void butCancel_onActionPerformed(ActionEvent evt) {
        this.bolOK = false;
        this.setVisible(false);
        this.dispose();
    }

    private void lblDnDMouseClicked(MouseEvent evt) {
        this.butFile_onActionPerformed(null);
    }
}

