/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.webgiscli.module.gui;

import de.riwagis.util.Config;
import de.riwagis.util.i18n.I18N;
import de.riwagis.webgiscli.module.gui.ExportFormat;
import de.riwagis.webgiscli.module.gui.LogoBean;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class ExpJReportDialog
extends JDialog {
    private static final I18N i18n = new I18N(Config.LOCALE, "de.riwagis.webgiscli.i18n.i18n");
    private boolean bolOkPressed = false;
    private JButton butCancel;
    private JButton butOK;
    private ButtonGroup buttonGroup1;
    private JComboBox<LogoBean> cmbLogo;
    private JLabel lblHeader;
    private JLabel lblLogo;
    private JLabel lblLogoHeader;
    private JRadioButton optCSV;
    private JRadioButton optCrystalRPT;
    private JRadioButton optExcel;
    private JRadioButton optPDF;
    private JRadioButton optRTF;
    private JPanel pnlButtons;
    private JPanel pnlLogo;
    private JPanel pnlReportFormat;

    public final void setVisibleFormats(Collection<ExportFormat> formats) {
        JRadioButton[] ALL_BUTTONS = new JRadioButton[]{this.optPDF, this.optRTF, this.optExcel, this.optCrystalRPT, this.optCSV};
        for (JRadioButton jRadioButton : ALL_BUTTONS) {
            jRadioButton.setVisible(false);
        }
        for (ExportFormat currFormat : formats) {
            if (currFormat == ExportFormat.PDF) {
                this.optPDF.setVisible(true);
            }
            if (currFormat == ExportFormat.RTF) {
                this.optRTF.setVisible(true);
            }
            if (currFormat == ExportFormat.FORMAT_EXCEL) {
                this.optExcel.setVisible(true);
            }
            if (currFormat == ExportFormat.FORMAT_RPT) {
                this.optCrystalRPT.setVisible(true);
            }
            if (currFormat != ExportFormat.FORMAT_CSV) continue;
            this.optCSV.setVisible(true);
        }
        for (JRadioButton jRadioButton : ALL_BUTTONS) {
            if (!jRadioButton.isVisible()) continue;
            jRadioButton.setSelected(true);
            break;
        }
    }

    public ExpJReportDialog(Window parent) {
        super(parent, Dialog.ModalityType.APPLICATION_MODAL);
        this.initComponents();
        this.i18n();
        this.setVisibleFormats(Arrays.asList(ExportFormat.PDF, ExportFormat.RTF));
        this.setLogo(null);
    }

    private void i18n() {
        this.setTitle(i18n.get("module.gui.ExpJReportDialog.title"));
        this.lblHeader.setText(i18n.get("module.gui.ExpJReportDialog.header"));
        this.optPDF.setText(i18n.get("module.gui.ExpJReportDialog.pdf"));
        this.optRTF.setText(i18n.get("module.gui.ExpJReportDialog.rtf"));
        this.optExcel.setText(i18n.get("module.gui.ExpJReportDialog.xls"));
        this.optCrystalRPT.setText(i18n.get("module.gui.ExpJReportDialog.rpt"));
        this.optCSV.setText(i18n.get("module.gui.ExpJReportDialog.csv"));
        this.butOK.setText(i18n.get("common.ok"));
        this.butCancel.setText(i18n.get("common.cancel"));
    }

    public boolean wasOkPressed() {
        return this.bolOkPressed;
    }

    public ExportFormat getFormat() {
        if (this.optPDF.isSelected()) {
            return ExportFormat.PDF;
        }
        if (this.optRTF.isSelected()) {
            return ExportFormat.RTF;
        }
        if (this.optExcel.isSelected()) {
            return ExportFormat.FORMAT_EXCEL;
        }
        if (this.optCrystalRPT.isSelected()) {
            return ExportFormat.FORMAT_RPT;
        }
        if (this.optCSV.isSelected()) {
            return ExportFormat.FORMAT_CSV;
        }
        return ExportFormat.PDF;
    }

    public int getLogo() {
        if (this.cmbLogo.getItemCount() == 0) {
            return -1;
        }
        return ((LogoBean)this.cmbLogo.getSelectedItem()).getId();
    }

    public final void setFormat(ExportFormat exportFormat) {
        this.optPDF.setSelected(exportFormat == ExportFormat.PDF);
        this.optRTF.setSelected(exportFormat == ExportFormat.RTF);
        this.optCrystalRPT.setSelected(exportFormat == ExportFormat.FORMAT_RPT);
        this.optCSV.setSelected(exportFormat == ExportFormat.FORMAT_CSV);
        this.optExcel.setSelected(exportFormat == ExportFormat.FORMAT_EXCEL);
    }

    public final void setLogo(Map<Integer, String> mapLogo) {
        this.cmbLogo.removeAllItems();
        if (mapLogo == null || mapLogo.isEmpty()) {
            this.setLogoVisible(false);
        } else {
            this.setLogoVisible(true);
            for (Integer key : mapLogo.keySet()) {
                LogoBean logo = new LogoBean(key, mapLogo.get(key));
                this.cmbLogo.addItem(logo);
            }
        }
    }

    public void setSelectedLogo(int lastUsedLogoId) {
        for (int i = 0; i < this.cmbLogo.getModel().getSize(); ++i) {
            LogoBean logo = (LogoBean)this.cmbLogo.getModel().getElementAt(i);
            if (logo.getId() != lastUsedLogoId) continue;
            this.cmbLogo.setSelectedItem(logo);
            return;
        }
    }

    private void setLogoVisible(boolean visible) {
        this.pnlLogo.setVisible(visible);
        this.lblLogoHeader.setVisible(visible);
        this.lblLogo.setVisible(visible);
        this.cmbLogo.setVisible(visible);
        this.pack();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.pnlLogo = new JPanel();
        this.lblLogoHeader = new JLabel();
        this.lblLogo = new JLabel();
        this.cmbLogo = new JComboBox();
        this.pnlReportFormat = new JPanel();
        this.lblHeader = new JLabel();
        this.optPDF = new JRadioButton();
        this.optRTF = new JRadioButton();
        this.optExcel = new JRadioButton();
        this.optCrystalRPT = new JRadioButton();
        this.optCSV = new JRadioButton();
        this.pnlButtons = new JPanel();
        this.butOK = new JButton();
        this.butCancel = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Berichtserstellung");
        this.setMinimumSize(new Dimension(420, 120));
        this.setResizable(false);
        this.getContentPane().setLayout(new GridBagLayout());
        this.pnlLogo.setPreferredSize(new Dimension(269, 55));
        this.pnlLogo.setRequestFocusEnabled(false);
        this.pnlLogo.setLayout(new GridBagLayout());
        this.lblLogoHeader.setText("Bitte w\u00e4hlen Sie ein Logo f\u00fcr die Berichtsdarstellung:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(9, 9, 3, 9);
        this.pnlLogo.add((Component)this.lblLogoHeader, gridBagConstraints);
        this.lblLogo.setText("Logo:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 9, 3, 3);
        this.pnlLogo.add((Component)this.lblLogo, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 9);
        this.pnlLogo.add(this.cmbLogo, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.pnlLogo, gridBagConstraints);
        this.pnlReportFormat.setLayout(new GridBagLayout());
        this.lblHeader.setText("Bitte w\u00e4hlen Sie das Datenformat des Berichtes:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(9, 9, 3, 9);
        this.pnlReportFormat.add((Component)this.lblHeader, gridBagConstraints);
        this.buttonGroup1.add(this.optPDF);
        this.optPDF.setSelected(true);
        this.optPDF.setText("PDF (z. B. mit Acrobat Reader)");
        this.optPDF.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.optPDF.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 30, 3, 3);
        this.pnlReportFormat.add((Component)this.optPDF, gridBagConstraints);
        this.buttonGroup1.add(this.optRTF);
        this.optRTF.setText("RTF (z. B. mit  Microsoft Word)");
        this.optRTF.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.optRTF.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 30, 3, 3);
        this.pnlReportFormat.add((Component)this.optRTF, gridBagConstraints);
        this.buttonGroup1.add(this.optExcel);
        this.optExcel.setText("XLS (z. B. mit  Microsoft Excel)");
        this.optExcel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.optExcel.setMargin(new Insets(0, 0, 0, 0));
        this.optExcel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExpJReportDialog.this.optExcelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 30, 3, 3);
        this.pnlReportFormat.add((Component)this.optExcel, gridBagConstraints);
        this.buttonGroup1.add(this.optCrystalRPT);
        this.optCrystalRPT.setText("RPT (z.B. mit CrystalReports)");
        this.optCrystalRPT.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.optCrystalRPT.setMargin(new Insets(0, 0, 0, 0));
        this.optCrystalRPT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExpJReportDialog.this.optCrystalRPTActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 30, 3, 3);
        this.pnlReportFormat.add((Component)this.optCrystalRPT, gridBagConstraints);
        this.buttonGroup1.add(this.optCSV);
        this.optCSV.setText("CSV (z.B. Excel, Texteditor)");
        this.optCSV.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.optCSV.setMargin(new Insets(0, 0, 0, 0));
        this.optCSV.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExpJReportDialog.this.optCSVActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 30, 3, 3);
        this.pnlReportFormat.add((Component)this.optCSV, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.pnlReportFormat, gridBagConstraints);
        this.pnlButtons.setOpaque(false);
        this.pnlButtons.setPreferredSize(new Dimension(215, 34));
        this.pnlButtons.setLayout(new FlowLayout(2));
        this.butOK.setText("OK");
        this.butOK.setPreferredSize(new Dimension(100, 23));
        this.butOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExpJReportDialog.this.butOK_onActionPerformed(evt);
            }
        });
        this.pnlButtons.add(this.butOK);
        this.butCancel.setText("Abbrechen");
        this.butCancel.setPreferredSize(new Dimension(100, 23));
        this.butCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExpJReportDialog.this.butCancel_onActionPerformed(evt);
            }
        });
        this.pnlButtons.add(this.butCancel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.pnlButtons, gridBagConstraints);
        this.pack();
    }

    private void butOK_onActionPerformed(ActionEvent evt) {
        this.bolOkPressed = true;
        this.setVisible(false);
        this.dispose();
    }

    private void butCancel_onActionPerformed(ActionEvent evt) {
        this.bolOkPressed = false;
        this.setVisible(false);
        this.dispose();
    }

    private void optExcelActionPerformed(ActionEvent evt) {
    }

    private void optCrystalRPTActionPerformed(ActionEvent evt) {
    }

    private void optCSVActionPerformed(ActionEvent evt) {
    }

    public static void main(String[] args) {
        ExpJReportDialog dlg = new ExpJReportDialog(null);
        dlg.setVisibleFormats(Arrays.asList(ExportFormat.PDF, ExportFormat.FORMAT_EXCEL, ExportFormat.FORMAT_RPT));
        dlg.setFormat(ExportFormat.RTF);
        HashMap<Integer, String> mapLogo = new HashMap<Integer, String>();
        mapLogo.put(1, "Test1 Logo");
        mapLogo.put(2, "Test2 Logo");
        dlg.setLogo(mapLogo);
        dlg.setVisible(true);
        JOptionPane.showMessageDialog(null, (Object)dlg.getFormat());
        JOptionPane.showMessageDialog(null, dlg.getLogo());
    }
}

