/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.webgiscli.module.dialog.messaging;

import com.google.gson.Gson;
import de.riwagis.browser.BrowserQueryable;
import de.riwagis.browser.QueryListener;
import de.riwagis.webgiscli.module.dialog.messaging.GisClientMessage;
import de.riwagis.webgiscli.module.dialog.messaging.SPMessageHandler;
import de.riwagis.webgiscli.util.SizePositionData;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SPMessageListener
implements QueryListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SPMessageListener.class);
    private final Gson gson = new Gson();
    private final Map<String, MessageCall> messages = Map.ofEntries(Map.entry("enableMessaging", (gisMessage, callback) -> {
        messageHandler.enableMessaging(gisMessage.getArguments());
        callback.success("");
        return true;
    }), Map.entry("disableMessaging", (gisMessage, callback) -> {
        messageHandler.disableMessaging(gisMessage.getArguments());
        callback.success("");
        return true;
    }), Map.entry("registerMasterDetailDialogIds", (gisMessage, callback) -> {
        messageHandler.registerMasterDetailDialogIds((String[])this.gson.fromJson(gisMessage.getArguments(), String[].class));
        callback.success("");
        return true;
    }), Map.entry("dialogIdUpdated", (gisMessage, callback) -> {
        try {
            messageHandler.dialogIdUpdated((String)this.gson.fromJson(gisMessage.getArguments(), String.class));
            callback.success("");
        }
        catch (Exception ex) {
            callback.failure(0, ex.getMessage());
        }
        return true;
    }), Map.entry("getWindowSizeAndPosition", (gisMessage, callback) -> {
        callback.success(this.gson.toJson((Object)messageHandler.getWindowSizeAndPosition()));
        return true;
    }), Map.entry("setWindowSize", (gisMessage, callback) -> {
        callback.success(this.gson.toJson((Object)messageHandler.setWindowSize((SizePositionData)this.gson.fromJson(gisMessage.getArguments(), SizePositionData.class))));
        return true;
    }), Map.entry("setWindowPosition", (gisMessage, callback) -> {
        callback.success(this.gson.toJson((Object)messageHandler.setWindowPosition((SizePositionData)this.gson.fromJson(gisMessage.getArguments(), SizePositionData.class))));
        return true;
    }));

    public SPMessageListener(SPMessageHandler messageHandler) {
    }

    public boolean canHandle(String request) {
        GisClientMessage gisMessage = (GisClientMessage)this.gson.fromJson(request, GisClientMessage.class);
        return this.messages.containsKey(gisMessage.getMethodName());
    }

    public boolean handle(BrowserQueryable browser, String request, QueryListener.ResponseCallback callback) {
        try {
            GisClientMessage gisMessage = (GisClientMessage)this.gson.fromJson(request, GisClientMessage.class);
            String methodName = gisMessage.getMethodName();
            MessageCall call = this.messages.get(methodName);
            if (call == null) {
                log.warn("Unknown message '{}'", (Object)methodName);
                return false;
            }
            return call.execute(gisMessage, callback);
        }
        catch (Exception ex) {
            log.error("Could not handle gis message", (Throwable)ex);
            callback.failure(1, ex.getMessage());
            return false;
        }
    }

    @FunctionalInterface
    private static interface MessageCall {
        public boolean execute(GisClientMessage var1, QueryListener.ResponseCallback var2) throws Exception;
    }
}

