/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.webgiscli.module.dialog.gui;

import de.riwagis.util.Config;
import de.riwagis.util.Whiteboard;
import de.riwagis.util.excel.XlsExportSupport;
import de.riwagis.util.exception.SystemException;
import de.riwagis.util.file.FileSupport;
import de.riwagis.util.gui.ExceptionDialog;
import de.riwagis.util.gui.GUISupport;
import de.riwagis.util.gui.OSFile;
import de.riwagis.util.gui.components.StatusDisplayer;
import de.riwagis.util.gui.components.WaitDialog;
import de.riwagis.util.i18n.I18N;
import de.riwagis.webgiscli.WebGisContext;
import de.riwagis.webgiscli.module.dialog.WebGisDialog;
import de.riwagis.webgiscli.service.http.streams.ServerFileStream;
import de.riwagis.webgiscli.servlet.actions.XlsExportAction;
import de.riwagis.webgiscli.servlet.actions.XlsExportServerCapabilities;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class XlsExportDialog
extends JDialog {
    private static final I18N i18n = new I18N(Config.LOCALE, "de.riwagis.webgiscli.i18n.i18n");
    private WebGisDialog dlg = null;
    private final Map<Integer, String> mapIdIndex = new HashMap<Integer, String>();
    private boolean bolExportAbortFlag = true;
    public static final int STREAM_TIMEOUT = 480000;
    private JButton butAllOff;
    private JButton butAllOn;
    private JButton butCancel;
    private JButton butContinue;
    private JButton butFile;
    private JScrollPane jScrollPane1;
    private JLabel lblFile;
    private JLabel lblHeader;
    private ButtonGroup obtGrpData;
    private JRadioButton optExpAll;
    private JRadioButton optExpCurrent;
    private JRadioButton optExpFilter;
    private JPanel pnlButtons;
    private JPanel pnlFileSelect;
    private JPanel pnlOnOff;
    private JPanel pnlOptions;
    private JTable tblFields;
    private JTextField txtFile;

    public XlsExportDialog(Window parent, Dialog.ModalityType modal, WebGisDialog _dlg) throws SystemException {
        super(parent, modal);
        super.setPreferredSize(new Dimension(400, 430));
        this.initComponents();
        this.i18n();
        this.setDialog(_dlg);
        this.init();
    }

    private void init() {
        this.optExpFilter.setSelected(true);
        WebGisContext wgContext = this.dlg.getWgContext();
        Whiteboard wb = wgContext.getPermWhiteboard();
        String strFile = ObjectUtils.toString((Object)wb.getAttribute(XlsExportAction.KEY_FILE));
        if (strFile.length() > 0) {
            this.txtFile.setText(strFile);
        }
        this.txtFile.setEditable(false);
    }

    private void i18n() {
        this.setTitle(i18n.get("module.dialog.gui.XlsExportDialog.title"));
        this.lblHeader.setText(i18n.get("module.dialog.gui.XlsExportDialog.title"));
        this.lblFile.setText(i18n.get("common.file") + ":");
        this.butFile.setText(i18n.get("common.choose"));
        this.optExpFilter.setText(i18n.get("module.dialog.gui.XlsExportDialog.exp-filter"));
        this.optExpAll.setText(i18n.get("module.dialog.gui.XlsExportDialog.exp-all"));
        this.optExpCurrent.setText(i18n.get("module.dialog.gui.XlsExportDialog.exp-current"));
        this.tblFields.getColumnModel().getColumn(0).setHeaderValue(i18n.get("module.dialog.gui.XlsExportDialog.exp-field"));
        this.butCancel.setText(i18n.get("common.cancel"));
        this.butContinue.setText(i18n.get("common.continue"));
        this.butAllOff.setText(i18n.get("module.dialog.gui.XlsExportDialog.all-off"));
        this.butAllOn.setText(i18n.get("module.dialog.gui.XlsExportDialog.all-on"));
    }

    private DefaultTableModel getTblModel() {
        return (DefaultTableModel)this.tblFields.getModel();
    }

    public final void setDialog(WebGisDialog _dlg) throws SystemException {
        this.dlg = _dlg;
        DefaultTableModel modTbl = this.getTblModel();
        while (modTbl.getRowCount() > 0) {
            modTbl.removeRow(0);
        }
        this.tblFields.getColumnModel().getColumn(0).setPreferredWidth(300);
        this.lblHeader.setText(i18n.get("module.dialog.gui.XlsExportDialog.title") + " - " + this.dlg.getTitle());
        Iterator<?> i = this.dlg.getFields();
        int counter = 0;
        while (i.hasNext()) {
            String strShowTable;
            Namespace ns;
            Element elemField = (Element)i.next();
            String strType = elemField.getChildTextTrim("type", ns = elemField.getNamespace());
            if (strType == null || strType.equalsIgnoreCase("label") || (strShowTable = ObjectUtils.toString((Object)elemField.getChildTextTrim("showtable", ns))).equals("0")) continue;
            this.mapIdIndex.put(counter, elemField.getChildTextTrim("id", ns));
            modTbl.addRow(new Object[]{elemField.getChildTextTrim("name", ns), true});
            ++counter;
        }
    }

    private void exportFile(WaitDialog dlgWait) {
        try {
            WebGisContext wgContext;
            XlsExportServerCapabilities caps;
            boolean bolOverwrite;
            String strFile = this.txtFile.getText();
            if (StringUtils.isBlank((String)strFile)) {
                GUISupport.msgbox((Component)this, (String)i18n.get("module.dialog.gui.XlsExportDialog.select-file"), (String)i18n.get("common.error"));
                return;
            }
            File expFile = new File(strFile);
            if (expFile.exists() && !(bolOverwrite = GUISupport.yesnobox((Component)this, (String)i18n.get("module.dialog.gui.XlsExportDialog.overwrite"), (String)i18n.get("common.message")))) {
                this.bolExportAbortFlag = true;
                return;
            }
            if (!expFile.getParentFile().exists()) {
                GUISupport.msgbox((Component)this, (String)i18n.get("module.dialog.gui.XlsExportDialog.no-dir"), (String)i18n.get("common.error"));
                this.bolExportAbortFlag = true;
                return;
            }
            DefaultTableModel tblMod = this.getTblModel();
            ArrayList<String> lstFieldIds = new ArrayList<String>();
            for (int i = 0; i < tblMod.getRowCount(); ++i) {
                Boolean bolSelected = (Boolean)tblMod.getValueAt(i, 1);
                if (!bolSelected.booleanValue()) continue;
                lstFieldIds.add(this.mapIdIndex.get(i));
            }
            if (lstFieldIds.isEmpty()) {
                return;
            }
            String[] arrStrFields = lstFieldIds.toArray(new String[lstFieldIds.size()]);
            Integer[] arrFields = new Integer[arrStrFields.length];
            for (int i = 0; i < arrStrFields.length; ++i) {
                arrFields[i] = Integer.parseInt(arrStrFields[i]);
            }
            int intOption = 1;
            if (this.optExpAll.isSelected()) {
                intOption = 2;
            }
            if (this.optExpCurrent.isSelected()) {
                intOption = 3;
            }
            if ((caps = XlsExportAction.determineExcelExportCapabilities(wgContext = this.dlg.getWgContext())).isAllowServerGeneratedExcel()) {
                if (caps.isSupportAsychronGeneration()) {
                    String streamID = WebGisDialog.startServerExcelFile(wgContext, this.dlg.getModuleKey(), this.dlg.getKey(), arrFields, intOption, expFile);
                    ServerFileStream.buildServerFileAsynchronous(wgContext, streamID, (StatusDisplayer)dlgWait, expFile);
                    dlgWait.setMessage(i18n.get("servlet.actions.XlsExportAction.wait"));
                } else {
                    WebGisDialog.buildServerExcelFile(this.dlg, arrFields, intOption, expFile);
                }
            } else {
                String[][] arrResult = this.dlg.getStringArray(arrFields, intOption);
                XlsExportSupport.exportStringArray2Excel((String[][])arrResult, (File)expFile, (boolean)true);
            }
            boolean bolYes = GUISupport.yesnobox((Component)this, (String)i18n.get("module.dialog.gui.XlsExportDialog.show-file"), (String)i18n.get("common.message"));
            if (bolYes) {
                OSFile.showFile((File)new File(strFile), (boolean)true);
            }
        }
        catch (Exception e) {
            this.bolExportAbortFlag = true;
            ExceptionDialog.handleGuiException((Component)this, (Throwable)e, (String)"webgiscli");
        }
    }

    private void initComponents() {
        this.obtGrpData = new ButtonGroup();
        this.lblHeader = new JLabel();
        this.pnlFileSelect = new JPanel();
        this.lblFile = new JLabel();
        this.txtFile = new JTextField();
        this.butFile = new JButton();
        this.pnlOptions = new JPanel();
        this.optExpFilter = new JRadioButton();
        this.optExpAll = new JRadioButton();
        this.optExpCurrent = new JRadioButton();
        this.pnlOnOff = new JPanel();
        this.butAllOn = new JButton();
        this.butAllOff = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.tblFields = new JTable();
        this.pnlButtons = new JPanel();
        this.butCancel = new JButton();
        this.butContinue = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("CSV Export");
        this.getContentPane().setLayout(new GridBagLayout());
        this.lblHeader.setFont(this.lblHeader.getFont().deriveFont(this.lblHeader.getFont().getStyle() | 1, this.lblHeader.getFont().getSize() + 1));
        this.lblHeader.setText("CSV Export");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(9, 9, 3, 9);
        this.getContentPane().add((Component)this.lblHeader, gridBagConstraints);
        this.pnlFileSelect.setLayout(new GridBagLayout());
        this.lblFile.setText("Datei:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 9, 3, 3);
        this.pnlFileSelect.add((Component)this.lblFile, gridBagConstraints);
        this.txtFile.setPreferredSize(new Dimension(200, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlFileSelect.add((Component)this.txtFile, gridBagConstraints);
        this.butFile.setText("w\u00e4hlen");
        this.butFile.setPreferredSize(new Dimension(70, 23));
        this.butFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                XlsExportDialog.this.butFile_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlFileSelect.add((Component)this.butFile, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 9, 3, 9);
        this.getContentPane().add((Component)this.pnlFileSelect, gridBagConstraints);
        this.pnlOptions.setLayout(new GridLayout(0, 1));
        this.obtGrpData.add(this.optExpFilter);
        this.optExpFilter.setText("Daten im Filter exportieren");
        this.optExpFilter.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.optExpFilter.setMargin(new Insets(0, 0, 0, 0));
        this.pnlOptions.add(this.optExpFilter);
        this.obtGrpData.add(this.optExpAll);
        this.optExpAll.setText("Alle Daten exportieren");
        this.optExpAll.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.optExpAll.setMargin(new Insets(0, 0, 0, 0));
        this.pnlOptions.add(this.optExpAll);
        this.obtGrpData.add(this.optExpCurrent);
        this.optExpCurrent.setText("nur aktuellen Datensatz exportieren");
        this.optExpCurrent.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.optExpCurrent.setMargin(new Insets(0, 0, 0, 0));
        this.pnlOptions.add(this.optExpCurrent);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 9, 3, 9);
        this.getContentPane().add((Component)this.pnlOptions, gridBagConstraints);
        this.pnlOnOff.setLayout(new FlowLayout(2, 2, 0));
        this.butAllOn.setFont(this.butAllOn.getFont().deriveFont((float)this.butAllOn.getFont().getSize() - 2.0f));
        this.butAllOn.setText("alle ein");
        this.butAllOn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                XlsExportDialog.this.butAllOn_onActionPerformed(evt);
            }
        });
        this.pnlOnOff.add(this.butAllOn);
        this.butAllOff.setFont(this.butAllOff.getFont().deriveFont((float)this.butAllOff.getFont().getSize() - 2.0f));
        this.butAllOff.setText("alle aus");
        this.butAllOff.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                XlsExportDialog.this.butAllOff_onActionPerformed(evt);
            }
        });
        this.pnlOnOff.add(this.butAllOff);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 9, 3, 9);
        this.getContentPane().add((Component)this.pnlOnOff, gridBagConstraints);
        this.tblFields.setModel(new DefaultTableModel(new Object[0][], new String[]{"Feld", ""}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, Boolean.class};
                this.canEdit = new boolean[]{false, true};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.jScrollPane1.setViewportView(this.tblFields);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 9, 3, 9);
        this.getContentPane().add((Component)this.jScrollPane1, gridBagConstraints);
        this.butCancel.setText("abbrechen");
        this.butCancel.setPreferredSize(new Dimension(100, 23));
        this.butCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                XlsExportDialog.this.butCancel_onActionPerformed(evt);
            }
        });
        this.pnlButtons.add(this.butCancel);
        this.butContinue.setText("weiter");
        this.butContinue.setPreferredSize(new Dimension(100, 23));
        this.butContinue.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                XlsExportDialog.this.butContinue_onActionPerformed(evt);
            }
        });
        this.pnlButtons.add(this.butContinue);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 9, 9, 9);
        this.getContentPane().add((Component)this.pnlButtons, gridBagConstraints);
        this.pack();
    }

    private void butContinue_onActionPerformed(ActionEvent evt) {
        try {
            this.bolExportAbortFlag = false;
            WaitDialog dlgWait = WaitDialog.createWaitDialog((Window)this, (String)i18n.get("module.dialog.gui.XlsExportDialog.wait"));
            Runnable work = () -> this.exportFile(dlgWait);
            dlgWait.addWorkToDo(work);
            dlgWait.setCancelable(false);
            dlgWait.setVisible(true);
            this.setVisible(this.bolExportAbortFlag);
            this.dispose();
        }
        catch (Exception e) {
            ExceptionDialog.handleGuiException((Component)this, (Throwable)e, (String)"webgiscli");
        }
    }

    private void butFile_onActionPerformed(ActionEvent evt) {
        File prevFile = new File(this.txtFile.getText());
        JFileChooser fileChoose = GUISupport.createJFileChooser();
        fileChoose.setAcceptAllFileFilterUsed(false);
        fileChoose.setFileFilter(GUISupport.createFileFilter((String)"Excel-File", (String[])new String[]{"xls", "xlsx"}));
        fileChoose.setMultiSelectionEnabled(false);
        fileChoose.setSelectedFile(prevFile);
        int intOption = fileChoose.showSaveDialog(this);
        if (intOption == 1) {
            return;
        }
        File selectedFile = fileChoose.getSelectedFile();
        if (selectedFile != null) {
            String extension = FilenameUtils.getExtension((String)selectedFile.getName());
            String selectedFilename = !StringUtils.equalsIgnoreCase((String)extension, (String)"xls") ? FileSupport.addExtension((File)selectedFile, (String)"xlsx").getAbsolutePath() : selectedFile.getAbsolutePath();
            this.txtFile.setText(selectedFilename);
            WebGisContext wgContext = this.dlg.getWgContext();
            Whiteboard wb = wgContext.getPermWhiteboard();
            wb.setAttribute(XlsExportAction.KEY_FILE, (Object)selectedFilename);
            wgContext.writePermWhiteboard();
        }
    }

    private void butAllOff_onActionPerformed(ActionEvent evt) {
        DefaultTableModel modTbl = this.getTblModel();
        for (int i = 0; i < modTbl.getRowCount(); ++i) {
            modTbl.setValueAt(false, i, 1);
        }
    }

    private void butAllOn_onActionPerformed(ActionEvent evt) {
        DefaultTableModel modTbl = this.getTblModel();
        for (int i = 0; i < modTbl.getRowCount(); ++i) {
            modTbl.setValueAt(true, i, 1);
        }
    }

    private void butCancel_onActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }
}

