/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.webgiscli.module.dialog.gui;

import de.riwagis.util.gui.GUISupport;
import de.riwagis.util.gui.OSFile;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSavedDialog
extends JDialog {
    private static final Logger LOG = LoggerFactory.getLogger(FileSavedDialog.class);
    private final File saveFile;
    private JButton btnClose;
    private JButton btnOpenFile;
    private JButton btnOpenPath;
    private JTextField edtExistingFile;
    private JPanel jPanel1;
    private JLabel lblExplanation;
    private JLabel lblFiledate;
    private JLabel lblFiledateText;
    private JLabel lblFilesize;
    private JLabel lblFilesizeText;
    private JPanel pnlButtons;
    private JPanel pnlFilename;
    private JPanel pnlMessage;

    public static void notifyFileSaved(Window parent, File showFile) {
        if (showFile != null) {
            FileSavedDialog fex = new FileSavedDialog(parent, showFile);
            try {
                GUISupport.centreOnScreen((Component)fex);
                fex.setVisible(true);
            }
            finally {
                fex.dispose();
            }
        }
    }

    private void updateControls() {
        this.edtExistingFile.setText(this.saveFile.getAbsolutePath());
        boolean saveFileExists = this.saveFile.exists();
        this.btnOpenFile.setEnabled(saveFileExists);
        this.btnOpenPath.setEnabled(saveFileExists);
        this.lblFilesize.setText(MessageFormat.format("{0,NUMBER,0} b", this.saveFile.length()));
        this.lblFiledate.setText(MessageFormat.format("{0,DATE,medium} {0,TIME,medium}", this.saveFile.lastModified()));
    }

    public FileSavedDialog(Window parent, File saveFile) {
        super(parent, Dialog.ModalityType.DOCUMENT_MODAL);
        this.saveFile = saveFile;
        this.initComponents();
        this.btnClose.requestFocus();
        this.updateControls();
    }

    public File getFile() {
        return this.saveFile;
    }

    private void initComponents() {
        this.pnlMessage = new JPanel();
        this.lblExplanation = new JLabel();
        this.pnlFilename = new JPanel();
        this.edtExistingFile = new JTextField();
        this.jPanel1 = new JPanel();
        this.lblFilesizeText = new JLabel();
        this.lblFilesize = new JLabel();
        this.lblFiledateText = new JLabel();
        this.lblFiledate = new JLabel();
        this.pnlButtons = new JPanel();
        this.btnOpenPath = new JButton();
        this.btnOpenFile = new JButton();
        this.btnClose = new JButton();
        this.setDefaultCloseOperation(2);
        ResourceBundle bundle = ResourceBundle.getBundle("de/riwagis/webgiscli/i18n/i18n");
        this.setTitle(bundle.getString("gui.filesaveddialog.title"));
        this.setIconImage(null);
        this.setIconImages(null);
        this.setLocationByPlatform(true);
        this.setMinimumSize(new Dimension(400, 200));
        this.setModal(true);
        this.setResizable(false);
        this.getContentPane().setLayout(new GridBagLayout());
        this.pnlMessage.setLayout(new GridBagLayout());
        this.lblExplanation.setText(bundle.getString("gui.filesaveddialog.filesaved"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.pnlMessage.add((Component)this.lblExplanation, gridBagConstraints);
        this.pnlFilename.setLayout(new GridBagLayout());
        this.edtExistingFile.setEditable(false);
        this.edtExistingFile.setMinimumSize(new Dimension(400, 20));
        this.edtExistingFile.setPreferredSize(new Dimension(400, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        this.pnlFilename.add((Component)this.edtExistingFile, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.lblFilesizeText.setHorizontalAlignment(11);
        this.lblFilesizeText.setText(bundle.getString("gui.fileexistsdialog.size"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 15, 0, 4);
        this.jPanel1.add((Component)this.lblFilesizeText, gridBagConstraints);
        this.lblFilesize.setFont(this.lblFilesize.getFont().deriveFont(this.lblFilesize.getFont().getStyle() | 1));
        this.lblFilesize.setMinimumSize(new Dimension(100, 0));
        this.lblFilesize.setPreferredSize(new Dimension(100, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        this.jPanel1.add((Component)this.lblFilesize, gridBagConstraints);
        this.lblFiledateText.setHorizontalAlignment(11);
        this.lblFiledateText.setText(bundle.getString("gui.fileexistsdialog.filedate"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 15, 0, 4);
        this.jPanel1.add((Component)this.lblFiledateText, gridBagConstraints);
        this.lblFiledate.setFont(this.lblFiledate.getFont().deriveFont(this.lblFiledate.getFont().getStyle() | 1));
        this.lblFiledate.setMinimumSize(new Dimension(100, 0));
        this.lblFiledate.setPreferredSize(new Dimension(100, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.lblFiledate, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        this.pnlFilename.add((Component)this.jPanel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        this.pnlMessage.add((Component)this.pnlFilename, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.pnlMessage, gridBagConstraints);
        this.pnlButtons.setLayout(new GridBagLayout());
        this.btnOpenPath.setText(bundle.getString("gui.filesaveddialog.openPath"));
        this.btnOpenPath.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileSavedDialog.this.btnOpenPathActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlButtons.add((Component)this.btnOpenPath, gridBagConstraints);
        this.btnOpenFile.setText(bundle.getString("gui.filesaveddialog.openfile"));
        this.btnOpenFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileSavedDialog.this.btnOpenFileActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlButtons.add((Component)this.btnOpenFile, gridBagConstraints);
        this.btnClose.setText(bundle.getString("common.close"));
        this.btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileSavedDialog.this.btnCloseActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlButtons.add((Component)this.btnClose, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.pnlButtons, gridBagConstraints);
        this.pack();
    }

    private void btnOpenFileActionPerformed(ActionEvent evt) {
        OSFile.showFile((File)this.saveFile, (boolean)false);
        this.setVisible(false);
    }

    private void btnOpenPathActionPerformed(ActionEvent evt) {
        OSFile.showFile((File)this.saveFile.getParentFile(), (boolean)false);
        this.setVisible(false);
    }

    private void btnCloseActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }
}

