/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.webgiscli.module.dialog.gui;

import de.riwagis.icons.IconLoader;
import de.riwagis.util.gui.GUISupport;
import de.riwagis.util.gui.OSFile;
import de.riwagis.webgiscli.module.dialog.gui.FEXResult;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class FileExistsDialog
extends JDialog {
    private final File existantFile;
    private File saveFile;
    private final JFileChooser choose = GUISupport.createJFileChooserOverwritePrompting();
    private FEXResult fexRes = FEXResult.FEX_Cancel;
    private JButton btnCancel;
    private JButton btnOverwrite;
    private JButton btnSave;
    private JButton btnShowFile;
    private JTextField edtExistingFile;
    private JPanel jPanel1;
    private JLabel lblExplanation;
    private JLabel lblExplanation2;
    private JLabel lblFiledate;
    private JLabel lblFiledateText;
    private JLabel lblFilesize;
    private JLabel lblFilesizeText;
    private JLabel lblIcon;
    private JPanel pnlButtons;
    private JPanel pnlFilename;
    private JPanel pnlMessage;

    private void updateControls() {
        this.edtExistingFile.setText(this.existantFile.getAbsolutePath());
        boolean saveFileExists = this.saveFile.exists();
        this.btnOverwrite.setEnabled(saveFileExists);
        this.btnSave.setEnabled(true);
        this.lblFilesize.setText(MessageFormat.format("{0,NUMBER,0} b", this.existantFile.length()));
        this.lblFiledate.setText(MessageFormat.format("{0,DATE,medium} {0,TIME,medium}", this.existantFile.lastModified()));
    }

    public FileExistsDialog(Window parent, Dialog.ModalityType modal, File saveFile, int fileMode) {
        super(parent, modal);
        this.existantFile = saveFile;
        this.saveFile = saveFile;
        this.initComponents();
        this.btnCancel.requestFocus();
        this.updateControls();
        this.choose.setFileSelectionMode(fileMode);
    }

    public File getFile() {
        return this.saveFile;
    }

    public FEXResult getResult() {
        return this.fexRes;
    }

    private void initComponents() {
        this.lblIcon = new JLabel();
        this.pnlMessage = new JPanel();
        this.lblExplanation = new JLabel();
        this.pnlFilename = new JPanel();
        this.edtExistingFile = new JTextField();
        this.btnShowFile = new JButton();
        this.jPanel1 = new JPanel();
        this.lblFilesizeText = new JLabel();
        this.lblFilesize = new JLabel();
        this.lblFiledateText = new JLabel();
        this.lblFiledate = new JLabel();
        this.lblExplanation2 = new JLabel();
        this.pnlButtons = new JPanel();
        this.btnOverwrite = new JButton();
        this.btnSave = new JButton();
        this.btnCancel = new JButton();
        this.setDefaultCloseOperation(2);
        ResourceBundle bundle = ResourceBundle.getBundle("de/riwagis/webgiscli/i18n/i18n");
        this.setTitle(bundle.getString("gui.fileexistsdialog.title"));
        this.setIconImage(null);
        this.setIconImages(null);
        this.setLocationByPlatform(true);
        this.setMinimumSize(new Dimension(400, 200));
        this.setModal(true);
        this.setResizable(false);
        this.getContentPane().setLayout(new GridBagLayout());
        this.lblIcon.setIcon(IconLoader.svgIcon((String)"common_attention.svg"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.getContentPane().add((Component)this.lblIcon, gridBagConstraints);
        this.pnlMessage.setLayout(new GridBagLayout());
        this.lblExplanation.setText(bundle.getString("gui.fileexistsdialog.filealreadyexists"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.pnlMessage.add((Component)this.lblExplanation, gridBagConstraints);
        this.pnlFilename.setLayout(new GridBagLayout());
        this.edtExistingFile.setEditable(false);
        this.edtExistingFile.setMinimumSize(new Dimension(400, 20));
        this.edtExistingFile.setPreferredSize(new Dimension(400, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        this.pnlFilename.add((Component)this.edtExistingFile, gridBagConstraints);
        this.btnShowFile.setIcon(IconLoader.svgIcon((String)"common_eye_on.svg"));
        this.btnShowFile.setToolTipText(bundle.getString("gui.fileexistsdialog.viewFile"));
        this.btnShowFile.setMargin(new Insets(2, 2, 2, 2));
        this.btnShowFile.setMinimumSize(new Dimension(24, 24));
        this.btnShowFile.setPreferredSize(new Dimension(24, 24));
        this.btnShowFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileExistsDialog.this.btnShowFileActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.pnlFilename.add((Component)this.btnShowFile, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.lblFilesizeText.setHorizontalAlignment(11);
        this.lblFilesizeText.setText(bundle.getString("gui.fileexistsdialog.size"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 15, 0, 4);
        this.jPanel1.add((Component)this.lblFilesizeText, gridBagConstraints);
        this.lblFilesize.setFont(this.lblFilesize.getFont().deriveFont(this.lblFilesize.getFont().getStyle() | 1));
        this.lblFilesize.setMinimumSize(new Dimension(100, 0));
        this.lblFilesize.setPreferredSize(new Dimension(100, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        this.jPanel1.add((Component)this.lblFilesize, gridBagConstraints);
        this.lblFiledateText.setHorizontalAlignment(11);
        this.lblFiledateText.setText(bundle.getString("gui.fileexistsdialog.filedate"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 15, 0, 4);
        this.jPanel1.add((Component)this.lblFiledateText, gridBagConstraints);
        this.lblFiledate.setFont(this.lblFiledate.getFont().deriveFont(this.lblFiledate.getFont().getStyle() | 1));
        this.lblFiledate.setMinimumSize(new Dimension(100, 0));
        this.lblFiledate.setPreferredSize(new Dimension(100, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.lblFiledate, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        this.pnlFilename.add((Component)this.jPanel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        this.pnlMessage.add((Component)this.pnlFilename, gridBagConstraints);
        this.lblExplanation2.setText(bundle.getString("gui.fileexistsdialog.message"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.pnlMessage.add((Component)this.lblExplanation2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.pnlMessage, gridBagConstraints);
        this.pnlButtons.setLayout(new GridBagLayout());
        this.btnOverwrite.setText(bundle.getString("gui.fileexistsdialog.overwrite"));
        this.btnOverwrite.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileExistsDialog.this.btnOverwriteActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlButtons.add((Component)this.btnOverwrite, gridBagConstraints);
        this.btnSave.setText(bundle.getString("gui.fileexistsdialog.saveAs"));
        this.btnSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileExistsDialog.this.btnSaveActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlButtons.add((Component)this.btnSave, gridBagConstraints);
        this.btnCancel.setText(bundle.getString("common.cancel"));
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileExistsDialog.this.btnCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlButtons.add((Component)this.btnCancel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.pnlButtons, gridBagConstraints);
        this.pack();
    }

    private void btnOverwriteActionPerformed(ActionEvent evt) {
        this.fexRes = FEXResult.FEX_Overwrite;
        this.setVisible(false);
    }

    private void btnSaveActionPerformed(ActionEvent evt) {
        this.choose.setSelectedFile(this.saveFile);
        if (this.choose.showDialog(this.getParent(), "Speichern") == 0) {
            this.fexRes = FEXResult.FEX_SaveAs;
            if (this.choose.getSelectedFile().exists()) {
                this.fexRes = FEXResult.FEX_Overwrite;
            }
            this.saveFile = this.choose.getSelectedFile();
            this.setVisible(false);
        }
    }

    private void btnShowFileActionPerformed(ActionEvent evt) {
        OSFile.showFile((File)this.saveFile, (boolean)false);
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.fexRes = FEXResult.FEX_Cancel;
        this.setVisible(false);
    }

    public static File checkFileExists(Window parent, File f) {
        File res = f;
        if (res != null && res.exists()) {
            FileExistsDialog fex = new FileExistsDialog(parent, Dialog.ModalityType.APPLICATION_MODAL, f, 0);
            GUISupport.centreOnScreen((Component)fex);
            fex.setVisible(true);
            switch (fex.getResult()) {
                case FEX_Cancel: {
                    res = null;
                    break;
                }
                case FEX_SaveAs: 
                case FEX_Overwrite: {
                    res = fex.getFile();
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown dialog state");
                }
            }
        }
        return res;
    }
}

