/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.webgiscli.module.dialog.gui;

import de.riwagis.service.ServiceException;
import de.riwagis.util.Config;
import de.riwagis.util.gui.ExceptionDialog;
import de.riwagis.util.gui.components.WaitDialog;
import de.riwagis.util.i18n.I18N;
import de.riwagis.webgiscli.module.dialog.WebGisDialog;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class DocExportDialog
extends JDialog {
    public static final int EXP_CANCELED = 0;
    public static final int EXP_FILTER = 1;
    public static final int EXP_ALL = 2;
    public static final int EXP_CURRENT = 3;
    private static final I18N i18n = new I18N(Config.LOCALE, "de.riwagis.webgiscli.i18n.i18n");
    private WebGisDialog dlg = null;
    private int intExpType = 0;
    private JButton butCancel;
    private JButton butContinue;
    private JPanel jPanel2;
    private JLabel lblHeader;
    private ButtonGroup obtGrpData;
    private JRadioButton optExpAll;
    private JRadioButton optExpCurrent;
    private JRadioButton optExpFilter;

    public DocExportDialog(Window window, WebGisDialog _dlg) {
        super(window, Dialog.ModalityType.APPLICATION_MODAL);
        this.initComponents();
        this.i18n();
        this.setDialog(_dlg);
        this.init();
    }

    private void init() {
        this.optExpCurrent.setSelected(true);
    }

    public final void setDialog(WebGisDialog _dlg) {
        this.dlg = _dlg;
    }

    private void i18n() {
        this.setTitle(i18n.get("module.dialog.gui.DocExportDialog.title"));
        this.lblHeader.setText(i18n.get("module.dialog.gui.DocExportDialog.header"));
        this.optExpAll.setText(i18n.get("module.dialog.gui.DocExportDialog.exp-all"));
        this.optExpCurrent.setText(i18n.get("module.dialog.gui.DocExportDialog.exp-current"));
        this.optExpFilter.setText(i18n.get("module.dialog.gui.DocExportDialog.exp-filter"));
        this.butCancel.setText(i18n.get("common.cancel"));
        this.butContinue.setText(i18n.get("common.continue"));
    }

    public int getExportType() {
        return this.intExpType;
    }

    private boolean fillReport() throws ServiceException {
        this.intExpType = 1;
        if (this.optExpAll.isSelected()) {
            this.intExpType = 2;
        }
        if (this.optExpCurrent.isSelected()) {
            this.intExpType = 3;
        }
        return this.dlg.fillReportData(this.intExpType);
    }

    private void initComponents() {
        this.obtGrpData = new ButtonGroup();
        this.lblHeader = new JLabel();
        this.optExpAll = new JRadioButton();
        this.optExpCurrent = new JRadioButton();
        this.jPanel2 = new JPanel();
        this.butCancel = new JButton();
        this.butContinue = new JButton();
        this.optExpFilter = new JRadioButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("CSV Export");
        this.getContentPane().setLayout(new GridBagLayout());
        this.lblHeader.setFont(this.lblHeader.getFont().deriveFont(this.lblHeader.getFont().getStyle() | 1, this.lblHeader.getFont().getSize() + 1));
        this.lblHeader.setText("Exportoptionen:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(9, 9, 3, 9);
        this.getContentPane().add((Component)this.lblHeader, gridBagConstraints);
        this.obtGrpData.add(this.optExpAll);
        this.optExpAll.setText("Alle Daten exportieren");
        this.optExpAll.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.optExpAll.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 9, 3, 9);
        this.getContentPane().add((Component)this.optExpAll, gridBagConstraints);
        this.obtGrpData.add(this.optExpCurrent);
        this.optExpCurrent.setText("nur aktuellen Datensatz exportieren");
        this.optExpCurrent.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.optExpCurrent.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 9, 3, 9);
        this.getContentPane().add((Component)this.optExpCurrent, gridBagConstraints);
        this.butCancel.setText("abbrechen");
        this.butCancel.setPreferredSize(new Dimension(100, 23));
        this.butCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DocExportDialog.this.butCancel_onActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.butCancel);
        this.butContinue.setText("weiter");
        this.butContinue.setPreferredSize(new Dimension(100, 23));
        this.butContinue.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DocExportDialog.this.butContinue_onActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.butContinue);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 9, 9, 9);
        this.getContentPane().add((Component)this.jPanel2, gridBagConstraints);
        this.obtGrpData.add(this.optExpFilter);
        this.optExpFilter.setText("Daten im Filter exportieren");
        this.optExpFilter.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.optExpFilter.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 9, 3, 9);
        this.getContentPane().add((Component)this.optExpFilter, gridBagConstraints);
        this.pack();
    }

    private void butContinue_onActionPerformed(ActionEvent evt) {
        final WaitDialog dlgWait = WaitDialog.createWaitDialog((Window)this, (String)i18n.get("module.dialog.gui.DocExportDialog.wait"), (Runnable)new Runnable(this){

            @Override
            public void run() {
            }
        });
        Runnable work = new Runnable(){

            @Override
            public void run() {
                try {
                    if (!DocExportDialog.this.fillReport()) {
                        throw new Exception("fillReport was not successful.");
                    }
                }
                catch (Exception e) {
                    dlgWait.setError(e);
                }
            }
        };
        dlgWait.addWorkToDo(work);
        dlgWait.setCancelable(false);
        dlgWait.setVisible(true);
        if (dlgWait.getError() != null) {
            this.intExpType = 0;
            ExceptionDialog.handleGuiException((Component)this, (Throwable)dlgWait.getError(), (String)"webgiscli");
        }
        this.setVisible(false);
    }

    private void butCancel_onActionPerformed(ActionEvent evt) {
        this.intExpType = 0;
        this.setVisible(false);
    }
}

