/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.webgiscli.module.dialog.gui;

import de.riwagis.dms.DMSCapabilities;
import de.riwagis.dms.DMSDocument;
import de.riwagis.dms.DMSInterface;
import de.riwagis.icons.IconLoader;
import de.riwagis.util.Config;
import de.riwagis.util.exception.SystemException;
import de.riwagis.util.file.FileSupport;
import de.riwagis.util.gui.ExceptionDialog;
import de.riwagis.util.gui.FileFilterWrapper;
import de.riwagis.util.gui.GUISupport;
import de.riwagis.util.gui.components.WaitDialog;
import de.riwagis.util.gui.filedrop.FileDrop;
import de.riwagis.util.i18n.I18N;
import de.riwagis.webgiscli.module.dialog.WebGisDialog;
import de.riwagis.webgiscli.module.dialog.gui.DBParserBaseDialog;
import de.riwagis.webgiscli.module.dialog.gui.DMSEventType;
import de.riwagis.webgiscli.module.dialog.gui.FieldFileStorageType;
import de.riwagis.webgiscli.util.ThrowingSupplier;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;

public class DBParserUploadDialog
extends DBParserBaseDialog {
    private static final String KEY_DIR = DBParserUploadDialog.class.getName() + "_Dir";
    private static final I18N i18n = new I18N(Config.LOCALE, "de.riwagis.webgiscli.i18n.i18n");
    private static final long _1MB = 0x100000L;
    private transient FileFilter fileFilter;
    private FileDrop fdServer;
    private FileDrop fdLocal;
    private boolean shouldRefresh = true;
    private ThrowingSupplier<DMSDocument, Exception> deferredSaveAction;
    private String dmsDocumentTemplateLabel;
    private JButton btnInputDMS;
    private JButton btnInsertDMS;
    private JButton btnSelectDMS;
    private JButton butCancel;
    private JButton butFileLocal;
    private JButton butFileServer;
    private JButton butSave;
    private JComboBox<String> cmbDirServer;
    private JLabel lblDMSID;
    private JLabel lblDMSType;
    private JLabel lblDirServer;
    private JLabel lblDnDLocal;
    private JLabel lblDnDServer;
    private JLabel lblFileLocal;
    private JLabel lblFileServer;
    private JLabel lblFilenameServer;
    private JLabel lblInfo;
    private JLabel lblInfo2;
    private JPanel pnlButtons;
    private JPanel pnlConfigDMS;
    private JPanel pnlConfigServer;
    private JPanel pnlDMSType;
    private JPanel pnlDropLocal;
    private JPanel pnlDropServer;
    private JPanel pnlFileLocal;
    private JPanel pnlFileServer;
    private JPanel pnlSelectFile1;
    private JPanel pnlSelectFileServer;
    private JTabbedPane tabStorageType;
    private JTextField txtDMSLink;
    private JLabel txtDMSType;
    private JTextField txtFileLocal;
    private JTextField txtFileServer;
    private JTextField txtFilenameServer;

    public DBParserUploadDialog(Window parent) {
        super(parent, Dialog.ModalityType.APPLICATION_MODAL);
        super.setPreferredSize(new Dimension(460, 200));
        this.pack();
        this.initComponents();
        this.i18n();
        this.init();
    }

    private void init() {
        this.txtFileServer.setEditable(false);
        this.lblInfo.setIcon(IconLoader.svgIcon((String)"common_info.svg"));
        this.fdServer = new FileDrop((Component)this.pnlFileServer, dropEvent -> {
            File droppedFile = null;
            for (File file2test : dropEvent.getFiles()) {
                if (file2test.isDirectory() || this.fileFilter != null && !this.fileFilter.accept(file2test)) continue;
                droppedFile = file2test;
                break;
            }
            if (droppedFile != null) {
                this.selectFileServer(droppedFile);
            }
        });
        this.fdLocal = new FileDrop((Component)this.pnlFileLocal, dropEvent -> {
            File droppedFile = null;
            for (File file2test : dropEvent.getFiles()) {
                if (this.fileFilter != null && !this.fileFilter.accept(file2test)) continue;
                droppedFile = file2test;
                break;
            }
            if (droppedFile != null) {
                this.selectFileLocal(droppedFile);
            }
        });
    }

    private void i18n() {
        this.lblDnDServer.setText(i18n.get("common.drop-file"));
        this.lblDnDLocal.setText(i18n.get("common.drop-file"));
        this.lblDirServer.setText(i18n.get("module.dialog.gui.DBParserUploadDialog.dir-server"));
        this.lblFilenameServer.setText(i18n.get("module.dialog.gui.DBParserUploadDialog.filename-server"));
        this.txtFilenameServer.setToolTipText(i18n.get("module.dialog.gui.DBParserUploadDialog.filename-server-tooltip"));
        this.lblFileServer.setText(i18n.get("module.dialog.gui.DBParserUploadDialog.select-file"));
        this.lblFileLocal.setText(i18n.get("module.dialog.gui.DBParserUploadDialog.select-file"));
        this.butFileServer.setText(i18n.get("common.choose"));
        this.butFileLocal.setText(i18n.get("common.choose"));
        this.butCancel.setText(i18n.get("common.cancel"));
        this.butSave.setText(i18n.get("common.save"));
    }

    @Override
    public final void setDialog(WebGisDialog _dlg, Map<String, ?> _mapInfo) throws SystemException {
        super.setDialog(_dlg, _mapInfo, KEY_DIR);
        LinkedHashMap<String, Integer> storageTypeBtns = new LinkedHashMap<String, Integer>();
        storageTypeBtns.put("server", 0);
        storageTypeBtns.put("local", 1);
        storageTypeBtns.put("dms", 2);
        if (_mapInfo.containsKey("refresh")) {
            this.shouldRefresh = (Boolean)_mapInfo.get("refresh");
        }
        this.fileFilter = DBParserUploadDialog.createFileFilter(this.getMapInfo());
        this.fdLocal.setFileFilter(FileFilterWrapper.wrapFileFilter((FileFilter)this.fileFilter));
        this.fdServer.setFileFilter(FileFilterWrapper.wrapFileFilter((FileFilter)this.fileFilter));
        String fileFilterText = this.fileFilter != null ? "<br><small>" + this.fileFilter.getDescription() + "</small>" : "";
        this.lblDnDServer.setText("<html>" + i18n.get("common.drop-file") + fileFilterText + "</html>");
        this.lblDnDLocal.setText("<html>" + i18n.get("common.drop-file") + fileFilterText + "</html>");
        List<String> receivedStorageTypes = (List<String>)this.getMapInfo().get("storageTypes");
        List<String> allowedTypes = receivedStorageTypes != null ? receivedStorageTypes : Arrays.asList("server");
        String savedStorageType = this.detectTabIndex("server", storageTypeBtns);
        String storageType = this.getMapInfo().get("storageType") != null ? StringUtils.trimToEmpty((String)((String)this.getMapInfo().get("storageType"))) : savedStorageType;
        int selected = -1;
        for (Map.Entry currBtnEntry : storageTypeBtns.entrySet()) {
            Integer tabIndex = (Integer)currBtnEntry.getValue();
            this.tabStorageType.setEnabledAt(tabIndex, allowedTypes.contains(currBtnEntry.getKey()));
            if (!this.tabStorageType.isEnabledAt(tabIndex)) continue;
            if (selected < 0) {
                selected = tabIndex;
                continue;
            }
            if (!this.tabStorageType.isEnabledAt((Integer)currBtnEntry.getValue()) || !StringUtils.equalsIgnoreCase((String)storageType, (String)((String)currBtnEntry.getKey()))) continue;
            selected = (Integer)currBtnEntry.getValue();
        }
        this.tabStorageType.setSelectedIndex(selected);
        String fieldName = StringUtils.trimToEmpty((String)ObjectUtils.toString(this.getMapInfo().get("name")));
        if (fieldName.endsWith(":")) {
            fieldName = fieldName.substring(0, fieldName.length() - 1);
        }
        StringBuilder infoText = new StringBuilder();
        infoText.append("<html><ul><li>Datenfeld - <b>").append(fieldName).append("</b></li>");
        if (this.getMapInfo().containsKey("dir_list")) {
            this.lblDirServer.setVisible(true);
            this.cmbDirServer.setVisible(true);
            boolean bolListEmpty = (Boolean)this.getMapInfo().get("dir_list_empty");
            this.cmbDirServer.removeAllItems();
            if (bolListEmpty) {
                this.cmbDirServer.addItem("");
            }
            for (Object currDir : (List)this.getMapInfo().get("dir_list")) {
                this.cmbDirServer.addItem(currDir.toString());
            }
            if (this.cmbDirServer.getItemCount() == 0) {
                throw new SystemException(this.getClass(), i18n.get("module.dialog.gui.DBParserUploadDialog.no-valid-directories"));
            }
        } else {
            this.cmbDirServer.removeAllItems();
            this.lblDirServer.setVisible(false);
            this.cmbDirServer.setVisible(false);
        }
        this.txtFileServer.setText("");
        this.txtFileLocal.setText("");
        boolean bolExists = (Boolean)this.getMapInfo().get("existing_file");
        String strFileOnServer = ObjectUtils.toString(this.getMapInfo().get("filename"));
        if (StringUtils.startsWith((String)strFileOnServer, (String)"file://")) {
            this.txtFileLocal.setText(StringUtils.removeStart((String)strFileOnServer, (String)"file://"));
        }
        if (bolExists) {
            this.setTitle(i18n.get("module.dialog.gui.DBParserUploadDialog.title-replace"));
            if (strFileOnServer.startsWith("dms")) {
                DMSDocument d = DMSDocument.parseURI((String)strFileOnServer);
                this.setDmsLinkText(strFileOnServer);
            } else {
                strFileName = FilenameUtils.getBaseName((String)strFileOnServer);
                String strFilePath = FileSupport.getPathOfFile((String)strFileOnServer);
                infoText.append("<li>").append(i18n.fmt("module.dialog.gui.DBParserUploadDialog.file-on-server", new Object[]{strFileOnServer})).append("</li>");
                if (this.getMapInfo().containsKey("dir_list")) {
                    this.cmbDirServer.setSelectedItem(strFilePath);
                }
                this.txtFilenameServer.setText(strFileName);
            }
            this.butSave.setText(i18n.get("common.replace"));
            this.dmsDocumentTemplateLabel = "module.dialog.gui.DBParserUploadDialog.dms-uri-generated-on-replace";
        } else {
            this.setTitle(i18n.get("module.dialog.gui.DBParserUploadDialog.title"));
            this.butSave.setText(i18n.get("common.save"));
            this.dmsDocumentTemplateLabel = "module.dialog.gui.DBParserUploadDialog.dms-uri-generated-on-save";
            infoText.append("<li>").append(i18n.get("module.dialog.gui.DBParserUploadDialog.no-file-on-server")).append("</li>");
            if (this.getMapInfo().containsKey("dir_list")) {
                this.cmbDirServer.setSelectedIndex(0);
            }
            strFileName = ObjectUtils.toString(this.getMapInfo().get("filename"));
            this.txtFilenameServer.setText(strFileName);
            this.setDmsLinkText("");
        }
        infoText.append("<li>").append(i18n.fmt("module.dialog.gui.DBParserUploadDialog.max-filesize", new Object[]{this.getMapInfo().get("max_file_size")})).append("</li>");
        infoText.append("</ul></html>");
        this.lblInfo.setToolTipText(infoText.toString());
    }

    private void handleFiles(WaitDialog dlgWait, String uploadFileName) {
        try {
            Long lastModified;
            File uploadFile;
            Object strServerFileName = this.txtFilenameServer.getText();
            if (((String)strServerFileName).isEmpty()) {
                strServerFileName = FilenameUtils.getName((String)uploadFileName);
            } else {
                String fileExt = FilenameUtils.getExtension((String)uploadFileName);
                if (!FilenameUtils.getExtension((String)strServerFileName).equalsIgnoreCase(fileExt) && StringUtils.isNotBlank((String)fileExt)) {
                    strServerFileName = (String)strServerFileName + "." + fileExt;
                }
            }
            String strServerDirName = "";
            if (this.cmbDirServer.isVisible()) {
                strServerDirName = this.cmbDirServer.getSelectedItem().toString();
            }
            if (!uploadFileName.toLowerCase().startsWith("http")) {
                uploadFile = new File(uploadFileName);
                lastModified = DBParserUploadDialog.detectLastModified(uploadFile);
            } else {
                uploadFile = null;
                lastModified = null;
            }
            if (this.tabStorageType.getSelectedIndex() == 1) {
                this.executeUpload(uploadFileName, FieldFileStorageType.UT_LOCAL, strServerDirName, null, lastModified);
            }
            if (this.tabStorageType.getSelectedIndex() == 0) {
                this.executeUpload((String)strServerFileName, FieldFileStorageType.UT_SERVER, strServerDirName, uploadFile, lastModified);
            }
        }
        catch (Exception e) {
            dlgWait.setError(e);
        }
    }

    private void initComponents() {
        this.tabStorageType = new JTabbedPane();
        this.pnlFileServer = new JPanel();
        this.pnlDropServer = new JPanel();
        this.lblDnDServer = new JLabel();
        this.lblInfo = new JLabel();
        this.pnlSelectFileServer = new JPanel();
        this.lblFileServer = new JLabel();
        this.txtFileServer = new JTextField();
        this.butFileServer = new JButton();
        this.pnlConfigServer = new JPanel();
        this.lblDirServer = new JLabel();
        this.cmbDirServer = new JComboBox();
        this.lblFilenameServer = new JLabel();
        this.txtFilenameServer = new JTextField();
        this.pnlFileLocal = new JPanel();
        this.pnlDropLocal = new JPanel();
        this.lblDnDLocal = new JLabel();
        this.lblInfo2 = new JLabel();
        this.pnlSelectFile1 = new JPanel();
        this.lblFileLocal = new JLabel();
        this.txtFileLocal = new JTextField();
        this.butFileLocal = new JButton();
        this.pnlConfigDMS = new JPanel();
        this.pnlDMSType = new JPanel();
        this.lblDMSType = new JLabel();
        this.txtDMSType = new JLabel();
        this.btnInsertDMS = new JButton();
        this.btnSelectDMS = new JButton();
        this.btnInputDMS = new JButton();
        this.lblDMSID = new JLabel();
        this.txtDMSLink = new JTextField();
        this.pnlButtons = new JPanel();
        this.butCancel = new JButton();
        this.butSave = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(400, 300));
        this.getContentPane().setLayout(new GridBagLayout());
        this.pnlFileServer.setName("cardFileServer");
        this.pnlFileServer.setLayout(new GridBagLayout());
        this.pnlDropServer.setName("");
        this.pnlDropServer.setLayout(new GridBagLayout());
        this.lblDnDServer.setBackground(new Color(255, 255, 204));
        this.lblDnDServer.setFont(this.lblDnDServer.getFont().deriveFont(this.lblDnDServer.getFont().getStyle() | 1, this.lblDnDServer.getFont().getSize() + 2));
        this.lblDnDServer.setForeground(new Color(102, 102, 102));
        this.lblDnDServer.setHorizontalAlignment(0);
        this.lblDnDServer.setText("Drop file here...");
        this.lblDnDServer.setBorder(BorderFactory.createLineBorder(new Color(102, 102, 102), 2));
        this.lblDnDServer.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.lblDnDServer.setOpaque(true);
        this.lblDnDServer.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DBParserUploadDialog.this.lblDnDServerMouseClicked(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlDropServer.add((Component)this.lblDnDServer, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlDropServer.add((Component)this.lblInfo, gridBagConstraints);
        this.pnlSelectFileServer.setMinimumSize(new Dimension(343, 29));
        this.pnlSelectFileServer.setLayout(new GridBagLayout());
        this.lblFileServer.setText("Dateiauswahl:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 9, 3, 3);
        this.pnlSelectFileServer.add((Component)this.lblFileServer, gridBagConstraints);
        this.txtFileServer.setPreferredSize(new Dimension(160, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 8, 3, 3);
        this.pnlSelectFileServer.add((Component)this.txtFileServer, gridBagConstraints);
        this.butFileServer.setText("w\u00e4hlen");
        this.butFileServer.setPreferredSize(new Dimension(80, 23));
        this.butFileServer.addActionListener(this::butFileServer_onActionPerformed);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 9);
        this.pnlSelectFileServer.add((Component)this.butFileServer, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 9, 2, 9);
        this.pnlDropServer.add((Component)this.pnlSelectFileServer, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.pnlFileServer.add((Component)this.pnlDropServer, gridBagConstraints);
        this.pnlConfigServer.setMinimumSize(new Dimension(399, 54));
        this.pnlConfigServer.setLayout(new GridBagLayout());
        this.lblDirServer.setText("Verzeichnis auf dem Server:");
        this.lblDirServer.setMinimumSize(new Dimension(180, 14));
        this.lblDirServer.setPreferredSize(new Dimension(170, 14));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 9, 3, 3);
        this.pnlConfigServer.add((Component)this.lblDirServer, gridBagConstraints);
        this.cmbDirServer.setPreferredSize(new Dimension(200, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 8, 3, 9);
        this.pnlConfigServer.add(this.cmbDirServer, gridBagConstraints);
        this.lblFilenameServer.setText("Dateiname auf dem Server:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 9, 3, 3);
        this.pnlConfigServer.add((Component)this.lblFilenameServer, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 8, 3, 9);
        this.pnlConfigServer.add((Component)this.txtFilenameServer, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.pnlFileServer.add((Component)this.pnlConfigServer, gridBagConstraints);
        this.tabStorageType.addTab("Server", this.pnlFileServer);
        this.pnlFileLocal.setName("cardFileServer");
        this.pnlFileLocal.setLayout(new GridBagLayout());
        this.pnlDropLocal.setName("");
        this.pnlDropLocal.setLayout(new GridBagLayout());
        this.lblDnDLocal.setBackground(new Color(255, 255, 204));
        this.lblDnDLocal.setFont(this.lblDnDLocal.getFont().deriveFont(this.lblDnDLocal.getFont().getStyle() | 1, this.lblDnDLocal.getFont().getSize() + 2));
        this.lblDnDLocal.setForeground(new Color(102, 102, 102));
        this.lblDnDLocal.setHorizontalAlignment(0);
        this.lblDnDLocal.setText("Drop file here...");
        this.lblDnDLocal.setBorder(BorderFactory.createLineBorder(new Color(102, 102, 102), 2));
        this.lblDnDLocal.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.lblDnDLocal.setOpaque(true);
        this.lblDnDLocal.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DBParserUploadDialog.this.lblDnDLocalMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlDropLocal.add((Component)this.lblDnDLocal, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlDropLocal.add((Component)this.lblInfo2, gridBagConstraints);
        this.pnlSelectFile1.setMinimumSize(new Dimension(343, 29));
        this.pnlSelectFile1.setLayout(new GridBagLayout());
        this.lblFileLocal.setText("Dateiauswahl:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 9, 3, 3);
        this.pnlSelectFile1.add((Component)this.lblFileLocal, gridBagConstraints);
        this.txtFileLocal.setPreferredSize(new Dimension(160, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 8, 3, 3);
        this.pnlSelectFile1.add((Component)this.txtFileLocal, gridBagConstraints);
        this.butFileLocal.setText("w\u00e4hlen");
        this.butFileLocal.setPreferredSize(new Dimension(80, 23));
        this.butFileLocal.addActionListener(this::butFileLocal_onActionPerformed);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 9);
        this.pnlSelectFile1.add((Component)this.butFileLocal, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 9, 2, 9);
        this.pnlDropLocal.add((Component)this.pnlSelectFile1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.pnlFileLocal.add((Component)this.pnlDropLocal, gridBagConstraints);
        this.tabStorageType.addTab("Lokal", this.pnlFileLocal);
        this.pnlConfigDMS.setName("cardConfigDMS");
        this.pnlConfigDMS.setLayout(new GridBagLayout());
        this.pnlDMSType.setLayout(new GridBagLayout());
        this.lblDMSType.setText("DMS:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlDMSType.add((Component)this.lblDMSType, gridBagConstraints);
        this.txtDMSType.setText("unbekannt");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlDMSType.add((Component)this.txtDMSType, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 22;
        this.pnlConfigDMS.add((Component)this.pnlDMSType, gridBagConstraints);
        this.btnInsertDMS.setText("Dokument an DMS anbinden...");
        this.btnInsertDMS.addActionListener(this::btnInsertDMSActionPerformed);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 19;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.pnlConfigDMS.add((Component)this.btnInsertDMS, gridBagConstraints);
        this.btnSelectDMS.setText("Dokument in DMS w\u00e4hlen...");
        this.btnSelectDMS.addActionListener(this::btnSelectDMSActionPerformed);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 19;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.pnlConfigDMS.add((Component)this.btnSelectDMS, gridBagConstraints);
        this.btnInputDMS.setText("Dokumentdaten eingeben...");
        this.btnInputDMS.addActionListener(this::btnInputDMSActionPerformed);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 19;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.pnlConfigDMS.add((Component)this.btnInputDMS, gridBagConstraints);
        this.lblDMSID.setLabelFor(this.txtDMSLink);
        this.lblDMSID.setText("DMS-Link:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 22;
        gridBagConstraints.insets = new Insets(3, 9, 3, 3);
        this.pnlConfigDMS.add((Component)this.lblDMSID, gridBagConstraints);
        this.txtDMSLink.setEditable(false);
        this.txtDMSLink.setAutoscrolls(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 9, 8, 9);
        this.pnlConfigDMS.add((Component)this.txtDMSLink, gridBagConstraints);
        this.tabStorageType.addTab("DMS", this.pnlConfigDMS);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.tabStorageType, gridBagConstraints);
        this.pnlButtons.setMinimumSize(new Dimension(215, 33));
        this.butCancel.setText("abbrechen");
        this.butCancel.setPreferredSize(new Dimension(100, 23));
        this.butCancel.addActionListener(this::butCancel_onActionPerformed);
        this.pnlButtons.add(this.butCancel);
        this.butSave.setText("speichern");
        this.butSave.setPreferredSize(new Dimension(100, 23));
        this.butSave.addActionListener(this::butSave_onActionPerformed);
        this.pnlButtons.add(this.butSave);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.pnlButtons, gridBagConstraints);
        this.getAccessibleContext().setAccessibleName("File Upload");
        this.pack();
    }

    private void butSave_onActionPerformed(ActionEvent evt) {
        this.storeTabIndex(this.tabStorageType.getSelectedIndex());
        if (this.tabStorageType.getSelectedIndex() == 0 || this.tabStorageType.getSelectedIndex() == 1) {
            this.saveFileToServer();
        } else if (this.tabStorageType.getSelectedIndex() == 2) {
            this.saveFileToDMS();
        }
    }

    private void saveFileToServer() {
        String strFile;
        String string = strFile = this.tabStorageType.getSelectedIndex() == 0 ? this.txtFileServer.getText() : this.txtFileLocal.getText();
        if (StringUtils.isBlank((String)strFile)) {
            this.showPleaseSelectFilePopup();
        } else {
            if (!DBParserUploadDialog.isExternalLink(strFile)) {
                File uploadFile = new File(strFile);
                if (!uploadFile.exists()) {
                    GUISupport.msgbox((Component)this, (String)i18n.get("module.dialog.gui.DBParserUploadDialog.file-not-exist"), (String)i18n.get("common.error"));
                    return;
                }
                if (this.tabStorageType.getSelectedIndex() == 0) {
                    Number fileSizeAllowedMB = (Number)ObjectUtils.defaultIfNull(this.getMapInfo().get("max_file_size"), (Object)-1L);
                    long fileSizeAllowed = fileSizeAllowedMB.longValue() > 0L ? fileSizeAllowedMB.longValue() * 0x100000L : -1L;
                    long fileSize = FileUtils.sizeOf((File)uploadFile);
                    if (fileSizeAllowed > 0L && fileSize > fileSizeAllowed) {
                        GUISupport.msgbox((Component)this, (String)i18n.fmt("module.dialog.gui.DBParserUploadDialog.file-too-large", new Object[]{fileSizeAllowedMB}), (String)i18n.get("common.error"));
                        return;
                    }
                }
            }
            this.executeServerFileHandling(strFile);
        }
    }

    private void executeServerFileHandling(String strFile) {
        try {
            WaitDialog dlgWait = WaitDialog.createWaitDialog((Window)this, (String)i18n.get("module.dialog.gui.DBParserUploadDialog.wait-upload"));
            Runnable work = () -> this.handleFiles(dlgWait, strFile);
            dlgWait.addWorkToDo(work);
            dlgWait.setCancelable(false);
            dlgWait.setVisible(true);
            if (dlgWait.getError() != null) {
                Exception e = dlgWait.getError();
                if (e.getMessage().equals("already handled")) {
                    return;
                }
                throw dlgWait.getError();
            }
            this.setVisible(false);
            if (this.shouldRefresh) {
                this.getDlg().refresh();
            }
        }
        catch (Exception e) {
            ExceptionDialog.handleGuiException((Component)this, (Throwable)e, (String)"webgiscli");
        }
    }

    private void saveFileToDMS() {
        try {
            if (StringUtils.isBlank((String)this.txtDMSLink.getText()) && this.deferredSaveAction == null) {
                this.showPleaseSelectFilePopup();
                return;
            }
            WaitDialog dlgWait = WaitDialog.createWaitDialog((Window)this, (String)i18n.get("module.dialog.gui.DBParserUploadDialog.wait-upload"));
            Runnable work = () -> {
                try {
                    if (this.deferredSaveAction != null) {
                        DMSDocument document = Objects.requireNonNull(this.deferredSaveAction.get(), "DMS did not supply Resource Identifier");
                        this.setDMSID(document);
                    }
                    this.executeUpload(this.txtDMSLink.getText(), FieldFileStorageType.UT_DMS, null, null, null);
                }
                catch (Exception ex) {
                    dlgWait.setError(ex);
                }
            };
            dlgWait.addWorkToDo(work);
            dlgWait.setCancelable(false);
            dlgWait.setVisible(true);
            if (dlgWait.getError() != null) {
                Exception e = dlgWait.getError();
                if (e.getMessage().equals("already handled")) {
                    return;
                }
                throw dlgWait.getError();
            }
            this.setVisible(false);
            this.getDlg().refresh();
            this.dispose();
        }
        catch (Exception e) {
            ExceptionDialog.handleGuiException((Component)this, (Throwable)e, (String)"webgiscli");
        }
    }

    public void showPleaseSelectFilePopup() {
        GUISupport.msgbox((Component)this, (String)i18n.get("module.dialog.gui.DBParserUploadDialog.no-select-file"), (String)i18n.get("common.error"));
    }

    private void butFileLocal_onActionPerformed(ActionEvent evt) {
        File newFile = DBParserUploadDialog.selectFile(this, this.getLastDir(), this.fileFilter);
        this.setLastDir(newFile);
        if (newFile != null) {
            this.selectFileLocal(newFile);
        }
    }

    private void lblDnDLocalMouseClicked(MouseEvent evt) {
        this.butFileLocal.doClick();
    }

    private void butFileServer_onActionPerformed(ActionEvent evt) {
        File newFile = DBParserUploadDialog.selectFile(this, this.getLastDir(), this.fileFilter);
        this.setLastDir(newFile);
        if (newFile != null) {
            this.selectFileServer(newFile);
        }
    }

    private void lblDnDServerMouseClicked(MouseEvent evt) {
        this.butFileServer_onActionPerformed(null);
    }

    private void butCancel_onActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.storeTabIndex(this.tabStorageType.getSelectedIndex());
        this.dispose();
    }

    private void selectFileServer(File file2select) {
        this.txtFileServer.setText(file2select.toString());
    }

    private void selectFileLocal(File file2select) {
        this.txtFileLocal.setText(file2select.toString());
    }

    private void btnSelectDMSActionPerformed(ActionEvent evt) {
        this.fireDMSEvent(DMSEventType.SELECT);
    }

    private void btnInsertDMSActionPerformed(ActionEvent evt) {
        this.fireDMSEvent(DMSEventType.INSERT);
    }

    private void btnInputDMSActionPerformed(ActionEvent evt) {
        this.fireDMSEvent(DMSEventType.INPUT);
    }

    public void setDMSID(DMSDocument dmsDocument) {
        String buildURI = dmsDocument.buildURI();
        this.setDmsLinkText(buildURI);
    }

    public void setDmsTemporaryDocumentLabel(File localFile) {
        this.setDmsLinkText(i18n.fmt(this.dmsDocumentTemplateLabel, new Object[]{localFile.getAbsolutePath()}));
    }

    public void setDMSSystem(DMSInterface dmsInterface) {
        if (dmsInterface != null) {
            DMSCapabilities capabilities = dmsInterface.getCapabilities();
            this.btnInsertDMS.setEnabled(capabilities.isInsertAllowed());
            this.btnSelectDMS.setEnabled(capabilities.isAttachAllowed());
            this.btnInputDMS.setEnabled(capabilities.isInputAllowed());
            this.txtDMSType.setText(dmsInterface.getDMSInterface().getDMSID());
            String originKey = dmsInterface.computeOriginKey(this.getDlg().getModuleKey(), this.getDlg().getKey(), (Integer)this.getMapInfo().get("key"));
            if (StringUtils.isNotBlank((String)originKey)) {
                this.pnlConfigDMS.setToolTipText(i18n.fmt("module.dialog.gui.DBParserUploadDialog.tooltip-origin-key", new Object[]{originKey}));
            }
        } else {
            this.btnInsertDMS.setEnabled(false);
            this.btnSelectDMS.setEnabled(false);
            this.btnInputDMS.setEnabled(false);
            this.txtDMSType.setText("---");
            this.pnlConfigDMS.setToolTipText(null);
        }
    }

    public void setDeferredSaveAction(ThrowingSupplier<DMSDocument, Exception> deferredSaveAction) {
        this.deferredSaveAction = deferredSaveAction;
    }

    private void setDmsLinkText(String buildURI) {
        this.txtDMSLink.setText(buildURI);
        this.txtDMSLink.setCaretPosition(0);
    }

    public static boolean isExternalLink(String link) {
        return link.startsWith("http") || link.startsWith("riwa-client://");
    }
}

