/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.webgiscli.module.dialog.gui;

import de.riwagis.icons.IconLoader;
import de.riwagis.service.ServiceMData;
import de.riwagis.service.ServiceRequest;
import de.riwagis.service.registry.ServiceRegistry;
import de.riwagis.util.Config;
import de.riwagis.util.gui.ExceptionDialog;
import de.riwagis.util.gui.FileFilterWrapper;
import de.riwagis.util.gui.components.WaitDialog;
import de.riwagis.util.gui.filedrop.FileDrop;
import de.riwagis.util.i18n.I18N;
import de.riwagis.webgiscli.module.dialog.WebGisDialog;
import de.riwagis.webgiscli.module.dialog.gui.DBParserBaseDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.lang.ObjectUtils;

public class DBParserLinkDialog
extends DBParserBaseDialog {
    private static final String KEY_DIR = DBParserLinkDialog.class.getName() + "_Dir";
    private static final I18N i18n = new I18N(Config.LOCALE, "de.riwagis.webgiscli.i18n.i18n");
    private transient FileFilter fileFilter;
    private FileDrop fdLocal;
    private JButton butCancel;
    private JButton butFile;
    private JButton butSave;
    private JSeparator jSeparator1;
    private JLabel lblDnD;
    private JLabel lblFile;
    private JLabel lblInfo;
    private JPanel pnlButtons;
    private JPanel pnlDrop;
    private JPanel pnlFileSelect;
    private JTextField txtFile;

    public DBParserLinkDialog(Window parent) {
        super(parent, Dialog.ModalityType.APPLICATION_MODAL);
        super.setPreferredSize(new Dimension(460, 180));
        this.pack();
        this.initComponents();
        this.i18n();
        this.init();
    }

    private void init() {
        this.lblInfo.setIcon(IconLoader.svgIcon((String)"common_info.svg"));
        this.fdLocal = new FileDrop((Component)this, fileDropEvent -> {
            File droppedFile = null;
            for (File file2test : fileDropEvent.getFiles()) {
                if (this.fileFilter != null) {
                    if (!this.fileFilter.accept(file2test)) continue;
                    droppedFile = file2test;
                    break;
                }
                droppedFile = file2test;
                break;
            }
            if (droppedFile != null) {
                this.selectFile(droppedFile);
            }
        });
    }

    private void i18n() {
        this.lblDnD.setText(i18n.get("common.drop-file"));
        this.setTitle(i18n.get("module.dialog.gui.DBParserLinkDialog.title"));
        this.lblFile.setText(i18n.get("module.dialog.gui.DBParserLinkDialog.select-file"));
        this.butFile.setText(i18n.get("common.choose"));
        this.butCancel.setText(i18n.get("common.cancel"));
        this.butSave.setText(i18n.get("module.dialog.gui.DBParserLinkDialog.link"));
    }

    @Override
    public final void setDialog(WebGisDialog _dlg, Map<String, ?> _mapInfo) {
        super.setDialog(_dlg, _mapInfo, KEY_DIR);
        this.fileFilter = DBParserLinkDialog.createFileFilter(this.getMapInfo());
        this.fdLocal.setFileFilter(FileFilterWrapper.wrapFileFilter((FileFilter)this.fileFilter));
        boolean bolExists = (Boolean)this.getMapInfo().get("existing_link");
        String fieldName = this.getMapInfo().get("name").toString().trim();
        if (fieldName.endsWith(":")) {
            fieldName = fieldName.substring(0, fieldName.length() - 1);
        }
        StringBuilder infoText = new StringBuilder();
        infoText.append("<html><ul><li>Datenfeld - <b>").append(fieldName).append("</b></li>");
        if (bolExists) {
            String strFileLinked = ObjectUtils.toString(this.getMapInfo().get("filename"));
            this.txtFile.setText(strFileLinked);
        } else {
            this.txtFile.setText("");
        }
        infoText.append("</ul></html>");
        this.lblInfo.setToolTipText(infoText.toString());
    }

    private void handleFiles(WaitDialog dlgWait) {
        try {
            if (this.txtFile.getText().isEmpty()) {
                throw new Exception(i18n.get("module.dialog.gui.DBParserLinkDialog.no-select-file"));
            }
            String strFile = this.txtFile.getText();
            Long lastModified = null;
            if (!strFile.toLowerCase().startsWith("http")) {
                File uploadFile = new File(strFile);
                try {
                    if (uploadFile.exists()) {
                        lastModified = uploadFile.lastModified();
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                strFile = uploadFile.toString();
            }
            ServiceMData dlgFileService = ServiceRegistry.getService((String)"dialog_file", (int)0);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("module_key", this.getDlg().getModuleKey());
            params.put("dialog_key", this.getDlg().getKey());
            params.put("field_key", (Integer)this.getMapInfo().get("key"));
            params.put("filter_id", (String)this.getMapInfo().get("filter_id"));
            params.put("upload_filename", strFile);
            params.put("file_last_modified", lastModified);
            ServiceRequest req = dlgFileService.createRequest("link_file", params);
            this.getWGContext().getServiceProvider().execRequest(req);
        }
        catch (Exception e) {
            dlgWait.setError(e);
        }
    }

    private void initComponents() {
        this.pnlDrop = new JPanel();
        this.lblDnD = new JLabel();
        this.lblInfo = new JLabel();
        this.pnlFileSelect = new JPanel();
        this.lblFile = new JLabel();
        this.txtFile = new JTextField();
        this.butFile = new JButton();
        this.jSeparator1 = new JSeparator();
        this.pnlButtons = new JPanel();
        this.butCancel = new JButton();
        this.butSave = new JButton();
        this.setDefaultCloseOperation(2);
        this.getContentPane().setLayout(new GridBagLayout());
        this.pnlDrop.setLayout(new GridBagLayout());
        this.lblDnD.setBackground(new Color(255, 255, 204));
        this.lblDnD.setFont(this.lblDnD.getFont().deriveFont(this.lblDnD.getFont().getStyle() | 1, this.lblDnD.getFont().getSize() + 2));
        this.lblDnD.setForeground(new Color(102, 102, 102));
        this.lblDnD.setHorizontalAlignment(0);
        this.lblDnD.setText("Drop file here...");
        this.lblDnD.setBorder(BorderFactory.createLineBorder(new Color(102, 102, 102), 2));
        this.lblDnD.setOpaque(true);
        this.lblDnD.setPreferredSize(new Dimension(34, 30));
        this.lblDnD.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DBParserLinkDialog.this.lblDnDMouseClicked(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlDrop.add((Component)this.lblDnD, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlDrop.add((Component)this.lblInfo, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.pnlDrop, gridBagConstraints);
        this.pnlFileSelect.setLayout(new GridBagLayout());
        this.lblFile.setText("Dateiauswahl:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 9, 3, 3);
        this.pnlFileSelect.add((Component)this.lblFile, gridBagConstraints);
        this.txtFile.setPreferredSize(new Dimension(250, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 8, 3, 3);
        this.pnlFileSelect.add((Component)this.txtFile, gridBagConstraints);
        this.butFile.setText("w\u00e4hlen");
        this.butFile.setPreferredSize(new Dimension(80, 23));
        this.butFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DBParserLinkDialog.this.butFile_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 9);
        this.pnlFileSelect.add((Component)this.butFile, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 9, 4, 9);
        this.getContentPane().add((Component)this.pnlFileSelect, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.jSeparator1, gridBagConstraints);
        this.butCancel.setText("abbrechen");
        this.butCancel.setPreferredSize(new Dimension(100, 23));
        this.butCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DBParserLinkDialog.this.butCancel_onActionPerformed(evt);
            }
        });
        this.pnlButtons.add(this.butCancel);
        this.butSave.setText("anbinden");
        this.butSave.setPreferredSize(new Dimension(100, 23));
        this.butSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DBParserLinkDialog.this.butSave_onActionPerformed(evt);
            }
        });
        this.pnlButtons.add(this.butSave);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 9, 9, 9);
        this.getContentPane().add((Component)this.pnlButtons, gridBagConstraints);
        this.getAccessibleContext().setAccessibleName("File Upload");
        this.pack();
    }

    private void butFile_onActionPerformed(ActionEvent evt) {
        File newFile = DBParserLinkDialog.selectFile(this, this.getLastDir(), this.fileFilter);
        if (newFile != null) {
            this.selectFile(newFile);
            this.setLastDir(newFile);
        }
    }

    private void butSave_onActionPerformed(ActionEvent evt) {
        try {
            WaitDialog dlgWait = WaitDialog.createWaitDialog((Window)this, (String)i18n.get("module.dialog.gui.DBParserLinkDialog.wait-upload"), () -> {});
            Runnable work = () -> this.handleFiles(dlgWait);
            dlgWait.addWorkToDo(work);
            dlgWait.setCancelable(false);
            dlgWait.setVisible(true);
            if (dlgWait.getError() != null) {
                throw dlgWait.getError();
            }
            this.setVisible(false);
            this.getDlg().refresh();
            this.dispose();
        }
        catch (Exception e) {
            ExceptionDialog.handleGuiException((Component)this, (Throwable)e, (String)"webgiscli");
        }
    }

    private void selectFile(File file2select) {
        this.txtFile.setText(file2select.toString());
    }

    private void butCancel_onActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void lblDnDMouseClicked(MouseEvent evt) {
        this.butFile_onActionPerformed(null);
    }
}

