/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.webgiscli.module.dialog.gui;

import de.riwagis.dms.DMSCapabilities;
import de.riwagis.dms.DMSDocument;
import de.riwagis.dms.DMSInterface;
import de.riwagis.icons.IconLoader;
import de.riwagis.service.ServiceException;
import de.riwagis.util.Config;
import de.riwagis.util.exception.SystemException;
import de.riwagis.util.gui.ExceptionDialog;
import de.riwagis.util.gui.FileFilterWrapper;
import de.riwagis.util.gui.GUISupport;
import de.riwagis.util.gui.components.FileListTable;
import de.riwagis.util.gui.components.WaitDialog;
import de.riwagis.util.gui.filedrop.FileDrop;
import de.riwagis.util.i18n.I18N;
import de.riwagis.webgiscli.module.dialog.WebGisDialog;
import de.riwagis.webgiscli.module.dialog.gui.DBParserBaseDialog;
import de.riwagis.webgiscli.module.dialog.gui.DMSEventType;
import de.riwagis.webgiscli.module.dialog.gui.FieldFileStorageType;
import de.riwagis.webgiscli.util.ThrowingFunction;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;

public class DBParserInsertUploadDialog
extends DBParserBaseDialog {
    private static final String KEY_DIR = DBParserInsertUploadDialog.class.getName() + "_Dir";
    private static final I18N i18n = new I18N(Config.LOCALE, "de.riwagis.webgiscli.i18n.i18n");
    private transient FileFilter fileFilter;
    private FileDrop fdServer;
    private FileDrop fdLocal;
    private String linkTarget = "";
    private String linkValue = "";
    private ThrowingFunction<File, DMSDocument, Exception> deferredInsertAction;
    private JButton btnInputDMS;
    private JButton btnInsertDMS;
    private JButton btnSelectDMS;
    private JButton butCancel;
    private JButton butFileLocal;
    private JButton butFileServer;
    private JButton butSave;
    private JComboBox<String> cmbDirServer;
    private FileListTable fileList;
    private Box.Filler filler1;
    private JLabel lblDMSType;
    private JLabel lblDirServer;
    private JLabel lblDnDLocal;
    private JLabel lblDnDServer;
    private JLabel lblFileLocal;
    private JLabel lblFileServer;
    private JLabel lblInfo;
    private JLabel lblInfo2;
    private JPanel pnlButtons;
    private JPanel pnlConfigDMS;
    private JPanel pnlDMSType;
    private JPanel pnlFileLocal;
    private JPanel pnlFileSelect;
    private JPanel pnlFileServer;
    private JPanel pnlSelectFile1;
    private JPanel pnlSelectFileServer;
    private JTabbedPane tabStorageType;
    private JLabel txtDMSType;

    public DBParserInsertUploadDialog(Window parent) {
        super(parent, Dialog.ModalityType.APPLICATION_MODAL);
        super.setPreferredSize(new Dimension(460, 400));
        this.pack();
        this.initComponents();
        this.i18n();
        this.init();
    }

    private void init() {
        this.lblInfo.setIcon(IconLoader.svgIcon((String)"common_info.svg"));
        this.fileList.setIcoError(IconLoader.svgIcon((String)"common_attention_small.svg", (int)14));
        this.fileList.setIcoDocument(IconLoader.svgIcon((String)"template_show.svg", (int)14));
        this.fileList.setIcoFolder(IconLoader.svgIcon((String)"file_folder_closed.svg", (int)14));
        this.fileList.setIcoLink(IconLoader.svgIcon((String)"show_link_small.svg", (int)14));
        this.fileList.setIcoRemove(IconLoader.svgIcon((String)"common_delete_small.svg", (int)14));
        this.fdServer = new FileDrop((Component)this.lblDnDServer, fileDropEvent -> {
            for (File file2test : fileDropEvent.getFiles()) {
                if (file2test.isDirectory() || this.fileFilter != null && !this.fileFilter.accept(file2test)) continue;
                this.fileList.addFile(file2test);
            }
        });
        this.fdLocal = new FileDrop((Component)this.lblDnDLocal, fileDropEvent -> {
            for (File file2test : fileDropEvent.getFiles()) {
                if (this.fileFilter != null && !this.fileFilter.accept(file2test)) continue;
                this.fileList.addFile(file2test.getName(), (Object)("file://" + file2test.getPath()));
            }
        });
    }

    private void i18n() {
        this.lblDnDServer.setText(i18n.get("common.drop-file"));
        this.lblDnDLocal.setText(i18n.get("common.drop-file"));
        this.lblDirServer.setText(i18n.get("module.dialog.gui.DBParserInsertUploadDialog.dir-server"));
        this.lblFileServer.setText(i18n.get("module.dialog.gui.DBParserInsertUploadDialog.select-file"));
        this.lblFileLocal.setText(i18n.get("module.dialog.gui.DBParserUploadDialog.select-file"));
        this.butFileServer.setText(i18n.get("common.choose"));
        this.butFileLocal.setText(i18n.get("common.choose"));
        this.butCancel.setText(i18n.get("common.cancel"));
        this.butSave.setText(i18n.get("common.save"));
    }

    public final void setLink(String linkTarget, String linkValue) {
        this.linkTarget = linkTarget;
        this.linkValue = linkValue;
    }

    @Override
    public final void setDialog(WebGisDialog _dlg, Map<String, ?> _mapInfo) throws SystemException {
        super.setDialog(_dlg, _mapInfo, KEY_DIR);
        LinkedHashMap<String, Integer> storageTypeBtns = new LinkedHashMap<String, Integer>();
        storageTypeBtns.put("server", 0);
        storageTypeBtns.put("local", 1);
        storageTypeBtns.put("dms", 2);
        this.fileFilter = DBParserInsertUploadDialog.createFileFilter(this.getMapInfo());
        this.fdLocal.setFileFilter(FileFilterWrapper.wrapFileFilter((FileFilter)this.fileFilter));
        this.fdServer.setFileFilter(FileFilterWrapper.wrapFileFilter((FileFilter)this.fileFilter));
        String fileFilterText = this.fileFilter != null ? "<br><small>" + this.fileFilter.getDescription() + "</small>" : "";
        this.lblDnDServer.setText("<html>" + i18n.get("common.drop-file") + fileFilterText + "</html>");
        this.lblDnDLocal.setText("<html>" + i18n.get("common.drop-file") + fileFilterText + "</html>");
        List<String> allowedTypes = this.getMapInfo().get("storageTypes") != null ? (List<String>)this.getMapInfo().get("storageTypes") : Arrays.asList("server");
        String savedStorageType = this.detectTabIndex("server", storageTypeBtns);
        String storageType = this.getMapInfo().get("storageType") != null ? StringUtils.trimToEmpty((String)((String)this.getMapInfo().get("storageType"))) : savedStorageType;
        int selected = -1;
        for (Map.Entry currBtnEntry : storageTypeBtns.entrySet()) {
            Integer tabIndex = (Integer)currBtnEntry.getValue();
            this.tabStorageType.setEnabledAt(tabIndex, allowedTypes.contains(currBtnEntry.getKey()));
            if (!this.tabStorageType.isEnabledAt(tabIndex)) continue;
            if (selected < 0) {
                selected = tabIndex;
                continue;
            }
            if (!this.tabStorageType.isEnabledAt((Integer)currBtnEntry.getValue()) || !StringUtils.equalsIgnoreCase((String)storageType, (String)((String)currBtnEntry.getKey()))) continue;
            selected = (Integer)currBtnEntry.getValue();
        }
        this.tabStorageType.setSelectedIndex(selected);
        String fieldName = StringUtils.trimToEmpty((String)ObjectUtils.toString(this.getMapInfo().get("name")));
        if (fieldName.endsWith(":")) {
            fieldName = fieldName.substring(0, fieldName.length() - 1);
        }
        StringBuilder infoText = new StringBuilder();
        infoText.append("<html><ul><li>Datenfeld - <b>").append(fieldName).append("</b></li>");
        if (this.getMapInfo().containsKey("dir_list")) {
            this.lblDirServer.setVisible(true);
            this.cmbDirServer.setVisible(true);
            boolean bolListEmpty = (Boolean)this.getMapInfo().get("dir_list_empty");
            this.cmbDirServer.removeAllItems();
            if (bolListEmpty) {
                this.cmbDirServer.addItem("");
            }
            for (Object currDir : (List)this.getMapInfo().get("dir_list")) {
                this.cmbDirServer.addItem(currDir.toString());
            }
            if (this.cmbDirServer.getItemCount() == 0) {
                throw new SystemException(this.getClass(), i18n.get("module.dialog.gui.DBParserInsertUploadDialog.no-valid-directories"));
            }
        } else {
            this.cmbDirServer.removeAllItems();
            this.lblDirServer.setVisible(false);
            this.cmbDirServer.setVisible(false);
        }
        this.fileList.removeAllFiles();
        this.setTitle(i18n.get("module.dialog.gui.DBParserInsertUploadDialog.title"));
        this.butSave.setText(i18n.get("common.save"));
        if (this.getMapInfo().containsKey("dir_list")) {
            this.cmbDirServer.setSelectedIndex(0);
        }
        infoText.append("<li>").append(i18n.fmt("module.dialog.gui.DBParserUploadDialog.max-filesize", new Object[]{this.getMapInfo().get("max_file_size")})).append("</li>");
        infoText.append("</ul></html>");
        this.lblInfo.setToolTipText(infoText.toString());
    }

    private void handleFiles(WaitDialog dlgWait) {
        try {
            Collection selectedFiles = this.fileList.getAllFiles();
            if (selectedFiles.isEmpty()) {
                GUISupport.msgbox((Component)this, (String)i18n.get("module.dialog.gui.DBParserInsertUploadDialog.no-select-file"), (String)i18n.get("common.error"));
                dlgWait.setError(new Exception("already handled"));
                return;
            }
            int counter = 1;
            for (FileListTable.FileContent uploadItem : selectedFiles) {
                block21: {
                    int finalCounter = counter;
                    SwingUtilities.invokeLater(() -> dlgWait.setMessage(i18n.fmt("module.dialog.gui.DBParserInsertUploadDialog.wait-upload", new Object[]{finalCounter, selectedFiles.size()})));
                    if (uploadItem.getFullContent() instanceof File) {
                        File currentFile = (File)uploadItem.getFullContent();
                        if (!currentFile.exists()) {
                            uploadItem.setErrorMessage(i18n.fmt("module.dialog.gui.DBParserUploadDialog.file-not-exist", new Object[]{currentFile.toString()}));
                            continue;
                        }
                        Number fileSizeAllowedMB = (Number)this.getMapInfo().get("max_file_size");
                        if (fileSizeAllowedMB != null) {
                            long fileSizeAllowed = fileSizeAllowedMB.longValue() * 1024L * 1024L;
                            long fileSize = FileUtils.sizeOf((File)currentFile);
                            if (fileSize > fileSizeAllowed) {
                                uploadItem.setErrorMessage(i18n.fmt("module.dialog.gui.DBParserInsertUploadDialog.file-too-large", new Object[]{currentFile.getName(), fileSizeAllowedMB}));
                                continue;
                            }
                        }
                        String strServerDirName = "";
                        if (this.cmbDirServer.isVisible()) {
                            strServerDirName = this.cmbDirServer.getSelectedItem().toString();
                        }
                        try {
                            boolean uploadOk = this.executeInsertUpload(currentFile.getName(), FieldFileStorageType.UT_SERVER, strServerDirName, currentFile, DBParserBaseDialog.detectLastModified(currentFile), this.linkTarget, this.linkValue);
                            if (uploadOk) {
                                this.fileList.removeFile(uploadItem);
                                break block21;
                            }
                            uploadItem.setErrorMessage(i18n.fmt("module.dialog.gui.DBParserInsertUploadDialog.error-uploading-file", new Object[]{i18n.get("module.dialog.gui.DBParserInsertUploadDialog.server-false")}));
                        }
                        catch (Exception e) {
                            uploadItem.setErrorMessage(i18n.fmt("module.dialog.gui.DBParserInsertUploadDialog.error-uploading-file", new Object[]{e.getMessage()}));
                        }
                    } else if (uploadItem.getFullContent() instanceof String) {
                        String currUploadStr = (String)uploadItem.getFullContent();
                        this.uploadLocalOrDms(currUploadStr, uploadItem);
                    } else if (uploadItem.getFullContent() instanceof DMSUpload) {
                        try {
                            DMSUpload deferredUpload = (DMSUpload)uploadItem.getFullContent();
                            DMSDocument dmsDoc = this.deferredInsertAction.apply(deferredUpload.getFile());
                            this.uploadLocalOrDms(dmsDoc.buildURI(), uploadItem);
                        }
                        catch (Exception e) {
                            uploadItem.setErrorMessage(i18n.fmt("module.dialog.gui.DBParserInsertUploadDialog.error-uploading-file", new Object[]{e.getMessage()}));
                        }
                    }
                }
                ++counter;
            }
            this.fileList.repaint();
            if (this.getMapInfo().containsKey("refresh")) {
                boolean refresh = (Boolean)this.getMapInfo().get("refresh");
                if (refresh) {
                    this.getDlg().refresh();
                }
            } else {
                this.getDlg().refresh();
            }
        }
        catch (Exception e) {
            dlgWait.setError(e);
        }
    }

    private void uploadLocalOrDms(String currUploadStr, FileListTable.FileContent uploadItem) throws ServiceException {
        Long modificationTime;
        FieldFileStorageType uploadType = DBParserInsertUploadDialog.detectByProtocol(currUploadStr);
        boolean uploadOk = this.executeInsertUpload(currUploadStr, uploadType, null, null, modificationTime = StringUtils.startsWith((String)currUploadStr, (String)"file:") ? DBParserBaseDialog.detectLastModified(new File(currUploadStr)) : null, this.linkTarget, this.linkValue);
        if (uploadOk) {
            this.fileList.removeFile(uploadItem);
        } else {
            uploadItem.setErrorMessage(i18n.fmt("module.dialog.gui.DBParserInsertUploadDialog.error-uploading-file", new Object[]{i18n.get("module.dialog.gui.DBParserInsertUploadDialog.server-false")}));
        }
    }

    public static FieldFileStorageType detectByProtocol(String currUploadStr) {
        return StringUtils.startsWith((String)currUploadStr, (String)"dms:") ? FieldFileStorageType.UT_DMS : FieldFileStorageType.UT_LOCAL;
    }

    private void initComponents() {
        this.tabStorageType = new JTabbedPane();
        this.pnlFileServer = new JPanel();
        this.lblDnDServer = new JLabel();
        this.lblInfo = new JLabel();
        this.pnlSelectFileServer = new JPanel();
        this.lblDirServer = new JLabel();
        this.cmbDirServer = new JComboBox();
        this.lblFileServer = new JLabel();
        this.butFileServer = new JButton();
        this.pnlFileLocal = new JPanel();
        this.lblDnDLocal = new JLabel();
        this.lblInfo2 = new JLabel();
        this.pnlSelectFile1 = new JPanel();
        this.lblFileLocal = new JLabel();
        this.butFileLocal = new JButton();
        this.pnlConfigDMS = new JPanel();
        this.pnlDMSType = new JPanel();
        this.lblDMSType = new JLabel();
        this.txtDMSType = new JLabel();
        this.btnInsertDMS = new JButton();
        this.btnSelectDMS = new JButton();
        this.btnInputDMS = new JButton();
        this.filler1 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0));
        this.pnlFileSelect = new JPanel();
        this.fileList = new FileListTable();
        this.pnlButtons = new JPanel();
        this.butCancel = new JButton();
        this.butSave = new JButton();
        this.setDefaultCloseOperation(2);
        this.getContentPane().setLayout(new GridBagLayout());
        this.pnlFileServer.setLayout(new GridBagLayout());
        this.lblDnDServer.setBackground(new Color(255, 255, 204));
        this.lblDnDServer.setFont(this.lblDnDServer.getFont().deriveFont(this.lblDnDServer.getFont().getStyle() | 1, this.lblDnDServer.getFont().getSize() + 2));
        this.lblDnDServer.setForeground(new Color(102, 102, 102));
        this.lblDnDServer.setHorizontalAlignment(0);
        this.lblDnDServer.setText("Drop file here...");
        this.lblDnDServer.setBorder(BorderFactory.createLineBorder(new Color(102, 102, 102), 2));
        this.lblDnDServer.setMaximumSize(new Dimension(104, 60));
        this.lblDnDServer.setMinimumSize(new Dimension(104, 60));
        this.lblDnDServer.setOpaque(true);
        this.lblDnDServer.setPreferredSize(new Dimension(34, 60));
        this.lblDnDServer.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DBParserInsertUploadDialog.this.lblDnDServerMouseClicked(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlFileServer.add((Component)this.lblDnDServer, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlFileServer.add((Component)this.lblInfo, gridBagConstraints);
        this.pnlSelectFileServer.setLayout(new GridBagLayout());
        this.lblDirServer.setText("Verzeichnisse auf dem Server:");
        this.lblDirServer.setMinimumSize(new Dimension(180, 14));
        this.lblDirServer.setPreferredSize(new Dimension(170, 14));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 9, 3, 3);
        this.pnlSelectFileServer.add((Component)this.lblDirServer, gridBagConstraints);
        this.cmbDirServer.setPreferredSize(new Dimension(200, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 8, 3, 9);
        this.pnlSelectFileServer.add(this.cmbDirServer, gridBagConstraints);
        this.lblFileServer.setText("Dateiauswahl:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 9, 3, 3);
        this.pnlSelectFileServer.add((Component)this.lblFileServer, gridBagConstraints);
        this.butFileServer.setText("w\u00e4hlen");
        this.butFileServer.setPreferredSize(new Dimension(80, 23));
        this.butFileServer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DBParserInsertUploadDialog.this.butFileServer_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 9);
        this.pnlSelectFileServer.add((Component)this.butFileServer, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.pnlFileServer.add((Component)this.pnlSelectFileServer, gridBagConstraints);
        this.tabStorageType.addTab("Server", this.pnlFileServer);
        this.pnlFileLocal.setName("");
        this.pnlFileLocal.setLayout(new GridBagLayout());
        this.lblDnDLocal.setBackground(new Color(255, 255, 204));
        this.lblDnDLocal.setFont(this.lblDnDLocal.getFont().deriveFont(this.lblDnDLocal.getFont().getStyle() | 1, this.lblDnDLocal.getFont().getSize() + 2));
        this.lblDnDLocal.setForeground(new Color(102, 102, 102));
        this.lblDnDLocal.setHorizontalAlignment(0);
        this.lblDnDLocal.setText("Drop file here...");
        this.lblDnDLocal.setBorder(BorderFactory.createLineBorder(new Color(102, 102, 102), 2));
        this.lblDnDLocal.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.lblDnDLocal.setOpaque(true);
        this.lblDnDLocal.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DBParserInsertUploadDialog.this.lblDnDLocalMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlFileLocal.add((Component)this.lblDnDLocal, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlFileLocal.add((Component)this.lblInfo2, gridBagConstraints);
        this.pnlSelectFile1.setMinimumSize(new Dimension(343, 29));
        this.pnlSelectFile1.setLayout(new GridBagLayout());
        this.lblFileLocal.setText("Dateiauswahl:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 9, 3, 3);
        this.pnlSelectFile1.add((Component)this.lblFileLocal, gridBagConstraints);
        this.butFileLocal.setText("w\u00e4hlen");
        this.butFileLocal.setPreferredSize(new Dimension(80, 23));
        this.butFileLocal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DBParserInsertUploadDialog.this.butFileLocal_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 9);
        this.pnlSelectFile1.add((Component)this.butFileLocal, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 9, 2, 9);
        this.pnlFileLocal.add((Component)this.pnlSelectFile1, gridBagConstraints);
        this.tabStorageType.addTab("Lokal", this.pnlFileLocal);
        this.pnlConfigDMS.setName("cardConfigDMS");
        this.pnlConfigDMS.setLayout(new GridBagLayout());
        this.pnlDMSType.setLayout(new GridBagLayout());
        this.lblDMSType.setText("DMS:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlDMSType.add((Component)this.lblDMSType, gridBagConstraints);
        this.txtDMSType.setText("unbekannt");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlDMSType.add((Component)this.txtDMSType, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlConfigDMS.add((Component)this.pnlDMSType, gridBagConstraints);
        this.btnInsertDMS.setText("Dokument an DMS anbinden...");
        this.btnInsertDMS.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DBParserInsertUploadDialog.this.btnInsertDMSActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 19;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlConfigDMS.add((Component)this.btnInsertDMS, gridBagConstraints);
        this.btnSelectDMS.setText("Dokument in DMS w\u00e4hlen...");
        this.btnSelectDMS.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DBParserInsertUploadDialog.this.btnSelectDMSActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 19;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlConfigDMS.add((Component)this.btnSelectDMS, gridBagConstraints);
        this.btnInputDMS.setText("Dokumentdaten eingeben...");
        this.btnInputDMS.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DBParserInsertUploadDialog.this.btnInputDMSActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 19;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlConfigDMS.add((Component)this.btnInputDMS, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlConfigDMS.add((Component)this.filler1, gridBagConstraints);
        this.tabStorageType.addTab("DMS", this.pnlConfigDMS);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        this.getContentPane().add((Component)this.tabStorageType, gridBagConstraints);
        this.pnlFileSelect.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlFileSelect.add((Component)this.fileList, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 9, 4, 9);
        this.getContentPane().add((Component)this.pnlFileSelect, gridBagConstraints);
        this.butCancel.setText("abbrechen");
        this.butCancel.setPreferredSize(new Dimension(100, 23));
        this.butCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DBParserInsertUploadDialog.this.butCancel_onActionPerformed(evt);
            }
        });
        this.pnlButtons.add(this.butCancel);
        this.butSave.setText("speichern");
        this.butSave.setPreferredSize(new Dimension(100, 23));
        this.butSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DBParserInsertUploadDialog.this.butSave_onActionPerformed(evt);
            }
        });
        this.pnlButtons.add(this.butSave);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 9, 9, 9);
        this.getContentPane().add((Component)this.pnlButtons, gridBagConstraints);
        this.getAccessibleContext().setAccessibleName("File Upload");
        this.pack();
    }

    private void butSave_onActionPerformed(ActionEvent evt) {
        try {
            WaitDialog dlgWait = WaitDialog.createWaitDialog((Window)this, (String)i18n.fmt("module.dialog.gui.DBParserInsertUploadDialog.wait-upload", new Object[]{1, this.fileList.getAllFiles().size()}), () -> {});
            dlgWait.addWorkToDo(() -> this.handleFiles(dlgWait));
            dlgWait.setCancelable(false);
            dlgWait.setVisible(true);
            if (dlgWait.getError() != null) {
                Exception e = dlgWait.getError();
                if (e.getMessage().equals("already handled")) {
                    return;
                }
                throw dlgWait.getError();
            }
            if (!this.fileList.getAllFiles().isEmpty()) {
                GUISupport.msgbox((Component)this, (String)i18n.get("module.dialog.gui.DBParserInsertUploadDialog.errors-occured"), (String)i18n.get("common.error"));
            } else {
                this.setVisible(false);
                if (this.getMapInfo().containsKey("refresh")) {
                    boolean refresh = (Boolean)this.getMapInfo().get("refresh");
                    if (refresh) {
                        this.getDlg().refresh();
                    }
                } else {
                    this.getDlg().refresh();
                }
                this.dispose();
            }
        }
        catch (Exception e) {
            ExceptionDialog.handleGuiException((Component)this, (Throwable)e, (String)"webgiscli");
        }
    }

    private void butCancel_onActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void butFileLocal_onActionPerformed(ActionEvent evt) {
        File[] files2Link;
        for (File currentFile : files2Link = DBParserInsertUploadDialog.selectFile(this, this.getLastDir(), this.fileFilter, true)) {
            this.fileList.addFile(currentFile.getName(), (Object)("file://" + currentFile.getPath()));
        }
        if (files2Link.length > 0) {
            this.setLastDir(files2Link[0]);
        }
    }

    private void lblDnDLocalMouseClicked(MouseEvent evt) {
        this.butFileLocal.doClick();
    }

    private void butFileServer_onActionPerformed(ActionEvent evt) {
        File[] files2Link;
        for (File currentFile : files2Link = DBParserInsertUploadDialog.selectFile(this, this.getLastDir(), this.fileFilter, true)) {
            this.fileList.addFile(currentFile);
        }
        if (files2Link.length > 0) {
            this.setLastDir(files2Link[0]);
        }
    }

    private void lblDnDServerMouseClicked(MouseEvent evt) {
        this.butFileServer_onActionPerformed(null);
    }

    private void btnSelectDMSActionPerformed(ActionEvent evt) {
        this.fireDMSEvent(DMSEventType.SELECT);
    }

    private void btnInsertDMSActionPerformed(ActionEvent evt) {
        this.fireDMSEvent(DMSEventType.INSERT);
    }

    private void btnInputDMSActionPerformed(ActionEvent evt) {
        this.fireDMSEvent(DMSEventType.INPUT);
    }

    public void addLink(DMSDocument document) {
        this.fileList.addFile(document.getDocumentName(), (Object)document.buildURI());
    }

    public void setDMSSystem(DMSInterface dmsInterface) {
        if (dmsInterface != null) {
            DMSCapabilities capabilities = dmsInterface.getCapabilities();
            this.btnInsertDMS.setEnabled(capabilities.isInsertAllowed());
            this.btnSelectDMS.setEnabled(capabilities.isAttachAllowed());
            this.btnInputDMS.setEnabled(capabilities.isInputAllowed());
            this.txtDMSType.setText(dmsInterface.getDMSInterface().getDMSID());
            String originKey = dmsInterface.computeOriginKey(this.getDlg().getModuleKey(), this.getDlg().getKey(), (Integer)this.getMapInfo().get("key"));
            if (StringUtils.isNotBlank((String)originKey)) {
                this.pnlConfigDMS.setToolTipText(i18n.fmt("module.dialog.gui.DBParserInsertUploadDialog.tooltip-origin-key", new Object[]{originKey}));
            }
        } else {
            this.btnInsertDMS.setEnabled(false);
            this.btnSelectDMS.setEnabled(false);
            this.btnInputDMS.setEnabled(false);
            this.txtDMSType.setText("---");
        }
    }

    public void setDeferredInsertAction(ThrowingFunction<File, DMSDocument, Exception> deferredInsertAction) {
        this.deferredInsertAction = deferredInsertAction;
    }

    public void addDeferredLink(File file) {
        this.fileList.addFile(file.getName(), (Object)new DMSUpload(file));
    }

    private static class DMSUpload {
        private final File file;

        public DMSUpload(File file) {
            this.file = file;
        }

        public File getFile() {
            return this.file;
        }

        public int hashCode() {
            int hash = 5;
            hash = 73 * hash + Objects.hashCode(this.file);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DMSUpload other = (DMSUpload)obj;
            return Objects.equals(this.file, other.file);
        }

        public String toString() {
            return i18n.get("module.dialog.gui.DBParserInsertUploadDialog.dms-uri-generated-on-save");
        }
    }
}

