/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.webgiscli.module.dialog.gui;

import de.riwagis.icons.IconLoader;
import de.riwagis.service.ServiceMData;
import de.riwagis.service.ServiceRequest;
import de.riwagis.service.registry.ServiceRegistry;
import de.riwagis.util.Config;
import de.riwagis.util.gui.ExceptionDialog;
import de.riwagis.util.gui.FileFilterWrapper;
import de.riwagis.util.gui.GUISupport;
import de.riwagis.util.gui.components.FileListTable;
import de.riwagis.util.gui.components.WaitDialog;
import de.riwagis.util.gui.filedrop.FileDrop;
import de.riwagis.util.i18n.I18N;
import de.riwagis.webgiscli.module.dialog.WebGisDialog;
import de.riwagis.webgiscli.module.dialog.gui.DBParserBaseDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class DBParserInsertLinkDialog
extends DBParserBaseDialog {
    private static final String KEY_DIR = DBParserInsertLinkDialog.class.getName() + "_Dir";
    private static final I18N i18n = new I18N(Config.LOCALE, "de.riwagis.webgiscli.i18n.i18n");
    private transient FileFilter fileFilter;
    private FileDrop fdLocal;
    private JButton butCancel;
    private JButton butFileLocal;
    private JButton butSave;
    private FileListTable fileList;
    private JLabel lblDnDLocal;
    private JLabel lblFile;
    private JLabel lblInfo;
    private JPanel pnlButtons;
    private JPanel pnlDrop;

    public DBParserInsertLinkDialog(Window parent) {
        super(parent, Dialog.ModalityType.APPLICATION_MODAL);
        super.setPreferredSize(new Dimension(460, 400));
        this.pack();
        this.initComponents();
        this.i18n();
        this.init();
    }

    private void init() {
        this.lblInfo.setIcon(IconLoader.svgIcon((String)"common_info.svg"));
        this.fileList.setIcoError(IconLoader.svgIcon((String)"common_attention_small.svg", (int)14));
        this.fileList.setIcoDocument(IconLoader.svgIcon((String)"template_show.svg", (int)14));
        this.fileList.setIcoFolder(IconLoader.svgIcon((String)"file_folder_closed.svg", (int)14));
        this.fileList.setIcoLink(IconLoader.svgIcon((String)"show_link_small.svg", (int)14));
        this.fileList.setIcoRemove(IconLoader.svgIcon((String)"common_delete_small.svg", (int)14));
        this.fdLocal = new FileDrop((Component)this.lblDnDLocal, fileDropEvent -> {
            for (File file2test : fileDropEvent.getFiles()) {
                if (this.fileFilter != null && !this.fileFilter.accept(file2test)) continue;
                this.fileList.addFile(file2test);
            }
        });
    }

    private void i18n() {
        this.lblDnDLocal.setText(i18n.get("common.drop-file"));
        this.setTitle(i18n.get("module.dialog.gui.DBParserInsertLinkDialog.title"));
        this.lblFile.setText(i18n.get("module.dialog.gui.DBParserInsertLinkDialog.select-file"));
        this.butFileLocal.setText(i18n.get("common.choose"));
        this.butCancel.setText(i18n.get("common.cancel"));
        this.butSave.setText(i18n.get("module.dialog.gui.DBParserInsertLinkDialog.link"));
    }

    @Override
    public final void setDialog(WebGisDialog _dlg, Map<String, ?> _mapInfo) {
        super.setDialog(_dlg, _mapInfo, KEY_DIR);
        this.fileFilter = DBParserInsertLinkDialog.createFileFilter(this.getMapInfo());
        this.fdLocal.setFileFilter(FileFilterWrapper.wrapFileFilter((FileFilter)this.fileFilter));
        StringBuilder infoText = new StringBuilder();
        String fieldName = StringUtils.trimToEmpty((String)ObjectUtils.toString(this.getMapInfo().get("name")));
        if (fieldName.endsWith(":")) {
            fieldName = fieldName.substring(0, fieldName.length() - 1);
        }
        infoText.append("<html>Datenfeld - <b>").append(fieldName).append("</b>");
        infoText.append("</html>");
        this.lblInfo.setToolTipText(infoText.toString());
    }

    private void handleFiles(WaitDialog dlgWait) {
        try {
            Collection selectedFiles = this.fileList.getAllFiles();
            if (selectedFiles.isEmpty()) {
                throw new Exception(i18n.get("module.dialog.gui.DBParserInsertLinkDialog.no-select-file"));
            }
            int counter = 1;
            for (FileListTable.FileContent uploadItem : selectedFiles) {
                if (uploadItem.getFullContent() instanceof File) {
                    File currentFile = (File)uploadItem.getFullContent();
                    int finalCounter = counter;
                    SwingUtilities.invokeLater(() -> dlgWait.setMessage(i18n.fmt("module.dialog.gui.DBParserInsertLinkDialog.wait-link", new Object[]{finalCounter, selectedFiles.size()})));
                    try {
                        String strFile = currentFile.getAbsolutePath();
                        ServiceMData dlgFileService = ServiceRegistry.getService((String)"dialog_file", (int)0);
                        HashMap<String, Object> params = new HashMap<String, Object>();
                        params.put("module_key", this.getDlg().getModuleKey());
                        params.put("dialog_key", this.getDlg().getKey());
                        params.put("field_key", (Integer)this.getMapInfo().get("key"));
                        params.put("upload_filename", strFile);
                        params.put("file_last_modified", DBParserInsertLinkDialog.detectLastModified(currentFile));
                        ServiceRequest req = dlgFileService.createRequest("insert_link_file", params);
                        this.getWGContext().getServiceProvider().execRequest(req);
                        boolean uploadOk = (Boolean)req.getResult();
                        if (uploadOk) {
                            this.fileList.removeFile(uploadItem);
                        } else {
                            uploadItem.setErrorMessage(i18n.fmt("module.dialog.gui.DBParserInsertUploadDialog.error-uploading-file", new Object[]{i18n.get("module.dialog.gui.DBParserInsertUploadDialog.server-false")}));
                        }
                    }
                    catch (Exception e) {
                        uploadItem.setErrorMessage(i18n.fmt("module.dialog.gui.DBParserInsertLinkDialog.error-linking-file", new Object[]{e.getMessage()}));
                    }
                }
                ++counter;
            }
            this.getDlg().refresh();
        }
        catch (Exception e) {
            dlgWait.setError(e);
        }
    }

    private void initComponents() {
        this.pnlDrop = new JPanel();
        this.lblDnDLocal = new JLabel();
        this.lblInfo = new JLabel();
        this.lblFile = new JLabel();
        this.butFileLocal = new JButton();
        this.fileList = new FileListTable();
        this.pnlButtons = new JPanel();
        this.butCancel = new JButton();
        this.butSave = new JButton();
        this.setDefaultCloseOperation(2);
        this.getContentPane().setLayout(new GridBagLayout());
        this.pnlDrop.setLayout(new GridBagLayout());
        this.lblDnDLocal.setBackground(new Color(255, 255, 204));
        this.lblDnDLocal.setFont(this.lblDnDLocal.getFont().deriveFont(this.lblDnDLocal.getFont().getStyle() | 1, this.lblDnDLocal.getFont().getSize() + 2));
        this.lblDnDLocal.setForeground(new Color(102, 102, 102));
        this.lblDnDLocal.setHorizontalAlignment(0);
        this.lblDnDLocal.setText("Drop file here...");
        this.lblDnDLocal.setBorder(BorderFactory.createLineBorder(new Color(102, 102, 102), 2));
        this.lblDnDLocal.setMaximumSize(new Dimension(104, 60));
        this.lblDnDLocal.setMinimumSize(new Dimension(104, 60));
        this.lblDnDLocal.setOpaque(true);
        this.lblDnDLocal.setPreferredSize(new Dimension(34, 60));
        this.lblDnDLocal.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DBParserInsertLinkDialog.this.lblDnDLocalMouseClicked(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlDrop.add((Component)this.lblDnDLocal, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 24;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlDrop.add((Component)this.lblInfo, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.pnlDrop, gridBagConstraints);
        this.lblFile.setText("Dateiauswahl:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 9, 3, 3);
        this.getContentPane().add((Component)this.lblFile, gridBagConstraints);
        this.butFileLocal.setText("w\u00e4hlen");
        this.butFileLocal.setPreferredSize(new Dimension(80, 23));
        this.butFileLocal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DBParserInsertLinkDialog.this.butFileLocal_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 9);
        this.getContentPane().add((Component)this.butFileLocal, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.fileList, gridBagConstraints);
        this.butCancel.setText("abbrechen");
        this.butCancel.setPreferredSize(new Dimension(100, 23));
        this.butCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DBParserInsertLinkDialog.this.butCancel_onActionPerformed(evt);
            }
        });
        this.pnlButtons.add(this.butCancel);
        this.butSave.setText("anbinden");
        this.butSave.setPreferredSize(new Dimension(100, 23));
        this.butSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DBParserInsertLinkDialog.this.butSave_onActionPerformed(evt);
            }
        });
        this.pnlButtons.add(this.butSave);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 9, 9, 9);
        this.getContentPane().add((Component)this.pnlButtons, gridBagConstraints);
        this.getAccessibleContext().setAccessibleName("File Upload");
        this.pack();
    }

    private void butFileLocal_onActionPerformed(ActionEvent evt) {
        File[] files2Link;
        JFileChooser fileChoose = GUISupport.createJFileChooser();
        String[] arrFilter = (String[])this.getMapInfo().get("filefilter");
        if (arrFilter.length == 0) {
            for (FileFilter arrFilt1 : fileChoose.getChoosableFileFilters()) {
                fileChoose.removeChoosableFileFilter(arrFilt1);
            }
            fileChoose.setAcceptAllFileFilterUsed(true);
        } else {
            fileChoose.setAcceptAllFileFilterUsed(false);
            fileChoose.setFileFilter(this.fileFilter);
        }
        fileChoose.setMultiSelectionEnabled(true);
        fileChoose.setCurrentDirectory(this.getLastDir());
        GUISupport.centreOnScreen((Component)fileChoose);
        int intOption = fileChoose.showSaveDialog(this);
        if (intOption == 1) {
            return;
        }
        for (File currentFile : files2Link = fileChoose.getSelectedFiles()) {
            this.fileList.addFile(currentFile);
        }
        if (files2Link.length > 0) {
            this.setLastDir(files2Link[0]);
        }
    }

    private void butSave_onActionPerformed(ActionEvent evt) {
        try {
            WaitDialog dlgWait = WaitDialog.createWaitDialog((Window)this, (String)i18n.fmt("module.dialog.gui.DBParserInsertLinkDialog.wait-link", new Object[]{1, this.fileList.getAllFiles().size()}), (Runnable)new Runnable(this){

                @Override
                public void run() {
                }
            });
            Runnable work = () -> this.handleFiles(dlgWait);
            dlgWait.addWorkToDo(work);
            dlgWait.setCancelable(false);
            dlgWait.setVisible(true);
            if (dlgWait.getError() != null) {
                Exception e = dlgWait.getError();
                if (StringUtils.equals((CharSequence)e.getMessage(), (CharSequence)"already handled")) {
                    return;
                }
                throw dlgWait.getError();
            }
            if (!this.fileList.getAllFiles().isEmpty()) {
                GUISupport.msgbox((Component)this, (String)i18n.get("module.dialog.gui.DBParserInsertUploadDialog.errors-occured"), (String)i18n.get("common.error"));
            } else {
                this.setVisible(false);
                this.getDlg().refresh();
                this.dispose();
            }
        }
        catch (Exception e) {
            ExceptionDialog.handleGuiException((Component)this, (Throwable)e, (String)"webgiscli");
        }
    }

    private void butCancel_onActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void lblDnDLocalMouseClicked(MouseEvent evt) {
        this.butFileLocal_onActionPerformed(null);
    }
}

