/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.webgiscli.module.dialog.gui;

import de.riwagis.service.ServiceException;
import de.riwagis.service.ServiceMData;
import de.riwagis.service.ServiceRequest;
import de.riwagis.service.registry.ServiceRegistry;
import de.riwagis.util.Whiteboard;
import de.riwagis.util.exception.SystemException;
import de.riwagis.util.gui.GUISupport;
import de.riwagis.webgiscli.WebGisContext;
import de.riwagis.webgiscli.module.dialog.WebGisDialog;
import de.riwagis.webgiscli.module.dialog.gui.DMSEventType;
import de.riwagis.webgiscli.module.dialog.gui.FieldFileStorageType;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.HeadlessException;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DBParserBaseDialog
extends JDialog {
    private static final Logger LOG = LoggerFactory.getLogger(DBParserBaseDialog.class);
    private final transient Collection<ActionListener> actionListeners = new ArrayList<ActionListener>();
    private File lastDir = null;
    private WebGisContext wgContext = null;
    private String keyDir;
    private transient Map<String, ?> mapInfo = null;
    private transient WebGisDialog dlg = null;

    public DBParserBaseDialog(Window owner) {
        this(owner, Dialog.ModalityType.APPLICATION_MODAL);
    }

    public DBParserBaseDialog(Window owner, Dialog.ModalityType modalityType) {
        super(owner, modalityType);
    }

    public abstract void setDialog(WebGisDialog var1, Map<String, ?> var2) throws SystemException;

    public void setDialog(WebGisDialog _dlg, Map<String, ?> _mapInfo, String keyDir) {
        this.initWGContext(_dlg.getWgContext(), keyDir);
        this.mapInfo = _mapInfo;
        this.dlg = _dlg;
    }

    public Map<String, ?> getMapInfo() {
        return this.mapInfo;
    }

    public WebGisDialog getDlg() {
        return this.dlg;
    }

    public static File[] selectFile(Component parent, File lastFolder, FileFilter fileFilter, boolean allowMultiple) {
        JFileChooser fileChoose = GUISupport.createJFileChooser();
        if (fileFilter == null) {
            for (FileFilter arrFilt1 : fileChoose.getChoosableFileFilters()) {
                fileChoose.removeChoosableFileFilter(arrFilt1);
            }
            fileChoose.setAcceptAllFileFilterUsed(true);
        } else {
            fileChoose.setAcceptAllFileFilterUsed(false);
            fileChoose.setFileFilter(fileFilter);
        }
        fileChoose.setMultiSelectionEnabled(allowMultiple);
        fileChoose.setCurrentDirectory(lastFolder);
        int intOption = fileChoose.showSaveDialog(parent);
        if (intOption == 0) {
            if (allowMultiple) {
                return fileChoose.getSelectedFiles();
            }
            return new File[]{fileChoose.getSelectedFile()};
        }
        return new File[0];
    }

    public static File selectFile(Component parent, File lastFolder, FileFilter fileFilter) throws HeadlessException {
        File[] selectedFiles = DBParserBaseDialog.selectFile(parent, lastFolder, fileFilter, false);
        return selectedFiles.length == 0 ? null : selectedFiles[0];
    }

    public static FileFilter createFileFilter(Map<String, ?> mapInfo) {
        if (mapInfo != null) {
            String[] arrFilter;
            Object fileFilter = mapInfo.get("filefilter");
            if (fileFilter instanceof ArrayList) {
                ArrayList list = (ArrayList)fileFilter;
                arrFilter = (String[])list.toArray(String[]::new);
            } else {
                arrFilter = (String[])mapInfo.get("filefilter");
            }
            if (arrFilter != null && arrFilter.length > 0) {
                return DBParserBaseDialog.createFileFilter(arrFilter);
            }
        }
        return null;
    }

    public static FileFilter createFileFilter(String[] arrFilter) {
        return GUISupport.createFileFilter((String)"erlaubte Dateien", (String[])arrFilter);
    }

    public static Long detectLastModified(File currentFile) {
        Long lastModified = null;
        try {
            if (currentFile.exists()) {
                lastModified = currentFile.lastModified();
            }
        }
        catch (Throwable t) {
            LOG.debug(String.format("unable to detect lastModified of '%s': %s", currentFile, t.getMessage()), t);
        }
        return lastModified;
    }

    public void addActionListener(ActionListener al) {
        if (al != null) {
            this.actionListeners.add(al);
        }
    }

    public void removeActionListener(ActionListener al) {
        if (al != null) {
            this.actionListeners.remove(al);
        }
    }

    protected final void fireDMSEvent(DMSEventType x) {
        ActionEvent actionEvent = new ActionEvent(this, x.getKey(), x.getCommand());
        this.actionListeners.stream().forEach(currAL -> currAL.actionPerformed(actionEvent));
    }

    public File getLastDir() {
        return this.lastDir;
    }

    public void setLastDir(File newFile) {
        if (newFile != null) {
            this.lastDir = newFile.getParentFile();
            Whiteboard wb = this.wgContext.getPermWhiteboard();
            wb.setAttribute(this.keyDir, (Object)this.lastDir.getAbsolutePath());
            this.wgContext.writePermWhiteboard();
        }
    }

    public void initWGContext(WebGisContext wgcontext, String keyDir) {
        this.keyDir = keyDir;
        this.wgContext = wgcontext;
        Whiteboard wb = this.wgContext.getPermWhiteboard();
        this.lastDir = new File(ObjectUtils.toString((Object)wb.getAttribute(keyDir, (Object)"")));
    }

    public WebGisContext getWGContext() {
        return this.wgContext;
    }

    public boolean executeInsertUpload(String uploadFileName, FieldFileStorageType uploadType, String strServerDirName, File uploadFile, Long lastModified) throws ServiceException {
        return this.executeUpload("insert_upload_file", uploadFileName, uploadType, strServerDirName, uploadFile, lastModified, null);
    }

    public boolean executeInsertUpload(String uploadFileName, FieldFileStorageType uploadType, String strServerDirName, File uploadFile, Long lastModified, String linkTarget, String linkValue) throws ServiceException {
        return this.executeUpload("insert_upload_file", uploadFileName, uploadType, strServerDirName, uploadFile, lastModified, null, linkTarget, linkValue);
    }

    public boolean executeUpload(String uploadFileName, FieldFileStorageType uploadType, String strServerDirName, File uploadFile, Long lastModified) throws ServiceException {
        return this.executeUpload("upload_file", uploadFileName, uploadType, strServerDirName, uploadFile, lastModified, (String)this.mapInfo.get("filter_id"));
    }

    public boolean executeUpload(String uploadMethod, String uploadFileName, FieldFileStorageType uploadType, String strServerDirName, File uploadFile, Long lastModified, String filterId) throws ServiceException {
        return this.executeUpload(uploadMethod, uploadFileName, uploadType, strServerDirName, uploadFile, lastModified, filterId, null, null);
    }

    public boolean executeUpload(String uploadMethod, String uploadFileName, FieldFileStorageType uploadType, String strServerDirName, File uploadFile, Long lastModified, String filterId, String linkTarget, String linkValue) throws ServiceException {
        ServiceMData dlgFileService = ServiceRegistry.getService((String)"dialog_file", (int)0);
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("module_key", this.dlg.getModuleKey());
        params.put("dialog_key", this.dlg.getKey());
        params.put("field_key", (Integer)this.mapInfo.get("key"));
        if (StringUtils.isNotBlank((String)filterId)) {
            params.put("filter_id", filterId);
        }
        if (StringUtils.isNotBlank((String)strServerDirName)) {
            params.put("upload_dirname", strServerDirName);
        }
        params.put("upload_filename", uploadFileName);
        if (uploadFile != null) {
            params.put("upload_file", uploadFile);
        }
        if (lastModified != null) {
            params.put("file_last_modified", lastModified);
        }
        if (linkTarget != null) {
            params.put("link_target", linkTarget);
        }
        if (linkValue != null) {
            params.put("link_value", linkValue);
        }
        params.put("upload_type", uploadType.getIdentificator());
        ServiceRequest req = dlgFileService.createRequest(uploadMethod, params);
        this.getWGContext().getServiceProvider().execRequest(req);
        return (Boolean)req.getResult();
    }

    public String detectTabIndex(String defaultValue, Map<String, Integer> availableTypes) {
        Whiteboard wb = this.wgContext.getPermWhiteboard();
        int x = wb.getAttribute("dbparserdialog.activetabindex", 0);
        for (Map.Entry<String, Integer> currType : availableTypes.entrySet()) {
            if (!currType.getValue().equals(x)) continue;
            return currType.getKey();
        }
        return defaultValue;
    }

    public void storeTabIndex(int tabIndex) {
        Whiteboard wb = this.wgContext.getPermWhiteboard();
        wb.setAttribute("dbparserdialog.activetabindex", tabIndex);
    }
}

