/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.webgiscli.module.dialog;

import java.util.ArrayList;
import java.util.Map;

public class WebGisDialogMap {
    public static final String MODDLGMAP_LAYERS = "moddlgmap_layers";
    public static final String MODDLGMAP_MAINLAYER = "moddlgmap_mainlayer";
    public static final String MODDLGMAP_MINSCALE = "moddlgmap_minscale";
    private final Map<String, Object> mapDlgMap;

    public WebGisDialogMap(Map<String, Object> _mapDlgMap) {
        this.mapDlgMap = _mapDlgMap;
    }

    public double getMinZoomScale() {
        if (this.mapDlgMap.containsKey(MODDLGMAP_MINSCALE)) {
            return (Double)this.mapDlgMap.get(MODDLGMAP_MINSCALE);
        }
        return 500.0;
    }

    public boolean setLayerVisibleOnZooming(String strLayerID) {
        Map mapLayers = (Map)this.mapDlgMap.get(MODDLGMAP_LAYERS);
        if (mapLayers.containsKey(strLayerID)) {
            return (Boolean)mapLayers.get(strLayerID);
        }
        return false;
    }

    public String[] getLinkedLayerIDs() throws Exception {
        Map mapLayers = (Map)this.mapDlgMap.get(MODDLGMAP_LAYERS);
        ArrayList<String> lstLayers = new ArrayList<String>();
        for (String layer : mapLayers.keySet()) {
            lstLayers.add(layer);
        }
        if (this.mapDlgMap.containsKey(MODDLGMAP_MAINLAYER)) {
            String strMainLayer = (String)this.mapDlgMap.get(MODDLGMAP_MAINLAYER);
            lstLayers.remove(strMainLayer);
            lstLayers.add(0, strMainLayer);
        }
        return lstLayers.toArray(new String[0]);
    }

    public boolean hasLayer(String strLayerID) {
        Map mapLayers = (Map)this.mapDlgMap.get(MODDLGMAP_LAYERS);
        return mapLayers.containsKey(strLayerID);
    }
}

