/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.webgiscli.module.dialog;

import de.riwagis.dms.DMSDocument;
import de.riwagis.gis.context.module.DialogContext;
import de.riwagis.service.ServiceException;
import de.riwagis.service.ServiceMData;
import de.riwagis.service.ServiceRequest;
import de.riwagis.service.StreamProcessor;
import de.riwagis.service.registry.ServiceRegistry;
import de.riwagis.service.stream.FileStreamProcessor;
import de.riwagis.service.stream.XmlStreamProcessor;
import de.riwagis.util.exception.SystemException;
import de.riwagis.webgiscli.WebGisContext;
import de.riwagis.webgiscli.module.dialog.DialogTypes;
import de.riwagis.webgiscli.module.dialog.WebGisDialogMap;
import de.riwagis.webgiscli.module.dialog.gui.FieldFileStorageType;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.jdom2.Document;
import org.jdom2.Namespace;
import org.jdom2.filter.ElementFilter;
import org.jdom2.filter.Filter;

public abstract class WebGisDialog
implements DialogContext {
    private int intID;
    private final int intModuleID;
    private Document dlgDoc;
    private String strType;
    private int intType;
    private Map<String, Object> mapDlgInfo;
    protected final WebGisContext wgContext;
    private WebGisDialogMap wgDlgMap;

    WebGisDialog(Map<String, Object> _mapDlgInfo, int _intModuleID, WebGisContext _wgContext) throws SystemException {
        this.intModuleID = _intModuleID;
        this.wgContext = _wgContext;
        this.setMapDlgInfo(_mapDlgInfo);
    }

    protected void resetMapDlgInfo(Map<String, Object> _mapDlgInfo) throws SystemException {
        this.setMapDlgInfo(_mapDlgInfo);
    }

    private void setMapDlgInfo(Map<String, Object> _mapDlgInfo) throws SystemException {
        try {
            this.mapDlgInfo = _mapDlgInfo;
            this.intID = (Integer)this.mapDlgInfo.get("moddlg_key");
            this.strType = this.mapDlgInfo.get("moddlg_type").toString();
            this.intType = DialogTypes.class.getDeclaredField(this.strType).getInt(null);
            if (this.mapDlgInfo.containsKey("moddlg_map")) {
                Map modDlgMapInfo = (Map)this.mapDlgInfo.get("moddlg_map");
                this.wgDlgMap = new WebGisDialogMap(modDlgMapInfo);
            } else {
                this.wgDlgMap = null;
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            throw new SystemException(this.getClass(), (Throwable)e);
        }
    }

    public abstract String getSelectedInFilter() throws Exception;

    public abstract String[] getFilter() throws Exception;

    public abstract void setFilter(Map<String, ?> var1) throws Exception;

    public abstract void addGeometry(String[] var1) throws Exception;

    public abstract void setAction(String var1, Map<String, ?> var2) throws Exception;

    Object getInfo(String param) {
        return this.mapDlgInfo.get(param);
    }

    public String getID() {
        return "" + this.intID;
    }

    public int getKey() {
        return this.intID;
    }

    public String getName() {
        return (String)this.mapDlgInfo.get("moddlg_name");
    }

    public String toString() {
        return this.intID + " : " + this.getName() + " - Module: " + this.intModuleID;
    }

    public String getTitle() throws SystemException {
        try {
            this.getDocument();
            Namespace ns = this.dlgDoc.getRootElement().getNamespace();
            return ObjectUtils.toString((Object)this.dlgDoc.getRootElement().getChildTextTrim("title", ns));
        }
        catch (Exception e) {
            throw new SystemException(this.getClass(), (Throwable)e);
        }
    }

    public boolean hasRelation() {
        return this.mapDlgInfo.containsKey("moddlg_relationinfo");
    }

    public Map<?, ?> getRelationInfo() {
        return (Map)this.mapDlgInfo.get("moddlg_relationinfo");
    }

    public String getModuleID() {
        return "" + this.intModuleID;
    }

    public int getModuleKey() {
        return this.intModuleID;
    }

    public String getType() throws Exception {
        return DialogTypes.getClassname(this.intType);
    }

    public int getTypeKey() throws Exception {
        return this.intType;
    }

    public WebGisDialogMap getDialogMap() {
        return this.wgDlgMap;
    }

    public boolean hasDialogMap() {
        return this.wgDlgMap != null;
    }

    @Deprecated
    private Document getDocument() throws ServiceException {
        if (this.dlgDoc == null) {
            ServiceMData dlgService = ServiceRegistry.getService((String)"dialog", (int)0);
            HashMap<String, Integer> params = new HashMap<String, Integer>();
            params.put("module_key", this.getModuleKey());
            params.put("dialog_key", this.getKey());
            ServiceRequest req = dlgService.createRequest("get_dialog", params);
            req.setStreamProcessor((StreamProcessor)new XmlStreamProcessor());
            this.dlgDoc = (Document)this.wgContext.getServiceProvider().execRequest(req).getResult();
        }
        return this.dlgDoc;
    }

    @Deprecated
    public Iterator<?> getFields() throws SystemException {
        try {
            this.getDocument();
            Namespace ns = this.dlgDoc.getRootElement().getNamespace();
            ElementFilter filt = new ElementFilter("field", ns);
            return this.dlgDoc.getRootElement().getDescendants((Filter)filt);
        }
        catch (Exception e) {
            throw new SystemException(this.getClass(), (Throwable)e);
        }
    }

    public Map<String, ?> getUploadInfo(int intFieldKey, String strFilterID) throws SystemException {
        try {
            ServiceMData dlgFileService = ServiceRegistry.getService((String)"dialog_file", (int)0);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("module_key", this.getModuleKey());
            params.put("dialog_key", this.getKey());
            params.put("field_key", intFieldKey);
            params.put("filter_id", strFilterID);
            ServiceRequest req = dlgFileService.createRequest("get_upload_info", params);
            Map res = (Map)this.wgContext.getServiceProvider().execRequest(req).getResult();
            return res;
        }
        catch (Exception e) {
            throw new SystemException(this.getClass(), (Throwable)e);
        }
    }

    public File downloadFromServer(int intFieldKey, String strFilterID, File destFile) throws SystemException {
        try {
            ServiceMData dlgFileService = ServiceRegistry.getService((String)"dialog_file", (int)0);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("module_key", this.getModuleKey());
            params.put("dialog_key", this.getKey());
            params.put("field_key", intFieldKey);
            params.put("filter_id", strFilterID);
            ServiceRequest req = dlgFileService.createRequest("get_file", params);
            FileStreamProcessor fproc = new FileStreamProcessor(destFile);
            req.setStreamProcessor((StreamProcessor)fproc);
            ServiceRequest svcRequest = this.wgContext.getServiceProvider().execRequest(req);
            File expFile = (File)svcRequest.getResult();
            return expFile != null && expFile.exists() ? expFile : null;
        }
        catch (Exception e) {
            throw new SystemException(this.getClass(), (Throwable)e);
        }
    }

    public Map<String, ?> getLinkInfo(int intFieldKey, String strFilterID) throws SystemException {
        try {
            ServiceMData dlgFileService = ServiceRegistry.getService((String)"dialog_file", (int)0);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("module_key", this.getModuleKey());
            params.put("dialog_key", this.getKey());
            params.put("field_key", intFieldKey);
            params.put("filter_id", strFilterID);
            ServiceRequest req = dlgFileService.createRequest("get_link_info", params);
            Map res = (Map)this.wgContext.getServiceProvider().execRequest(req).getResult();
            return res;
        }
        catch (Exception e) {
            throw new SystemException(this.getClass(), (Throwable)e);
        }
    }

    public String[][] getStringArray(Integer[] arrFields, int intOption) throws ServiceException {
        ServiceMData dlgService = ServiceRegistry.getService((String)"dialog", (int)0);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("module_key", this.getModuleKey());
        params.put("dialog_key", this.getKey());
        StringBuilder sbFields = new StringBuilder();
        for (Integer arrField : arrFields) {
            if (sbFields.length() > 0) {
                sbFields.append(",");
            }
            sbFields.append(arrField);
        }
        params.put("dialog_fields", sbFields.toString());
        params.put("export_option", intOption);
        ServiceRequest req = dlgService.createRequest("get_string_array", params);
        return (String[][])this.wgContext.getServiceProvider().execRequest(req).getResult();
    }

    public boolean fillReportData(int intOption) throws ServiceException {
        ServiceMData dlgService = ServiceRegistry.getService((String)"dialog", (int)0);
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("module_key", this.getModuleKey());
        params.put("dialog_key", this.getKey());
        params.put("export_option", intOption);
        ServiceRequest req = dlgService.createRequest("fill_report_data", params);
        return (Boolean)this.wgContext.getServiceProvider().execRequest(req).getResult();
    }

    public WebGisContext getWgContext() {
        return this.wgContext;
    }

    public static File buildServerExcelFile(WebGisContext wgContext, Integer moduleKey, File expFile) throws SystemException, ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("module_key", moduleKey);
        params.put("export_option", -1);
        return WebGisDialog.buildServerExcelFile(wgContext, params, expFile);
    }

    public static File buildServerExcelFile(WebGisDialog dlg, Integer[] arrFields, int exportOption, File expFile) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("module_key", dlg.getModuleKey());
        params.put("dialog_key", dlg.getKey());
        params.put("dialog_fields", StringUtils.join((Object[])arrFields, (String)","));
        params.put("export_option", exportOption);
        WebGisContext wgContext = dlg.getWgContext();
        return WebGisDialog.buildServerExcelFile(wgContext, params, expFile);
    }

    public static File buildServerExcelFile(WebGisContext wgContext, Map<String, Object> params, File expFile) throws ServiceException {
        ServiceMData dlgService = ServiceRegistry.getService((String)"dialog", (int)0);
        params.put("export_format", FilenameUtils.getExtension((String)expFile.getName()));
        ServiceRequest req = dlgService.createRequest("create_excel_file", params);
        req.setStreamProcessor((StreamProcessor)new FileStreamProcessor(expFile));
        wgContext.getServiceProvider().execRequest(req).getResult();
        return expFile;
    }

    public static String startServerExcelFile(WebGisContext wgContext, Integer moduleKey, Integer dialogKey, Integer[] arrFields, int exportOption, File expFile) throws SystemException, ServiceException {
        ServiceMData dlgService = ServiceRegistry.getService((String)"dialog", (int)0);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("module_key", moduleKey);
        params.put("dialog_key", dialogKey);
        params.put("export_option", exportOption);
        params.put("dialog_fields", StringUtils.join((Object[])arrFields, (String)","));
        params.put("export_format", FilenameUtils.getExtension((String)expFile.getName()));
        ServiceRequest req = dlgService.createRequest("create_excel_stream_start", params);
        Map res = (Map)wgContext.getServiceProvider().execRequest(req).getResult();
        return ObjectUtils.toString(res.get("stream_id"));
    }

    public static int statusServerStream(WebGisContext wgContext, String stream_id) throws SystemException, ServiceException {
        String errorMessage;
        ServiceMData dlgService = ServiceRegistry.getService((String)"dialog", (int)0);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("stream_id", stream_id);
        ServiceRequest req = dlgService.createRequest("stream_status", params);
        Map res = (Map)wgContext.getServiceProvider().execRequest(req).getResult();
        int resInt = (Integer)res.get("percent");
        if (((Boolean)res.get("done")).booleanValue()) {
            resInt = 101;
        }
        if (StringUtils.isNotBlank((String)(errorMessage = ObjectUtils.toString(res.get("errormessage"))))) {
            throw new SystemException(errorMessage);
        }
        return resInt;
    }

    public static File retrieveServerStream(WebGisContext wgContext, String stream_id, File expFile) throws SystemException, ServiceException {
        ServiceMData dlgService = ServiceRegistry.getService((String)"dialog", (int)0);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("stream_id", stream_id);
        ServiceRequest req = dlgService.createRequest("stream_download", params);
        req.setStreamProcessor((StreamProcessor)new FileStreamProcessor(expFile));
        wgContext.getServiceProvider().execRequest(req).getResult();
        return expFile;
    }

    public void deleteServerDocument(Integer fileFieldId, String strID) throws ServiceException {
        ServiceMData dlgFileService = ServiceRegistry.getService((String)"module_file", (int)0);
        Map params = Map.ofEntries(Map.entry("module_key", this.getModuleKey()), Map.entry("dialog_key", this.getKey()), Map.entry("field_key", fileFieldId), Map.entry("filter_id", strID));
        ServiceRequest req = dlgFileService.createRequest("delete_file", params);
        this.getWgContext().getServiceProvider().execRequest(req);
    }

    public void updateDMSDocument(Integer fileFieldId, String strID, DMSDocument dmsDocument) throws ServiceException {
        ServiceMData dlgFileService = ServiceRegistry.getService((String)"dialog_file", (int)0);
        Map params = Map.ofEntries(Map.entry("module_key", this.getModuleKey()), Map.entry("dialog_key", this.getKey()), Map.entry("field_key", fileFieldId), Map.entry("filter_id", strID), Map.entry("upload_filename", dmsDocument.buildURI()), Map.entry("upload_type", FieldFileStorageType.UT_DMS.getIdentificator()));
        ServiceRequest req = dlgFileService.createRequest("upload_file", params);
        this.getWgContext().getServiceProvider().execRequest(req);
    }
}

