/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.webgiscli.module.dialog;

import de.riwagis.browser.BrowserFrame;
import de.riwagis.browser.WindowManager;
import de.riwagis.util.exception.SystemException;
import de.riwagis.webgiscli.WebGisConfiguration;
import de.riwagis.webgiscli.WebGisContext;
import de.riwagis.webgiscli.module.dialog.DialogFactory;
import de.riwagis.webgiscli.module.dialog.DialogTypes;
import de.riwagis.webgiscli.module.dialog.WebGisDialog;
import de.riwagis.webgiscli.module.dialog.WebGisDialogMap;
import de.riwagis.webgiscli.service.http.HttpServiceProvider;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.apache.commons.lang.ObjectUtils;
import org.locationtech.jts.geom.Envelope;

public class HtmlWGMapLinkDialog
extends WebGisDialog {
    private final String strBasicURL;
    private final Map<String, String[]> mapFilter = new LinkedHashMap<String, String[]>();
    private final WebGisDialogMap dlgMap;

    private HtmlWGMapLinkDialog(Map<String, Object> dialogInfo, int moduleKey, WebGisContext wgContext) throws SystemException {
        super(dialogInfo, moduleKey, wgContext);
        this.strBasicURL = WebGisConfiguration.getWhiteboard().getAttribute("HttpBridgeURL").toString() + ((HttpServiceProvider)wgContext.getServiceProvider()).getURI();
        HashMap<String, Object> mapDialogMapInfo = new HashMap<String, Object>();
        HashMap<String, Boolean> mapDialogMapLayers = new HashMap<String, Boolean>();
        Collection lstLayers = (Collection)this.getInfo("moddlg_maplink_layers");
        for (String ly : lstLayers) {
            mapDialogMapLayers.put(ly, true);
        }
        mapDialogMapInfo.put("moddlgmap_layers", mapDialogMapLayers);
        this.dlgMap = new WebGisDialogMap(mapDialogMapInfo);
    }

    private String getBrowserName() {
        return ObjectUtils.toString((Object)this.getInfo("moddlg_name"));
    }

    @Override
    public String getSelectedInFilter() throws Exception {
        return null;
    }

    @Override
    public String[] getFilter() throws Exception {
        String[] arrFilter = this.mapFilter.get("fid");
        if (arrFilter == null) {
            return new String[0];
        }
        return arrFilter;
    }

    public void setFilter(String[] arrID) throws Exception {
        this.mapFilter.put("fid", arrID);
        this.refresh();
    }

    @Override
    public void addGeometry(String[] arrGeom) throws Exception {
    }

    @Override
    public void setFilter(Map<String, ?> mapFilter) throws Exception {
        this.mapFilter.clear();
        Map<String, ?> stringArrayMap = mapFilter;
        this.mapFilter.putAll(stringArrayMap);
        this.refresh();
    }

    @Override
    public void setAction(String strAction, Map<String, ?> mapParam) throws Exception {
    }

    private String getFilterURL() {
        StringBuilder sbFilter = new StringBuilder();
        for (String strCol : this.mapFilter.keySet()) {
            String[] arrFilterValues = this.mapFilter.get(strCol);
            if (arrFilterValues == null || arrFilterValues.length <= 0) continue;
            if (sbFilter.length() > 0) {
                sbFilter.append("&");
            }
            sbFilter.append(strCol).append("=");
            for (String strValue : arrFilterValues) {
                sbFilter.append(strValue).append(",");
            }
            sbFilter.deleteCharAt(sbFilter.length() - 1);
        }
        return sbFilter.toString();
    }

    public void show() throws Exception {
        this.show(this.getURL(), false);
    }

    @Override
    public WebGisDialogMap getDialogMap() {
        return this.dlgMap;
    }

    @Override
    public boolean hasDialogMap() {
        return true;
    }

    private synchronized void show(String strURL, boolean bolNavigate) throws Exception {
        boolean bolInvisible = (Boolean)this.getInfo("moddlg_invisible");
        if (bolInvisible) {
            if (bolNavigate) {
                WindowManager.getInstance().callServer(strURL);
            }
            return;
        }
        int intLeft = (Integer)this.getInfo("moddlg_left");
        int intTop = (Integer)this.getInfo("moddlg_top");
        int intWidth = (Integer)this.getInfo("moddlg_width");
        int intHeight = (Integer)this.getInfo("moddlg_height");
        String strName = this.getBrowserName();
        BrowserFrame brDlg = WindowManager.getInstance().getWindow(strName);
        if (brDlg != null) {
            WindowManager.getInstance().navigateAndFocusBrowserFrame(brDlg, bolNavigate ? strURL : null);
            return;
        }
        final BrowserFrame brDlgNew = WindowManager.getInstance().window().webgisAddress(strURL).name(strName).size(intWidth, intHeight).location(intLeft, intTop).open();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                brDlgNew.setVisible(true);
            }
        });
    }

    public void hide() throws Exception {
        final BrowserFrame brDlg = WindowManager.getInstance().getWindow(this.getBrowserName());
        if (brDlg != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    brDlg.setVisible(false);
                }
            });
        }
    }

    public void refresh() throws Exception {
        this.show(this.getURL(), true);
    }

    private String getURL() {
        Object strURL = this.getInfo("moddlg_maplink_url").toString();
        strURL = (String)strURL + "?modulekey=" + this.getModuleKey();
        strURL = (String)strURL + "&structurekey=" + ObjectUtils.toString((Object)this.getInfo("moddlg_struct_key"));
        String strFilter = this.getFilterURL();
        if (strFilter.length() > 0) {
            strURL = (String)strURL + "&" + strFilter;
        }
        return strURL;
    }

    public Envelope getBounds(int filterType) throws Exception {
        throw new UnsupportedOperationException("HtmlWGMapLinkDialog does not supports the method getBounds()");
    }

    static {
        DialogFactory.addFactory(DialogTypes.HTML_MAPLINK, new DialogFactory(){

            @Override
            protected WebGisDialog create(Map<String, Object> mapDialogInfo, int intModuleKey, WebGisContext wgContext) throws SystemException {
                try {
                    HtmlWGMapLinkDialog htmlDlg = new HtmlWGMapLinkDialog(mapDialogInfo, intModuleKey, wgContext);
                    return htmlDlg;
                }
                catch (Exception e) {
                    throw new SystemException(HtmlWGMapLinkDialog.class, "create(): " + e.getMessage(), (Throwable)e);
                }
            }
        });
    }
}

