/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.webgiscli.module.dialog;

import de.riwagis.browser.BrowserFrame;
import de.riwagis.browser.WindowManager;
import de.riwagis.geotools.envelope.EnvelopeUtil;
import de.riwagis.service.ServiceMData;
import de.riwagis.service.ServiceRequest;
import de.riwagis.service.registry.ServiceRegistry;
import de.riwagis.service.registry.ServiceRegistryModule;
import de.riwagis.util.exception.SystemException;
import de.riwagis.webgiscli.WebGisConfiguration;
import de.riwagis.webgiscli.WebGisContext;
import de.riwagis.webgiscli.module.dialog.DialogFactory;
import de.riwagis.webgiscli.module.dialog.DialogTypes;
import de.riwagis.webgiscli.module.dialog.WebGisDialog;
import de.riwagis.webgiscli.service.http.HttpServiceProvider;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.apache.commons.lang.ObjectUtils;
import org.geotools.geometry.jts.ReferencedEnvelope;

public class HtmlWGDialog
extends WebGisDialog {
    private final String strBasicURL;

    private HtmlWGDialog(Map<String, Object> dialogInfo, int moduleKey, WebGisContext wgContext) throws SystemException {
        super(dialogInfo, moduleKey, wgContext);
        this.strBasicURL = WebGisConfiguration.getWhiteboard().getAttribute("HttpBridgeURL").toString() + ((HttpServiceProvider)wgContext.getServiceProvider()).getURI();
    }

    private String getBrowserName() {
        if (!this.hasRelation()) {
            return ObjectUtils.toString((Object)this.getInfo("moddlg_name"));
        }
        return ObjectUtils.toString(this.getRelationInfo().get("modrel_name"));
    }

    @Override
    public String getSelectedInFilter() throws Exception {
        ServiceMData dlgService = ServiceRegistry.getService((String)"dialog", (int)0);
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("module_key", this.getModuleKey());
        params.put("dialog_key", this.getKey());
        ServiceRequest req = dlgService.createRequest("get_selected_in_filter", params);
        return (String)this.getWgContext().getServiceProvider().execRequest(req).getResult();
    }

    @Override
    public String[] getFilter() throws Exception {
        ServiceMData dlgService = ServiceRegistry.getService((String)"dialog", (int)0);
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("module_key", this.getModuleKey());
        params.put("dialog_key", this.getKey());
        ServiceRequest req = dlgService.createRequest("get_filter", params);
        return (String[])this.getWgContext().getServiceProvider().execRequest(req).getResult();
    }

    public void setFilter(String[] arrID) throws Exception {
        ServiceMData dlgService = ServiceRegistry.getService((String)"dialog", (int)0);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("module_key", this.getModuleKey());
        params.put("dialog_key", this.getKey());
        params.put("id_filter", arrID);
        ServiceRequest req = dlgService.createRequest("set_id_filter", params);
        this.getWgContext().getServiceProvider().execRequest(req);
        this.refresh();
    }

    @Override
    public void addGeometry(String[] arrGeom) throws Exception {
        ServiceMData dlgService = ServiceRegistry.getService((String)"dialog", (int)0);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("module_key", this.getModuleKey());
        params.put("dialog_key", this.getKey());
        params.put("wkt_geometries", arrGeom);
        ServiceRequest req = dlgService.createRequest("add_geometry", params);
        this.getWgContext().getServiceProvider().execRequest(req);
        this.refresh();
    }

    @Override
    public void setFilter(Map<String, ?> mapFilter) throws Exception {
        ServiceMData dlgService = ServiceRegistry.getService((String)"dialog", (int)0);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("module_key", this.getModuleKey());
        params.put("dialog_key", this.getKey());
        params.put("filter", mapFilter);
        ServiceRequest req = dlgService.createRequest("set_filter", params);
        this.getWgContext().getServiceProvider().execRequest(req);
        this.refresh();
    }

    @Override
    public void setAction(String strAction, Map<String, ?> mapParam) throws Exception {
        StringBuilder sbAction = new StringBuilder();
        sbAction.append(strAction);
        if (mapParam != null) {
            for (Map.Entry<String, ?> currEntry : mapParam.entrySet()) {
                String strValue = URLEncoder.encode(currEntry.getValue().toString(), "UTF-8");
                sbAction.append("&").append(currEntry.getKey()).append("=").append(strValue);
            }
        }
        this.refresh(sbAction.toString());
    }

    public void show() throws Exception {
        String strURL;
        if (!this.hasRelation()) {
            strURL = String.format("dbparser/dialog?dbparserid=%s&dbparsermodule=%s", this.getKey(), this.getModuleKey());
        } else {
            Object objRelKey = this.getRelationInfo().get("modrel_key");
            strURL = String.format("dbparser/relation?dbparserrelation=%s&dbparsermodule=%s", objRelKey, this.getModuleKey());
        }
        this.show(strURL, false);
    }

    private synchronized void show(String strURL, boolean bolNavigate) throws Exception {
        int intHeightTmp;
        int intWidthTmp;
        int intTopTmp;
        int intLeftTmp;
        boolean bolInvisible = (Boolean)this.getInfo("moddlg_invisible");
        if (bolInvisible) {
            if (bolNavigate) {
                WindowManager.getInstance().callServer(strURL);
            }
            return;
        }
        if (!this.hasRelation()) {
            intLeftTmp = (Integer)this.getInfo("moddlg_left");
            intTopTmp = (Integer)this.getInfo("moddlg_top");
            intWidthTmp = (Integer)this.getInfo("moddlg_width");
            intHeightTmp = (Integer)this.getInfo("moddlg_height");
        } else {
            Map<?, ?> relationInfo = this.getRelationInfo();
            intLeftTmp = (Integer)relationInfo.get("modrel_left");
            intTopTmp = (Integer)relationInfo.get("modrel_top");
            intWidthTmp = (Integer)relationInfo.get("modrel_width");
            intHeightTmp = (Integer)relationInfo.get("modrel_height");
        }
        int intLeft = intLeftTmp;
        int intTop = intTopTmp;
        int intWidth = intWidthTmp;
        int intHeight = intHeightTmp;
        String strName = this.getBrowserName();
        BrowserFrame brDlg = WindowManager.getInstance().getWindow(strName);
        if (brDlg != null) {
            WindowManager.getInstance().navigateAndFocusBrowserFrame(brDlg, bolNavigate ? strURL : null);
            return;
        }
        BrowserFrame brDlgNew = WindowManager.getInstance().window().webgisAddress(strURL).name(strName).size(intWidth, intHeight).location(intLeft, intTop).open();
        SwingUtilities.invokeLater(() -> brDlgNew.setVisible(true));
    }

    public void hide() throws Exception {
        BrowserFrame brDlg = WindowManager.getInstance().getWindow(this.getBrowserName());
        if (brDlg != null) {
            SwingUtilities.invokeLater(() -> brDlg.setVisible(false));
        }
    }

    public void refresh() throws Exception {
        this.refresh("showdata");
    }

    private synchronized void refresh(String strAction) throws Exception {
        String strURL;
        if (!this.hasRelation()) {
            strURL = String.format("dbparser/dialog?dbparserid=%s&dbparsermodule=%s&dbparseraction=%s", this.getKey(), this.getModuleKey(), strAction);
        } else {
            Object objRelKey = this.getRelationInfo().get("modrel_key");
            strURL = String.format("dbparser/relation?dbparserrelation=%s&dbparserid=%s&dbparsermodule=%s&dbparseraction=%s", objRelKey, this.getKey(), this.getModuleKey(), strAction);
        }
        this.show(strURL, true);
    }

    public ReferencedEnvelope getBounds(int filterType) throws Exception {
        ServiceMData dlgService = ServiceRegistryModule.generateDialogServiceV0();
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("module_key", this.getModuleKey());
        params.put("dialog_key", this.getKey());
        params.put("filter_type", filterType);
        ServiceRequest req = dlgService.createRequest("get_bounds", params);
        String strBBox = (String)this.getWgContext().getServiceProvider().execRequest(req).getResult();
        ReferencedEnvelope bbox = EnvelopeUtil.readReferencedEnvelope((String)strBBox);
        return bbox;
    }

    static {
        DialogFactory.addFactory(DialogTypes.HTML_DIALOG, new DialogFactory(){

            @Override
            protected WebGisDialog create(Map<String, Object> mapDialogInfo, int intModuleKey, WebGisContext wgContext) throws SystemException {
                try {
                    HtmlWGDialog htmlDlg = new HtmlWGDialog(mapDialogInfo, intModuleKey, wgContext);
                    return htmlDlg;
                }
                catch (Exception e) {
                    throw new SystemException(HtmlWGDialog.class, "create(): " + e.getMessage(), (Throwable)e);
                }
            }
        });
    }
}

