/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.webgiscli.module.dialog;

import com.google.gson.Gson;
import de.riwagis.util.exception.SystemException;
import de.riwagis.webgiscli.WebGisContext;
import de.riwagis.webgiscli.module.dialog.AbstractHtmlSPWG;
import de.riwagis.webgiscli.module.dialog.DialogFactory;
import de.riwagis.webgiscli.module.dialog.DialogTypes;
import de.riwagis.webgiscli.module.dialog.WebGisDialog;
import de.riwagis.webgiscli.module.dialog.messaging.SPMessage;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.geotools.geometry.jts.ReferencedEnvelope;

public class HtmlSPWGDialogAssist
extends AbstractHtmlSPWG {
    private HtmlSPWGDialogAssist(Map<String, Object> dialogInfo, int moduleKey, WebGisContext wgContext) throws SystemException {
        super(dialogInfo, moduleKey, wgContext);
    }

    @Override
    public String getSelectedInFilter() throws Exception {
        throw new SystemException("Assist does not provide a filter");
    }

    @Override
    public String[] getFilter() throws Exception {
        throw new SystemException("Assist does not provide a filter");
    }

    public void setFilter(String[] arrID) throws Exception {
        this.show();
        this.sendMessage(new SPMessage(this.getID(), "setIdFilter", new Gson().toJson((Object)new Object[]{arrID})));
    }

    @Override
    public void setFilter(Map<String, ?> mapFilter) throws Exception {
        this.show();
        this.sendMessage(new SPMessage(this.getID(), "setFilter", new Gson().toJson((Object)new Object[]{mapFilter})));
    }

    @Override
    public void addGeometry(String[] arrGeom) throws Exception {
        throw new SystemException("Assist does not support addGeometry");
    }

    @Override
    public ReferencedEnvelope getBounds(int filterType) throws Exception {
        throw new SystemException("Assist does not support getBounds");
    }

    @Override
    public void registerMasterDetailDialogIds(String[] dialogIds) throws Exception {
        throw new SystemException("Assist does not support master - detail");
    }

    @Override
    public synchronized void dialogIdUpdated(String newDialogId) throws Exception {
        this.disableMessaging(this.getID());
        this.messageQueue.clear();
        int newDlgId = Integer.parseInt(newDialogId);
        boolean dialogFound = false;
        Iterator dlgIter = ((List)this.getWgContext().getModule(this.getModuleKey()).getModuleInfo("mod_dialogs")).iterator();
        while (!dialogFound && dlgIter.hasNext()) {
            Map mapInfo = (Map)dlgIter.next();
            if ((Integer)mapInfo.get("moddlg_key") != newDlgId) continue;
            dialogFound = true;
            this.resetMapDlgInfo(mapInfo);
        }
    }

    public void show() throws Exception {
        String strURL = String.format("dbparser/dialog?dbparserid=%s&dbparsermodule=%s", this.getKey(), this.getModuleKey());
        super.show(strURL, false);
    }

    static {
        DialogFactory.addFactory(DialogTypes.DIALOG_ASSIST, new DialogFactory(){

            @Override
            protected WebGisDialog create(Map<String, Object> mapDialogInfo, int intModuleKey, WebGisContext wgContext) throws SystemException {
                try {
                    return new HtmlSPWGDialogAssist(mapDialogInfo, intModuleKey, wgContext);
                }
                catch (Exception e) {
                    throw new SystemException(HtmlSPWGDialogAssist.class, "create(): " + e.getMessage(), (Throwable)e);
                }
            }
        });
    }
}

