/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.webgiscli.module.dialog;

import com.google.gson.Gson;
import de.riwagis.browser.BrowserFrame;
import de.riwagis.browser.BrowserScriptable;
import de.riwagis.browser.WindowManager;
import de.riwagis.geotools.envelope.EnvelopeUtil;
import de.riwagis.gis.context.module.DialogContext;
import de.riwagis.gis.context.module.ModuleContext;
import de.riwagis.service.ServiceMData;
import de.riwagis.service.ServiceRequest;
import de.riwagis.service.registry.ServiceRegistry;
import de.riwagis.service.registry.ServiceRegistryModule;
import de.riwagis.util.exception.SystemException;
import de.riwagis.webgiscli.WebGisContext;
import de.riwagis.webgiscli.module.dialog.AbstractHtmlSPWG;
import de.riwagis.webgiscli.module.dialog.DialogFactory;
import de.riwagis.webgiscli.module.dialog.DialogTypes;
import de.riwagis.webgiscli.module.dialog.WebGisDialog;
import de.riwagis.webgiscli.module.dialog.messaging.SPMessage;
import de.riwagis.webgiscli.module.dialog.messaging.SPMessageHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HtmlSPWGDialog
extends AbstractHtmlSPWG
implements SPMessageHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HtmlSPWGDialog.class);
    private DialogType type = DialogType.UNKNOWN;
    private String masterId;
    private final List<String> detailIds = new ArrayList<String>();
    private boolean showDetailAfterDialogInitialisation = false;

    private HtmlSPWGDialog(Map<String, Object> dialogInfo, int moduleKey, WebGisContext wgContext) throws SystemException {
        super(dialogInfo, moduleKey, wgContext);
        if (!this.hasRelation()) {
            this.type = DialogType.DIALOG;
        }
    }

    @Override
    public String getSelectedInFilter() throws Exception {
        String selectedFid = this.sendMessage(new SPMessage(this.getID(), "getSelectedFilter", true));
        return (String)new Gson().fromJson(selectedFid, String.class);
    }

    @Override
    public String[] getFilter() throws Exception {
        String filter = this.sendMessage(new SPMessage(this.getID(), "getFilter", true));
        return (String[])new Gson().fromJson(filter, String[].class);
    }

    public void setFilter(String[] arrID) throws Exception {
        this.show();
        this.sendMessage(new SPMessage(this.getID(), "setIdFilter", new Gson().toJson((Object)new Object[]{arrID})));
    }

    @Override
    public void setFilter(Map<String, ?> mapFilter) throws Exception {
        this.show();
        this.sendMessage(new SPMessage(this.getID(), "setFilter", new Gson().toJson((Object)new Object[]{mapFilter})));
    }

    @Override
    public void addGeometry(String[] arrGeom) throws Exception {
        AbstractHtmlSPWG.DialogMode dialogMode = AbstractHtmlSPWG.DialogMode.valueOf(this.sendMessage(new SPMessage(this.getID(), "getDialogMode", true)));
        if (dialogMode == AbstractHtmlSPWG.DialogMode.SHOW) {
            String currentFid = this.getSelectedInFilter();
            ServiceMData dlgService = ServiceRegistry.getService((String)"dialog", (int)0);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("module_key", this.getModuleKey());
            params.put("dialog_key", this.getKey());
            params.put("wkt_geometries", arrGeom);
            params.put("filter_id", currentFid);
            ServiceRequest req = dlgService.createRequest("add_geometry", params);
            this.getWgContext().getServiceProvider().execRequest(req);
            this.refresh();
        }
    }

    @Override
    public ReferencedEnvelope getBounds(int filterType) throws Exception {
        ServiceMData dlgService = ServiceRegistryModule.generateDialogServiceV0();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("module_key", this.getModuleKey());
        params.put("dialog_key", this.getKey());
        switch (filterType) {
            case 1: {
                params.put("id_filter", this.getFilter());
                break;
            }
            case 3: {
                params.put("id_filter", new String[]{this.getSelectedInFilter()});
                break;
            }
            default: {
                log.warn("Unknown filter type: {}", (Object)filterType);
            }
        }
        ServiceRequest req = dlgService.createRequest("get_bounds", params);
        String strBBox = (String)this.getWgContext().getServiceProvider().execRequest(req).getResult();
        return EnvelopeUtil.readReferencedEnvelope((String)strBBox);
    }

    public void show() throws Exception {
        String strURL;
        if (!this.hasRelation()) {
            strURL = String.format("dbparser/dialog?dbparserid=%s&dbparsermodule=%s", this.getKey(), this.getModuleKey());
        } else {
            Object objRelKey = this.getRelationInfo().get("modrel_key");
            strURL = String.format("dbparser/relation?dbparserrelation=%s&dbparsermodule=%s", objRelKey, this.getModuleKey());
        }
        super.show(strURL, false);
        if (this.type == DialogType.DETAIL) {
            ModuleContext module = this.wgContext.getModule(this.getModuleID());
            HtmlSPWGDialog master = (HtmlSPWGDialog)module.getDialog(this.masterId);
            master.sendMessage(new SPMessage(this.masterId, "showDetailDialog", new Gson().toJson((Object)new String[]{this.getID()})));
        } else if (this.type == DialogType.UNKNOWN) {
            this.setShowDetailAfterDialogInitialisation(true);
        }
    }

    @Override
    public void disableMessaging(String dialogId) throws Exception {
        if (this.getID().equals(dialogId)) {
            this.messagingIsInitialized = false;
            if (this.type == DialogType.MASTER) {
                ModuleContext module = this.wgContext.getModule(this.getModuleID());
                for (String detailId : this.detailIds) {
                    HtmlSPWGDialog detail = (HtmlSPWGDialog)module.getDialog(detailId);
                    detail.disableMessaging(detailId);
                }
            }
        } else {
            SPMessageHandler handler = this.getHandlerForDialogId(dialogId);
            if (handler != null) {
                handler.disableMessaging(dialogId);
            }
        }
    }

    @Override
    public synchronized void enableMessaging(String dialogId) throws Exception {
        if (this.getID().equals(dialogId)) {
            if (this.type == DialogType.MASTER) {
                ModuleContext module = this.wgContext.getModule(this.getModuleID());
                for (String detailId : this.detailIds) {
                    HtmlSPWGDialog detail = (HtmlSPWGDialog)module.getDialog(detailId);
                    if (!detail.getShowDetailAfterDialogInitialisation()) continue;
                    this.sendMessage(new SPMessage(this.getID(), "showDetailDialog", new Gson().toJson((Object)new String[]{detailId})));
                    detail.setShowDetailAfterDialogInitialisation(false);
                }
            }
            this.messagingIsInitialized = true;
            BrowserFrame brDlg = WindowManager.getInstance().getWindow(super.getBrowserName());
            this.processMessageQueue((BrowserScriptable)brDlg);
        } else {
            SPMessageHandler handler = this.getHandlerForDialogId(dialogId);
            if (handler != null) {
                handler.enableMessaging(dialogId);
            }
        }
    }

    @Override
    public synchronized void registerMasterDetailDialogIds(String[] dialogIds) throws Exception {
        ModuleContext module = this.wgContext.getModule(this.getModuleID());
        HtmlSPWGDialog master = (HtmlSPWGDialog)module.getDialog(dialogIds[0]);
        master.setType(DialogType.MASTER);
        master.clearDetailIds();
        for (int i = 1; i < dialogIds.length; ++i) {
            DialogContext dialog = module.getDialog(dialogIds[i]);
            if (!(dialog instanceof HtmlSPWGDialog)) continue;
            master.addDetailId(dialogIds[i]);
            ((HtmlSPWGDialog)dialog).setMasterId(master.getID());
            ((HtmlSPWGDialog)dialog).setType(DialogType.DETAIL);
        }
    }

    @Override
    public synchronized void dialogIdUpdated(String newDialogId) throws Exception {
        this.disableMessaging(this.getID());
        this.messageQueue.clear();
        this.setMasterId("");
        this.clearDetailIds();
        int newDlgId = Integer.parseInt(newDialogId);
        boolean dialogFound = false;
        Iterator dlgIter = ((List)this.getWgContext().getModule(this.getModuleKey()).getModuleInfo("mod_dialogs")).iterator();
        while (!dialogFound && dlgIter.hasNext()) {
            Map mapInfo = (Map)dlgIter.next();
            if ((Integer)mapInfo.get("moddlg_key") != newDlgId) continue;
            dialogFound = true;
            this.resetMapDlgInfo(mapInfo);
        }
    }

    @Override
    protected void resetMapDlgInfo(Map<String, Object> _mapDlgInfo) throws SystemException {
        super.resetMapDlgInfo(_mapDlgInfo);
        if (!this.hasRelation()) {
            this.type = DialogType.DIALOG;
        }
    }

    public void setType(DialogType type) {
        this.type = type;
    }

    public void setMasterId(String masterId) {
        this.masterId = masterId;
    }

    public void clearDetailIds() {
        this.detailIds.clear();
    }

    public void addDetailId(String id) {
        this.detailIds.add(id);
    }

    public void setShowDetailAfterDialogInitialisation(boolean value) {
        this.showDetailAfterDialogInitialisation = value;
    }

    public boolean getShowDetailAfterDialogInitialisation() {
        return this.showDetailAfterDialogInitialisation;
    }

    static {
        DialogFactory.addFactory(DialogTypes.DIALOG, new DialogFactory(){

            @Override
            protected WebGisDialog create(Map<String, Object> mapDialogInfo, int intModuleKey, WebGisContext wgContext) throws SystemException {
                try {
                    return new HtmlSPWGDialog(mapDialogInfo, intModuleKey, wgContext);
                }
                catch (Exception e) {
                    throw new SystemException(HtmlSPWGDialog.class, "create(): " + e.getMessage(), (Throwable)e);
                }
            }
        });
    }

    private static enum DialogType {
        UNKNOWN,
        DIALOG,
        DETAIL,
        MASTER;

    }
}

