/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.webgiscli.module.dialog;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public enum DialogTypes {
    DT_UNKNOWN(0, null, false, ""),
    DT_JAVAWG_DIALOG(1, "JavaWGDialog", false, "JAVA_DIALOG"),
    DT_HTML_DIALOG(2, "HtmlWGDialog", true, "HTML_DIALOG"),
    DT_HTML_MAPLINK(3, "HtmlWGMapLinkDialog", true, "HTML_MAPLINK"),
    DT_HTML_SP_DIALOG(4, "HtmlSPWGDialog", true, "DIALOG"),
    DT_HTML_SP_ASSIST(5, "HtmlSPWGDialogAssist", true, "DIALOG_ASSIST");

    @Deprecated
    public static final int HTML_DIALOG;
    @Deprecated
    public static final int HTML_MAPLINK;
    public static final int DIALOG;
    public static final int DIALOG_ASSIST;
    private final Integer typeKey;
    private final String typeClassName;
    private final boolean instantiationAllowed;
    private final String typeName;
    private static final Map<Integer, String> hmClasses;

    private DialogTypes(Integer typeKey, String typeClassName, boolean instantiationAllowed, String typeName) {
        this.typeKey = typeKey;
        this.typeClassName = typeClassName;
        this.instantiationAllowed = instantiationAllowed;
        this.typeName = typeName;
    }

    public Integer getTypeKey() {
        return this.typeKey;
    }

    public String getTypeClassName() {
        return this.typeClassName;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public static final DialogTypes findByTypeName(String typeName) {
        if (StringUtils.isNotBlank((String)typeName)) {
            for (DialogTypes currDT : DialogTypes.values()) {
                if (!StringUtils.equalsIgnoreCase((String)typeName, (String)currDT.getTypeName())) continue;
                return currDT;
            }
        }
        return DT_UNKNOWN;
    }

    public static final DialogTypes findByTypeKey(Integer typeKey) {
        if (typeKey != null) {
            for (DialogTypes currDT : DialogTypes.values()) {
                if (!typeKey.equals(currDT.getTypeKey())) continue;
                return currDT;
            }
        }
        return DT_UNKNOWN;
    }

    public boolean isInstantiationAllowed() {
        return this.instantiationAllowed;
    }

    @Deprecated
    public static final String getClassname(int intType) {
        return hmClasses.get(intType);
    }

    @Deprecated
    public static Iterator<String> getClassnames() {
        return hmClasses.values().iterator();
    }

    static {
        HTML_DIALOG = DT_HTML_DIALOG.getTypeKey();
        HTML_MAPLINK = DT_HTML_MAPLINK.getTypeKey();
        DIALOG = DT_HTML_SP_DIALOG.getTypeKey();
        DIALOG_ASSIST = DT_HTML_SP_ASSIST.getTypeKey();
        hmClasses = new HashMap<Integer, String>();
        for (DialogTypes currDT : DialogTypes.values()) {
            if (!currDT.isInstantiationAllowed()) continue;
            hmClasses.put(currDT.getTypeKey(), currDT.getTypeClassName());
        }
    }
}

