/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.webgiscli.module.dialog;

import de.riwagis.util.exception.SystemException;
import de.riwagis.webgiscli.WebGisContext;
import de.riwagis.webgiscli.module.dialog.DialogTypes;
import de.riwagis.webgiscli.module.dialog.WebGisDialog;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DialogFactory {
    private static final Logger LOG = LoggerFactory.getLogger(DialogFactory.class);
    private static final Map<String, DialogFactory> factories = new LinkedHashMap<String, DialogFactory>();

    protected abstract WebGisDialog create(Map<String, Object> var1, int var2, WebGisContext var3) throws SystemException;

    static void addFactory(int intType, DialogFactory factory) {
        if (factories.containsKey(DialogTypes.getClassname(intType))) {
            return;
        }
        factories.put(DialogTypes.getClassname(intType), factory);
    }

    public static WebGisDialog createDialog(Map<String, Object> mapDialogInfo, int intModuleKey, WebGisContext wgContext) throws SystemException {
        try {
            String strType = mapDialogInfo.get("moddlg_type").toString();
            int intType = DialogTypes.class.getDeclaredField(strType).getInt(null);
            String strClassName = DialogTypes.getClassname(intType);
            if (strClassName == null) {
                throw new Exception(String.format("No dialog factory found for type: %s", intType));
            }
            DialogFactory fac = factories.get(strClassName);
            if (fac == null) {
                throw new Exception(String.format("No dialog factory found for type: %s", intType));
            }
            return fac.create(mapDialogInfo, intModuleKey, wgContext);
        }
        catch (Exception e) {
            throw new SystemException(DialogFactory.class, (Throwable)e);
        }
    }

    static {
        Iterator<String> i = DialogTypes.getClassnames();
        while (i.hasNext()) {
            String strClassName = i.next();
            try {
                Class.forName("de.riwagis.webgiscli.module.dialog." + strClassName);
            }
            catch (ClassNotFoundException e) {
                LOG.warn(String.format("Error in DialogFactory - Class '%s' not found", strClassName));
            }
        }
    }
}

