/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.webgiscli.module.dialog;

import com.google.gson.Gson;
import de.riwagis.browser.BrowserFrame;
import de.riwagis.browser.BrowserScriptable;
import de.riwagis.browser.QueryListener;
import de.riwagis.browser.WindowManager;
import de.riwagis.gis.context.module.DialogContext;
import de.riwagis.gis.context.module.ModuleContext;
import de.riwagis.util.exception.SystemException;
import de.riwagis.webgiscli.WebGisContext;
import de.riwagis.webgiscli.module.dialog.WebGisDialog;
import de.riwagis.webgiscli.module.dialog.messaging.SPMessage;
import de.riwagis.webgiscli.module.dialog.messaging.SPMessageHandler;
import de.riwagis.webgiscli.module.dialog.messaging.SPMessageListener;
import de.riwagis.webgiscli.util.SizePositionData;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.apache.commons.lang.ObjectUtils;
import org.geotools.geometry.jts.ReferencedEnvelope;

public abstract class AbstractHtmlSPWG
extends WebGisDialog
implements SPMessageHandler {
    protected boolean messagingIsInitialized = false;
    protected final List<SPMessage> messageQueue = new ArrayList<SPMessage>();

    protected AbstractHtmlSPWG(Map<String, Object> dialogInfo, int moduleKey, WebGisContext wgContext) throws SystemException {
        super(dialogInfo, moduleKey, wgContext);
    }

    protected String getBrowserName() {
        if (!this.hasRelation()) {
            return ObjectUtils.toString((Object)this.getInfo("moddlg_name"));
        }
        return ObjectUtils.toString(this.getRelationInfo().get("modrel_name"));
    }

    @Override
    public abstract String getSelectedInFilter() throws Exception;

    @Override
    public abstract String[] getFilter() throws Exception;

    @Override
    public abstract void setFilter(Map<String, ?> var1) throws Exception;

    @Override
    public abstract void addGeometry(String[] var1) throws Exception;

    public abstract ReferencedEnvelope getBounds(int var1) throws Exception;

    @Override
    public void setAction(String strAction, Map<String, ?> mapParam) throws Exception {
        this.show();
        this.sendMessage(new SPMessage(this.getID(), "setAction", new Gson().toJson((Object)new Object[]{strAction})));
    }

    protected synchronized void show(String strURL, boolean bolNavigate) throws Exception {
        int intHeight;
        int intWidth;
        int intTop;
        int intLeft;
        boolean bolInvisible = (Boolean)this.getInfo("moddlg_invisible");
        if (bolInvisible) {
            if (bolNavigate) {
                WindowManager.getInstance().callServer(strURL);
            }
            return;
        }
        String strName = this.getBrowserName();
        BrowserFrame brDlg = WindowManager.getInstance().getWindow(strName);
        if (brDlg != null) {
            brDlg.requestFocus();
            brDlg.setVisible(true);
            return;
        }
        if (!this.hasRelation()) {
            intLeft = (Integer)this.getInfo("moddlg_left");
            intTop = (Integer)this.getInfo("moddlg_top");
            intWidth = (Integer)this.getInfo("moddlg_width");
            intHeight = (Integer)this.getInfo("moddlg_height");
        } else {
            Map<?, ?> relationInfo = this.getRelationInfo();
            intLeft = (Integer)relationInfo.get("modrel_left");
            intTop = (Integer)relationInfo.get("modrel_top");
            intWidth = (Integer)relationInfo.get("modrel_width");
            intHeight = (Integer)relationInfo.get("modrel_height");
        }
        BrowserFrame brDlgNew = WindowManager.getInstance().window().webgisAddress(strURL).name(strName).size(intWidth, intHeight).location(intLeft, intTop).open();
        brDlgNew.addQueryListener((QueryListener)new SPMessageListener(this));
        SwingUtilities.invokeLater(() -> brDlgNew.setVisible(true));
    }

    public void hide() throws Exception {
        BrowserFrame brDlg = WindowManager.getInstance().getWindow(this.getBrowserName());
        if (brDlg != null) {
            SwingUtilities.invokeLater(() -> brDlg.setVisible(false));
        }
    }

    public void refresh() throws Exception {
        BrowserFrame brDlg = WindowManager.getInstance().getWindow(this.getBrowserName());
        if (brDlg == null) {
            this.show();
        } else {
            this.sendMessage(new SPMessage(this.getID(), "refresh"));
        }
    }

    @Override
    public void disableMessaging(String dialogId) throws Exception {
        if (this.getID().equals(dialogId)) {
            this.messagingIsInitialized = false;
        } else {
            SPMessageHandler handler = this.getHandlerForDialogId(dialogId);
            if (handler != null) {
                handler.disableMessaging(dialogId);
            }
        }
    }

    @Override
    public synchronized void enableMessaging(String dialogId) throws Exception {
        if (this.getID().equals(dialogId)) {
            this.messagingIsInitialized = true;
            BrowserFrame brDlg = WindowManager.getInstance().getWindow(this.getBrowserName());
            this.processMessageQueue((BrowserScriptable)brDlg);
        } else {
            SPMessageHandler handler = this.getHandlerForDialogId(dialogId);
            if (handler != null) {
                handler.enableMessaging(dialogId);
            }
        }
    }

    @Override
    public SizePositionData setWindowSize(SizePositionData size) throws Exception {
        this.getBrowserDialogWindow().setSize(size.getWidth(), size.getHeight());
        return this.getWindowSizeAndPosition();
    }

    @Override
    public SizePositionData setWindowPosition(SizePositionData position) throws Exception {
        this.getBrowserDialogWindow().setLocation(position.getLeft(), position.getTop());
        return this.getWindowSizeAndPosition();
    }

    @Override
    public SizePositionData getWindowSizeAndPosition() throws Exception {
        Window dialogWindow = this.getBrowserDialogWindow();
        Point position = dialogWindow.getLocationOnScreen();
        Dimension size = dialogWindow.getSize();
        return new SizePositionData(position.x, position.y, size.width, size.height);
    }

    private Window getBrowserDialogWindow() {
        BrowserFrame browser = WindowManager.getInstance().getWindow(this.getBrowserName());
        Window dialogWindow = browser instanceof Window ? (Window)browser : SwingUtilities.getWindowAncestor((Component)browser);
        return dialogWindow;
    }

    protected SPMessageHandler getHandlerForDialogId(String dialogId) throws Exception {
        ModuleContext module = this.wgContext.getModule(this.getModuleID());
        DialogContext dialog = module.getDialog(dialogId);
        if (dialog instanceof SPMessageHandler) {
            return (SPMessageHandler)dialog;
        }
        return null;
    }

    protected void processMessageQueue(BrowserScriptable brDlg) {
        if (this.messageQueue.isEmpty()) {
            return;
        }
        for (SPMessage qMessage : this.messageQueue) {
            this.sendMessageToBrowser(qMessage, brDlg);
        }
        this.messageQueue.clear();
    }

    @Override
    public String sendMessage(SPMessage message) {
        BrowserFrame brDlg = WindowManager.getInstance().getWindow(this.getBrowserName());
        if (this.messagingIsInitialized && brDlg != null) {
            return this.sendMessageToBrowser(message, (BrowserScriptable)brDlg);
        }
        if (Boolean.TRUE.equals(message.isWaitForResult())) {
            throw new UnsupportedOperationException("Cannot wait for initialization with return-expected-messages");
        }
        this.messageQueue.add(message);
        return "";
    }

    private String sendMessageToBrowser(SPMessage message, BrowserScriptable brDlg) {
        String json = new Gson().toJson((Object)message);
        if (Boolean.TRUE.equals(message.isWaitForResult())) {
            return brDlg.execJSWithReturn("RiwaGisClient.onMessage(" + json + ")");
        }
        brDlg.execJS("RiwaGisClient.onMessage(" + json + ");");
        return "";
    }

    protected static enum DialogMode {
        SHOW("show"),
        INSERT("insert"),
        UPDATE("update"),
        TABLE("table"),
        SEARCH("search"),
        ASSIST("assist");

        public final String mode;

        private DialogMode(String mode) {
            this.mode = mode;
        }
    }
}

