/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.webgiscli.module.bsh;

import bsh.Interpreter;
import de.riwagis.browser.BrowserFrame;
import de.riwagis.browser.OpenWindowConfiguration;
import de.riwagis.browser.WindowManager;
import de.riwagis.browser.util.BrowserSupport;
import de.riwagis.util.Config;
import de.riwagis.util.gui.ExceptionDialog;
import de.riwagis.util.gui.GUISupport;
import de.riwagis.util.gui.components.WaitDialog;
import de.riwagis.util.i18n.I18N;
import de.riwagis.webgiscli.WebGisContext;
import de.riwagis.webgiscli.module.WebGisImp;
import de.riwagis.webgiscli.module.bsh.BshMenuEndpointService;
import de.riwagis.webgiscli.module.dialog.WebGisDialog;
import de.riwagis.webgiscli.service.http.HttpServiceProvider;
import de.riwagis.webgiscli.servlet.LocalActionServlet;
import de.riwagis.webgiscli.servlet.actions.LocalAction;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.apache.commons.lang.StringUtils;

public abstract class BshMenuRuntime {
    private static final I18N i18n = new I18N(Config.LOCALE, "de.riwagis.webgiscli.i18n.i18n");
    private WebGisContext wgContext = null;
    private int module_key = -1;

    private void setModuleKey(int _module_key) {
        this.module_key = _module_key;
    }

    private void setWebGisContext(WebGisContext _wgContext) {
        this.wgContext = _wgContext;
    }

    private void openWindow(String strURL, String strName, int intWidth, int intHeight, boolean bolShowToolbar) {
        try {
            WindowManager.getInstance().openWindow(strURL, strName, intWidth, intHeight, -1, -1, bolShowToolbar);
        }
        catch (Exception e) {
            ExceptionDialog.handleGuiException(null, (Throwable)e, (String)"webgiscli");
        }
    }

    private void showWindow(String strURL, String strName, int intWidth, int intHeight) {
        BrowserFrame window = WindowManager.getInstance().getWindow(strName);
        if (window == null || !StringUtils.equals((String)strURL, (String)window.getURL())) {
            this.openWindow(strURL, strName, intWidth, intHeight);
        } else {
            window.requestFocus();
        }
    }

    private void openWindow(String strURL, String strName, int intWidth, int intHeight) {
        try {
            WindowManager.getInstance().openWindow(strURL, strName, intWidth, intHeight);
        }
        catch (Exception e) {
            ExceptionDialog.handleGuiException(null, (Throwable)e, (String)"webgiscli");
        }
    }

    private OpenWindowConfiguration.Builder browserWindow() {
        return WindowManager.getInstance().window();
    }

    private void openBrowser(String strURL) {
        BrowserSupport.openBrowser((String)strURL);
    }

    @Deprecated
    private void callServer(String strURL) {
        try {
            WindowManager.getInstance().callServer(strURL);
        }
        catch (Exception e) {
            ExceptionDialog.handleGuiException(null, (Throwable)e, (String)"webgiscli");
        }
    }

    private void callEndpoint(String endpoint) {
        this.callEndpoint(endpoint, Collections.emptyMap());
    }

    private void callEndpoint(String endpoint, Map<String, Object> parameters) {
        Frame parentFrame = WebGisContext.getInstance().getWebGisClient().getFrame();
        WaitDialog dlgWait = WaitDialog.createWaitDialog((Window)parentFrame, (String)i18n.get("common.wait"));
        dlgWait.setCancelable(true);
        dlgWait.addWorkToDo(() -> {
            try {
                new BshMenuEndpointService().getEndpointMenuAction(this.wgContext, this.module_key, endpoint, parameters).ifPresent(runtime -> SwingUtilities.invokeLater(() -> {
                    try {
                        runtime.onClick();
                    }
                    catch (Exception ex) {
                        throw new IllegalStateException("Error while calling server endpoint", ex);
                    }
                }));
            }
            catch (Exception e) {
                dlgWait.setError(e);
            }
        });
        dlgWait.setVisible(250L);
        if (dlgWait.getError() != null) {
            ExceptionDialog.handleGuiException((Component)parentFrame, (Exception)dlgWait.getError(), this.getClass());
        }
    }

    private void showReport(String strFile, int intStructKey) {
        try {
            WindowManager.getInstance().callServer("/jsp_lib/showReport.jsp?file=" + strFile + "&module=" + this.module_key + "&struct=" + intStructKey);
        }
        catch (Exception e) {
            ExceptionDialog.handleGuiException(null, (Throwable)e, (String)"webgiscli");
        }
    }

    private void showDialog(int dialog_key) {
        try {
            this.wgContext.getModule(this.module_key).getDialog(dialog_key).show();
        }
        catch (Exception e) {
            ExceptionDialog.handleGuiException(null, (Throwable)e, (String)"webgiscli");
        }
    }

    private void callInterface(String _filename, String _fileContent, boolean _startExe) {
        try {
            LocalAction action = LocalActionServlet.getActionByName("Interface");
            LinkedHashMap<String, Object[]> mapParam = new LinkedHashMap<String, Object[]>();
            mapParam.put("action", new String[]{"writefile"});
            mapParam.put("file", new String[]{_filename});
            mapParam.put("text", new String[]{_fileContent});
            mapParam.put("startexe", new String[]{Boolean.toString(_startExe)});
            mapParam.put("moduleid", new String[]{Integer.toString(this.module_key)});
            action.execute(mapParam);
        }
        catch (Exception e) {
            ExceptionDialog.handleGuiException(null, (Throwable)e, (String)"webgiscli");
        }
    }

    private void showServerFile(String strURL) {
        try {
            LocalAction action = LocalActionServlet.getActionByName("FileOnServer");
            LinkedHashMap<String, Object[]> mapParam = new LinkedHashMap<String, Object[]>();
            mapParam.put("action", new String[]{"serverfile_show"});
            mapParam.put("url", new String[]{strURL});
            action.execute(mapParam);
        }
        catch (Exception e) {
            ExceptionDialog.handleGuiException(null, (Throwable)e, (String)"webgiscli");
        }
    }

    private void showImport(int import_key) {
        this.showImport(import_key, false);
    }

    private void showImport(int import_key, boolean multiSelection) {
        try {
            WebGisImp imp = new WebGisImp(this.module_key, import_key, multiSelection);
            imp.impFile();
        }
        catch (Exception e) {
            ExceptionDialog.handleGuiException(null, (Throwable)e, (String)"webgiscli");
        }
    }

    private WebGisDialog getDialog(int dialog_key) {
        try {
            return (WebGisDialog)this.wgContext.getModule(this.module_key).getDialog(dialog_key);
        }
        catch (Exception e) {
            ExceptionDialog.handleGuiException(null, (Throwable)e, (String)"webgiscli");
            return null;
        }
    }

    private boolean doReLogin() {
        boolean loginDone = false;
        try {
            loginDone = this.wgContext.getServiceProvider().doReLogin();
            if (!loginDone) {
                loginDone = ((HttpServiceProvider)this.wgContext.getServiceProvider()).doLogin(true);
            }
            if (!loginDone) {
                GUISupport.msgbox(null, (String)i18n.get("module.bsh.BshMenuRuntime.error-at-login"), (String)i18n.get("common.error"));
            }
        }
        catch (Exception e) {
            ExceptionDialog.handleGuiException(null, (Throwable)e, (String)"webgiscli");
        }
        return loginDone;
    }

    public ActionListener getActionListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BshMenuRuntime.this.onClick();
            }
        };
    }

    public void onClick() {
    }

    public static BshMenuRuntime getInstance(String strOnClick, WebGisContext _wgContext, int module_key) throws Exception {
        Interpreter ip = new Interpreter();
        String onClick_correctedWindowManager = StringUtils.replace((String)StringUtils.defaultIfEmpty((String)strOnClick, (String)""), (String)"de.riwagis.jxbrowser.WindowManager.", (String)"de.riwagis.browser.WindowManager.getInstance().");
        Object obj = ip.eval(String.format("new de.riwagis.webgiscli.module.bsh.BshMenuRuntime(){public void onClick(){%s}};", onClick_correctedWindowManager));
        BshMenuRuntime rt = (BshMenuRuntime)obj;
        rt.setModuleKey(module_key);
        rt.setWebGisContext(_wgContext);
        return rt;
    }
}

