/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.webgiscli.module.bsh;

import de.riwagis.util.exception.SystemException;
import de.riwagis.webgiscli.WebGisContext;
import de.riwagis.webgiscli.module.bsh.BshMenuRuntime;
import de.riwagis.webgiscli.service.http.EndpointService;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BshMenuEndpointService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BshMenuEndpointService.class);
    private final EndpointService<Map<String, Object>, EndpointResponse> generalEndpointService = new EndpointService(EndpointResponse.class);

    public Optional<BshMenuRuntime> getEndpointMenuAction(WebGisContext wgContext, int module_key, String endpoint, Map<String, Object> parameters) throws SystemException {
        return this.generalEndpointService.callMethod(wgContext, module_key, endpoint, parameters).map(EndpointResponse::getBsh).filter(StringUtils::isNotBlank).map(bsh -> BshMenuEndpointService.createBshMenuRuntime(bsh, wgContext, module_key));
    }

    private static BshMenuRuntime createBshMenuRuntime(String bsh, WebGisContext wgContext, int module_key) {
        try {
            return BshMenuRuntime.getInstance(bsh, wgContext, module_key);
        }
        catch (Exception ex) {
            throw new RuntimeException("Error while calling server endpoint", ex);
        }
    }

    static class EndpointResponse {
        private String bsh;

        EndpointResponse() {
        }

        public String getBsh() {
            return this.bsh;
        }

        public void setBsh(String bsh) {
            this.bsh = bsh;
        }
    }
}

