/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.webgiscli.module;

import de.riwagis.dms.DMSDocument;
import de.riwagis.gis.context.module.DialogContext;
import de.riwagis.gis.context.module.MenuContext;
import de.riwagis.gis.context.module.ModuleContext;
import de.riwagis.service.ServiceException;
import de.riwagis.service.ServiceMData;
import de.riwagis.service.ServiceRequest;
import de.riwagis.service.StreamProcessor;
import de.riwagis.service.registry.ServiceRegistry;
import de.riwagis.service.stream.FileStreamProcessor;
import de.riwagis.service.stream.ImgStreamProcessor;
import de.riwagis.service.stream.XmlStreamProcessor;
import de.riwagis.util.exception.SystemException;
import de.riwagis.util.xml.XMLSupport;
import de.riwagis.webgiscli.WebGisContext;
import de.riwagis.webgiscli.module.WebGisMenu;
import de.riwagis.webgiscli.module.dialog.DialogFactory;
import de.riwagis.webgiscli.module.dialog.WebGisDialog;
import de.riwagis.webgiscli.module.dialog.gui.FieldFileStorageType;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.jdom2.Document;

public class WebGisModule
implements ModuleContext {
    private final WebGisContext wgContext;
    private int intModuleKey = -1;
    private final Map<String, Object> mapModInfo = new HashMap<String, Object>();
    private final Map<Integer, MenuContext> mapMenus = new HashMap<Integer, MenuContext>();
    private final Map<Integer, DialogContext> mapDialogs = new HashMap<Integer, DialogContext>();
    public static final String MOD_MENUS = "mod_menus";
    public static final String MOD_MENUS_XML = "mod_menus_xml";
    public static final String MOD_QUICKINFO_MAPPING = "mod_quickinfo_mapping";
    public static final String MOD_QUICKINFO_MAPPING_TOOLTIPS = "mod_quickinfo_mapping_tooltips";

    public WebGisModule(Map<String, Object> _mapModInfo, WebGisContext _wgContext) {
        this.wgContext = _wgContext;
        this.mapModInfo.putAll(_mapModInfo);
        this.intModuleKey = (Integer)this.mapModInfo.get("mod_key");
    }

    public String getID() {
        return "" + this.intModuleKey;
    }

    public int getKey() {
        return this.intModuleKey;
    }

    public String toString() {
        return String.format("%s: %s", this.intModuleKey, this.mapModInfo.get("mod_name"));
    }

    public int[] getMenus() throws Exception {
        List lstMenus = (List)this.mapModInfo.get(MOD_MENUS);
        if (lstMenus != null) {
            int[] arrMenus = new int[lstMenus.size()];
            for (int i = 0; i < arrMenus.length; ++i) {
                arrMenus[i] = (Integer)lstMenus.get(i);
            }
            return arrMenus;
        }
        return new int[0];
    }

    public synchronized MenuContext getMenu(int intID) throws Exception {
        if (this.mapMenus.get(intID) == null) {
            Document doc;
            if (this.mapModInfo.containsKey(MOD_MENUS_XML)) {
                String strXML = (String)((Map)this.mapModInfo.get(MOD_MENUS_XML)).get(intID);
                doc = XMLSupport.build((InputStream)IOUtils.toInputStream((String)strXML, (String)"UTF-8"));
            } else {
                ServiceMData moduleService = ServiceRegistry.getService((String)"module", (int)0);
                HashMap<String, Integer> params = new HashMap<String, Integer>();
                params.put("module_key", this.intModuleKey);
                params.put("menu_key", intID);
                ServiceRequest req = moduleService.createRequest("get_menu", params);
                req.setStreamProcessor((StreamProcessor)new XmlStreamProcessor());
                doc = (Document)this.wgContext.getServiceProvider().execRequest(req).getResult();
            }
            WebGisMenu men = new WebGisMenu(doc, intID, this, this.wgContext);
            this.mapMenus.put(intID, men);
        }
        return this.mapMenus.get(intID);
    }

    public BufferedImage getPicture(String strName) throws ServiceException {
        ServiceMData moduleService = ServiceRegistry.getService((String)"module", (int)0);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("module_key", this.intModuleKey);
        params.put("picture_name", strName);
        ServiceRequest req = moduleService.createRequest("get_picture", params);
        req.setStreamProcessor((StreamProcessor)new ImgStreamProcessor());
        BufferedImage img = (BufferedImage)this.wgContext.getServiceProvider().execRequest(req).getResult();
        return img;
    }

    private synchronized Map<Integer, DialogContext> getDialogMap() throws Exception {
        if (this.mapDialogs.isEmpty()) {
            Iterator dlgIter = ((List)this.mapModInfo.get("mod_dialogs")).iterator();
            this.mapDialogs.clear();
            while (dlgIter.hasNext()) {
                Map mapInfo = (Map)dlgIter.next();
                WebGisDialog dlgCtx = DialogFactory.createDialog(mapInfo, this.intModuleKey, this.wgContext);
                this.mapDialogs.put(Integer.valueOf(dlgCtx.getID()), dlgCtx);
            }
        }
        return this.mapDialogs;
    }

    public DialogContext[] getDialogs() throws Exception {
        Map<Integer, DialogContext> mapDialog = this.getDialogMap();
        DialogContext[] arrDlgContext = new DialogContext[mapDialog.size()];
        Iterator<Integer> i = mapDialog.keySet().iterator();
        int count = 0;
        while (i.hasNext()) {
            arrDlgContext[count] = mapDialog.get(i.next());
            ++count;
        }
        return arrDlgContext;
    }

    public DialogContext getDialog(String strID) throws Exception {
        return this.getDialog(Integer.parseInt(strID));
    }

    public DialogContext getDialog(int intID) throws Exception {
        if (this.getDialogMap().containsKey(intID)) {
            return this.getDialogMap().get(intID);
        }
        throw new SystemException(this.getClass(), "Dialog not found.");
    }

    public Object getModuleInfo(String strKey) throws Exception {
        return this.mapModInfo.get(strKey);
    }

    public Map<String, ?> getUploadInfo(int fileUploadKey, String filterFID) throws SystemException {
        try {
            ServiceMData dlgModuleFileService = ServiceRegistry.getService((String)"module_file", (int)0);
            Map params = Map.ofEntries(Map.entry("module_key", this.getKey()), Map.entry("file_upload_key", fileUploadKey), Map.entry("obj_id", filterFID));
            ServiceRequest req = dlgModuleFileService.createRequest("get_upload_info", params);
            Map res = (Map)this.wgContext.getServiceProvider().execRequest(req).getResult();
            return res;
        }
        catch (Exception e) {
            throw new SystemException(this.getClass(), (Throwable)e);
        }
    }

    public void deleteServerDocument(Integer fileUploadKey, String strID) throws ServiceException {
        ServiceMData dlgFileService = ServiceRegistry.getService((String)"module_file", (int)0);
        Map params = Map.ofEntries(Map.entry("module_key", this.getKey()), Map.entry("file_upload_key", fileUploadKey), Map.entry("obj_id", strID));
        ServiceRequest req = dlgFileService.createRequest("delete_file", params);
        this.wgContext.getServiceProvider().execRequest(req);
    }

    public void updateDMSDocument(int fileUploadKey, String strID, DMSDocument dmsDocument) throws ServiceException {
        ServiceMData dlgFileService = ServiceRegistry.getService((String)"module_file", (int)0);
        Map params = Map.ofEntries(Map.entry("module_key", this.getKey()), Map.entry("file_upload_key", fileUploadKey), Map.entry("obj_id", strID), Map.entry("upload_filename", dmsDocument.buildURI()), Map.entry("upload_type", FieldFileStorageType.UT_DMS.getIdentificator()));
        ServiceRequest req = dlgFileService.createRequest("upload_file", params);
        this.wgContext.getServiceProvider().execRequest(req);
    }

    public File downloadFromServer(int fileUploadKey, String strFilterID, File destFile) throws SystemException {
        try {
            ServiceMData dlgFileService = ServiceRegistry.getService((String)"module_file", (int)0);
            Map params = Map.ofEntries(Map.entry("module_key", this.getKey()), Map.entry("file_upload_key", fileUploadKey), Map.entry("obj_id", strFilterID));
            ServiceRequest req = dlgFileService.createRequest("get_file", params);
            FileStreamProcessor fproc = new FileStreamProcessor(destFile);
            req.setStreamProcessor((StreamProcessor)fproc);
            ServiceRequest svcRequest = this.wgContext.getServiceProvider().execRequest(req);
            File expFile = (File)svcRequest.getResult();
            return expFile != null && expFile.exists() ? expFile : null;
        }
        catch (Exception e) {
            throw new SystemException(this.getClass(), (Throwable)e);
        }
    }
}

