/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.webgiscli.module;

import de.riwagis.gis.context.module.MenuContext;
import de.riwagis.util.exception.SystemException;
import de.riwagis.util.gui.GUISupport;
import de.riwagis.webgiscli.WebGisContext;
import de.riwagis.webgiscli.module.WebGisModule;
import de.riwagis.webgiscli.module.bsh.BshMenuRuntime;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import org.apache.commons.lang.StringUtils;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebGisMenu
implements MenuContext {
    public static final String DEFAULTVALUE_UNDEFINED = "undefined";
    public static final String ELEM_ITEM = "item";
    public static final String ELEM_MNEMONIC = "mnemonic";
    public static final String ELEM_NAME = "name";
    public static final String ELEM_ON_CLICK = "on_click";
    public static final String ELEM_PICTURE = "picture";
    public static final String ELEM_PRIO = "prio";
    public static final String ELEM_SEPARATOR = "separator";
    public static final String ELEM_SUBMENU = "submenu";
    public static final String THREADNAME_MENUCONTEXTPICTURELOADER = "MenuContextPictureLoader";
    private static final Logger LOG = LoggerFactory.getLogger(WebGisMenu.class);
    public static final Namespace NS_XMEN = Namespace.getNamespace((String)"http://www.riwagis.de/xmen");
    private final WebGisModule wgMod;
    private final int intMenuKey;
    private final WebGisContext wgContext;
    private final Document menuDoc;
    private int intPrio = -1;
    private String strName = null;

    public WebGisMenu(Document _menuDoc, int _intMenuKey, WebGisModule _wgMod, WebGisContext _wgContext) throws SystemException {
        this.intMenuKey = _intMenuKey;
        this.wgMod = _wgMod;
        this.wgContext = _wgContext;
        this.menuDoc = _menuDoc;
        JMenu topMenu = this.processDocument(this.menuDoc);
    }

    private ActionListener buildActionListener(final String strOnClick) {
        return new ActionListener(){
            private BshMenuRuntime rt = null;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (this.rt == null) {
                    try {
                        this.rt = BshMenuRuntime.getInstance(strOnClick, WebGisMenu.this.wgContext, WebGisMenu.this.wgMod.getKey());
                    }
                    catch (Exception ex) {
                        LOG.error(String.format("error creating function '%s' (Module: %d, Menukey: %d): %s", strOnClick, WebGisMenu.this.wgMod.getKey(), WebGisMenu.this.intMenuKey, ex.getMessage()), (Throwable)ex);
                        GUISupport.msgbox(null, (String)MessageFormat.format("Fehler beim Erzeugen der Funktion:\nFehlermeldung: ''{0}''", ex.getMessage()), (String)"Fehler");
                        return;
                    }
                }
                this.rt.onClick();
            }
        };
    }

    private JMenu processDocument(Document doc) throws SystemException {
        try {
            String strOnClick;
            String strMnemonic;
            Element root = doc.getRootElement();
            this.strName = StringUtils.defaultString((String)root.getChildTextTrim(ELEM_NAME, NS_XMEN), (String)DEFAULTVALUE_UNDEFINED);
            final JMenu currMenu = new JMenu(this.strName);
            final String strPicture = root.getChildTextTrim(ELEM_PICTURE, NS_XMEN);
            Runnable runImgLoad = new Runnable(){

                @Override
                public void run() {
                    ImageIcon icon = null;
                    if (StringUtils.isNotBlank((String)strPicture)) {
                        try {
                            icon = new ImageIcon(WebGisMenu.this.wgMod.getPicture(strPicture));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (icon != null) {
                        final ImageIcon finIcon = icon;
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                currMenu.setIcon(finIcon);
                                currMenu.firePropertyChange("icon", false, true);
                            }
                        });
                    }
                }
            };
            Thread thImgLoader = new Thread(runImgLoad, THREADNAME_MENUCONTEXTPICTURELOADER);
            String strPrio = root.getChildTextTrim(ELEM_PRIO, NS_XMEN);
            if (StringUtils.isNotBlank((String)strPrio)) {
                this.intPrio = Integer.parseInt(strPrio);
            }
            if (StringUtils.isNotBlank((String)(strMnemonic = root.getChildTextTrim(ELEM_MNEMONIC, NS_XMEN)))) {
                currMenu.setMnemonic(strMnemonic.charAt(0));
            }
            if (StringUtils.isNotBlank((String)(strOnClick = root.getChildTextTrim(ELEM_ON_CLICK, NS_XMEN)))) {
                currMenu.addActionListener(this.buildActionListener(strOnClick));
            }
            for (Object chElemObj : root.getChildren()) {
                Element chElem = (Element)chElemObj;
                String elemName = chElem.getName();
                if (elemName == null) continue;
                if (elemName.equals(ELEM_ITEM)) {
                    currMenu.add(this.processItemElement(chElem));
                }
                if (elemName.equals(ELEM_SEPARATOR)) {
                    currMenu.addSeparator();
                }
                if (!elemName.equals(ELEM_SUBMENU)) continue;
                currMenu.add(this.processSubmenuElement(chElem));
            }
            thImgLoader.start();
            return currMenu;
        }
        catch (Exception e) {
            throw new SystemException(this.getClass(), (Throwable)e);
        }
    }

    private JMenuItem processSubmenuElement(Element elem) throws SystemException {
        try {
            String strMnemonic;
            JMenu sub = null;
            String strSumName = elem.getChildTextTrim(ELEM_NAME, NS_XMEN);
            if (strSumName == null) {
                strSumName = DEFAULTVALUE_UNDEFINED;
            }
            sub = new JMenu(strSumName);
            String strPicture = elem.getChildTextTrim(ELEM_PICTURE, NS_XMEN);
            ImageIcon icon = null;
            if (StringUtils.isNotBlank((String)strPicture)) {
                try {
                    icon = new ImageIcon(this.wgMod.getPicture(strPicture));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (icon != null) {
                sub.setIcon(icon);
            }
            if (StringUtils.isNotBlank((String)(strMnemonic = elem.getChildTextTrim(ELEM_MNEMONIC, NS_XMEN)))) {
                sub.setMnemonic(strMnemonic.charAt(0));
            }
            for (Object chElemObj : elem.getChildren()) {
                Element chElem = (Element)chElemObj;
                String elemName = chElem.getName();
                if (elemName.equals(ELEM_ITEM)) {
                    sub.add(this.processItemElement(chElem));
                }
                if (elemName.equals(ELEM_SEPARATOR)) {
                    sub.addSeparator();
                }
                if (!elemName.equals(ELEM_SUBMENU)) continue;
                sub.add(this.processSubmenuElement(chElem));
            }
            return sub;
        }
        catch (Exception e) {
            throw new SystemException(this.getClass(), (Throwable)e);
        }
    }

    private JMenuItem processItemElement(Element elem) throws SystemException {
        try {
            String strOnClick;
            String strItemName = StringUtils.defaultString((String)elem.getChildTextTrim(ELEM_NAME, NS_XMEN), (String)DEFAULTVALUE_UNDEFINED);
            LOG.debug(String.format("Generating menu: %s (%d)", strItemName, this.wgMod.getKey()));
            String strPicture = elem.getChildTextTrim(ELEM_PICTURE, NS_XMEN);
            ImageIcon icon = null;
            if (StringUtils.isNotBlank((String)strPicture)) {
                try {
                    icon = new ImageIcon(this.wgMod.getPicture(strPicture));
                }
                catch (Exception e) {
                    LOG.warn(String.format("Error creating icon '%s' for menuitem '%s': %s", strPicture, strItemName, e.getMessage()));
                }
            }
            JMenuItem item = new JMenuItem(strItemName, icon);
            String strMnemonic = elem.getChildTextTrim(ELEM_MNEMONIC, NS_XMEN);
            if (StringUtils.isNotBlank((String)strMnemonic)) {
                item.setMnemonic(strMnemonic.charAt(0));
            }
            if (StringUtils.isNotBlank((String)(strOnClick = elem.getChildTextTrim(ELEM_ON_CLICK, NS_XMEN)))) {
                item.addActionListener(this.buildActionListener(strOnClick));
            }
            return item;
        }
        catch (Exception e) {
            throw new SystemException(this.getClass(), (Throwable)e);
        }
    }

    public int getKey() {
        return this.intMenuKey;
    }

    public int getPrio() {
        return this.intPrio;
    }

    public String getName() {
        return this.strName;
    }

    public JMenu buildMenu() throws Exception {
        return this.processDocument(this.menuDoc);
    }
}

