/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.webgiscli.module;

import de.riwagis.browser.WindowManager;
import de.riwagis.service.ServiceException;
import de.riwagis.service.ServiceMData;
import de.riwagis.service.ServiceRequest;
import de.riwagis.service.registry.ServiceRegistry;
import de.riwagis.util.Config;
import de.riwagis.util.Whiteboard;
import de.riwagis.util.gui.ExceptionDialog;
import de.riwagis.util.gui.GUISupport;
import de.riwagis.util.gui.components.WaitDialog;
import de.riwagis.util.i18n.I18N;
import de.riwagis.webgiscli.WebGisContext;
import de.riwagis.webgiscli.module.WebGisModule;
import de.riwagis.webgiscli.module.dialog.AbstractHtmlSPWG;
import de.riwagis.webgiscli.module.dialog.messaging.SPMessage;
import java.awt.Component;
import java.awt.Window;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;

public class WebGisImp {
    public static final String MODIMPINFO_URL_AFTER_UPLOAD = "url_after_upload";
    private static final String MODIMPINFO_DLG_AFTER_UPLOAD = "dlg_after_upload";
    private static final String KEY_DIR = WebGisImp.class.getName() + "_Dir";
    private static final I18N i18n = new I18N(Config.LOCALE, "de.riwagis.webgiscli.i18n.i18n");
    private final Map<?, ?> mapInfo;
    private final ServiceMData impService = ServiceRegistry.getService((String)"import", (int)0);
    private final int intModuleKey;
    private final int intImportKey;
    private final boolean boolMultiSelection;

    public WebGisImp(int _intModuleKey, int _intImportKey) throws ServiceException {
        this(_intModuleKey, _intImportKey, false);
    }

    public WebGisImp(int _intModuleKey, int _intImportKey, boolean multiSelection) throws ServiceException {
        this.intModuleKey = _intModuleKey;
        this.intImportKey = _intImportKey;
        this.boolMultiSelection = multiSelection;
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("module_key", this.intModuleKey);
        params.put("import_key", this.intImportKey);
        ServiceRequest req = this.impService.createRequest("get_import_info", params);
        this.mapInfo = (Map)WebGisContext.getInstance().getServiceProvider().execRequest(req).getResult();
    }

    public void impFile() {
        this.impFile(null);
    }

    public void impFile(File defaultFile) {
        try {
            File[] fileArray;
            File preSelImpFile;
            JFileChooser fileChoose = GUISupport.createJFileChooser();
            String strFilter = (String)this.mapInfo.get("modimp_file_extension");
            if (strFilter.isEmpty()) {
                for (FileFilter arrFilt1 : fileChoose.getChoosableFileFilters()) {
                    fileChoose.removeChoosableFileFilter(arrFilt1);
                }
                fileChoose.setAcceptAllFileFilterUsed(true);
            } else {
                FileFilter filt = GUISupport.createFileFilter((String)"Import-File", (String[])strFilter.split(","));
                fileChoose.setAcceptAllFileFilterUsed(false);
                fileChoose.setFileFilter(filt);
            }
            fileChoose.setMultiSelectionEnabled(this.boolMultiSelection);
            Whiteboard wb = WebGisContext.getInstance().getPermWhiteboard();
            File file = preSelImpFile = defaultFile == null ? new File(ObjectUtils.toString((Object)wb.getAttribute(KEY_DIR, (Object)""), (String)"")) : defaultFile;
            if (preSelImpFile.isFile()) {
                fileChoose.setSelectedFile(preSelImpFile);
            } else {
                fileChoose.setCurrentDirectory(preSelImpFile);
            }
            GUISupport.centreOnScreen((Component)fileChoose);
            int intOption = fileChoose.showDialog(WebGisContext.getInstance().getWebGisClient().getFrame(), i18n.get("module.WebGisImp.import"));
            if (intOption == 1) {
                return;
            }
            if (fileChoose.isMultiSelectionEnabled()) {
                fileArray = fileChoose.getSelectedFiles();
            } else {
                File[] fileArray2 = new File[1];
                fileArray = fileArray2;
                fileArray2[0] = fileChoose.getSelectedFile();
            }
            File[] selectedFiles = fileArray;
            wb.setAttribute(KEY_DIR, (Object)selectedFiles[0].getParent());
            WebGisContext.getInstance().writePermWhiteboard();
            WaitDialog dlgWait = WaitDialog.createWaitDialog((Window)WebGisContext.getInstance().getWebGisClient().getFrame(), (String)i18n.get("module.WebGisImp.wait-for-upload"), () -> {
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("module_key", this.intModuleKey);
                params.put("import_key", this.intImportKey);
                if (selectedFiles.length == 1) {
                    params.put("import_file", selectedFiles[0]);
                } else {
                    params.put("import_files", Arrays.asList(selectedFiles));
                }
                params.put("import_filepath", selectedFiles.length == 1 ? selectedFiles[0].getPath() : selectedFiles[0].getParentFile().getPath());
                ServiceRequest req = selectedFiles.length == 1 ? this.impService.createRequest("import_file", params) : this.impService.createRequest("import_multi_file", params);
                return WebGisContext.getInstance().getServiceProvider().execRequest(req).getResult();
            });
            dlgWait.setCancelable(false);
            dlgWait.setVisible(true);
            if (dlgWait.getError() != null) {
                throw dlgWait.getError();
            }
            String urlAfterUpload = ObjectUtils.toString(this.mapInfo.get(MODIMPINFO_URL_AFTER_UPLOAD));
            String dlgAfterUpload = ObjectUtils.toString(this.mapInfo.get(MODIMPINFO_DLG_AFTER_UPLOAD));
            if (StringUtils.isBlank((String)urlAfterUpload) && StringUtils.isBlank((String)dlgAfterUpload)) {
                GUISupport.msgbox((Component)WebGisContext.getInstance().getWebGisClient().getFrame(), (String)i18n.get("module.WebGisImp.ready"), (String)i18n.get("common.message"));
                WindowManager.getInstance().openWindow("modules/system/imp/import_log.jsp", "imp_log", 500, 500);
            } else {
                if (!StringUtils.isBlank((String)urlAfterUpload)) {
                    WindowManager.getInstance().openWindow(urlAfterUpload, "imp_" + this.intImportKey + "_" + this.intModuleKey, 500, 500);
                }
                if (!StringUtils.isBlank((String)dlgAfterUpload)) {
                    WebGisModule module = WebGisContext.getInstance().getModule(this.intModuleKey);
                    AbstractHtmlSPWG dialog = (AbstractHtmlSPWG)module.getDialog(dlgAfterUpload);
                    dialog.show();
                    dialog.sendMessage(new SPMessage(dialog.getID(), "importExecuted", String.format("[%d, %d]", this.intModuleKey, this.intImportKey)));
                }
            }
        }
        catch (Exception e) {
            ExceptionDialog.handleGuiException((Component)WebGisContext.getInstance().getWebGisClient().getFrame(), (Throwable)e, (String)"webgiscli");
        }
    }
}

