/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.webgiscli.login.handlers;

import com.sun.jna.platform.win32.Sspi;
import com.sun.jna.platform.win32.SspiUtil;
import de.riwagis.service.ServiceException;
import de.riwagis.service.ServiceMData;
import de.riwagis.service.ServiceRequest;
import de.riwagis.service.registry.ServiceRegistry;
import de.riwagis.util.Support;
import de.riwagis.util.exception.SystemException;
import de.riwagis.webgiscli.login.LoginInfo;
import de.riwagis.webgiscli.login.handlers.LoginHandlerDefault;
import de.riwagis.webgiscli.service.http.HttpServiceProvider;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import waffle.windows.auth.IWindowsCredentialsHandle;
import waffle.windows.auth.impl.WindowsAccountImpl;
import waffle.windows.auth.impl.WindowsCredentialsHandleImpl;
import waffle.windows.auth.impl.WindowsSecurityContextImpl;

public class LoginHandlerSingleSignOn
extends LoginHandlerDefault {
    public LoginHandlerSingleSignOn(LoginInfo loginInfo, HttpServiceProvider sp) {
        super(loginInfo, sp);
    }

    @Override
    public boolean needsCredentials() {
        return false;
    }

    @Override
    public boolean useWindowsPwd() {
        return false;
    }

    @Override
    public Map<String, Object> doLogin() throws SystemException {
        try {
            boolean continueServer;
            if (Support.isLinux()) {
                throw new SystemException("Single sign-on is not supported on this server.");
            }
            ServiceMData svc = ServiceRegistry.getService((String)"http-login", (int)0);
            ServiceRequest targetNameRequest = svc.createRequest("single_signon_servertoken", new HashMap());
            List targetNameResponse = (List)this.getHttpServiceProvider().execRequest(targetNameRequest, false, false).getResult();
            String targetName = (String)targetNameResponse.get(0);
            String securityPackage = "Negotiate";
            IWindowsCredentialsHandle clientCredentials = WindowsCredentialsHandleImpl.getCurrent((String)"Negotiate");
            clientCredentials.initialize();
            WindowsSecurityContextImpl clientContext = new WindowsSecurityContextImpl();
            clientContext.setPrincipalName(WindowsAccountImpl.getCurrentUsername());
            clientContext.setCredentialsHandle(clientCredentials);
            clientContext.setSecurityPackage("Negotiate");
            clientContext.initialize(null, null, targetName);
            byte[] serverToken = null;
            do {
                if (serverToken != null) {
                    SspiUtil.ManagedSecBufferDesc continueToken = new SspiUtil.ManagedSecBufferDesc(2, serverToken);
                    clientContext.initialize(clientContext.getHandle(), (Sspi.SecBufferDesc)continueToken, "localhost");
                }
                HashMap<String, byte[]> mapParam = new HashMap<String, byte[]>();
                mapParam.put("client_token", clientContext.getToken());
                ServiceRequest echoRequest = svc.createRequest("single_signon_servertoken", mapParam);
                List serverResponse = (List)this.getHttpServiceProvider().execRequest(echoRequest, false, false).getResult();
                continueServer = (Boolean)serverResponse.get(0);
                serverToken = (byte[])serverResponse.get(1);
            } while (continueServer);
            clientCredentials.dispose();
            clientContext.dispose();
        }
        catch (ServiceException se) {
            throw new SystemException((Throwable)se);
        }
        return super.doLogin();
    }

    @Override
    public boolean canChangePassword() {
        return false;
    }
}

