/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.webgiscli.login.handlers;

import de.riwagis.browser.WindowManager;
import de.riwagis.service.ServiceException;
import de.riwagis.service.ServiceMData;
import de.riwagis.service.ServiceRequest;
import de.riwagis.service.registry.ServiceRegistry;
import de.riwagis.util.exception.SystemException;
import de.riwagis.webgiscli.WebGisClient;
import de.riwagis.webgiscli.WebGisContext;
import de.riwagis.webgiscli.login.LoginCredentials;
import de.riwagis.webgiscli.login.LoginCredentialsUtils;
import de.riwagis.webgiscli.login.LoginInfo;
import de.riwagis.webgiscli.login.LoginUtils;
import de.riwagis.webgiscli.login.handlers.AbstractLoginHandler;
import de.riwagis.webgiscli.service.http.HttpServiceProvider;
import java.security.GeneralSecurityException;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoginHandlerDefault
extends AbstractLoginHandler {
    private static final Logger LOG = LoggerFactory.getLogger(LoginHandlerDefault.class);

    public LoginHandlerDefault(LoginInfo loginInfo, HttpServiceProvider sp) {
        super(loginInfo, sp);
    }

    @Override
    public boolean needsCredentials() {
        return true;
    }

    @Override
    public boolean useWindowsPwd() {
        return false;
    }

    @Override
    public String isValidPassword(String username, String newPwd) throws SystemException {
        try {
            StopWatch sw = new StopWatch();
            Map<String, String> mapParam = Map.of("name", username, "pwd_new", newPwd);
            ServiceMData svc = ServiceRegistry.getService((String)"http-login", (int)0);
            ServiceRequest rqPasswordValiditiy = svc.createRequest("validate_user_password", mapParam);
            sw.start();
            this.getHttpServiceProvider().execRequest(rqPasswordValiditiy);
            sw.stop();
            LOG.trace(String.format("elapsed time for checking password: %d ms", sw.getTime()));
            Map serviceResult = (Map)rqPasswordValiditiy.getResult();
            Object validFlag = serviceResult.get("valid");
            boolean res = Boolean.getBoolean(Objects.toString(validFlag));
            return res ? "" : Objects.toString(serviceResult.get("errText"), "");
        }
        catch (ServiceException se) {
            throw new SystemException((Throwable)se);
        }
    }

    @Override
    public Map<String, Object> doLogin() throws SystemException {
        try {
            if (this.getLoginInfo().isPerformLogin()) {
                LoginCredentialsUtils.handleLoginCredentials(WebGisContext.getInstance().getPermWhiteboard(), this.getLoginInfo());
                LoginCredentials creds = this.getLoginInfo().getLoginCredentials();
                String strAdminPwd = LoginCredentialsUtils.readAdminPwd(WebGisContext.getInstance().getPermWhiteboard(), LoginCredentialsUtils.determineDefaultSuffix());
                String machineKey = LoginCredentialsUtils.provideMachineKey(WebGisContext.getInstance().getPermWhiteboard());
                ServiceRequest<?> rqLogin = LoginUtils.buildLoginRequest(creds, strAdminPwd, machineKey, this.getLoginInfo().getServerInfo().isLdap(this.getHttpServiceProvider()), this.getLoginInfo().getSubUser());
                long timestart = System.currentTimeMillis();
                this.getHttpServiceProvider().execRequest(rqLogin, false, true);
                long timeend = System.currentTimeMillis();
                LOG.trace(String.format("elapsed time for login: %d ms", timeend - timestart));
                Map result = (Map)rqLogin.getResult();
                if (result != null && !result.containsKey("error")) {
                    this.getHttpServiceProvider().getUserInfo().clear();
                    this.getHttpServiceProvider().getUserInfo().putAll(result);
                    if (WebGisClient.GIS_CONTEXT != null) {
                        try {
                            WindowManager.getInstance().closeAll();
                            WebGisContext.getInstance().clearAllCaches();
                            if (WebGisClient.GIS_CONTEXT.getMapApp() != null) {
                                WebGisClient.GIS_CONTEXT.getMapApp().reloadModuleContext();
                            }
                        }
                        catch (Exception ex) {
                            LOG.warn(String.format("unable to reload module context: %s", ex.getMessage()), (Throwable)ex);
                        }
                    }
                }
                return result;
            }
            throw new SystemException("Should never reach here. doLogin should not be called when performing login is forbidden.");
        }
        catch (ServiceException | GeneralSecurityException se) {
            throw new SystemException(se);
        }
    }

    @Override
    public boolean canChangePassword() {
        return !this.getLoginInfo().getServerInfo().isLdap(this.getHttpServiceProvider());
    }

    @Override
    public boolean doLogout() {
        try {
            ServiceMData svcMData = ServiceRegistry.getService((String)"http-login", (int)0);
            ServiceRequest reqLogout = svcMData.createRequest("logout");
            this.getHttpServiceProvider().execRequest(reqLogout, false, false);
            reqLogout.getResult();
            return true;
        }
        catch (ServiceException e1) {
            LOG.error("Error at logout", (Throwable)e1);
            return false;
        }
    }
}

