/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.webgiscli.login.gui;

import de.riwagis.service.ServiceException;
import de.riwagis.service.ServiceMData;
import de.riwagis.service.ServiceProvider;
import de.riwagis.service.registry.ServiceRegistry;
import de.riwagis.util.Config;
import de.riwagis.util.gui.dialogs.ExpandableDialog;
import de.riwagis.util.i18n.I18N;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserWarningsListener
implements ActionListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UserWarningsListener.class);
    private static final String USR_HAS_MOD_ERROR = "usr_has_mod_error";
    private static final String USR_HAS_MOD_DEACTIVATED = "usr_has_mod_deactivated";
    public static final String USR_HAS_SERVER_WARNINGS = "usr_has_server_warnings";
    private static final String MOD_LINK_MOD_ADMIN_NAME = "mod_link_mod_admin_name";
    private static final String MOD_KEY = "mod_key";
    private static final String MOD_NAME = "mod_name";
    private static final String MOD_INACTIVE_REASON = "mod_inactive_reason";
    private static final String MOD_EXCEPTION_ON_INIT = "mod_exception_on_init";
    private static final String MOD_REASON_INACTIVE = "INACTIVE";
    private static final String MOD_REASON_INACTIVE_STRUCTURE = "INACTIVE_STRUCTURE";
    private static final String MOD_REASON_INIT_EXCEPTION = "INIT_EXCEPTION";
    private static final String MOD_REASON_DEV_MODE_ERROR = "DEV_MODE_ERROR";
    private static final I18N i18n = new I18N(Config.LOCALE, "de.riwagis.webgiscli.i18n.i18n");
    private final ServiceMData moduleService = ServiceRegistry.getService((String)"module", (int)0);
    private final ServiceMData loginService = ServiceRegistry.getService((String)"http-login", (int)0);
    private final ServiceProvider serviceProvider;
    private final Frame parentFrame;

    public UserWarningsListener(ServiceProvider serviceProvider, Frame parentFrame) {
        this.serviceProvider = serviceProvider;
        this.parentFrame = parentFrame;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.checkModuleErrors();
    }

    private void checkModuleErrors() {
        Map userInfo = this.serviceProvider.getUserInfo();
        boolean hasModuleErrors = userInfo.getOrDefault(USR_HAS_MOD_ERROR, false);
        boolean hasModuleDeactivated = userInfo.getOrDefault(USR_HAS_MOD_DEACTIVATED, false);
        boolean hasServerWarnings = userInfo.getOrDefault(USR_HAS_SERVER_WARNINGS, false);
        if (hasModuleDeactivated) {
            log.warn("Some modules are deactivated and therefore not loaded");
        }
        if (hasModuleErrors) {
            log.warn("Some modules have thrown error(s) and are therefore not loaded");
        }
        if (hasServerWarnings) {
            log.warn("There are server warnings for the current user");
        }
        if (!(hasModuleDeactivated || hasModuleErrors || hasServerWarnings)) {
            return;
        }
        try {
            ArrayList<HashMap<String, Object>> modsWithErrors = hasModuleErrors ? this.doModuleServiceCall("get_modules_error") : new ArrayList<HashMap<String, Object>>();
            ArrayList<HashMap<String, Object>> modsDeactivated = hasModuleDeactivated ? this.doModuleServiceCall("get_modules_deactivated") : new ArrayList<HashMap<String, Object>>();
            ArrayList<HashMap<String, Object>> userWarnings = hasServerWarnings ? this.doLoginServiceCall("get_user_warning") : new ArrayList<HashMap<String, Object>>();
            List<HashMap<String, Object>> modsWithDevModeErrors = modsWithErrors.stream().filter(map -> MOD_REASON_DEV_MODE_ERROR.equals(map.get(MOD_INACTIVE_REASON))).collect(Collectors.toList());
            List modsWithInitExceptions = modsWithErrors.stream().filter(map -> MOD_REASON_INIT_EXCEPTION.equals(map.get(MOD_INACTIVE_REASON))).collect(Collectors.toList());
            ArrayList<String> headings = new ArrayList<String>();
            StringJoiner detailsJoiner = new StringJoiner("<hr>");
            if (!modsWithDevModeErrors.isEmpty() || !userWarnings.isEmpty()) {
                headings.add(String.format("%s", i18n.get("de.riwagis.webgiscli.module.gui.MissingModulesListener.error-message-common-warnings")));
                if (!userWarnings.isEmpty()) {
                    detailsJoiner.add(String.format("<h3>%s:</h3>%s<br/>", i18n.get("de.riwagis.webgiscli.module.gui.MissingModulesListener.error-message-common-warnings-sub-header"), this.userWarningToString(userWarnings)));
                }
                if (!modsWithDevModeErrors.isEmpty()) {
                    detailsJoiner.add(String.format("<h3>%s:</h3>%s<br/>", i18n.get("de.riwagis.webgiscli.module.gui.MissingModulesListener.error-message-sub-heading-dev-mode-error"), this.moduleListToString(modsWithDevModeErrors)));
                }
            }
            if (!modsWithInitExceptions.isEmpty() || !modsDeactivated.isEmpty()) {
                headings.add(i18n.get("de.riwagis.webgiscli.module.gui.MissingModulesListener.error-message-not-all-modules-loaded"));
                detailsJoiner.add(String.format("<h3>%s:</h3>%s<br/>", i18n.get("de.riwagis.webgiscli.module.gui.MissingModulesListener.error-message-sub-heading-mod-not-loaded"), this.moduleListToString(ListUtils.union(modsWithInitExceptions, modsDeactivated))));
            }
            ExpandableDialog.showWarning((Component)this.parentFrame, (String)headings.stream().collect(Collectors.joining("<br/>")), (String)String.format("<html>%s</html>", detailsJoiner.toString()), (boolean)true);
        }
        catch (ServiceException e) {
            log.error("Module state could not be retrieved", (Throwable)e);
        }
    }

    private ArrayList<HashMap<String, Object>> doModuleServiceCall(String method) throws ServiceException {
        return (ArrayList)this.serviceProvider.execRequest(this.moduleService.createRequest(method, Collections.emptyMap())).getResult();
    }

    private ArrayList<HashMap<String, Object>> doLoginServiceCall(String method) throws ServiceException {
        return (ArrayList)this.serviceProvider.execRequest(this.loginService.createRequest(method, Collections.emptyMap())).getResult();
    }

    private String moduleListToString(List<HashMap<String, Object>> modules) {
        StringBuilder stringBuilder = new StringBuilder();
        for (HashMap<String, Object> entry : modules) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("<br/>");
            }
            stringBuilder.append(i18n.get("de.riwagis.webgiscli.module.gui.MissingModulesListener.error-detail-name")).append(": ").append(entry.get(MOD_LINK_MOD_ADMIN_NAME)).append("<br/>").append(i18n.get("de.riwagis.webgiscli.module.gui.MissingModulesListener.error-detail-module")).append(": ").append(entry.get(MOD_KEY)).append(" - ").append(entry.get(MOD_NAME)).append("<br/>").append(i18n.get("de.riwagis.webgiscli.module.gui.MissingModulesListener.error-detail-reason")).append(": ").append(this.mapReason((String)entry.get(MOD_INACTIVE_REASON), (String)entry.get(MOD_EXCEPTION_ON_INIT))).append("<br/>");
        }
        return stringBuilder.toString();
    }

    private String userWarningToString(List<HashMap<String, Object>> userWarnings) {
        StringBuilder stringBuilder = new StringBuilder();
        for (HashMap<String, Object> userWarning : userWarnings) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("<br/>");
            }
            stringBuilder.append(userWarning.get("warning_message")).append("<br/>");
        }
        return stringBuilder.toString();
    }

    private String mapReason(String reasonCode, String errorMessage) {
        switch (reasonCode) {
            case "INACTIVE": {
                return i18n.get("de.riwagis.webgiscli.module.gui.MissingModulesListener.error-reason-inactive");
            }
            case "INACTIVE_STRUCTURE": {
                return i18n.get("de.riwagis.webgiscli.module.gui.MissingModulesListener.error-reason-structure-inactive");
            }
            case "INIT_EXCEPTION": 
            case "DEV_MODE_ERROR": {
                if (StringUtils.isNotBlank((CharSequence)errorMessage)) {
                    return StringUtils.replace((String)errorMessage.trim(), (String)System.lineSeparator(), (String)"<br/>");
                }
                return i18n.get("de.riwagis.webgiscli.module.gui.MissingModulesListener.error-reason-init-exception");
            }
        }
        return i18n.get("de.riwagis.webgiscli.module.gui.MissingModulesListener.error-reason-unknown");
    }
}

