/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.webgiscli.login.gui;

import de.riwagis.util.Config;
import de.riwagis.util.exception.SystemException;
import de.riwagis.util.gui.GUIException;
import de.riwagis.util.gui.GUISupport;
import de.riwagis.util.i18n.I18N;
import de.riwagis.webgiscli.WebGisClient;
import de.riwagis.webgiscli.login.gui.ChangePasswordDialog;
import de.riwagis.webgiscli.service.http.LoginResult;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import org.apache.commons.lang3.StringUtils;

public class InvalidLoginDialog
extends JDialog {
    private static final I18N i18n = new I18N(Config.LOCALE, "de.riwagis.webgiscli.i18n.i18n");
    private LoginResult intReturnCode = LoginResult.EXIT_PROGRAM;
    private JButton butAdminLogin;
    private JButton butAgain;
    private JButton butExit;
    private JButton butNewPwd;
    private JLabel lblMessage;
    private JTextArea txtServerMsg;

    public InvalidLoginDialog(Dialog parent, String errorText) {
        super(parent, true);
        this.initComponents();
        this.i18n();
        this.txtServerMsg.setText(ChangePasswordDialog.formatErrorMessageHTML(List.of(errorText.split("[\\n\\r]"))));
        this.init();
    }

    private void i18n() {
        this.setTitle(i18n.get("gui.InvalidLoginDialog.title"));
        this.lblMessage.setText(i18n.get("gui.InvalidLoginDialog.message"));
        this.butAgain.setText(i18n.get("gui.InvalidLoginDialog.again"));
        this.butAdminLogin.setText(i18n.get("gui.InvalidLoginDialog.admin-pwd"));
        this.butNewPwd.setText(i18n.get("gui.InvalidLoginDialog.new-pwd"));
        this.butExit.setText(i18n.get("gui.InvalidLoginDialog.exit-program"));
    }

    private void init() {
        this.pack();
        this.setResizable(false);
        GUISupport.centreOnScreen((Component)this);
    }

    public LoginResult getReturnCode() {
        return this.intReturnCode;
    }

    private void initComponents() {
        this.lblMessage = new JLabel();
        this.txtServerMsg = new JTextArea();
        this.butAgain = new JButton();
        this.butAdminLogin = new JButton();
        this.butNewPwd = new JButton();
        this.butExit = new JButton();
        this.setDefaultCloseOperation(2);
        this.getContentPane().setLayout(new GridBagLayout());
        this.lblMessage.setText("<html>Ihre Anmeldung ist fehlgeschlagen. Bitte w\u00e4hlen Sie eine der unten genannten M\u00f6glichkeiten aus.<br><br>Fehlermeldung des Server:</html>");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(9, 9, 3, 9);
        this.getContentPane().add((Component)this.lblMessage, gridBagConstraints);
        this.txtServerMsg.setEditable(false);
        this.txtServerMsg.setBackground(new Color(240, 240, 240));
        this.txtServerMsg.setColumns(20);
        this.txtServerMsg.setFont(new Font("Tahoma", 1, 11));
        this.txtServerMsg.setForeground(new Color(255, 0, 0));
        this.txtServerMsg.setLineWrap(true);
        this.txtServerMsg.setRows(5);
        this.txtServerMsg.setText("Fehlermeldung");
        this.txtServerMsg.setWrapStyleWord(true);
        this.txtServerMsg.setFocusable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(9, 9, 3, 9);
        this.getContentPane().add((Component)this.txtServerMsg, gridBagConstraints);
        this.butAgain.setText("Anmeldung erneut versuchen");
        this.butAgain.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InvalidLoginDialog.this.butAgain_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(9, 9, 3, 9);
        this.getContentPane().add((Component)this.butAgain, gridBagConstraints);
        this.butAdminLogin.setText("Aktivierungscode eingeben");
        this.butAdminLogin.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InvalidLoginDialog.this.butAdminLogin_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 9, 3, 9);
        this.getContentPane().add((Component)this.butAdminLogin, gridBagConstraints);
        this.butNewPwd.setText("Passwort neu erzeugen und per Email zusenden");
        this.butNewPwd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InvalidLoginDialog.this.butNewPwd_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 9, 3, 9);
        this.getContentPane().add((Component)this.butNewPwd, gridBagConstraints);
        this.butExit.setText("Programm beenden");
        this.butExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InvalidLoginDialog.this.butExit_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(9, 9, 9, 9);
        this.getContentPane().add((Component)this.butExit, gridBagConstraints);
        this.pack();
    }

    private void butAdminLogin_onActionPerformed(ActionEvent evt) {
        this.intReturnCode = LoginResult.QUERY_ADMIN_PWD;
        this.setVisible(false);
    }

    private void butNewPwd_onActionPerformed(ActionEvent evt) {
        this.intReturnCode = LoginResult.SEND_NEW_PWD;
        this.setVisible(false);
    }

    private void butAgain_onActionPerformed(ActionEvent evt) {
        this.intReturnCode = LoginResult.RETRY_LOGIN;
        this.setVisible(false);
    }

    private void butExit_onActionPerformed(ActionEvent evt) {
        this.intReturnCode = LoginResult.EXIT_PROGRAM;
        this.setVisible(false);
    }

    public static LoginResult queryInvalidLoginAction(JDialog parent, String errorText) throws SystemException, GUIException {
        final InvalidLoginDialog invLoginDialog = new InvalidLoginDialog((Dialog)parent, errorText);
        try {
            GUISupport.executeSyncOnEventThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    boolean bolSplashVisible = false;
                    if (WebGisClient.getSplash().isVisible()) {
                        bolSplashVisible = true;
                        WebGisClient.getSplash().setVisible(false);
                    }
                    invLoginDialog.setVisible(true);
                    invLoginDialog.requestFocus();
                    if (bolSplashVisible) {
                        WebGisClient.getSplash().setVisible(true);
                        WebGisClient.getSplash().requestFocus();
                    }
                }
            });
        }
        finally {
            GUISupport.disposeQuietly((Window)invLoginDialog);
        }
        return invLoginDialog.getReturnCode();
    }

    public static void main(String[] args) {
        List<String> checkRes = List.of("Langer Text mit vielen vielen Zeichen um den Umbruch zu testen, weil das ja auch wichtig ist, um zu sehen ob das auch ordentlich angezeigt wird.", "Eine zweite Zeile mit einigen Zeichen ist auch nicht verkehrt, sonst sieht man ja das nicht.", "Zum Schluss noch 'ne dritte Zeile. Aller Guten Dinge sind drei!");
        InvalidLoginDialog dlg = new InvalidLoginDialog(null, StringUtils.join(checkRes, (String)"\n"));
        dlg.setModal(true);
        dlg.setVisible(true);
        dlg.dispose();
    }
}

