/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.webgiscli.login.gui;

import de.riwagis.browser.BrowserPanel;
import de.riwagis.browser.WindowManager;
import de.riwagis.icons.IconLoader;
import de.riwagis.service.ServiceException;
import de.riwagis.service.ServiceMData;
import de.riwagis.service.ServiceRequest;
import de.riwagis.service.registry.ServiceRegistry;
import de.riwagis.util.Config;
import de.riwagis.util.Support;
import de.riwagis.util.exception.SystemException;
import de.riwagis.util.file.FileSupport;
import de.riwagis.util.gui.ErrorBox;
import de.riwagis.util.gui.ExceptionDialog;
import de.riwagis.util.gui.GUISupport;
import de.riwagis.util.gui.components.WaitDialog;
import de.riwagis.util.http.ProxyDialog;
import de.riwagis.util.i18n.I18N;
import de.riwagis.webgiscli.WebGisClient;
import de.riwagis.webgiscli.WebGisConfiguration;
import de.riwagis.webgiscli.WebGisContext;
import de.riwagis.webgiscli.login.LoginCredentials;
import de.riwagis.webgiscli.login.LoginCredentialsUtils;
import de.riwagis.webgiscli.login.LoginInfo;
import de.riwagis.webgiscli.login.LoginUtils;
import de.riwagis.webgiscli.login.ServerInfo;
import de.riwagis.webgiscli.login.VersionStatus;
import de.riwagis.webgiscli.service.http.HttpServiceProvider;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.util.Collection;
import java.util.LinkedHashSet;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpLoginDialog
extends JDialog {
    private static final Logger LOG = LoggerFactory.getLogger(HttpLoginDialog.class);
    private static final int MIN_LENGTH_PWD = 5;
    private static final int MIN_LENGTH_USERNAME = 3;
    private static final I18N i18n = new I18N(Config.LOCALE, "de.riwagis.webgiscli.i18n.i18n");
    private final WebGisContext wgContext;
    private final HttpServiceProvider sp;
    private boolean bolBlockEvents = false;
    private BrowserPanel brPanel = null;
    private boolean bolPwdEncrypted = false;
    private final Collection<ActionListener> connectionChangedListeners = new LinkedHashSet<ActionListener>();
    private boolean performLogin = false;
    private ServerInfo serverInfo = null;
    private static final String ICON_VIEWER = "app-icon-viewer.ico";
    private boolean storeCredentials;
    private JButton butCancel;
    private JButton butLogin;
    private JCheckBox cboSaveLogin;
    private JComboBox<ServerInfo> cmbServer;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JLabel lblConfig;
    private JLabel lblLDAPInfo;
    private JLabel lblLogo;
    private JLabel lblNewPwd;
    private JLabel lblPwd;
    private JLabel lblServer;
    private JLabel lblUpdateVersion;
    private JLabel lblUser;
    private JLabel lblVersion;
    private JPanel pnlBrowser;
    private JPanel pnlLoginButtons;
    private JPanel pnlLogo;
    private JPanel pnlUserdata;
    private JPanel pnlVersion;
    private JPasswordField txtPwd;
    private JTextField txtUser;

    public HttpLoginDialog(WebGisContext _wgContext, HttpServiceProvider _sp, ActionListener serviceProviderActionListener) throws ServiceException {
        super((Window)null, Dialog.ModalityType.TOOLKIT_MODAL);
        this.wgContext = _wgContext;
        this.sp = _sp;
        if (serviceProviderActionListener != null) {
            this.addConnectionChangedListener(serviceProviderActionListener);
        }
        this.initComponents();
        this.i18n();
        this.init();
        GUISupport.setDefaultButton((JButton)this.butLogin, (int)10);
        try {
            this.setIconImages(IconLoader.getIconImagesOfIcoFile((String)ICON_VIEWER));
        }
        catch (IOException | IllegalArgumentException ex) {
            LOG.error("Could not read icons.", (Throwable)ex);
        }
        super.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                HttpLoginDialog.this.onConnectionChanged();
                HttpLoginDialog.this.loadCredentials();
            }

            @Override
            public void windowClosing(WindowEvent e) {
                HttpLoginDialog.this.brPanel.dispose();
            }
        });
    }

    private void init() throws ServiceException {
        this.brPanel = WindowManager.getInstance().createBrowserPanel();
        this.pnlBrowser.add((Component)this.brPanel, "Center");
        this.butLogin.setFont(this.butLogin.getFont().deriveFont(1));
        this.lblConfig.setCursor(new Cursor(12));
        this.lblNewPwd.setCursor(new Cursor(12));
        this.pnlVersion.setVisible(false);
        this.lblConfig.setVisible(FileSupport.canWrite((String)"."));
        this.lblLDAPInfo.setVisible(false);
        this.storeCredentials = this.parseStoreCredentialsFromConfig(this.wgContext);
        this.refillServerList();
    }

    private void refillServerList() throws ServiceException {
        this.bolBlockEvents = true;
        try {
            Collection<ServerInfo> knownServers = LoginUtils.readServerInfos();
            if (!knownServers.isEmpty()) {
                ServerInfo selectedServer = this.findPrevSelectedServerInfo(knownServers, (ServerInfo)this.cmbServer.getSelectedItem());
                this.cmbServer.removeAllItems();
                for (ServerInfo currServer : knownServers) {
                    this.cmbServer.addItem(currServer);
                }
                if (selectedServer != null) {
                    this.cmbServer.setSelectedItem(selectedServer);
                } else {
                    String serverName = LoginCredentialsUtils.readServerName(this.wgContext.getPermWhiteboard(), LoginCredentialsUtils.determineDefaultSuffix());
                    if (serverName != null) {
                        this.cmbServer.setSelectedIndex(this.findServerItemPosition(serverName));
                    }
                }
            } else {
                throw new SystemException(String.format("No server_url found in config file.", new Object[0]));
            }
            if (this.cmbServer.getItemCount() == 1) {
                this.cmbServer.setEnabled(false);
            }
        }
        catch (Exception e) {
            throw new ServiceException(String.format("error reading default server_url: %s", e.getMessage()), (Throwable)e);
        }
        finally {
            this.bolBlockEvents = false;
        }
    }

    private int findServerItemPosition(String serverName) {
        boolean isUrl = StringUtils.startsWithIgnoreCase((String)serverName, (String)"http");
        int pos = 0;
        int size = this.cmbServer.getItemCount();
        for (int i = 0; i < size; ++i) {
            ServerInfo item = this.cmbServer.getItemAt(i);
            if (isUrl) {
                String url = item.getServer() + item.getURI();
                if (!serverName.equalsIgnoreCase(url)) continue;
                pos = i;
                break;
            }
            if (!serverName.equalsIgnoreCase(item.getServerName())) continue;
            pos = i;
            break;
        }
        return pos;
    }

    private void loadCredentials() {
        LoginCredentials lc = null;
        if (this.storeCredentials) {
            try {
                lc = LoginCredentialsUtils.readLoginCredentials(this.wgContext.getPermWhiteboard(), LoginCredentialsUtils.determineDefaultSuffix());
            }
            catch (GeneralSecurityException ex) {
                LOG.error(String.format("Error reading LoginCredentials from context: %s", ex.getMessage()), (Throwable)ex);
            }
        }
        this.fillLogin(lc);
    }

    private void fillLogin(LoginCredentials lc) {
        this.bolBlockEvents = true;
        try {
            if (this.serverInfo != null && (this.serverInfo.isLdap(this.sp) || this.serverInfo.isSingleSignOnLogin())) {
                this.txtUser.setText(System.getProperty("user.name"));
                this.txtPwd.setText("");
            } else if (lc != null && this.serverInfo != null && !this.serverInfo.isLdap(this.sp)) {
                this.txtPwd.setText(lc.getEncryptedPassword());
                this.txtUser.setText(lc.getUsername());
                this.bolPwdEncrypted = true;
                this.cboSaveLogin.setSelected(true);
            }
        }
        catch (Exception e) {
            LOG.warn("error filling login", (Throwable)e);
        }
        finally {
            this.bolBlockEvents = false;
        }
    }

    public final void addConnectionChangedListener(ActionListener currListener) {
        if (currListener != null) {
            this.connectionChangedListeners.add(currListener);
        }
    }

    public final void removeConnectionChangedListener(ActionListener currListener) {
        if (currListener != null) {
            this.connectionChangedListeners.remove(currListener);
        }
    }

    private void onConnectionChanged() {
        final WaitDialog dlgWait = new WaitDialog((Window)this, i18n.get("common.wait"));
        dlgWait.addWorkToDo(new Runnable(){

            @Override
            public void run() {
                try {
                    ServerInfo oldServerInfo = HttpLoginDialog.this.serverInfo;
                    HttpLoginDialog.this.serverInfo = (ServerInfo)HttpLoginDialog.this.cmbServer.getSelectedItem();
                    HttpLoginDialog.this.serverInfo.resetConfirmedState();
                    WindowManager.getInstance().setForwardProxy(URI.create(WebGisConfiguration.getHttpBridgeURL()));
                    WindowManager.getInstance().setWebgisPath(HttpLoginDialog.this.serverInfo.getURI());
                    ActionEvent actionEvent = new ActionEvent(HttpLoginDialog.this, 0, "server_connection_changed");
                    for (ActionListener listener : HttpLoginDialog.this.connectionChangedListeners) {
                        listener.actionPerformed(actionEvent);
                    }
                    if (oldServerInfo != null && oldServerInfo.isLdap(HttpLoginDialog.this.sp) != HttpLoginDialog.this.serverInfo.isLdap(HttpLoginDialog.this.sp)) {
                        HttpLoginDialog.this.loadCredentials();
                    }
                    try {
                        Element rootElem = HttpLoginDialog.this.wgContext.getConfiguration().getRootElement();
                        Namespace ns = rootElem.getNamespace();
                        String strStartpage = StringUtils.defaultIfBlank((String)rootElem.getChildTextTrim("startpage", ns), (String)"messages.jsp");
                        String paramLink = "?";
                        if (strStartpage.contains("?")) {
                            paramLink = "&";
                        }
                        String startURL = strStartpage + paramLink + "version=" + WebGisContext.getInstance().getClientAPILevel();
                        if (dlgWait.isCanceled()) {
                            return;
                        }
                        HttpLoginDialog.this.navigateMessages(String.format("%s%s/nofilter/%s", WebGisConfiguration.getHttpBridgeURL(), HttpLoginDialog.this.serverInfo.getURI(), startURL));
                    }
                    catch (Exception ex) {
                        LOG.error(String.format("Error displaying messages at login dialog: %s", ex.getMessage()), (Throwable)ex);
                    }
                }
                catch (Exception ex) {
                    String strEcho = "";
                    try {
                        ServiceMData svc = ServiceRegistry.getService((String)"http-login", (int)0);
                        ServiceRequest echoRequest = svc.createRequest("echo");
                        strEcho = HttpLoginDialog.this.sp.execRequest(echoRequest, false, false).getResult().toString();
                    }
                    catch (Exception e1) {
                        LOG.warn(String.format("Error querying echo: %s", e1.getMessage()), (Throwable)e1);
                    }
                    dlgWait.setError(ex);
                    ExceptionDialog.handleGuiException(null, (Throwable)ex, (String)"webgiscli");
                    LOG.error(String.format("Error retrieving data from server: %s (Echo: '%s')", ex.getMessage(), strEcho), (Throwable)ex);
                }
                HttpLoginDialog.this.updateVisibilityAndEnabledState();
            }
        });
        dlgWait.setCancelable(true);
        dlgWait.setVisible(true);
        if (dlgWait.getError() != null) {
            ExceptionDialog.handleGuiException(null, (Throwable)dlgWait.getError(), (String)"webgiscli");
        }
    }

    private void initComponents() {
        this.pnlVersion = new JPanel();
        this.lblUpdateVersion = new JLabel();
        this.pnlUserdata = new JPanel();
        this.lblServer = new JLabel();
        this.cmbServer = new JComboBox();
        this.lblUser = new JLabel();
        this.txtUser = new JTextField();
        this.lblPwd = new JLabel();
        this.txtPwd = new JPasswordField();
        this.lblNewPwd = new JLabel();
        this.cboSaveLogin = new JCheckBox();
        this.lblLDAPInfo = new JLabel();
        this.pnlLoginButtons = new JPanel();
        this.butLogin = new JButton();
        this.butCancel = new JButton();
        this.pnlLogo = new JPanel();
        this.jPanel4 = new JPanel();
        this.lblConfig = new JLabel();
        this.jPanel3 = new JPanel();
        this.lblLogo = new JLabel();
        this.lblVersion = new JLabel();
        this.pnlBrowser = new JPanel();
        this.setMinimumSize(new Dimension(400, 221));
        this.setModal(true);
        this.getContentPane().setLayout(new GridBagLayout());
        this.lblUpdateVersion.setText("jLabel1");
        this.pnlVersion.add(this.lblUpdateVersion);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.pnlVersion, gridBagConstraints);
        this.pnlUserdata.setLayout(new GridBagLayout());
        this.lblServer.setLabelFor(this.cmbServer);
        this.lblServer.setText("Server:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(10, 9, 3, 3);
        this.pnlUserdata.add((Component)this.lblServer, gridBagConstraints);
        this.cmbServer.setFont(this.cmbServer.getFont().deriveFont((float)this.cmbServer.getFont().getSize() - 1.0f));
        this.cmbServer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HttpLoginDialog.this.cmbServer_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 3, 3, 9);
        this.pnlUserdata.add(this.cmbServer, gridBagConstraints);
        this.lblUser.setLabelFor(this.txtUser);
        this.lblUser.setText("Benutzer:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(9, 9, 3, 3);
        this.pnlUserdata.add((Component)this.lblUser, gridBagConstraints);
        this.txtUser.setColumns(20);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(9, 3, 1, 9);
        this.pnlUserdata.add((Component)this.txtUser, gridBagConstraints);
        this.lblPwd.setLabelFor(this.txtPwd);
        this.lblPwd.setText("Passwort:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 9, 3, 3);
        this.pnlUserdata.add((Component)this.lblPwd, gridBagConstraints);
        this.txtPwd.setColumns(20);
        this.txtPwd.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                HttpLoginDialog.this.txtPwd_onFocusGained(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 9);
        this.pnlUserdata.add((Component)this.txtPwd, gridBagConstraints);
        this.lblNewPwd.setFont(this.lblNewPwd.getFont().deriveFont((float)this.lblNewPwd.getFont().getSize() - 1.0f));
        this.lblNewPwd.setHorizontalAlignment(0);
        this.lblNewPwd.setText("neues Passwort anfordern...");
        this.lblNewPwd.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                HttpLoginDialog.this.lblNewPwd_onMouseClicked(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                HttpLoginDialog.this.lblNewPwd_onMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                HttpLoginDialog.this.lblNewPwd_onMouseExited(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.ipady = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(1, 3, 3, 10);
        this.pnlUserdata.add((Component)this.lblNewPwd, gridBagConstraints);
        this.cboSaveLogin.setText("Anmeldeinformationen lokal speichern");
        this.cboSaveLogin.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cboSaveLogin.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 9, 3, 9);
        this.pnlUserdata.add((Component)this.cboSaveLogin, gridBagConstraints);
        this.lblLDAPInfo.setText("Die Anmeldung findet \u00fcber das Windows-Passwort statt.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 9, 3, 9);
        this.pnlUserdata.add((Component)this.lblLDAPInfo, gridBagConstraints);
        this.butLogin.setText("Login");
        this.butLogin.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HttpLoginDialog.this.butLogin_onActionPerformed(evt);
            }
        });
        this.pnlLoginButtons.add(this.butLogin);
        this.butCancel.setText("Abbruch");
        this.butCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HttpLoginDialog.this.butCancel_onActionPerformed(evt);
            }
        });
        this.pnlLoginButtons.add(this.butCancel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 9, 9, 9);
        this.pnlUserdata.add((Component)this.pnlLoginButtons, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.pnlUserdata, gridBagConstraints);
        this.pnlLogo.setLayout(new GridBagLayout());
        this.jPanel4.setPreferredSize(new Dimension(150, 18));
        this.jPanel4.setLayout(new GridBagLayout());
        this.lblConfig.setHorizontalAlignment(0);
        this.lblConfig.setText("Einstellungen...");
        this.lblConfig.setHorizontalTextPosition(2);
        this.lblConfig.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                HttpLoginDialog.this.lblConfig_onMouseClicked(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                HttpLoginDialog.this.lblConfig_onMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                HttpLoginDialog.this.lblConfig_onMouseExited(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.ipady = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.jPanel4.add((Component)this.lblConfig, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.pnlLogo.add((Component)this.jPanel4, gridBagConstraints);
        this.jPanel3.setMinimumSize(new Dimension(150, 65));
        this.jPanel3.setPreferredSize(new Dimension(150, 65));
        this.jPanel3.setLayout(new BorderLayout());
        this.lblLogo.setHorizontalAlignment(0);
        this.lblLogo.setIcon(IconLoader.image((String)"logo"));
        this.lblLogo.setVerticalAlignment(1);
        this.jPanel3.add((Component)this.lblLogo, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlLogo.add((Component)this.jPanel3, gridBagConstraints);
        this.lblVersion.setFont(this.lblVersion.getFont().deriveFont((float)this.lblVersion.getFont().getSize() - 2.0f));
        this.lblVersion.setText("jLabel1");
        this.lblVersion.setVerticalAlignment(3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.pnlLogo.add((Component)this.lblVersion, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        this.getContentPane().add((Component)this.pnlLogo, gridBagConstraints);
        this.pnlBrowser.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.pnlBrowser, gridBagConstraints);
        this.pack();
    }

    private void cmbServer_onActionPerformed(ActionEvent evt) {
        if (this.bolBlockEvents) {
            return;
        }
        try {
            this.onConnectionChanged();
        }
        catch (Exception e) {
            ExceptionDialog.handleGuiException((Component)this, (Throwable)e, (String)"webgiscli");
        }
    }

    private void txtPwd_onFocusGained(FocusEvent evt) {
        if (this.txtPwd.hasFocus()) {
            this.txtPwd.setText("");
            this.bolPwdEncrypted = false;
        }
    }

    private void butLogin_onActionPerformed(ActionEvent evt) {
        try {
            if (this.serverInfo.getVersionStatus(this.sp) == VersionStatus.TOO_OLD) {
                return;
            }
            String strError = this.verifyInput();
            if (StringUtils.isNotEmpty((String)strError)) {
                ErrorBox.showError((Window)this, (String)i18n.get("common.error"), (String)strError, (String)"", (String)"");
                return;
            }
            this.setVisible(false);
            this.performLogin = true;
        }
        catch (Exception e) {
            if (WebGisClient.getSplash().isVisible()) {
                WebGisClient.getSplash().setVisible(false);
            }
            ErrorBox.showException((Window)this, (String)"Fehler", (Throwable)e);
        }
    }

    private void butCancel_onActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.performLogin = false;
    }

    private void lblConfig_onMouseEntered(MouseEvent evt) {
        this.lblConfig.setForeground(Color.BLUE);
    }

    private void lblConfig_onMouseExited(MouseEvent evt) {
        this.lblConfig.setForeground(Color.BLACK);
    }

    private void lblConfig_onMouseClicked(MouseEvent evt) {
        try {
            if (!FileSupport.canWrite((String)".")) {
                GUISupport.msgbox((Component)this, (String)i18n.get("gui.HttpLoginFrame.no-write-perm"), (String)i18n.get("common.message"));
            }
            ProxyDialog dlgProxy = new ProxyDialog((Dialog)this);
            dlgProxy.setVisible(true);
            this.onConnectionChanged();
        }
        catch (Exception e) {
            ExceptionDialog.handleGuiException((Component)this, (Throwable)e, (String)"webgiscli");
        }
    }

    private void lblNewPwd_onMouseClicked(MouseEvent evt) {
        try {
            this.sp.requestNewPassword(this.getCredentials());
        }
        catch (Exception e) {
            ExceptionDialog.handleGuiException((Component)this, (Throwable)e, (String)"webgiscli");
        }
    }

    private void lblNewPwd_onMouseEntered(MouseEvent evt) {
        this.lblNewPwd.setForeground(Color.BLUE);
    }

    private void lblNewPwd_onMouseExited(MouseEvent evt) {
        this.lblNewPwd.setForeground(Color.BLACK);
    }

    private void i18n() {
        this.setTitle(i18n.get("gui.HttpLoginFrame.title"));
        this.lblServer.setText(i18n.get("gui.HttpLoginFrame.server"));
        this.lblUser.setText(i18n.get("gui.HttpLoginFrame.user"));
        this.lblPwd.setText(i18n.get("gui.HttpLoginFrame.pwd"));
        this.cboSaveLogin.setText(i18n.get("gui.HttpLoginFrame.save-login"));
        this.butCancel.setText(i18n.get("gui.HttpLoginFrame.cancel"));
        this.butLogin.setText(i18n.get("gui.HttpLoginFrame.login"));
        this.lblConfig.setText(i18n.get("gui.HttpLoginFrame.configuration"));
        this.lblVersion.setText(String.format("%s: %s / RIWA GmbH", i18n.get("gui.HttpLoginFrame.version"), WebGisContext.getInstance().getClientVersion()));
        this.lblNewPwd.setText(i18n.get("gui.HttpLoginFrame.new-pwd"));
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible && this.cmbServer.getItemCount() == 1 && this.cmbServer.getItemAt(0).isSingleSignOnLogin()) {
            if (this.serverInfo == null) {
                this.onConnectionChanged();
            }
            this.bolPwdEncrypted = false;
            this.txtUser.setText(System.getProperty("user.name"));
            this.txtPwd.setText("");
            this.butLogin.doClick();
            return;
        }
        super.setVisible(visible);
    }

    private void checkVersion() {
        if (this.serverInfo.getVersionStatus(this.sp) == VersionStatus.TOO_OLD) {
            this.pnlVersion.setVisible(true);
            this.butLogin.setEnabled(false);
            this.lblUpdateVersion.setForeground(Color.RED);
            this.lblUpdateVersion.setText(String.format("<html>%s</html>", i18n.get("gui.HttpLoginFrame.version-too-old")));
        }
        if (this.serverInfo.getVersionStatus(this.sp) == VersionStatus.OLD && Support.isWindows()) {
            this.pnlVersion.setVisible(true);
            this.lblUpdateVersion.setForeground(Color.BLACK);
            this.lblUpdateVersion.setText(String.format("<html>%s</html>", i18n.get("gui.HttpLoginFrame.version-old")));
        }
    }

    private LoginCredentials getCredentials() {
        LoginCredentials lg = new LoginCredentials();
        if (this.bolPwdEncrypted) {
            lg.setEncryptedPassword(String.valueOf(this.txtPwd.getPassword()));
        } else {
            lg.setCleartextPassword(this.txtPwd.getPassword());
        }
        lg.setUsername(this.txtUser.getText().trim());
        return lg;
    }

    private String verifyInput() {
        LinkedHashSet<String> strError = new LinkedHashSet<String>();
        if (this.cmbServer.getSelectedItem() == null) {
            strError.add(i18n.get("gui.HttpLoginFrame.invalid-server"));
        } else {
            ServerInfo srvInfo = (ServerInfo)this.cmbServer.getSelectedItem();
            if (!StringUtils.startsWithIgnoreCase((String)ObjectUtils.toString((Object)srvInfo.getServer()), (String)"http")) {
                strError.add(i18n.get("gui.HttpLoginFrame.invalid-server"));
            }
        }
        if (this.serverInfo.isLdap(this.sp) || this.serverInfo.isSingleSignOnLogin()) {
            if (this.serverInfo.isLdap(this.sp) && this.txtUser.getText().trim().isEmpty()) {
                strError.add(i18n.fmt("gui.HttpLoginFrame.invalid-user", new Object[]{1}));
            }
        } else {
            if (this.txtUser.getText().trim().length() < 3) {
                strError.add(i18n.fmt("gui.HttpLoginFrame.invalid-user", new Object[]{3}));
            }
            if (this.txtPwd.getPassword().length < 5) {
                strError.add(i18n.get("gui.HttpLoginFrame.invalid-pwd"));
            }
        }
        return StringUtils.join(strError, (String)"\n");
    }

    @Override
    public void dispose() {
        this.brPanel.dispose();
        super.dispose();
    }

    private void updateVisibilityAndEnabledState() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                HttpLoginDialog.this.butLogin.setEnabled(false);
                HttpLoginDialog.this.pnlVersion.setVisible(false);
                HttpLoginDialog.this.butCancel.setEnabled(false);
                HttpLoginDialog.this.txtUser.setEnabled(false);
                HttpLoginDialog.this.txtPwd.setEnabled(false);
                HttpLoginDialog.this.cboSaveLogin.setEnabled(false);
                HttpLoginDialog.this.lblLDAPInfo.setVisible(false);
                HttpLoginDialog.this.cmbServer.setEnabled(HttpLoginDialog.this.cmbServer.getItemCount() > 1);
                if (HttpLoginDialog.this.serverInfo.isLdap(HttpLoginDialog.this.sp) || HttpLoginDialog.this.serverInfo.isSingleSignOnLogin()) {
                    HttpLoginDialog.this.lblLDAPInfo.setVisible(true);
                    if (HttpLoginDialog.this.serverInfo.isSingleSignOnLogin()) {
                        HttpLoginDialog.this.lblLDAPInfo.setText(i18n.get("gui.HttpLoginFrame.single-sign-on"));
                    } else {
                        HttpLoginDialog.this.lblLDAPInfo.setText(i18n.get("gui.HttpLoginFrame.use-windows-pwd"));
                    }
                }
                boolean isLdapOrSso = !HttpLoginDialog.this.serverInfo.isLdap(HttpLoginDialog.this.sp) && !HttpLoginDialog.this.serverInfo.isSingleSignOnLogin();
                HttpLoginDialog.this.lblNewPwd.setVisible(isLdapOrSso);
                HttpLoginDialog.this.cboSaveLogin.setVisible(isLdapOrSso && HttpLoginDialog.this.storeCredentials);
                HttpLoginDialog.this.cboSaveLogin.setEnabled(isLdapOrSso && HttpLoginDialog.this.storeCredentials);
                if (!HttpLoginDialog.this.serverInfo.isSingleSignOnLogin()) {
                    HttpLoginDialog.this.txtUser.setEnabled(true);
                    HttpLoginDialog.this.txtPwd.setEnabled(true);
                }
                boolean serverStatusMatch = HttpLoginDialog.this.serverInfo.getVersionStatus(HttpLoginDialog.this.sp) != VersionStatus.TOO_OLD && HttpLoginDialog.this.serverInfo.getVersionStatus(HttpLoginDialog.this.sp) != VersionStatus.ERROR;
                HttpLoginDialog.this.butLogin.setEnabled(serverStatusMatch);
                HttpLoginDialog.this.butCancel.setEnabled(true);
                if (HttpLoginDialog.this.txtUser.isEnabled() && !HttpLoginDialog.this.serverInfo.isLdap(HttpLoginDialog.this.sp)) {
                    HttpLoginDialog.this.txtUser.requestFocus();
                } else if (HttpLoginDialog.this.txtPwd.isEnabled()) {
                    HttpLoginDialog.this.txtPwd.requestFocus();
                }
                HttpLoginDialog.this.checkVersion();
            }
        });
    }

    private ServerInfo findPrevSelectedServerInfo(Collection<ServerInfo> knownServers, ServerInfo oldServer) {
        ServerInfo selectedServer = null;
        if (oldServer != null) {
            for (ServerInfo currServer : knownServers) {
                if (!StringUtils.equalsIgnoreCase((String)currServer.getServer(), (String)oldServer.getServer())) continue;
                selectedServer = currServer;
            }
        }
        return selectedServer;
    }

    public LoginInfo getLoginInfo() {
        LoginInfo loginInfo = new LoginInfo();
        loginInfo.setServerInfo(this.serverInfo);
        loginInfo.setLoginCredentials(this.getCredentials());
        loginInfo.setPerformLogin(this.isPerformLogin());
        loginInfo.setStoreLogin(this.isStoreLoginSelected());
        return loginInfo;
    }

    public void navigateMessages(String messagesURL) {
        if (this.brPanel != null) {
            this.brPanel.navigate(messagesURL);
        }
    }

    private boolean isPerformLogin() {
        return this.performLogin;
    }

    private boolean isStoreLoginSelected() {
        return this.cboSaveLogin.isSelected();
    }

    private boolean parseStoreCredentialsFromConfig(WebGisContext wgContext) {
        try {
            Element elemRoot = wgContext.getConfiguration().getRootElement();
            Namespace ns = elemRoot.getNamespace();
            String rawValue = elemRoot.getChild("services", ns).getChild("http", ns).getChildTextTrim("store-credentials", ns);
            return !"false".equals(rawValue);
        }
        catch (Exception e) {
            LOG.error("Could parse root-ca validation setting from configuration. Defaulting to true.", (Throwable)e);
            return true;
        }
    }
}

