/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.webgiscli.login.gui;

import de.riwagis.util.Support;
import de.riwagis.util.exception.SystemException;
import de.riwagis.util.gui.GUISupport;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.apache.commons.lang3.StringUtils;

public class ChangePasswordDialog
extends JDialog {
    private int modalResult = -1;
    private String knownEncryptedOldPassword;
    private final List<PasswordCheckGuideline> passwordCheckGuidelines = new ArrayList<PasswordCheckGuideline>();
    private JButton btnCancel;
    private JButton btnOk;
    private JPasswordField edtNewPassword1;
    private JPasswordField edtNewPassword2;
    private JPasswordField edtOldPassword;
    private JTextField edtUsername;
    private JLabel jLabel1;
    private JPanel jPanel2;
    private JLabel lblNewPassword1;
    private JLabel lblNewPassword2;
    private JLabel lblOldPassword;
    private JLabel lblPasswordExpired;
    private JLabel lblUsername;
    private JPanel pnlButtons;
    private JPanel pnlPasswordHint;
    private JTextArea txtPasswordHint;

    public int getModalResult() {
        return this.modalResult;
    }

    public ChangePasswordDialog(Window parent, List<PasswordCheckGuideline> guidelines) {
        super(parent);
        this.initComponents();
        this.lblPasswordExpired.setVisible(false);
        GUISupport.setDefaultButton((JButton)this.btnCancel, (int)27);
        GUISupport.setDefaultButton((JButton)this.btnOk, (int)10);
        this.setPasswordCheckGuidelines(guidelines);
        this.txtPasswordHint.setVisible(false);
    }

    public void setKnownEncryptedOldPassword(String knownEncryptedOldPassword) {
        this.knownEncryptedOldPassword = knownEncryptedOldPassword;
        this.edtOldPassword.setText(knownEncryptedOldPassword);
    }

    public void setAllowEditPassword(boolean allowEditPassword) {
        this.edtOldPassword.setEditable(allowEditPassword);
        this.edtOldPassword.setBackground(allowEditPassword ? Color.WHITE : Color.LIGHT_GRAY);
    }

    private void initComponents() {
        this.jPanel2 = new JPanel();
        this.lblPasswordExpired = new JLabel();
        this.jLabel1 = new JLabel();
        this.lblUsername = new JLabel();
        this.edtUsername = new JTextField();
        this.lblOldPassword = new JLabel();
        this.edtOldPassword = new JPasswordField();
        this.lblNewPassword1 = new JLabel();
        this.edtNewPassword1 = new JPasswordField();
        this.lblNewPassword2 = new JLabel();
        this.edtNewPassword2 = new JPasswordField();
        this.pnlPasswordHint = new JPanel();
        this.txtPasswordHint = new JTextArea();
        this.pnlButtons = new JPanel();
        this.btnCancel = new JButton();
        this.btnOk = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Passwort \u00e4ndern");
        this.setModal(true);
        this.getContentPane().setLayout(new GridBagLayout());
        this.jPanel2.setLayout(new GridBagLayout());
        this.lblPasswordExpired.setText("<html><b>Ihr Passwort ist abgelaufen.</b></html>");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel2.add((Component)this.lblPasswordExpired, gridBagConstraints);
        this.jLabel1.setText("<html>Geben Sie hier Ihren Benutzernamen, das bisherige Passwort und zweimal das neue Passwort ein.</html>");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel2.add((Component)this.jLabel1, gridBagConstraints);
        this.lblUsername.setHorizontalAlignment(11);
        this.lblUsername.setLabelFor(this.edtUsername);
        this.lblUsername.setText("Benutzername:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel2.add((Component)this.lblUsername, gridBagConstraints);
        this.edtUsername.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                ChangePasswordDialog.this.edtUsernameFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel2.add((Component)this.edtUsername, gridBagConstraints);
        this.lblOldPassword.setHorizontalAlignment(11);
        this.lblOldPassword.setLabelFor(this.edtOldPassword);
        this.lblOldPassword.setText("Bisheriges Passwort:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel2.add((Component)this.lblOldPassword, gridBagConstraints);
        this.edtOldPassword.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                ChangePasswordDialog.this.edtUsernameFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel2.add((Component)this.edtOldPassword, gridBagConstraints);
        this.lblNewPassword1.setHorizontalAlignment(11);
        this.lblNewPassword1.setLabelFor(this.edtNewPassword1);
        this.lblNewPassword1.setText("neues Passwort:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel2.add((Component)this.lblNewPassword1, gridBagConstraints);
        this.edtNewPassword1.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                ChangePasswordDialog.this.edtUsernameFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel2.add((Component)this.edtNewPassword1, gridBagConstraints);
        this.lblNewPassword2.setHorizontalAlignment(11);
        this.lblNewPassword2.setLabelFor(this.edtNewPassword2);
        this.lblNewPassword2.setText("Wiederholung:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel2.add((Component)this.lblNewPassword2, gridBagConstraints);
        this.edtNewPassword2.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                ChangePasswordDialog.this.edtUsernameFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel2.add((Component)this.edtNewPassword2, gridBagConstraints);
        this.pnlPasswordHint.setLayout(new GridBagLayout());
        this.txtPasswordHint.setEditable(false);
        this.txtPasswordHint.setBackground(new Color(240, 240, 240));
        this.txtPasswordHint.setColumns(20);
        this.txtPasswordHint.setFont(new Font("Tahoma", 1, 11));
        this.txtPasswordHint.setForeground(new Color(255, 51, 51));
        this.txtPasswordHint.setLineWrap(true);
        this.txtPasswordHint.setRows(5);
        this.txtPasswordHint.setWrapStyleWord(true);
        this.txtPasswordHint.setDisabledTextColor(SystemColor.activeCaptionText);
        this.txtPasswordHint.setFocusable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.pnlPasswordHint.add((Component)this.txtPasswordHint, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        this.jPanel2.add((Component)this.pnlPasswordHint, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.jPanel2, gridBagConstraints);
        this.pnlButtons.setLayout(new GridBagLayout());
        this.btnCancel.setText("Abbrechen");
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChangePasswordDialog.this.btnCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.pnlButtons.add((Component)this.btnCancel, gridBagConstraints);
        this.btnOk.setText("Ok");
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChangePasswordDialog.this.btnOkActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.pnlButtons.add((Component)this.btnOk, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.pnlButtons, gridBagConstraints);
        this.pack();
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
        this.modalResult = 2;
    }

    private void btnOkActionPerformed(ActionEvent evt) {
        Collection<String> errCond = this.checkPwds(this.edtNewPassword1.getPassword(), this.edtNewPassword2.getPassword(), this.edtOldPassword.getPassword());
        if (errCond.size() > 0) {
            int retryPwd = JOptionPane.showConfirmDialog(this, String.format("%s\nM\u00f6chten Sie die Passw\u00f6rter erneut eingeben?", StringUtils.join(errCond, (String)"\n")), String.format("Passwort fehlerhaft", new Object[0]), 2);
            if (retryPwd == 2) {
                this.btnCancel.doClick();
            }
        } else {
            try {
                if (StringUtils.equalsIgnoreCase((CharSequence)this.getOldPassword(), (CharSequence)this.getNewPassword())) {
                    JOptionPane.showMessageDialog(this, "<html><div>Neues und altes Passwort sind identisch.<div><div>Bitte geben Sie ein andere Passwort ein.</html>");
                    return;
                }
            }
            catch (SystemException ex) {
                JOptionPane.showMessageDialog(this, String.format("<html><div>Fehler beim Verschl\u00fcsseln der Passw\u00f6rter: %s.<div></html>", ex.getMessage()));
            }
            this.modalResult = 0;
            this.setVisible(false);
            this.dispose();
        }
    }

    private void edtUsernameFocusLost(FocusEvent evt) {
        Collection<String> pwdCheck = this.checkPwds(this.edtNewPassword1.getPassword(), this.edtNewPassword2.getPassword(), this.edtOldPassword.getPassword());
        this.txtPasswordHint.setText(ChangePasswordDialog.formatErrorMessageHTML(pwdCheck));
        this.txtPasswordHint.setVisible(!pwdCheck.isEmpty());
        this.pack();
    }

    public static String formatErrorMessageHTML(Collection<String> pwdCheck) {
        return pwdCheck.stream().collect(Collectors.joining("\n"));
    }

    public Collection<String> checkPwds(char[] newPwd1, char[] newPwd2, char[] oldPwdInput) {
        boolean oldPasswordLongEnough;
        ArrayList<String> errCond = new ArrayList<String>();
        boolean passwordsMatch = Arrays.equals(newPwd1, newPwd2);
        if (!passwordsMatch) {
            errCond.add("Passw\u00f6rter stimmen nicht \u00fcberein.");
        }
        boolean bl = oldPasswordLongEnough = oldPwdInput.length >= 5;
        if (!oldPasswordLongEnough) {
            errCond.add("Altes Passwort ist zu kurz. Es muss mindestens 5 Zeichen lang sein.");
        }
        String newPwd = String.valueOf(newPwd1);
        for (PasswordCheckGuideline guideline : this.passwordCheckGuidelines) {
            String res = guideline.checkPassword(newPwd);
            if (!StringUtils.isNotBlank((CharSequence)res)) continue;
            errCond.addAll(List.of(StringUtils.split((String)res, (String)"\n")));
        }
        return errCond;
    }

    public void setUsername(String username) {
        this.edtUsername.setText(username);
        if (StringUtils.isBlank((CharSequence)username)) {
            // empty if block
        }
    }

    public String getUsername() {
        return this.edtUsername.getText();
    }

    public String getOldPassword() throws SystemException {
        if (Arrays.equals(this.knownEncryptedOldPassword.toCharArray(), this.edtOldPassword.getPassword())) {
            return this.knownEncryptedOldPassword;
        }
        return Support.encryptOneWay((char[])this.edtOldPassword.getPassword(), (String)"SHA-1");
    }

    public String getNewPassword() throws SystemException {
        return Support.encryptOneWay((char[])this.edtNewPassword1.getPassword(), (String)"SHA-1");
    }

    public void setAllowEditUsername(boolean allowEditUsername) {
        this.edtUsername.setEditable(allowEditUsername);
        this.edtUsername.setBackground(allowEditUsername ? Color.WHITE : Color.LIGHT_GRAY);
    }

    public void setShowExpiredNotification(boolean b) {
        this.lblPasswordExpired.setVisible(b);
    }

    public void setPasswordCheckGuidelines(List<PasswordCheckGuideline> guidelines) {
        this.passwordCheckGuidelines.addAll((Collection<PasswordCheckGuideline>)Objects.requireNonNull(guidelines, "guidelines must not be null"));
    }

    public static void main(String[] args) {
        List<PasswordCheckGuideline> guideLines = List.of(new PasswordCheckGuideline(){

            @Override
            public String checkPassword(String pwd) {
                List<String> checkRes = List.of("Langer Text mit vielen vielen Zeichen um den Umbruch zu testen, weil das ja auch wichtig ist, um zu sehen ob das auch ordentlich angezeigt wird.", "Eine zweite Zeile mit einigen Zeichen ist auch nicht verkehrt, sonst sieht man ja das nicht.", "Zum Schluss noch 'ne dritte Zeile. Aller Guten Dinge sind drei!");
                return StringUtils.join(checkRes, (String)"\n");
            }
        });
        ChangePasswordDialog dlg = new ChangePasswordDialog(null, guideLines);
        dlg.setModal(true);
        dlg.setVisible(true);
        dlg.dispose();
    }

    public static interface PasswordCheckGuideline {
        public String checkPassword(String var1);
    }
}

