/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.webgiscli.login;

import de.riwagis.service.ServiceMData;
import de.riwagis.service.ServiceRequest;
import de.riwagis.service.registry.ServiceRegistry;
import de.riwagis.webgiscli.WebGisContext;
import de.riwagis.webgiscli.login.VersionStatus;
import de.riwagis.webgiscli.service.http.HttpServiceProvider;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerInfo {
    private static final Logger LOG = LoggerFactory.getLogger(ServerInfo.class);
    private boolean versionStatusConfirmedByServer = false;
    private final String strServer;
    private final String strURI;
    private final String strServerName;
    private VersionStatus versionStatus;
    private final boolean singleSignOnLogin;
    private Map<String, ?> serverInfo;
    private final boolean ldap;

    public ServerInfo(String strServer, String strURI, String strServerName, boolean ldap, boolean singleSignOnLogin) {
        this.strServer = strServer;
        this.strURI = strURI;
        this.strServerName = strServerName;
        this.versionStatus = VersionStatus.VS_UNDEFINED;
        this.singleSignOnLogin = singleSignOnLogin;
        this.ldap = ldap;
    }

    public String toString() {
        return StringUtils.isBlank((CharSequence)this.strServerName) ? this.strServer + this.strURI : this.strServerName;
    }

    public String getServerVersion(HttpServiceProvider sp) {
        String serverVersion = (String)this.retrieveServerInfo(sp).get("version");
        if (serverVersion == null) {
            return "unknown";
        }
        return serverVersion;
    }

    public String getServerVersionWithHotfix(HttpServiceProvider sp) {
        return (String)this.retrieveServerInfo(sp).get("version_with_hotfix");
    }

    public void resetConfirmedState() {
        this.serverInfo = null;
        this.versionStatusConfirmedByServer = false;
    }

    private Map<String, ?> retrieveServerInfo(HttpServiceProvider sp) {
        if (this.serverInfo == null) {
            try {
                ServiceMData svc = ServiceRegistry.getService((String)"http-login", (int)0);
                ServiceRequest ldapRequest = svc.createRequest("server_info");
                Object svInfo = sp.execRequest(ldapRequest, false, false).getResult();
                this.serverInfo = svInfo instanceof Map ? (Map<Object, Object>)svInfo : new HashMap();
            }
            catch (Throwable e) {
                this.serverInfo = new HashMap();
                LOG.error("Error retrieving server info", e);
            }
        }
        if (this.serverInfo == null) {
            return new HashMap();
        }
        return this.serverInfo;
    }

    public synchronized boolean isLdap(HttpServiceProvider sp) {
        Boolean ldapOnServer = (Boolean)this.retrieveServerInfo(sp).get("LDAPavailable");
        if (ldapOnServer != null && ldapOnServer.booleanValue()) {
            return this.ldap;
        }
        return false;
    }

    public String getServer() {
        return this.strServer;
    }

    public String getURI() {
        return this.strURI;
    }

    public String getServerName() {
        return this.strServerName;
    }

    public VersionStatus getVersionStatus(HttpServiceProvider sp) {
        if (!this.versionStatusConfirmedByServer) {
            if (this.versionStatus == VersionStatus.VS_UNDEFINED || this.versionStatus == VersionStatus.ERROR) {
                try {
                    ServiceMData svc = ServiceRegistry.getService((String)"http-login", (int)0);
                    HashMap<String, Integer> mapParam = new HashMap<String, Integer>();
                    mapParam.put("client_version", WebGisContext.getInstance().getClientAPILevel());
                    ServiceRequest logouReq = svc.createRequest("check_version", mapParam);
                    this.versionStatus = VersionStatus.fromValue((Integer)sp.execRequest(logouReq, false, false).getResult());
                }
                catch (Exception ex) {
                    LOG.debug(String.format("error checking version: %s", ex.getMessage()), (Throwable)ex);
                    this.versionStatus = VersionStatus.ERROR;
                }
            }
            this.versionStatusConfirmedByServer = true;
        }
        return this.versionStatus;
    }

    private final void setVersionStatus(VersionStatus versionStatus) {
        this.versionStatus = versionStatus;
    }

    public String getURL() {
        String tmpUri = this.getURI();
        return String.format("%s%s%s", this.getServer(), tmpUri, tmpUri.endsWith("/") ? "" : "/");
    }

    public boolean isSingleSignOnLogin() {
        return this.singleSignOnLogin;
    }

    public Object clone() {
        ServerInfo clonedServerInfo = new ServerInfo(this.strServer, this.strURI, this.strServerName, this.ldap, this.singleSignOnLogin);
        clonedServerInfo.setVersionStatus(this.versionStatus);
        clonedServerInfo.versionStatusConfirmedByServer = this.versionStatusConfirmedByServer;
        clonedServerInfo.serverInfo = this.serverInfo;
        return clonedServerInfo;
    }
}

