/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.webgiscli.login;

import de.riwagis.browser.OpenWindowConfiguration;
import de.riwagis.browser.WindowManager;
import de.riwagis.gis.context.GisContext;
import de.riwagis.gis.context.map.MapAppContext;
import de.riwagis.service.ServiceMData;
import de.riwagis.service.ServiceProvider;
import de.riwagis.service.ServiceRequest;
import de.riwagis.service.registry.ServiceRegistry;
import de.riwagis.util.exception.SystemException;
import de.riwagis.util.lang.VersionComparator;
import de.riwagis.webgiscli.WebGisClient;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModuleInfoService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ModuleInfoService.class);
    private static final String VERSION_MIN_FOR_MODULE_INFOS = "2.1.00.7";
    public static final String SHOW_MODULE_INFO_KEY = "SHOW_MODULE_INFO";
    public static final String MODULE_INFO_WINDOW_NAME = "moduleInfoWindow";
    private final ServiceProvider svProvider;
    private final GisContext context;

    public ModuleInfoService(ServiceProvider svProvider) {
        this.svProvider = svProvider;
        this.context = WebGisClient.GIS_CONTEXT;
    }

    public ModuleInfoService(ServiceProvider svProvider, GisContext context) {
        this.svProvider = svProvider;
        this.context = context;
    }

    public void callModuleInfo() {
        try {
            if (!this.serverDeliversModuleInfos() || !this.isModuleInfoEnabled()) {
                return;
            }
            long timestampStart = System.currentTimeMillis();
            ServiceMData moduleService = ServiceRegistry.getService((String)"module", (int)0);
            ServiceRequest req = moduleService.createRequest("is_user_module_info_available", Map.of());
            Map userHasModuleInfosResult = (Map)this.svProvider.execRequest(req).getResult();
            log.trace("Moduleinfo Request to Server: " + (System.currentTimeMillis() - timestampStart));
            if (Objects.equals(userHasModuleInfosResult.get("result"), Boolean.TRUE)) {
                OpenWindowConfiguration.Builder winBuilder = WindowManager.getInstance().window().name(MODULE_INFO_WINDOW_NAME).webgisAddress("/modules/infos").size(900, 700);
                winBuilder.open();
            }
        }
        catch (Exception e) {
            log.error("Module info could not be loaded", (Throwable)e);
        }
    }

    public boolean isModuleInfoEnabled() throws SystemException {
        Optional showModuleInfo = this.getMapAppContext().getBlackboardValue(SHOW_MODULE_INFO_KEY);
        if (showModuleInfo.isEmpty() || !(showModuleInfo.get() instanceof Boolean)) {
            return true;
        }
        return Objects.equals(showModuleInfo.get(), Boolean.TRUE);
    }

    public void setModuleInfoEnabled() throws SystemException {
        this.setModuleInfo(Boolean.TRUE);
    }

    public void setModuleInfoDisabled() throws SystemException {
        this.setModuleInfo(Boolean.FALSE);
    }

    private void setModuleInfo(boolean enabled) throws SystemException {
        this.getMapAppContext().setBlackboardValue(SHOW_MODULE_INFO_KEY, (Object)enabled);
    }

    protected MapAppContext getMapAppContext() throws SystemException {
        MapAppContext mapAppContext = this.context.getMapApp();
        if (mapAppContext == null) {
            throw new SystemException("MapAppContext bei Initialisierung nicht vorhanden.");
        }
        return mapAppContext;
    }

    private boolean serverDeliversModuleInfos() {
        return this.context.getModuleApp().getVersionWithHotfix().filter(v -> VersionComparator.DEFAULT_VERSIONCOMPARATOR.compare(v, VERSION_MIN_FOR_MODULE_INFOS) >= 0).isPresent();
    }
}

