/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.webgiscli.login;

import de.riwagis.service.ServiceException;
import de.riwagis.service.ServiceMData;
import de.riwagis.service.ServiceRequest;
import de.riwagis.service.registry.ServiceRegistry;
import de.riwagis.util.exception.SystemException;
import de.riwagis.webgiscli.WebGisContext;
import de.riwagis.webgiscli.login.LoginCredentials;
import de.riwagis.webgiscli.login.LoginInfo;
import de.riwagis.webgiscli.login.ServerInfo;
import de.riwagis.webgiscli.login.handlers.LoginHandler;
import de.riwagis.webgiscli.login.handlers.LoginHandlerDefault;
import de.riwagis.webgiscli.login.handlers.LoginHandlerSingleSignOn;
import de.riwagis.webgiscli.service.http.HttpServiceProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.apache.commons.lang3.SystemUtils;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class LoginUtils {
    private static final int GIS_CLIENT_COMPONENT_KEY = -100;

    public static Collection<ServerInfo> readServerInfos() {
        Element rootElem = WebGisContext.getInstance().getConfiguration().getRootElement();
        Namespace ns = rootElem.getNamespace();
        Element elemHtml = rootElem.getChild("services", ns).getChild("http", ns);
        ArrayList<ServerInfo> knownServers = new ArrayList<ServerInfo>();
        for (Object urlElemObj : elemHtml.getChildren("webapp", ns)) {
            Element urlElem = (Element)urlElemObj;
            String strServer = urlElem.getChildTextTrim("url_server", ns);
            String strURI = urlElem.getChildTextTrim("uri_webapp", ns);
            String strServerName = urlElem.getChildText("name_server", ns);
            Element elemLdap = urlElem.getChild("ldap", ns);
            Element elemSingleSignOn = urlElem.getChild("singleSignOn", ns);
            knownServers.add(new ServerInfo(strServer, strURI, strServerName, elemLdap != null, elemSingleSignOn != null));
        }
        return knownServers;
    }

    public static LoginHandler retrieveLoginHandler(LoginInfo loginInfo, HttpServiceProvider sp) {
        if (loginInfo.getServerInfo().isSingleSignOnLogin()) {
            return new LoginHandlerSingleSignOn(loginInfo, sp);
        }
        return new LoginHandlerDefault(loginInfo, sp);
    }

    public static ServiceRequest<?> buildLoginRequest(LoginCredentials lc, String adminPWDEncrypted, String machineKey, boolean isLdapLogin, String subUser) throws SystemException, ServiceException {
        HashMap<String, Object> mapParam = new HashMap<String, Object>();
        if (lc != null) {
            mapParam.put("name", lc.getUsername());
            mapParam.put("pwd", lc.getEncryptedPassword());
            if (isLdapLogin) {
                if (lc.getCleartextPassword() == null) {
                    throw new SystemException("Should never reach here. LDAP-Login but no cleartext password provided.");
                }
                mapParam.put("pwd_ldap", String.valueOf(lc.getCleartextPassword()));
            }
        }
        mapParam.put("subuser_name", subUser);
        mapParam.put("pwd_admin", adminPWDEncrypted);
        mapParam.put("client_version", WebGisContext.getInstance().getClientAPILevel());
        mapParam.put("component_key", -100);
        mapParam.put("clientmachineos", String.format("%s (%s, %s)", SystemUtils.OS_NAME, SystemUtils.OS_VERSION, SystemUtils.OS_ARCH));
        mapParam.put("clientmachinename", String.format("%s", SystemUtils.getHostName()));
        mapParam.put("clientmachinecode", machineKey);
        ServiceMData svc = ServiceRegistry.getService((String)"http-login", (int)0);
        ServiceRequest loginRequest = svc.createRequest("login_user", mapParam);
        return loginRequest;
    }

    private LoginUtils() {
    }
}

